static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006, 2010 Øyvind Kolås <pippin@gimp.org>                      \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (x, _(\"X\"), 20.0)                                           \n"
"  description   (_(\"Horizontal shadow offset\"))                             \n"
"  ui_range      (-40.0, 40.0)                                                 \n"
"  ui_meta       (\"unit\", \"pixel-distance\")                                \n"
"  ui_meta       (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_double (y, _(\"Y\"), 20.0)                                           \n"
"  description   (_(\"Vertical shadow offset\"))                               \n"
"  ui_range      (-40.0, 40.0)                                                 \n"
"  ui_meta       (\"unit\", \"pixel-distance\")                                \n"
"  ui_meta       (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_double (radius, _(\"Blur radius\"), 10.0)                            \n"
"  value_range   (0.0, G_MAXDOUBLE)                                            \n"
"  ui_range      (0.0, 300.0)                                                  \n"
"  ui_gamma      (1.5)                                                         \n"
"  ui_meta       (\"unit\", \"pixel-distance\")                                \n"
"                                                                              \n"
"property_color  (color, _(\"Color\"), \"black\")                              \n"
"  description   (_(\"The shadow's color (defaults to 'black')\"))             \n"
"                                                                              \n"
"/* It does make sense to sometimes have opacities > 1 (see GEGL logo          \n"
" * for example)                                                               \n"
" */                                                                           \n"
"property_double (opacity, _(\"Opacity\"), 0.5)                                \n"
"  value_range   (0.0, 2.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_META                                                          \n"
"#define GEGL_OP_C_SOURCE dropshadow.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"/* in attach we hook into graph adding the needed nodes */                    \n"
"static void                                                                   \n"
"attach (GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglNode  *gegl = operation->node;                                          \n"
"  GeglNode  *input, *output, *over, *translate, *opacity, *blur, *darken, *color;\n"
"  GeglColor *black_color = gegl_color_new (\"rgb(0.0,0.0,0.0)\");             \n"
"                                                                              \n"
"  input     = gegl_node_get_input_proxy (gegl, \"input\");                    \n"
"  output    = gegl_node_get_output_proxy (gegl, \"output\");                  \n"
"  over      = gegl_node_new_child (gegl, \"operation\", \"gegl:over\", NULL); \n"
"  translate = gegl_node_new_child (gegl, \"operation\", \"gegl:translate\", NULL);\n"
"  opacity   = gegl_node_new_child (gegl, \"operation\", \"gegl:opacity\", NULL);\n"
"  blur      = gegl_node_new_child (gegl, \"operation\", \"gegl:gaussian-blur\",\n"
"                                         \"clip-extent\", FALSE, NULL);       \n"
"  darken    = gegl_node_new_child (gegl, \"operation\", \"gegl:src-in\", NULL);\n"
"  color     = gegl_node_new_child (gegl, \"operation\", \"gegl:color\",       \n"
"                                   \"value\", black_color,                    \n"
"                                   NULL);                                     \n"
"                                                                              \n"
"  g_object_unref (black_color);                                               \n"
"                                                                              \n"
"  gegl_node_link_many (input, darken, blur, opacity, translate, over, output, \n"
"                       NULL);                                                 \n"
"  gegl_node_connect_from (over, \"aux\", input, \"output\");                  \n"
"  gegl_node_connect_from (darken, \"aux\", color, \"output\");                \n"
"                                                                              \n"
"  gegl_operation_meta_redirect (operation, \"radius\", blur, \"std-dev-x\");  \n"
"  gegl_operation_meta_redirect (operation, \"radius\", blur, \"std-dev-y\");  \n"
"  gegl_operation_meta_redirect (operation, \"x\", translate, \"x\");          \n"
"  gegl_operation_meta_redirect (operation, \"y\", translate, \"y\");          \n"
"  gegl_operation_meta_redirect (operation, \"color\", color, \"value\");      \n"
"  gegl_operation_meta_redirect (operation, \"opacity\", opacity, \"value\");  \n"
"                                                                              \n"
"  gegl_operation_meta_watch_nodes (operation,                                 \n"
"                                   over, translate, opacity,                  \n"
"                                   blur, darken, color,                       \n"
"                                   NULL);                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_CLASS (klass);         \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:dropshadow\",                                     \n"
"    \"categories\",  \"effects:light\",                                       \n"
"    \"description\",                                                          \n"
"    _(\"Creates a dropshadow effect on the input buffer\"),                   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
