//genesis
/**********************************************************************
** This program is part of kinetikit and is
**           copyright (C) 1995-2001 Upinder S. Bhalla.
** It is made available under the terms of the GNU General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/

int pathway_id

// This function dumps the notes
function db_dumpnotes(filename, elm)
	echo > textsave
	call {elm}/notes SAVE textsave
	// This little hack puts the sed script in kkit9_sedfile
	// I do it this way because the path of the sedfile is system-
	// dependent. Also the file includes characters I cannot echo. 
	call /dumpdb_textfile/text SAVE2
	sed -f kkit9_sedfile textsave >> {filename}
// The below version was there before. It uses an absolute path
// for the sedfile, causing much grief.
//	sed -f /home/bhalla/scripts/kkit8/sfile textsave
	echo > textsave
	echo ");" >> {filename}
	sh rm kkit9_sedfile
end

function db_dumpdisp(filename, elm)
	str filename
	str elm

	echo {getfield {elm} x}, >> {filename}
	echo {getfield {elm} y}, >> {filename}
	echo {getfield {elm} z}, >> {filename}
	echo '{getfield {elm} xtree_fg_req}', >> {filename}
end

// This function dumps all the info for channels
function db_dumpchans(filename, group)
	str filename
	str group

	float perm
	int i, j

	if ({getarg {el {group}/#[]/#[][TYPE=kchan]} -count} == 0)
		return
	end
	str name
	foreach name ({el {group}/#[]/#[][TYPE=kchan]})
		perm = {getfield {name} perm}
		echo {getpath {el {name}/..} -tail}/{getpath {name} -tail} {perm} >> {filename}
	end
	echo >> {filename}
end

function do_extract_sumtotal(filename)
	str filename

	str name
	int nmsgs
	int i, j
	str s

	foreach name ({el /kinetics/#[][TYPE=kpool]})
		nmsgs = {getmsg {name} -incoming -count}
		j = 1
		for (i = 0; i < nmsgs; i = i + 1)
			if ({strcmp {getmsg {name} -incoming -type {i}} "SUMTOTAL"} == 0)
				s = {getmsg {name} -incoming -source {i}}
				echo SELECT @s1 := id FROM molecule WHERE name = '{getpath {s} -tail}' AND accessno = @accessno ";" >> {filename}
				echo UPDATE molecule set sumtotal{j} = @s1 WHERE name = '{getpath {name} -tail}' AND accessno = @accessno ";" >> {filename}
				j = j + 1
			end
		end
	end
end

// This function dumps all the info for pools
function db_dumppools(filename, group)
	str filename
	str group

	float CoInit, buffered
	float realvol, vol
	float scale = {getfield /editcontrol/conc scalefactor}
	int i, j

	str name

	if ({getarg {el {group}/#[][TYPE=kpool]} -count} == 0)
		return
	end

	foreach name ({el {group}/#[][TYPE=kpool]})
		CoInit = {getfield {name} CoInit}
		buffered = {getfield {name} slave_enable}
		if ({{buffered} & 4} == 4)
			buffered = 1
		else
			buffered = 0
		end
		vol = {getfield {name} vol}
		realvol = scale * vol / NA
		echo >> {filename}
		echo insert into molecule >> {filename}
		echo "(name, accessno, pathway," >> {filename}
		echo "is_buffered, initial_conc," >> {filename}
		echo "volume, " >> {filename}
		echo "dispx, dispy, dispz, dispcolor, " >> {filename}
		echo "notes)" >> {filename}
		echo "VALUES ('"{getpath {name} -tail}"'," >> {filename}
		echo "@accessno, @pathwayno, " >> {filename}
		echo {buffered}, {CoInit}, {realvol},  >> {filename}
		db_dumpdisp {filename} {name}
		db_dumpnotes {filename} {name}
	end
end
// This function makes a string of the names of all msg dest of the
// given msgtype
function find_outputs(elm, mtype)
	str elm
	str mtype

	int i
	int j = 0
	int nmsg = {getmsg {elm} -outgoing -count}
	str type
	str dest
	str ret = ""

	for (i = 0; i < nmsg; i = i + 1)
		type = {getmsg {elm} -outgoing -type {i}}
		if ({strcmp {type} {mtype}} == 0)
			dest = {getmsg {elm} -outgoing -dest {i}}
			dest = {getpath {dest} -tail}
			ret = ret @ "'" @ {dest} @ "', "
			j = j + 1
		end
	end
	for (i = j; j < 5; j = j + 1)
		ret = ret @ "'', "
	end
	return {ret}
end

// This function makes a string of the names of all msg src of the
// given msgtype
function find_inputs(elm, mtype)
	str elm
	str mtype

	int i
	int j = 0
	int nmsg = {getmsg {elm} -incoming -count}
	str type
	str src
	str ret = ""

	for (i = 0; i < nmsg; i = i + 1)
		type = {getmsg {elm} -incoming -type {i}}
		if ({strcmp {type} {mtype}} == 0)
			src = {getmsg {elm} -incoming -source {i}}
			src = {getpath {src} -tail}
			ret = ret @ "'" @ {src} @ "', "
			j = j + 1
		end
	end
	for ( i = j; j < 5; j = j + 1)
		ret = ret @ "'', "
	end
	return {ret}
end

// This function dumps all the info for enzs
function db_dumpenzs(filename, group)
	str filename
	str group

	float k1, k2, k3, Km, Vmax
	int i, j
	int nsub
	str orig_name = {getfield /parmedit/enz elmpath}
	str name
	int is_available

	if ({getarg {el {group}/#[]/#[][TYPE=kenz]} -count} == 0)
		return
	end

	foreach name ({el {group}/#[]/#[][TYPE=kenz]})
		k1 = {getfield {name} k1}
		k2 = {getfield {name} k2}
		k3 = {getfield {name} k3}
		calc_mm {name}

		Vmax = {getfield /parmedit/enz/Vmax value}
		Km  = {getfield /parmedit/enz/Km value}
		nsub = {find_enz_order {name}}
		is_available = {getfield {name} usecomplex}

		echo >> {filename}
		echo insert into enzyme  >> {filename}
		echo "(name, accessno, pathway," >> {filename}
		echo parent, Km, Vmax, ratio, nsub, nprd, >> {filename}
		echo is_available, >> {filename}
		echo sub1, sub2, sub3, sub4, sub5, >> {filename}
		echo prd1, prd2, prd3, prd4, prd5, >> {filename}
		echo "dispx, dispy, dispz, dispcolor, " >> {filename}
		echo "notes)" >> {filename}

		echo "VALUES ('"{getpath {name} -tail}"', " >> {filename}
		echo "@accessno, @pathwayno," >> {filename}
		echo '{getpath {el {name}/..} -tail}', >> {filename}
		echo {Km}, {Vmax}, {k2/k3}, {nsub}, 0, >> {filename}
		echo {is_available}, >> {filename}
		echo {find_inputs {name} "SUBSTRATE"} >> {filename}
		echo {find_outputs {name} "MM_PRD"} >> {filename}

		db_dumpdisp {filename} {name}
		db_dumpnotes {filename} {name}
	end

	setfield /parmedit/enz elmpath {orig_name}
	do_update_enzinfo
end

// This function dumps all the info for reacs
function db_dumpreacs(filename, group)
	str filename
	str group

	float kf, kb, Kf, Kb, Kd, tau
	int i, j
	str sub_order
	str prd_order

	str name
	str orig_name = {getfield /parmedit/reac elmpath}

	if ({getarg {el {group}/#[][TYPE=kreac]} -count} == 0)
		return
	end
	foreach name ({el {group}/#[][TYPE=kreac]})
		setfield /parmedit/reac elmpath {name}
		do_update_reac_scaling

		kf = {getfield {name} kf}
		kb = {getfield {name} kb}

		Kf = {getfield /parmedit/reac/skf value}
		Kb = {getfield /parmedit/reac/skb value}
		Kd = {getfield /parmedit/reac/Kd value}
		tau = {getfield /parmedit/reac/Tau value}
		sub_order = {getfield /parmedit/reac/forder label}
		prd_order = {getfield /parmedit/reac/border label}

		echo >> {filename}
		echo "insert into reaction " >> {filename}
		echo "(name, accessno, pathway," >> {filename}
		echo "Kf, Kb, nsub, nprd," >> {filename}
		echo "sub1, sub2, sub3, sub4, sub5, prd1," >> {filename}
		echo "prd2, prd3, prd4, prd5, " >> {filename}
		echo "dispx, dispy, dispz, dispcolor, " >> {filename}
		echo "notes)" >> {filename}
		
		echo "VALUES ('"{getpath {name} -tail}"', " >> {filename}
		echo "@accessno, @pathwayno, "{Kf}, {Kb}, >> {filename}
		echo {sub_order}, {prd_order}, >> {filename}

		echo {find_inputs {name} "SUBSTRATE"} >> {filename}
		echo {find_inputs {name} "PRODUCT"} >> {filename}
		db_dumpdisp {filename} {name}
		db_dumpnotes {filename} {name}
	end
	setfield /parmedit/reac elmpath {orig_name}
	do_update_reacinfo
end

// This function dumps all info for a group
function db_dumpgroup(filename, group)
	str pathname = {getpath {group} -tail}
	echo insert into pathway (accessno, name, entrydate, >> {filename}
	echo "dispx, dispy, dispz, dispcolor, " >> {filename}
	echo "notes)" >> {filename}
	
	echo VALUES (@accessno, '{pathname}', CURDATE(), >> {filename}
	db_dumpdisp {filename} {group}
	db_dumpnotes {filename} {group}
	echo >> {filename}

	echo "select @pathwayno := last_insert_id();"  >> {filename}
	echo >> {filename}


	echo "update pathway set" >> {filename}
	echo "figure=LOAD_FILE('/tmp/"{pathname}".png')" >> {filename}
	echo "where accessno = @accessno " >> {filename}
	echo "AND pathwayno = @pathwayno;" >> {filename}
	echo >> {filename}

	echo "update pathway set" >> {filename}
	echo "kkitfile=LOAD_FILE('/tmp/"{pathname}".g')" >> {filename}
	echo "where accessno = @accessno" >> {filename}
	echo "AND pathwayno = @pathwayno;" >> {filename}
	echo >> {filename}

	db_dumpreacs {filename} {group}
	echo >> {filename}
	db_dumpenzs {filename} {group}
	echo >> {filename}
	// dumpchans {filename} {group}
	db_dumppools {filename} {group}

	echo done dumping {group}
end

function dumpunits(filename)
	str filename

	echo >> {filename}
	echo Concentration units: {getfield /editcontrol/conc unitname} >> {filename}
	echo Time units: {getfield /editcontrol/time unitname} >> {filename}
	echo Default {getfield /editcontrol/vol label} :  {getfield /editcontrol/vol value} >> {filename}
	echo >> {filename}
end

function db_newaccession(filename, login, passwd, fname, accessno)
	str filename
	str accessname
	str atype = "pathway"
	str login
	str passwd
	str fname
	int accessno

	if ({getfield /dumpdb/atype state} == 1)
		atype = "network"
	end

	echo "use doqcs;" >> {filename}
	if (accessno > 0) // old entry
		echo select @c:= COUNT(*) from accession >> {filename}
		echo where accessno = {accessno} >> {filename}
		echo AND login = '{login}' >> {filename}
		echo "AND password= PASSWORD('"{passwd}"');" >> {filename}

		// If the above mouthful is true, then @c is nonzero
		// Since accession number is unique, @c can only be 1 or 0
		echo delete from accession >> {filename}
		echo where accessno = {accessno} AND @c= 1";" >> {filename}

		echo delete from pathway >> {filename}
		echo where accessno = {accessno} AND @c= 1";" >> {filename}

		echo delete from molecule >> {filename}
		echo where accessno = {accessno} AND @c= 1";" >> {filename}

		echo delete from reaction >> {filename}
		echo where accessno = {accessno} AND @c= 1";" >> {filename}

		echo delete from enzyme >> {filename}
		echo where accessno = {accessno} AND @c= 1";" >> {filename}
	end
	echo >> {filename}
	echo insert into accession >> {filename}
	echo "(name, accesstype, entrydate," >> {filename}
	echo "transcriber, developer, citation, " >> {filename}
	echo "login, password, kkitfile, notes)" >> {filename}
	echo VALUES >> {filename}
	echo ( >> {filename}
	echo '{getfield /dumpdb/accessname value}', >> {filename}
	echo '{atype}', >> {filename}
	echo CURDATE(), >> {filename}
	echo '{getfield /dumpdb/transcriber value}', >> {filename}
	echo '{getfield /dumpdb/developer value}',  >> {filename}
	echo '{getfield /dumpdb/citation value}',  >> {filename}
	echo '{login}', PASSWORD('{passwd}'), >> {filename}
	echo LOAD_FILE('/tmp/{fname}'),  >> {filename}

	call /dumpdb/NOTES PROCESS
	echo '{getfield /dumpdb/NOTES initialtext}' >> {filename}
	
	echo )";" >> {filename}
	echo >> {filename}

	echo "select @accessno := last_insert_id();" >> {filename}
end

function dump_db(filename, login, passwd, fname, accessno)
	str filename
	str login
	str passwd
	str fname
	int accessno

	str name

// This function scans through the entire simulation in stages, and
// dumps out all rates, initial values, and the order of reactions.
	
	echo > {filename}

	db_newaccession {filename} {login} {passwd} {fname} {accessno}

	db_dumpgroup {filename} /kinetics
	foreach name ({el /kinetics/##[][TYPE=group]})
		db_dumpgroup {filename} {name}
	end
	// Now that all the pools are in, look for SUMTOTAL messages
	do_extract_sumtotal {filename}

	do_inform "Finished dumping simulation data to "{filename}
end

function xdumpdb
	dump_db {getfield /dumpdb/filename value} \
		{getfield /dumpdb/login value} \
		{getfield /dumpdb/passwd value} \
		{getfield /dumpdb/fname value} \
		{getfield /dumpdb/accessno value}
end

function make_xdump_db
	create xform /dumpdb [15%,100,50%,500] \
		-label "Generate database dump file"
	pushe /dumpdb
	create xdialog filename -value "model.db"
	create xdialog accessname -label "Name of accession:" \
		-value "New_pathway"
	// create xdialog atype -label "Type of accession:" -value "network"
	create xlabel atypelabel -wgeom 50% -label "Accession type:"
	create xtoggle atype [0:last,0:accessname,50%,] \
		-onlabel "Network" -offlabel "Pathway"
	create xdialog transcriber -label "Transcriber:" \
		-value "Upinder S. Bhalla, NCBS"
	create xdialog developer -label "Model developer:" \
		-value "Upinder S. Bhalla, NCBS"
	create xdialog citation -label "Citation:" \
		-value "Bhalla and Iyengar 1999 Science 283:381-387"
	create xdialog login -label "Login" -value "mylogin"
	create xdialog passwd -label "Password" -value "mypasswd"
	create xdialog fname -label "Model file" -value "model.g"
	create xdialog accessno -label "Old accession #" -value "0"
	create xtext NOTES -hgeom 100 -editable 1
	create xbutton Cancel -script "xhide /dumpdb"
	create xbutton Submit -script "xdumpdb"
	pope
	create xform /dumpdb_textfile
	create xtext /dumpdb_textfile/text -filename "kkit9_sedfile"
end
