/******************************************************************************
**
** Cmdline.java
**
** Sun Mar 14 16:38:31 2010
** Linux 2.6.23 (#9 Sun Jan 27 22:29:05 CET 2008) i686
** linux@mgpc (Michael Geng)
**
** Definition of command line parser class
**
** Automatically created by genparse v0.8.7
**
** See http://genparse.sourceforge.net for details and updates
**
******************************************************************************/

import gnu.getopt.LongOpt;
import gnu.getopt.Getopt;

/*----------------------------------------------------------------------------
**
** class Cmdline ()
**
** Command line parser class.
**
**--------------------------------------------------------------------------*/

public class Cmdline implements CmdlineInterface
{
  /* parameters */
  private int _i;
  private String _o = "";
  private boolean _h;
  private boolean _v;

  /* Name of the calling program */
  private String _executable;

  /* next (non-option) parameter */
  private int _optind;

  /* Must be constructed with parameters. */
  public Cmdline (String[] argv) throws CmdlineEx
  {
    /* character returned by optind () */
    int c;

    LongOpt[] longopts = new LongOpt[4];
    longopts[0] = new LongOpt ("iterations", LongOpt.REQUIRED_ARGUMENT, null, 'i');
    longopts[1] = new LongOpt ("outfile", LongOpt.REQUIRED_ARGUMENT, null, 'o');
    longopts[2] = new LongOpt ("help", LongOpt.NO_ARGUMENT, null, 'h');
    longopts[3] = new LongOpt ("version", LongOpt.NO_ARGUMENT, null, 'v');

    _executable = Cmdline.class.getName ();

    /* default values */
    _i = 1;
    _h = false;
    _v = false;

    Getopt g = new Getopt (_executable, argv, "i:o:hv", longopts);
    while ((c = g.getopt ()) != -1)
    {
      switch (c)
      {
        case 'i': 
          _i = Integer.parseInt (g.getOptarg ());
          if (_i < 1)
            throw new CmdlineEx ("parameter range error: i must be >= 1");
          if (_i > 10)
            throw new CmdlineEx ("parameter range error: i must be <= 10");
          break;

        case 'o': 
          _o = g.getOptarg ();
          if (!outfile_cb ())
            usage (-1, _executable);
          break;

        case 'h': 
          _h = true;
          usage (0, _executable);
          break;

        case 'v': 
          _v = true;
          break;

        default:
          usage (-1, _executable);

        }
    } /* while */

    _optind = g.getOptind ();
    if (!my_callback ())
      usage (-1, _executable);

  }

  public void usage (int status, String program_name)
  {
    if (status != 0)
      {
        System.err.println ("Try `" + program_name + " --help' for more information.");
      }
    else
      {
        System.out.println (
"usage: " + program_name + " [ -iohv ] file\n" +
"Print a file for a number of times to stdout.\n" +
"   [ -i ] [ --iterations ] (type=INTEGER, range=1...10, default=1)\n" +
"          Number of times to output <file>.\n" +
"          do it like this\n" +
"   [ -o ] [ --outfile ] (type=STRING)\n" +
"          Output file.\n" +
"   [ -h ] [ --help ] (type=FLAG)\n" +
"          Display this help and exit.\n" +
"   [ -v ] [ --version ] (type=FLAG)\n" +
"          Output version information and exit.");
      }
    System.exit (status);
  }

  /* return next (non-option) parameter */
  public int next_param () { return _optind; }

  /* Callback functions */
  /* Derive your own class and overwrite any of the callback  */
  /* functions if you need customized callbacks. */
  public boolean my_callback () { return true; }
  public boolean outfile_cb () { return true; }

  /* getter functions for command line parameters */
  public int i () { return _i; }
  public String o () { return _o; }
  public boolean h () { return _h; }
  public boolean v () { return _v; }
}
