// GENPO - the GENeral Purpose Organ
// Copyright (C) 2003-2007 - Steve Merrony 

// This program is free software; you may redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.

// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.

// You should have received a copy of the GNU General Public License along with 
// this program; if not, write to the Free Software Foundation, Inc., 59 Temple 
// Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef CONSOLE_H
#define CONSOLE_H

#include "division.h"
#include "toepiston.h"
#include "voice.h"

#include <alsa/asoundlib.h>

#include <qstring.h>
    
    

const int MAX_DIVISIONS = 8;
const int MIDI_CHANNELS_PER_PORT = 16;
const int MAX_INPUT_CHANNELS = 16; // This is not necessarily either MAX_DIVISIONS or M_C_P_P...
const int MAX_MIDI_OUTPUT_PORTS = 2;     // max output ports/synths 
const int MAX_MIDI_VOICES = MIDI_CHANNELS_PER_PORT * MAX_MIDI_OUTPUT_PORTS;
const int MAX_TOE_PISTONS = 16;
const int FREE_CHANNEL = -1;       // indicates that channel is unallocated

typedef struct {
  int my_client;
  int seq_client;
  snd_seq_t *seq_handle;
  snd_seq_event_t ev;
} midi_seq;

typedef struct {
  int my_port;
  int seq_port;
} midi_port;


/* N.B. Any additions here will probably need to be handled in TWO 
   places: configParser::characters and configParser::copyConfig */

class Console {
public:
  Console();
  ~Console();
  QString orgFileName;
  QString organName;
  bool    verboseMode;
  bool    singleStopMode;
  bool    requestedOutput;
  int     requestedOutClient;
  int     requestedOutPort;
  QString soundFont;
  QString description;
  QString acceleratorStyle;
  int     num_divisions;
  Division  divisions[MAX_DIVISIONS];
  int     channel_division_map[MAX_INPUT_CHANNELS]; // store the manual assoc with each channel for fast lookup
  int     num_toePistons;
  ToePiston toePistons[MAX_TOE_PISTONS];
  Voice   voices[MAX_MIDI_VOICES]; 
  midi_seq  seq;
  midi_port inp_port;
  midi_port out_port_a, out_port_b;
  int       num_out_ports;

};

#endif
