# GeographicLib

GeographicLib is a small C++ library for

* geodesic and rhumb line calculations;
* conversions between geographic, UTM, UPS, MGRS, geocentric, and local
  cartesian coordinates;
* gravity (e.g., EGM2008) and geomagnetic field (e.g., WMM2020)
  calculations.

It is licensed under the MIT License; see
[LICENSE.txt](https://geographiclib.sourceforge.io/LICENSE.txt).

## Links:

* Library documentation (latest release):
  https://geographiclib.sourceforge.io/C++/doc
* Library documentation (all versions):
  https://geographiclib.sourceforge.io/C++
* Change log: https://geographiclib.sourceforge.io/C++/doc/changes.html
* Git repository: https://github.com/geographiclib/geographiclib
  * Releases are on the [`release`](../../tree/release) branch, and specific
    releases are tagged as, e.g., [`r1.52`](../../tree/r1.52),
    [`r2.0`](../../tree/r2.0), etc.  This is the appropriate branch
    for most *users* of GeographicLib.
  * The main branch is [`main`](../..) and most development is done on
    the [`devel`](../../tree/devel) branch.  These branches are for the
    *developers* of GeographicLib.  Tags [`v1.52`](../../tree/v1.52),
    [`v2.0`](../../tree/v2.0), etc., are aligned with the
    corresponding release tags `r1.52`, `r2.0`, etc.
* Source distribution:
  https://sourceforge.net/projects/geographiclib/files/distrib-C++
* GeographicLib: https://geographiclib.sourceforge.io
* GeographicLib in various languages:
  https://geographiclib.sourceforge.io/doc/library.html#languages
* Author: Charles Karney, <karney@alum.mit.edu>
