
#include <iostream>
#include <string>
#include <fstream>
#include <stdexcept>
#include <vector>
#include <cerrno>
#include <cstring>
#include <cstdlib>
#include <cstdio>
#include <ctime>
#include <ios>
#include <set>
#include <functional>
#include <clocale>
#include <cxxabi.h>
#include <ext/malloc_allocator.h>
#include <boost/noncopyable.hpp>
#include "geordi.hpp"
#include "bin_iomanip.hpp"

namespace geordi
{
  namespace
  {
    bool is_prefix_of(char const * a, char const * b) { while(*a && *b == *a) { ++a; ++b; } return !*a; }

    void terminate_handler(bool const unexp)
    {
      // We use printf because cout may be dead.

      std::printf("%sterminated", parsep);

      if(std::type_info const * const t = abi::__cxa_current_exception_type())
      {
        int status = 0;
        char const * const name = abi::__cxa_demangle(t->name(), 0, 0, &status);

        // In OOM conditions, the above call to __cxa_demangle will fail (and name will be 0). Supplying a preallocated buffer using __cxa_demangle's second and third parameters does not help, because it performs additional internal allocations.

        std::printf(" by ");
        if(unexp) std::printf("unexpected ");
        try { throw; }
        catch(std::exception const & e)
        {
          char const * const what = e.what();
          if(!name) std::printf("exception: ");
          else if(!is_prefix_of(name, what)) std::printf("%s: ", name);
          std::printf("%s", what);
        }
        catch(char const * const s) { std::printf("exception: %s", s); }
        catch(int const i) { std::printf("exception: %d", i); }
        catch(...)
        {
          std::printf("exception");
          if(name) std::printf(" of type %s", name);
        }
      }

      std::fclose(stdout);
      std::abort();
    }

    void terminate_handler() { terminate_handler(false); }
    void unexpected_handler() { terminate_handler(true); }
  }

  initializer_t::initializer_t ()
  {
    std::ios_base::Init const i;

    std::boolalpha(std::cout);

    std::cout.imbue(std::locale(std::cout.getloc(), new bin_num_put<>));
    std::wcout.imbue(std::locale(std::wcout.getloc(), new bin_num_put<wchar_t>));
      // Having this compiled separately saves more than a full second per request.

    std::set_terminate(terminate_handler);
    std::set_unexpected(unexpected_handler);

    std::setlocale(LC_ALL, "");
  }

  utsname uname()
  {
    utsname r;
    if (uname(&r)) throw std::runtime_error(std::strerror(errno));
    return r;
  }
} // namespace geordi
