
/*
 * ProgressDlg.java
 *
 * Created on April 9, 2001, 9:10 AM
 */

package geotrans.gui;


import geotrans.jni.JNIFiomeths;
import geotrans.jni.JNIStrtoval;
import geotrans.jni.GeotransError;
import geotrans.utility.Center;


/**
 *
 * @author  amyc
 * @version 
 */
public class ProgressDlg extends javax.swing.JDialog {

    JNIFiomeths jniFiomeths;
    
    /** Creates new form ProgressDlg */
    public ProgressDlg(javax.swing.JDialog parent, boolean modal, JNIFiomeths jni_Fiomeths) {
        super (parent, modal);
        jniFiomeths = jni_Fiomeths;
        initComponents ();
        numProcessedLabel.setVisible(false);
        numWarningsLabel.setVisible(false);
        numErrorsLabel.setVisible(false);
        elapsedTimeLabel.setVisible(false);
        pack ();
        new Center(parent, this);        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
  // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    buttonsPanel = new javax.swing.JPanel();
    startButton = new javax.swing.JButton();
    okButton = new javax.swing.JButton();
    cancelButton = new javax.swing.JButton();
    statusLabel = new javax.swing.JLabel();
    resultsPanel = new javax.swing.JPanel();
    numProcessedLabel = new javax.swing.JLabel();
    numWarningsLabel = new javax.swing.JLabel();
    numErrorsLabel = new javax.swing.JLabel();
    elapsedTimeLabel = new javax.swing.JLabel();

    setTitle("GEOTRANS File Processing");
    setResizable(false);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        closeDialog(evt);
      }
    });

    buttonsPanel.setLayout(new java.awt.GridBagLayout());

    buttonsPanel.setPreferredSize(new java.awt.Dimension(274, 26));
    buttonsPanel.setMinimumSize(new java.awt.Dimension(274, 26));
    startButton.setPreferredSize(new java.awt.Dimension(76, 21));
    startButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
    startButton.setMnemonic(java.awt.event.KeyEvent.VK_S);
    startButton.setMaximumSize(new java.awt.Dimension(76, 21));
    startButton.setText("Start");
    startButton.setMinimumSize(new java.awt.Dimension(76, 21));
    startButton.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(java.awt.event.MouseEvent evt) {
        startButtonMousePressed(evt);
      }
      public void mouseReleased(java.awt.event.MouseEvent evt) {
        startButtonMouseReleased(evt);
      }
    });

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
    gridBagConstraints.insets = new java.awt.Insets(0, 2, 4, 15);
    buttonsPanel.add(startButton, gridBagConstraints);

    okButton.setPreferredSize(new java.awt.Dimension(76, 21));
    okButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
    okButton.setMnemonic(java.awt.event.KeyEvent.VK_O);
    okButton.setMaximumSize(new java.awt.Dimension(76, 21));
    okButton.setText("OK");
    okButton.setMinimumSize(new java.awt.Dimension(76, 21));
    okButton.setEnabled(false);
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okButtonActionPerformed(evt);
      }
    });

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 1;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
    gridBagConstraints.insets = new java.awt.Insets(0, 2, 4, 15);
    buttonsPanel.add(okButton, gridBagConstraints);

    cancelButton.setPreferredSize(new java.awt.Dimension(76, 21));
    cancelButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
    cancelButton.setMnemonic(java.awt.event.KeyEvent.VK_C);
    cancelButton.setMaximumSize(new java.awt.Dimension(76, 21));
    cancelButton.setText("Cancel");
    cancelButton.setMinimumSize(new java.awt.Dimension(76, 21));
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 2;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
    gridBagConstraints.insets = new java.awt.Insets(0, 2, 4, 0);
    buttonsPanel.add(cancelButton, gridBagConstraints);

    getContentPane().add(buttonsPanel, java.awt.BorderLayout.SOUTH);

    statusLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    statusLabel.setText("Waiting");
    statusLabel.setMaximumSize(new java.awt.Dimension(35, 26));
    statusLabel.setMinimumSize(new java.awt.Dimension(35, 26));
    statusLabel.setPreferredSize(new java.awt.Dimension(35, 26));
    getContentPane().add(statusLabel, java.awt.BorderLayout.NORTH);

    resultsPanel.setLayout(new java.awt.GridBagLayout());

    resultsPanel.setPreferredSize(new java.awt.Dimension(274, 100));
    resultsPanel.setMinimumSize(new java.awt.Dimension(274, 100));
    numProcessedLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    numProcessedLabel.setText("Num Processed:");
    numProcessedLabel.setMaximumSize(new java.awt.Dimension(274, 16));
    numProcessedLabel.setMinimumSize(new java.awt.Dimension(274, 16));
    numProcessedLabel.setPreferredSize(new java.awt.Dimension(274, 16));
    resultsPanel.add(numProcessedLabel, new java.awt.GridBagConstraints());

    numWarningsLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    numWarningsLabel.setText("Num Warnings:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    resultsPanel.add(numWarningsLabel, gridBagConstraints);

    numErrorsLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    numErrorsLabel.setText("Num Errors:");
    numErrorsLabel.setMaximumSize(new java.awt.Dimension(73, 16));
    numErrorsLabel.setMinimumSize(new java.awt.Dimension(73, 16));
    numErrorsLabel.setPreferredSize(new java.awt.Dimension(73, 16));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 2;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    resultsPanel.add(numErrorsLabel, gridBagConstraints);

    elapsedTimeLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
    elapsedTimeLabel.setText("Elapsed Time:");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 3;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    resultsPanel.add(elapsedTimeLabel, gridBagConstraints);

    getContentPane().add(resultsPanel, java.awt.BorderLayout.CENTER);

  }// </editor-fold>//GEN-END:initComponents

  private void startButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_startButtonMousePressed
    statusLabel.setText("In Progress");
    this.setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
    startButton.setEnabled(false);
    cancelButton.setEnabled(false);
  }//GEN-LAST:event_startButtonMousePressed

  private void startButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_startButtonMouseReleased
    long numProcessed = 0;
    long numErrors = 0;
    long numWarnings = 0;
//    double elapsedTime = 0;
    
    try
    {
        jniFiomeths.JNIConvertFile();
        statusLabel.setText("Completed");
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        numProcessed = jniFiomeths.JNIGetNumProcessed();
        numProcessedLabel.setVisible(true);
        numProcessedLabel.setText("Number of coordinates processed = " + numProcessed);
        
        numWarnings = jniFiomeths.JNIGetNumWarnings();
        numWarningsLabel.setVisible(true);
        numWarningsLabel.setText("Number of warnings = " + numWarnings);

        numErrors = jniFiomeths.JNIGetNumErrors();
        numErrorsLabel.setVisible(true);
        numErrorsLabel.setText("Number of errors = " + numErrors);
        
     /*   elapsedTime = jniFiomeths.JNIGetElapsedTime();
        elapsedTimeLabel.setVisible(true);
        elapsedTimeLabel.setText("Elapsed Time = " + elapsedTime + "s");*/
        
        okButton.setEnabled(true);
    }
    catch(GeotransError e)
    {
        new JNIStrtoval().displayErrorMsg(this, e.getMessage());
        jniFiomeths.JNICloseInputFile();
        jniFiomeths.JNICloseOutputFile();
    }        
  }//GEN-LAST:event_startButtonMouseReleased

  private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    setVisible( false );
    dispose();      
  }//GEN-LAST:event_okButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    setVisible( false );
    jniFiomeths.JNICloseInputFile();
    jniFiomeths.JNICloseOutputFile();
    dispose();      
  }//GEN-LAST:event_cancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible (false);
        jniFiomeths.JNICloseInputFile();
        jniFiomeths.JNICloseOutputFile();
        dispose ();
    }//GEN-LAST:event_closeDialog

    /**
    * @param args the command line arguments
    */
    public static void main (String args[]) {
        JNIFiomeths jni_Fiomeths = new JNIFiomeths();
        new ProgressDlg (new javax.swing.JDialog (), true, jni_Fiomeths).show ();
    }


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel buttonsPanel;
  private javax.swing.JButton cancelButton;
  private javax.swing.JLabel elapsedTimeLabel;
  private javax.swing.JLabel numErrorsLabel;
  private javax.swing.JLabel numProcessedLabel;
  private javax.swing.JLabel numWarningsLabel;
  private javax.swing.JButton okButton;
  private javax.swing.JPanel resultsPanel;
  private javax.swing.JButton startButton;
  private javax.swing.JLabel statusLabel;
  // End of variables declaration//GEN-END:variables

}
