/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graph;

import hypergraph.graph.AttributeManagerImpl;
import hypergraph.graph.EdgeImpl;
import hypergraph.graph.ElementImpl;
import hypergraph.graph.GraphEventImpl;
import hypergraph.graph.GraphSystemImpl;
import hypergraph.graph.GroupImpl;
import hypergraph.graph.Map2D;
import hypergraph.graph.NodeImpl;
import hypergraph.graph.NodeMap2D;
import hypergraph.graphApi.AttributeManager;
import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphEvent;
import hypergraph.graphApi.GraphException;
import hypergraph.graphApi.GraphListener;
import hypergraph.graphApi.GraphSystem;
import hypergraph.graphApi.Group;
import hypergraph.graphApi.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;

public class GraphImpl
extends ElementImpl
implements Graph,
GraphListener {
    protected Map nodes;
    protected Map groups;
    protected Map2D adjacencyList;
    protected Map edges;
    private AttributeManager attributeManager;
    private GraphImpl spanningTree;
    private GraphImpl spanningTreeRoot;
    private EventListenerList listenerList;
    GraphSystem graphSystem;
    static /* synthetic */ Class class$hypergraph$graphApi$GraphListener;

    GraphImpl(GraphSystemImpl graphSystemImpl) {
        super(graphSystemImpl.createId());
        this.graphSystem = graphSystemImpl;
        this.nodes = new HashMap();
        this.adjacencyList = new NodeMap2D();
        this.edges = new HashMap();
        this.groups = null;
        this.spanningTree = null;
        this.attributeManager = new AttributeManagerImpl(this);
        this.listenerList = new EventListenerList();
        this.addGraphListener(this);
    }

    public void elementsAdded(GraphEvent graphEvent) {
        this.spanningTree = null;
    }

    public void elementsRemoved(GraphEvent graphEvent) {
        this.spanningTree = null;
    }

    public void structureChanged(GraphEvent graphEvent) {
        this.spanningTree = null;
    }

    public void addGraphListener(GraphListener graphListener) {
        this.listenerList.add(class$hypergraph$graphApi$GraphListener == null ? (class$hypergraph$graphApi$GraphListener = GraphImpl.class$("hypergraph.graphApi.GraphListener")) : class$hypergraph$graphApi$GraphListener, graphListener);
    }

    public void removeGraphListener(GraphListener graphListener) {
        this.listenerList.remove(class$hypergraph$graphApi$GraphListener == null ? (class$hypergraph$graphApi$GraphListener = GraphImpl.class$("hypergraph.graphApi.GraphListener")) : class$hypergraph$graphApi$GraphListener, graphListener);
    }

    void fireElementsAdded(GraphEvent graphEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$hypergraph$graphApi$GraphListener == null ? GraphImpl.class$("hypergraph.graphApi.GraphListener") : class$hypergraph$graphApi$GraphListener)) continue;
            ((GraphListener)objectArray[i + 1]).elementsAdded(graphEvent);
        }
    }

    void fireElementsRemoved(GraphEvent graphEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$hypergraph$graphApi$GraphListener == null ? GraphImpl.class$("hypergraph.graphApi.GraphListener") : class$hypergraph$graphApi$GraphListener)) continue;
            ((GraphListener)objectArray[i + 1]).elementsRemoved(graphEvent);
        }
    }

    public GraphSystem getGraphSystem() {
        return this.graphSystem;
    }

    public synchronized void addElement(Element element) {
        if (element == null) {
            return;
        }
        if (element.getElementType() == 1) {
            boolean bl;
            boolean bl2 = bl = this.nodes.put(element.getName(), element) == null;
            if (bl) {
                this.fireElementsAdded(new GraphEventImpl(this, element));
            }
            return;
        }
        if (element.getElementType() == 2) {
            Edge edge = (Edge)element;
            if (this.isConnected(edge.getSource(), edge.getTarget())) {
                return;
            }
            this.addElement(edge.getSource());
            this.addElement(edge.getTarget());
            this.adjacencyList.put(edge.getSource(), edge.getTarget(), edge);
            this.edges.put(edge.getName(), edge);
            this.fireElementsAdded(new GraphEventImpl(this, edge));
            return;
        }
        if (element.getElementType() == 3) {
            if (this.groups == null) {
                this.groups = new HashMap();
            }
            this.groups.put(element.getName(), (Group)element);
            return;
        }
    }

    public synchronized void removeElement(Element element) {
        if (element == null) {
            return;
        }
        if (element.getElementType() == 1) {
            Collection collection = this.getEdges((Node)element);
            Object[] objectArray = collection.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.removeElement((Edge)objectArray[i]);
            }
            this.nodes.remove(element.getName());
            this.fireElementsRemoved(new GraphEventImpl(this, element));
            return;
        }
        if (element.getElementType() == 2) {
            this.adjacencyList.remove(((Edge)element).getSource(), ((Edge)element).getTarget());
            this.edges.remove(((Edge)element).getName());
            this.fireElementsRemoved(new GraphEventImpl(this, element));
            return;
        }
    }

    public synchronized void removeAll() {
        Object[] objectArray = this.nodes.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.removeElement((Node)objectArray[i]);
        }
    }

    public int getElementType() {
        return 0;
    }

    public Collection getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    public Collection getEdges() {
        return Collections.unmodifiableCollection(this.edges.values());
    }

    public Collection getEdges(Node node) {
        Map map = this.adjacencyList.get(node);
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.adjacencyList.get(node).values());
    }

    public void insertGraph(Graph graph) {
        if (graph == null) {
            return;
        }
        this.addEdges(graph.getEdges());
    }

    public Node createNode() {
        NodeImpl nodeImpl = new NodeImpl(GraphSystemImpl.createId());
        this.addElement(nodeImpl);
        return nodeImpl;
    }

    public Node createNode(String string) throws GraphException {
        if (string == null) {
            return this.createNode();
        }
        Element element = this.getElement(string);
        if (element != null) {
            throw new GraphException("Duplicate name \"" + string + "\"for element.");
        }
        NodeImpl nodeImpl = new NodeImpl(string);
        this.addElement(nodeImpl);
        return nodeImpl;
    }

    public Edge createEdge(Node node, Node node2) {
        if (node == null || node2 == null || node.equals(node2)) {
            return null;
        }
        EdgeImpl edgeImpl = new EdgeImpl(GraphSystemImpl.createId(), node, node2);
        this.addElement(edgeImpl);
        return edgeImpl;
    }

    public Edge createEdge(String string, Node node, Node node2) throws GraphException {
        if (string == null) {
            return this.createEdge(node, node2);
        }
        Element element = this.getElement(string);
        if (element != null) {
            throw new GraphException("Duplicate name \"" + string + "\"for element.");
        }
        EdgeImpl edgeImpl = new EdgeImpl(string, node, node2);
        this.addElement(edgeImpl);
        return edgeImpl;
    }

    public Group createGroup() {
        try {
            return this.createGroup(GraphSystemImpl.createId());
        }
        catch (GraphException graphException) {
            return null;
        }
    }

    public Group createGroup(String string) throws GraphException {
        if (string == null) {
            return this.createGroup();
        }
        Element element = this.getElement(string);
        if (element != null) {
            throw new GraphException("Duplicate name \"" + string + "\"for element.");
        }
        GroupImpl groupImpl = new GroupImpl(string);
        this.addElement(groupImpl);
        return groupImpl;
    }

    public Element getElement(String string) {
        Group group;
        Element element = (Element)this.nodes.get(string);
        if (element != null) {
            return element;
        }
        element = (Element)this.edges.get(string);
        if (element != null) {
            return element;
        }
        if (this.groups != null && (group = (Group)this.groups.get(string)) != null) {
            return group;
        }
        return null;
    }

    public void addNodes(Collection collection) {
        collection.addAll(collection);
    }

    public void addEdges(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addElement((Edge)iterator.next());
        }
    }

    public boolean isConnected(Node node, Node node2) {
        return this.adjacencyList.containsKey(node, node2);
    }

    public synchronized Graph getSpanningTree() {
        if (this.spanningTree == null) {
            Node node = this.getMinInDegree();
            this.getSpanningTree(node);
        }
        return this.spanningTree;
    }

    public synchronized Graph getSpanningTree(Node node) {
        AttributeManager attributeManager;
        Object object;
        if (this.spanningTree != null && node == (object = (Node)(attributeManager = this.spanningTree.getAttributeManager()).getAttribute("GRAPH_ROOT", this.spanningTree))) {
            return this.spanningTree;
        }
        this.spanningTree = new GraphImpl((GraphSystemImpl)this.getGraphSystem());
        this.spanningTree.addElement(node);
        attributeManager = this.spanningTree.getAttributeManager();
        attributeManager.setAttribute("GRAPH_ROOT", this.spanningTree, node);
        object = new HashSet();
        object.add(node);
        while (!object.isEmpty()) {
            Node node2 = (Node)object.iterator().next();
            object.remove(node2);
            Iterator iterator = this.getEdges(node2).iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                Node node3 = edge.getOtherNode(node2);
                if (this.spanningTree.getElement(node3.getName()) != null) continue;
                if (node3 == edge.getSource()) {
                    edge = new ReverseEdge("reverse" + edge.getName(), edge);
                }
                this.spanningTree.addElement(node3);
                this.spanningTree.addElement(edge);
                object.add(node3);
            }
        }
        return this.spanningTree;
    }

    public Node getMinInDegree() {
        Iterator iterator = this.getNodes().iterator();
        Node node = null;
        Node node2 = null;
        int n = -1;
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            int n2 = 0;
            Iterator iterator2 = this.getEdges(node2).iterator();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                if (!edge.getTarget().equals(node2)) continue;
                ++n2;
            }
            if (n < 0 || n > n2) {
                node = node2;
                n = n2;
            }
            if (n != 0) continue;
            break;
        }
        return node;
    }

    public Node getMaxOutDegree() {
        Iterator iterator = this.getNodes().iterator();
        Node node = null;
        Node node2 = null;
        int n = -1;
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            int n2 = 0;
            Iterator iterator2 = this.getEdges(node2).iterator();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                if (!edge.getSource().equals(node2)) continue;
                ++n2;
            }
            if (n >= n2) continue;
            node = node2;
            n = n2;
        }
        return node;
    }

    protected void createSpanningTreeDFS(Node node) {
        Iterator iterator = this.getEdges(node).iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            Node node2 = edge.getOtherNode(node);
            if (this.spanningTree.getElement(node2.getName()) == null) continue;
            if (node2 == edge.getSource()) {
                edge = new ReverseEdge("reverse" + edge.getName(), edge);
            }
            this.spanningTree.addElement(node2);
            this.spanningTree.addElement(edge);
            this.createSpanningTreeDFS(node2);
        }
    }

    protected void processBFS(Set set) {
        Node node = (Node)set.iterator().next();
        set.remove(node);
        Iterator iterator = this.getEdges(node).iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            Node node2 = edge.getOtherNode(node);
            if (this.spanningTree.getElement(node2.getName()) == null) continue;
            if (node2 == edge.getSource()) {
                edge = new ReverseEdge("reverse" + edge.getName(), edge);
            }
            this.spanningTree.addElement(node2);
            this.spanningTree.addElement(edge);
            set.add(node2);
        }
    }

    public void setAttributeManager(AttributeManager attributeManager) {
        this.attributeManager = attributeManager;
    }

    public AttributeManager getAttributeManager() {
        return this.attributeManager;
    }

    public Object clone() {
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "\n";
        stringBuffer.append("hypergraph.graph.GraphImpl" + string);
        stringBuffer.append("nodes : " + string);
        Iterator iterator = this.getNodes().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString() + string);
        }
        stringBuffer.append("edges : " + string);
        iterator = this.getEdges().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString() + string);
        }
        return stringBuffer.toString();
    }

    public String getLabel() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ReverseEdge
    extends ElementImpl
    implements Edge {
        private Edge underlying;

        public ReverseEdge(String string, Edge edge) {
            super(string);
            this.underlying = edge;
        }

        public String getName() {
            return this.underlying.getName();
        }

        public Group getGroup() {
            return this.underlying.getGroup();
        }

        public void setGroup(Group group) {
            this.underlying.setGroup(group);
        }

        public Node getSource() {
            return this.underlying.getTarget();
        }

        public Node getTarget() {
            return this.underlying.getSource();
        }

        public Node getOtherNode(Node node) {
            return this.underlying.getOtherNode(node);
        }

        public void reverse() {
            this.underlying.reverse();
        }

        public String getLabel() {
            return this.underlying.getLabel();
        }

        public void setLabel(String string) {
            this.underlying.setLabel(string);
        }

        public int getElementType() {
            return 2;
        }

        public String toString() {
            return "[ ReverseEdge : \n  underlying Edge : " + this.underlying + " ]\n";
        }
    }
}

