/* $Id: callbacks.c,v 1.35 2003/01/31 09:39:08 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik. Released under GPL license.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <gdk/gdkkeysyms.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include "callbacks.h"
#include "gg-types.h"
#include "gg.h"
#include "ggcore.h"
#include "search.h"
#include "support.h"
#include "interface.h"
#include "preferences.h"
#include "userstatus.h"

extern GGConfig config;
extern GGStatus status;
extern GList *kontakty;
extern GList *wyniki_kontakty;
extern GList *sessions;
extern GList *ignore;

extern GtkWidget *window;
extern GtkWidget *wyniki_szukaj;
extern GtkWidget *ignore_window;
extern GtkTooltips *tooltips;

#ifdef USE_APPLET
extern AppletWidget *applet;
#endif

#ifdef USE_XMMS
#include <xmms/xmmsctrl.h>
#include <pthread.h>
char *oldtitle = " "; 
unsigned int xmms_session = 0;
//pthread_t th_xmms_descr;
static int xmms_timeout = 0;
#endif


/* Zamienia tekst wywietlany na licie kontaktw nowym z edycji*/

static void update_lista_contents(GGContact * kontakt)
{
	gint row;
	GtkWidget *lista;
	GdkPixmap *pixmap;
	GdkBitmap *mask;

	lista = lookup_widget(window, "lista");
	g_return_if_fail(lista != NULL);

	row = gtk_clist_find_row_from_data(GTK_CLIST(lista), kontakt);
	if (row == -1)
		return;

	gtk_clist_get_pixtext(GTK_CLIST(lista), row, 0, NULL, NULL,
			      &pixmap, &mask);
	gtk_clist_set_pixtext(GTK_CLIST(lista), row, 0, kontakt->nick, 3,
			      pixmap, mask);
}

#if !(USE_APPLET || USE_DOCKLET || USE_DOCKAPP)
void destroy_window(GtkWidget * window, gpointer user_data)
{

	gg_change_status(GG_STATUS_OFFLINE);
	gtk_widget_destroy(window);
	shutdown_gg();
	window = NULL;
}
#endif

void destroy_wyniki_window(GtkWidget * window, GtkWidget * wyniki_lista)
{
	GList *tmplist;
	GGSearch *s;
	
	gtk_clist_clear(GTK_CLIST(wyniki_lista));
	tmplist = wyniki_kontakty;
	
	while (tmplist) {
	    GGContact *k;
	    
	    k = tmplist->data;
	    g_print("Freeing: k->uin = %d\n", k->uin);
	    free_contact(k);
	    tmplist = tmplist->next;
	}
	g_list_free(wyniki_kontakty);
	
	s = gtk_object_get_data(GTK_OBJECT(wyniki_szukaj), "search_data");
	gg_search_free(s);
	
	wyniki_kontakty = NULL;
	wyniki_szukaj = NULL;
}

void destroy_ignore_window(GtkWidget * window, gpointer data)
{
	ignore_window = NULL;
}

void destroy_msg_window(GtkWidget * window, GGSession * sesja)
{
	sesja->msg_window = NULL;
}

void destroy_sendmsg_window(GtkWidget * window, GGSession * sesja)
{
}

void destroy_chat_window(GtkWidget * window, GGSession * sesja)
{
	sesja->chat_window = NULL;
}

void on_not_available_activate(GtkWidget * item, gpointer user_data)
{
	if (status.state != GG_STATUS_OFFLINE) {
		gg_change_status(GG_STATUS_OFFLINE);
		set_status_img_status(GG_STATUS_OFFLINE);
		gtk_window_set_title(GTK_WINDOW(window), _(TITLE));
	}
	gg_close_connection();

#ifdef DEBUG
	g_warning("Niedostpny");
#endif
}

void on_available_activate(GtkWidget * item, gpointer user_data)
{
	if (status.connected) {
		gg_change_status(GG_STATUS_ONLINE);
		set_status_img_status(GG_STATUS_ONLINE);
	} else {
		config.status = GG_STATUS_ONLINE;
		status.retry = config.auto_reconnect;
		gg_connect_to_server();
	}
#ifdef DEBUG
	g_print("Dostpny\n");
#endif
}

void on_away_activate(GtkWidget * item, gpointer user_data)
{
	if(config.away_msg_ask != 0)
		get_away_message(NULL, NULL);

	if (status.state != GG_STATUS_AWAY && status.connected) {
		gg_change_status(GG_STATUS_AWAY);
		set_status_img_status(GG_STATUS_AWAY);
	} else if (!status.connected) {
		config.status = GG_STATUS_AWAY;
		status.retry = config.auto_reconnect;
		gg_connect_to_server();
	}
#ifdef DEBUG
	g_print("Zaraz wracam\n");
#endif
}

void on_invisible_activate(GtkWidget * item, gpointer user_data)
{
	if (status.state != GG_STATUS_INVISIBLE && status.connected) {
		gg_change_status(GG_STATUS_INVISIBLE);
		set_status_img_status(GG_STATUS_INVISIBLE);
	} else if (!status.connected) {
		config.status = GG_STATUS_INVISIBLE;
		status.retry = config.auto_reconnect;
		gg_connect_to_server();
	}

#ifdef DEBUG
	g_print("Niewidzialny\n");
#endif
}

void on_status_description_activate(GtkWidget * item, gpointer user_data)
{
	create_status_description_dialog();
#ifdef DEBUG
	g_print("Z Opisem...\n");
#endif
}

void on_optionmenu_clicked(GtkWidget * optionmenu, gpointer user_data)
{
	GtkWidget *item;

	item = gtk_menu_get_active(GTK_MENU(optionmenu));
}


void on_okbutton_clicked(GtkButton * button, GtkWidget * dialog)
{
	GtkWidget *entry;
	GtkWidget *toggle;
	gchar *tmpuin;
	gchar *tmppass;
	
	toggle = lookup_widget(dialog, "haveuin");
	
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(toggle))
	    == TRUE) {

	    entry = lookup_widget(dialog, "uin");
	    g_return_if_fail(entry != NULL);
	    tmpuin = gtk_entry_get_text(GTK_ENTRY(entry));

	    entry = lookup_widget(dialog, "password");
	    g_return_if_fail(entry != NULL);
	    tmppass = gtk_entry_get_text(GTK_ENTRY(entry));

	    if (!tmpuin || !tmppass || !*tmpuin || !*tmppass ) {
		show_error_dialog(_("Musisz wprowadzi numer GG i haso!"));
		return;
	    }
	
	    config.uin = atoi(tmpuin);
	    config.password = g_strdup(tmppass);
	    write_config();

	} else {
	    GtkWidget *register_dialog = create_register();
	    gtk_widget_show(register_dialog);
	}

	gtk_widget_destroy(dialog);
#ifdef DEBUG
	    g_warning("Ok clicked");
#endif
}


void on_zamknij_anuluj_clicked(GtkButton * button, GtkWidget * dialog)
{
	gtk_widget_destroy(dialog);
#ifdef DEBUG
	g_warning("Zamknij/Anuluj clicked");
#endif
}


void on_wyjscie_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	int tmp_state = status.state;
	gg_change_status(GG_STATUS_OFFLINE);
	status.state = tmp_state;
	shutdown_gg();
}

void on_informacje_o_activate(GtkMenuItem * menuitem, gpointer user_data)
{
#ifdef USE_GNOME
#ifdef USE_APPLET
	about(applet, NULL);
#else
	about(window, NULL);
#endif
#else
	GtkWidget *widget;
	widget = create_about();

	gtk_widget_show(widget);
#endif
}

void on_szukaj_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *widget;

	if (wyniki_szukaj != NULL && GTK_IS_WIDGET(wyniki_szukaj)) {
		gtk_widget_destroy(wyniki_szukaj);
	}

	widget = create_szukaj();
	gtk_widget_show(widget);
}


static void chat_create(GtkWidget * widget, GGContact * kontakt)
{
	GGSession *sesja;


	if ((sesja = gg_find_session(kontakt->uin)) == NULL) {
		sesja = gg_create_session(kontakt->uin);
		sessions = g_list_append(sessions, sesja);
	}
	if (sesja->chat_window == NULL
	    || !GTK_IS_WIDGET(sesja->chat_window)) {
		g_print("Nie znaleziono okna z rozmow, stworz nowe\n");
		sesja->chat_window = create_chat(sesja);
	}

	gtk_widget_show(sesja->chat_window);

	return;
}
static void send_message(GtkWidget * widget, GGContact * kontakt)
{
	GtkWidget *sendmsg, *lista;
	GGSession *sesja;

	lista = lookup_widget(window, "lista");
	g_return_if_fail(lista != NULL);

	if ((sesja = gg_find_session(kontakt->uin)) == NULL) {
		sesja = gg_create_session(kontakt->uin);
		sessions = g_list_append(sessions, sesja);
	}

	sendmsg = create_sendmsg(sesja);
	gtk_widget_show(sendmsg);

	return;
}

void on_odpowiedzmsg_clicked(GtkButton * button, GGSession * sesja)
{
	GtkWidget *widget;
	GtkWidget *sendmsg;

	sendmsg = create_sendmsg(sesja);
	gtk_widget_show(sendmsg);

	widget = lookup_widget(GTK_WIDGET(button), "msg");
	gtk_widget_destroy(widget);
#ifdef DEBUG
	g_warning("Odpowiedz clicked");
#endif
}


void on_lista_ignorowanych_activate(GtkWidget * widget, gpointer user_data)
{
	GtkWidget *ignore_list;
	GList *tmplist;
	guint *uin, row;
	gchar *nick;
	GGContact *kontakt;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GdkColormap *colormap;
	gchar *fullpath;
	
	if (GTK_IS_WIDGET(ignore_window) && ignore_window != NULL) {
		ignore_list = lookup_widget(ignore_window, "ignore_list");
		gtk_clist_clear(GTK_CLIST(ignore_list));
	} else {
		ignore_window = create_ignore_window();
		gtk_widget_show(ignore_window);
	}

	ignore_list = lookup_widget(ignore_window, "ignore_list");

	tmplist = ignore;

	while (tmplist) {
		uin = (guint *) tmplist->data;
		if ((kontakt = gg_get_contact_by_uin(*uin)) != NULL)
			nick = g_strdup(kontakt->nick);
		else
			nick = g_strdup_printf("%d", *uin);
		g_print("add uin -> %d\n", *uin);
		row = gtk_clist_append(GTK_CLIST(ignore_list), &nick);
		gtk_clist_set_row_data(GTK_CLIST(ignore_list), row, uin);

		colormap = gtk_widget_get_colormap(ignore_list);
		fullpath = GPP(GG_IGNORED);
		pixmap =
		    gdk_pixmap_colormap_create_from_xpm(NULL, colormap,
							&mask, NULL,
							fullpath);
		g_free(fullpath);
		if (pixmap != NULL) {
			gtk_clist_set_pixtext(GTK_CLIST(ignore_list),
					      row, 0, nick, 3, pixmap,
					      mask);
		}
		g_free(nick);

		tmplist = tmplist->next;
	}
}


static void lista_ignore_kontakt(GtkWidget * menuitem, GGContact * kontakt)
{
	GtkWidget *lista;
	gint row;
	guint *ignore_uin;

	lista = lookup_widget(window, "lista");
	g_return_if_fail(lista != NULL);

	row = gtk_clist_find_row_from_data(GTK_CLIST(lista), kontakt);
	g_return_if_fail(row != -1);

	gtk_clist_remove(GTK_CLIST(lista), row);

	ignore_uin = g_new0(guint, 1);
	*ignore_uin = kontakt->uin;
	ignore = g_list_append(ignore, ignore_uin);
	on_lista_ignorowanych_activate(NULL, NULL);
	return;
}


void lista_remove_item(GtkMenuItem * widget, GGContact * kontakt)
{
	remove_kontakt_from_list(kontakt);
	kontakty = g_list_remove(kontakty, kontakt);
	free_contact(kontakt);
}

static void
kontakt_edycja_activate(GtkWidget * menuitem, GGContact * kontakt)
{
	GtkWidget *edycja;

	edycja = create_edycja(kontakt);
	gtk_widget_show(edycja);
}
static void
kontakt_historia_activate(GtkWidget * menuitem, GGContact * kontakt)
{
	GtkWidget *history;
	GtkWidget *text;

	history = create_history(kontakt);
	text = lookup_widget(history, "text");
	g_return_if_fail(text != NULL);

	if (kontakt->uin != 0) {
		FILE *fp;
		gchar *path;

		path =
		    g_strdup_printf("%s/history/%d", config.homedir,
				    kontakt->uin);
		fp = fopen(path, "r");
		if (fp) {
			while (!feof(fp)) {
				gchar buf[1024];

				memset(buf, 0, 1024);
				fread(buf, 1023, 1, fp);
				gtk_text_insert(GTK_TEXT(text), NULL, NULL,
						NULL, buf, strlen(buf));
			}
			fclose(fp);
		}
		g_free(path);
	}
	gtk_widget_show(history);
	return;
}

static
void sms_create(GtkWidget * widget, GGContact * kontakt)
{
	GtkWidget *dialog;

	dialog = create_sms_dialog(kontakt);
	gtk_widget_show(dialog);
}

static
GtkWidget *create_lista_menu(GGContact * kontakt)
{
	GtkWidget *menu, *menuitem;

	menu = gtk_menu_new();

	menuitem = gtk_menu_item_new_with_label(_("Wiadomo"));
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);

	if (!status.connected || !kontakt->uin)
		gtk_widget_set_sensitive(menuitem, FALSE);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(send_message), kontakt);

	menuitem = gtk_menu_item_new_with_label(_("Rozmowa"));

	if (!status.connected || !kontakt->uin)
		gtk_widget_set_sensitive(menuitem, FALSE);
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);
	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(chat_create), kontakt);

	menuitem = gtk_menu_item_new_with_label(_("Wylij SMS'a"));

	if (!kontakt->mobile|| (g_strncasecmp(kontakt->mobile, "\0", 1) == 0))
		gtk_widget_set_sensitive(menuitem, FALSE);
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);
	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(sms_create), kontakt);

	menuitem = gtk_menu_item_new();
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);

	menuitem = gtk_menu_item_new_with_label(_("Edytuj"));
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(kontakt_edycja_activate),
			   kontakt);

	menuitem = gtk_menu_item_new_with_label(_("Usu"));
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(lista_remove_item), kontakt);

	menuitem = gtk_menu_item_new_with_label(_("Ignoruj"));
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(lista_ignore_kontakt), kontakt);

	gtk_signal_connect(GTK_OBJECT(menu), "hide",
			   GTK_SIGNAL_FUNC(gtk_object_unref), menu);

	menuitem = gtk_menu_item_new_with_label(_("Historia"));
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(kontakt_historia_activate),
			   kontakt);

	return menu;
}

void update_quick_info(GGContact *k)
{
    GtkWidget *label;
    struct in_addr in;
    gchar *info;
    gchar _uin[25];
    gchar _ip[25];
    gchar *_descr = NULL;
    
    label = lookup_widget(window, "quick_info_label");
    g_return_if_fail(label != NULL);
    gtk_widget_show(label);

    if (!k->uin) 
	g_snprintf(_uin, 25, "brak");
    else 
	g_snprintf(_uin, 25, "%d", k->uin);
    
    in.s_addr = k->remote_ip;
    
    if (k->remote_ip) {
	g_snprintf(_ip, 25, "(%s)", inet_ntoa(in));
    }
    
    if (k->description) {
	_descr = g_strdup_printf("\n%s", k->description);
    }

    info = g_strdup_printf("GG: %s %s\nTel: %s%s", _uin, (k->remote_ip) ?  _ip : "", (k->mobile) ? k->mobile : "brak", (k->description) ? _descr : "");
        
    gtk_label_set_text(GTK_LABEL(label), info); 
    gtk_widget_queue_resize(GTK_WIDGET(label->parent));
    
    g_free(_descr);
    g_free(info);
}

void
on_lista_select_row(GtkCList * lista,
		    gint row, gint col,
		    GdkEventButton * event, gpointer userdata)
{
	GtkWidget *menu;

	GGContact *kontakt;

	kontakt = gtk_clist_get_row_data(lista, row);
	
	g_print("Kliknito na %d\n", row);
	menu = create_lista_menu(kontakt);
	
	update_quick_info(kontakt);
	
	gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
		       event->button, event->time);

}

void on_dodaj_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *widget;
	widget = create_dodaj();
	gtk_widget_show(widget);
	return;
}

void on_konfiguracja_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *dialog;
	GtkWidget *widget;
	gchar *tmp;

	dialog = create_konfiguracja();

	widget = lookup_widget(dialog, "uin");
	g_return_if_fail(widget != NULL);
	tmp = g_strdup_printf("%d", config.uin);
	gtk_entry_set_text(GTK_ENTRY(widget), tmp);
	g_free(tmp);


	if (config.password != NULL) {
		widget = lookup_widget(dialog, "password");
		g_return_if_fail(widget != NULL);
		gtk_entry_set_text(GTK_ENTRY(widget), config.password);
	}
	if (config.email != NULL) {
		widget = lookup_widget(dialog, "email");
		g_return_if_fail(widget != NULL);
		gtk_entry_set_text(GTK_ENTRY(widget), config.email);
	}
	if (config.proxy_host != NULL) {
		widget = lookup_widget(dialog, "proxy_host");
		g_return_if_fail(widget != NULL);
		gtk_entry_set_text(GTK_ENTRY(widget), config.proxy_host);
	}
	widget = lookup_widget(dialog, "proxy_port");
	g_return_if_fail(widget != NULL);
	tmp = g_strdup_printf("%d", config.proxy_port);
	gtk_entry_set_text(GTK_ENTRY(widget), tmp);
	g_free(tmp);

	if (config.sms_send_app != NULL) {
		widget = lookup_widget(dialog, "sms_send_app");
		g_return_if_fail(widget != NULL);
		gtk_entry_set_text(GTK_ENTRY(widget), config.sms_send_app);
	}
#if (HAVE_ESD || HAVE_ARTS) 
	if (config.login_sound_path != NULL) {
		widget = lookup_widget(dialog, "login_sound_path");
		g_return_if_fail(widget != NULL);
		gtk_entry_set_text(GTK_ENTRY(widget), config.login_sound_path);
	}
	if (config.user_sound_path != NULL) {
		widget = lookup_widget(dialog, "user_sound_path");
		g_return_if_fail(widget != NULL);
		gtk_entry_set_text(GTK_ENTRY(widget), config.user_sound_path);
	}
	if (config.msg_sound_path != NULL) {
		widget = lookup_widget(dialog, "msg_sound_path");
		g_return_if_fail(widget != NULL);
		gtk_entry_set_text(GTK_ENTRY(widget), config.msg_sound_path);
	}
	if (config.login_sound_path != NULL) {
		widget = lookup_widget(dialog, "login_sound_path");
		g_return_if_fail(widget != NULL);
		gtk_entry_set_text(GTK_ENTRY(widget), config.login_sound_path);
	}
#endif
	gtk_widget_show(dialog);
	return;
}

void on_zapisz_ustawienia_activate(GtkMenuItem * menuitem,
				   gpointer user_data)
{
	write_config();
	write_contacts();

	show_message_dialog("Ustawienia zostay zapisane!");

	return;
}

void on_dodaj_clicked(GtkButton * button, GtkWidget * dialog)
{
	GtkWidget *uin_entry, *nick_entry, *mobile_entry;
	gint uin = 0;
	gchar *nick = NULL;
	gchar *mobile = NULL;
	gchar *tmpstr = NULL;

	uin_entry = lookup_widget(dialog, "uin");
	g_return_if_fail(uin_entry != NULL);

	nick_entry = lookup_widget(dialog, "nick");
	g_return_if_fail(nick_entry != NULL);

	mobile_entry = lookup_widget(dialog, "mobile");
	g_return_if_fail(mobile_entry != NULL);

	uin = atoi(gtk_entry_get_text(GTK_ENTRY(uin_entry)));
	nick = gtk_entry_get_text(GTK_ENTRY(nick_entry));
	mobile = gtk_entry_get_text(GTK_ENTRY(mobile_entry));

	if ((uin == 0 && g_strcasecmp(nick, "") == 0)
	    || g_strcasecmp(nick, "") == 0) {
		gg_error(_
			 ("Musisz wypeni wszystkie wymagane pola (nick, numer gadu-gadu lub tel. komrkowy)"));
	} else {
		GGContact *k = g_new0(GGContact, 1);
		GtkWidget *textentry;

		k->nick = g_strdup(nick);
		k->uin = uin;
		
		tmpstr = g_strdup(mobile);
		if (strlen(tmpstr) == 0) {
			g_free(tmpstr);
		        tmpstr = NULL;
		}
		k->mobile = tmpstr;

		textentry = lookup_widget(dialog, "first_name");
		g_return_if_fail(textentry != NULL);
		k->first_name =
		    g_strdup(gtk_entry_get_text(GTK_ENTRY(textentry)));

		textentry = lookup_widget(dialog, "last_name");
		g_return_if_fail(textentry != NULL);
		k->last_name =
		    g_strdup(gtk_entry_get_text(GTK_ENTRY(textentry)));


		

		gg_add_kontakt(k);
		gtk_widget_destroy(dialog);
	}

	return;
}


void on_wyslij_clicked(GtkWidget * button, GGSession * sesja)
{
	GtkWidget *widget;
	gchar *text;

	widget = lookup_widget(button, "text");
	g_return_if_fail(widget != NULL);

	text = gtk_editable_get_chars(GTK_EDITABLE(widget), 0, -1);
	text = g_strstrip(text);
	if (strlen(text) < GG_MAX_MSG_LEN) {
		gg_send_message(sesja->uin, GG_CLASS_MSG, text,
				gtk_text_get_length(GTK_TEXT(widget)));
		widget = lookup_widget(button, "sendmsg");
		g_return_if_fail(widget != NULL);
		gtk_widget_destroy(widget);
	} else {
		show_error_dialog
	    (_("Wiadomo, ktr chcesz wysa, jest za duga (moe mie max. 2000 znakw)"));
	}
}


void on_search_unknown_clicked(GtkWidget * button, GGSession * sesja)
{
	GGSearch *s;
	
	if (wyniki_szukaj != NULL && GTK_IS_WIDGET(wyniki_szukaj)) {
		gtk_widget_destroy(wyniki_szukaj);
	}

	s = g_new0(GGSearch, 1);
	s->uin = g_strdup_printf("%d", sesja->uin);
	gg_search(s);
	gg_search_free(s);
}

gboolean
on_lista_button_press_event(GtkWidget * widget,
			    GdkEventButton * event, gpointer user_data)
{
	gint row, col, res;
	GtkWidget *lista;
	GtkWidget *menu;
	GGContact *kontakt;
	GGSession *sesja;

	lista = lookup_widget(widget, "lista");

	res =
	    gtk_clist_get_selection_info(GTK_CLIST(lista), event->x,
					 event->y, &row, &col);
	kontakt = gtk_clist_get_row_data(GTK_CLIST(lista), row);
	if (res) {
		if (event->button == 2 || event->button == 3) {

			gtk_clist_select_row(GTK_CLIST(lista), row, col);
			menu = create_lista_menu(kontakt);

			gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL,
				       NULL, event->button, event->time);
		}
		if (event->type == GDK_2BUTTON_PRESS) {
			if (status.connected && kontakt->uin) {
				if ((sesja =
				     gg_find_session(kontakt->uin)) ==
				    NULL) {
					sesja =
					    gg_create_session
					    (kontakt->uin);
					sessions =
					    g_list_append(sessions, sesja);
				}
				if (kontakt->status == GG_STATUS_OFFLINE || kontakt->status == 0)
				{
    				    send_message(widget, kontakt);
				}
				else
				{
				    chat_create(widget, kontakt);
				}
			} else if (kontakt->mobile) {
				sms_create(widget, kontakt);
			}
		} 
		update_quick_info(kontakt);
		
	    if (kontakt->description) {
		gtk_tooltips_set_tip(tooltips, widget, kontakt->description, NULL); 
		g_print("DESCRIPTION IS: %s\n", kontakt->description);
	    }

	}

	return TRUE;
}

void on_zamknij_chat_clicked(GtkButton * button, GtkWidget * widget)
{
	if (GTK_IS_WIDGET(widget) || widget != NULL) {
		gtk_widget_hide(widget);
	}
}

void on_wyslij_chat_clicked(GtkWidget * button, GGSession * sesja)
{
	GtkWidget *widget, *chat_text;
	gchar *text, *title;
	GdkFont *font;
	GdkColor color;
	
	g_return_if_fail(sesja != NULL);

	color.pixel = 0;
	color.red = GG_GREY;
	color.green = GG_GREY;
	color.blue = GG_GREY;
	
	if (sesja->chat_window == NULL
	    || !GTK_IS_WIDGET(sesja->chat_window)) {
		sesja->chat_window = create_chat(sesja);
	}

	widget = lookup_widget(GTK_WIDGET(button), "text");
	g_return_if_fail(widget != NULL);

	text = gtk_editable_get_chars(GTK_EDITABLE(widget), 0, -1);
	text = g_strstrip(text);
	if (strlen(text) < GG_MAX_MSG_LEN) {
		gg_send_message(sesja->uin, GG_CLASS_CHAT, text,
				gtk_text_get_length(GTK_TEXT(widget)));

		chat_text = lookup_widget(GTK_WIDGET(button), "chat_text");
		g_return_if_fail(chat_text != NULL);

		title =
		    g_strdup_printf("%s :: %s\n", getenv("USER"),
				    get_timestamp(0));
		font = gdk_font_load(config.bold_font);

		gtk_text_insert(GTK_TEXT(chat_text), font, &color, NULL,
				title, strlen(title));
		gtk_text_insert(GTK_TEXT(chat_text), NULL, &color, NULL,
				text, strlen(text));
		gtk_text_insert(GTK_TEXT(chat_text), NULL, NULL, NULL,
				"\n", 1);
		gtk_editable_delete_text(GTK_EDITABLE(widget), 0,
					 gtk_text_get_length(GTK_TEXT
							     (widget)));
		gtk_editable_set_position(GTK_EDITABLE(widget), 0);

		g_free(title);
	} else {
		show_error_dialog
	    (_("Wiadomo, ktr chcesz wysa, jest za duga (moe mie max. 2000 znakw)"));
	}
}

gboolean
on_chat_text_press_event(GtkWidget * widget,
			 GdkEventKey * event, GGSession * sesja)
{
	GtkWidget *toggle;

	toggle = lookup_widget(widget, "entersend");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(toggle)) ==
	    TRUE) {
		if (event->type == GDK_KEY_PRESS) {
			if (event->keyval == GDK_Return) {
				on_wyslij_chat_clicked(widget, sesja);
			        gtk_signal_emit_stop_by_name(GTK_OBJECT(widget),"key_press_event");
				return TRUE;
			}
		} else if (event->type == GDK_KEY_RELEASE) {
			g_print("key release\n");
			gtk_editable_delete_text(GTK_EDITABLE(widget),
						 0,
						 gtk_text_get_length
						 (GTK_TEXT(widget)));
			gtk_editable_set_position(GTK_EDITABLE(widget), -1);
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
on_sendmsg_text_press_event(GtkWidget * widget,
			    GdkEventKey * event, GGSession * sesja)
{
	GtkWidget *toggle;

	toggle = lookup_widget(widget, "entersend");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(toggle)) ==
	    TRUE) {
		if (event->type == GDK_KEY_PRESS) {
			if (event->keyval == GDK_Return) {
				on_wyslij_clicked(widget, sesja);
				return TRUE;
			}
		}
		if (event->type == GDK_KEY_RELEASE) {
			gtk_editable_delete_text(GTK_EDITABLE(widget),
						 0,
						 gtk_text_get_length
						 (GTK_TEXT(widget)));
			gtk_editable_set_position(GTK_EDITABLE(widget), 0);
			return TRUE;
		}
	}
	return FALSE;
}


void on_konfiguracja_ok_clicked(GtkButton * button, GtkWidget * dialog)
{
	GtkWidget *textentry, *checkbox;
	gchar *tmptext;

	textentry = lookup_widget(dialog, "uin");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	config.uin = atoi(tmptext);

	textentry = lookup_widget(dialog, "password");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	if (config.password != NULL)
		g_free(config.password);
	config.password = g_strdup(tmptext);

	textentry = lookup_widget(dialog, "email");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	if (config.email != NULL)
		g_free(config.email);
	config.email = g_strdup(tmptext);

	checkbox = lookup_widget(dialog, "send_on_enter");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.send_on_enter = 1;
	} else {
		config.send_on_enter = 0;
	}
	checkbox = lookup_widget(dialog, "history");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.log = 1;
	} else {
		config.log = 0;
	}
#ifdef USE_APPLET
	checkbox = lookup_widget(dialog, "main_on_start");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.main_on_start = 1;
	} else {
		config.main_on_start = 0;
	}
#endif
	checkbox = lookup_widget(dialog, "private");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.private = 1;
	} else {
		config.private = 0;
	}


	checkbox = lookup_widget(dialog, "proxy_switch");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.use_proxy = 1;
	} else {
		config.use_proxy = 0;
	}

	checkbox = lookup_widget(dialog, "connect_on_start");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.connect_on_start = 1;
	} else {
		config.connect_on_start = 0;
	}

	textentry = lookup_widget(dialog, "proxy_host");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	if (config.proxy_host != NULL)
		g_free(config.proxy_host);
	config.proxy_host = g_strdup(tmptext);

	textentry = lookup_widget(dialog, "proxy_port");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	config.proxy_port = atoi(tmptext);

	textentry = lookup_widget(dialog, "sms_send_app");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	if (config.sms_send_app != NULL)
		g_free(config.sms_send_app);
	config.sms_send_app = g_strdup(tmptext);

#if HAVE_ESD || HAVE_ARTS
	checkbox = lookup_widget(dialog, "user_sound");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.user_sound = 1;
	} else {
		config.user_sound = 0;
	}

	checkbox = lookup_widget(dialog, "login_sound");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.login_sound = 1;
	} else {
		config.login_sound = 0;
	}

	checkbox = lookup_widget(dialog, "msg_sound");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.msg_sound = 1;
	} else {
		config.msg_sound = 0;
	}
#endif /* HAVE_ESD */

	checkbox = lookup_widget(dialog, "away_msg_ask");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.away_msg_ask = 1;
	} else {
		config.away_msg_ask = 0;
	}

	write_config();

#ifndef USE_GNOME
	gtk_widget_destroy(dialog);
#endif
}

void on_findbutton_clicked(GtkButton * button, GtkWidget * szukaj)
{
	GtkWidget *text;
	GtkCheckButton *active;
	GGSearch *s;

	s = g_new0(GGSearch, 1);

	if (wyniki_szukaj != NULL && GTK_IS_WIDGET(wyniki_szukaj)) {
		gtk_widget_destroy(wyniki_szukaj);
	}
	wyniki_szukaj = create_wyniki_szukaj();
	gtk_widget_show(wyniki_szukaj);

	active = GTK_CHECK_BUTTON(lookup_widget(szukaj, "active_only"));
	g_return_if_fail(active != NULL);

	if (gtk_toggle_button_get_active(&active->toggle_button)) {
		s->active_only = 1;
	}

	text = lookup_widget(szukaj, "first_name");
	g_return_if_fail(text != NULL);
	s->first_name = g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));

	text = lookup_widget(szukaj, "last_name");
	g_return_if_fail(text != NULL);
	s->last_name = g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));

	text = lookup_widget(szukaj, "gender_text");
	g_return_if_fail(text != NULL);
	s->gender = g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));

	text = lookup_widget(szukaj, "nick");
	g_return_if_fail(text != NULL);
	s->nick = g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));

	text = lookup_widget(szukaj, "city");
	g_return_if_fail(text != NULL);
	s->city = g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));

	text = lookup_widget(szukaj, "agemin");
	g_return_if_fail(text != NULL);
	s->agemin = g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));

	text = lookup_widget(szukaj, "agemax");
	g_return_if_fail(text != NULL);
	s->agemax = g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));

	text = lookup_widget(szukaj, "uin");
	g_return_if_fail(text != NULL);

	s->uin = g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));

	gg_search(s);
	gtk_widget_destroy(szukaj);

	text = lookup_widget(wyniki_szukaj, "wyniki_lista");
	g_return_if_fail(text != NULL);

	gtk_clist_clear(GTK_CLIST(text));
	gtk_widget_ref(wyniki_szukaj);
	gtk_object_set_data_full(GTK_OBJECT(wyniki_szukaj), "search_data", 
					    s, (GtkDestroyNotify) gtk_widget_unref);
//	gg_search_free(s);

}

static void wyniki_add_kontakt(GtkWidget * widget, GGContact * kontakt)
{
	GGContact *k = NULL;
	
	k = gg_get_contact_by_uin(kontakt->uin);
	
	if (k != NULL) {
	    show_error_dialog(_("Taki kontakt ju istnieje"));
	} else {
	    
	    k = g_new0(GGContact, 1);
	    memcpy(k, kontakt, sizeof(GGContact));

	    if (!k->nick || !g_strcasecmp(k->nick, "")) {
		k->nick = g_strdup(k->first_name);
	    }
	    gg_add_kontakt(k);
	}
}

static GtkWidget *create_wyniki_lista_menu(GGContact * kontakt)
{
	GtkWidget *menu, *menuitem;

	menu = gtk_menu_new();

	menuitem = gtk_menu_item_new_with_label(_("Dodaj"));
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(wyniki_add_kontakt), kontakt);
/*
	menuitem = gtk_menu_item_new_with_label(_("Rozmowa"));

	if (kontakt->status == GG_STATUS_NOT_AVAILABLE
	    || kontakt->status == 0)
		gtk_widget_set_sensitive(menuitem, FALSE);
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);
	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(chat_create), kontakt);

	menuitem = gtk_menu_item_new();
	gtk_widget_show(menuitem);
	gtk_menu
	(GTK_MENU(menu), menuitem);

	menuitem = gtk_menu_item_new_with_label(_("Edytuj"));
	gtk_widget_set_sensitive(menuitem, FALSE);
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);

	menuitem = gtk_menu_item_new_with_label(_("Usu"));
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(lista_remove_item), kontakt);
*/
	gtk_signal_connect(GTK_OBJECT(menu), "hide",
			   GTK_SIGNAL_FUNC(gtk_object_unref), menu);

	return menu;
}

gboolean
on_wyniki_lista_button_press_event(GtkWidget * widget,
				   GdkEventButton * event,
				   gpointer user_data)
{
	gint row, col, res;
	GtkWidget *lista;
	GtkWidget *menu;
	GGContact *kontakt;

	lista = lookup_widget(widget, "wyniki_lista");
	if (lista == NULL)
		return FALSE;

	res =
	    gtk_clist_get_selection_info(GTK_CLIST(lista), event->x,
					 event->y, &row, &col);
	kontakt = gtk_clist_get_row_data(GTK_CLIST(lista), row);
	if (res) {
		if (event->button == 2 || event->button == 3) {

			gtk_clist_select_row(GTK_CLIST(lista), row, col);
			menu = create_wyniki_lista_menu(kontakt);

			gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL,
				       NULL, event->button, event->time);
		}
/*    	if (event->type == GDK_2BUTTON_PRESS) {
			if ((sesja = gg_find_session(kontakt->uin)) == NULL) {
				sesja = gg_create_session(kontakt->uin);
				sessions = g_list_append(sessions, sesja);
			}
			send_message(widget, sesja);
		}*/
	}

	return TRUE;
}


void on_edycja_ok_clicked(GtkButton * button, GGContact * kontakt)
{
	GtkWidget *edycja, *text;
	gchar *tmpstr = NULL, *tmp;
	guint uin;
	
	edycja = lookup_widget(GTK_WIDGET(button), "edycja");
	g_return_if_fail(edycja != NULL);

	text = lookup_widget(edycja, "uin");
	g_return_if_fail(text != NULL);

	tmp = gtk_entry_get_text(GTK_ENTRY(text));
	
	if (tmp && *tmp)
	    uin = strtoul(tmp, NULL, 0);
	else {
	    uin = 0;
	}
	
	
		
	kontakt->uin = uin;
	
	if (!kontakt->uin)
	    kontakt->status = GG_STATUS_MOBILE_ONLY;
	
	text = lookup_widget(edycja, "nick");
	g_return_if_fail(text != NULL);
	g_free(kontakt->nick);
	kontakt->nick = g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));

	text = lookup_widget(edycja, "first_name");
	g_return_if_fail(text != NULL);
	g_free(kontakt->first_name);
	kontakt->first_name =
	    g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));

	text = lookup_widget(edycja, "last_name");
	g_return_if_fail(text != NULL);
	g_free(kontakt->last_name);
	kontakt->last_name = g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));

	text = lookup_widget(edycja, "mobile");
	g_return_if_fail(text != NULL);
	g_free(kontakt->mobile);
	tmpstr = g_strdup(gtk_entry_get_text(GTK_ENTRY(text)));
	if (strlen(tmpstr) == 0) {
		g_free(tmpstr);
		tmpstr = NULL;
	}

	kontakt->mobile = tmpstr;
	
	update_lista_contents(kontakt);
	// FIXME: jaki tu powinien by naprawde poprzedni status
	change_kontakt_status(kontakt, GG_STATUS_OFFLINE); 
	gtk_widget_destroy(edycja);
	write_contacts();
}
static void on_ignore_restore(GtkMenuItem * menuitem, guint * uin)
{
	GGContact *kontakt;
	GtkWidget *lista;
	gint row;

	lista = lookup_widget(ignore_window, "ignore_list");
	g_return_if_fail(lista != NULL);

	row = gtk_clist_find_row_from_data(GTK_CLIST(lista), uin);
	ignore = g_list_remove(ignore, uin);
	gtk_clist_remove(GTK_CLIST(lista), row);

	kontakt = gg_get_contact_by_uin(*uin);
	if (kontakt != NULL) {
		add_kontakt_to_list(kontakt);
		// FIXME: jaki tu powinien by naprawde poprzedni status
		change_kontakt_status(kontakt, GG_STATUS_OFFLINE);
	}
}
static GtkWidget *create_ignore_list_menu(guint * uin)
{
	GtkWidget *menu, *menuitem;

	menu = gtk_menu_new();

	menuitem = gtk_menu_item_new_with_label(_("Usu"));
	gtk_widget_show(menuitem);
	gtk_menu_append(GTK_MENU(menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_ignore_restore), uin);
	gtk_signal_connect(GTK_OBJECT(menu), "hide",
			   GTK_SIGNAL_FUNC(gtk_object_unref), menu);

	return menu;
}

gboolean
on_ignore_list_button_press_event(GtkWidget * widget,
				  GdkEventButton * event,
				  gpointer user_data)
{
	gint row, col, res;
	GtkWidget *lista;
	GtkWidget *menu;
	guint *uin;

	lista = lookup_widget(widget, "ignore_list");
	if (lista == NULL)
		return FALSE;

	res =
	    gtk_clist_get_selection_info(GTK_CLIST(lista), event->x,
					 event->y, &row, &col);
	uin = gtk_clist_get_row_data(GTK_CLIST(lista), row);
	if (res) {
		if (event->button == 2 || event->button == 3) {

			gtk_clist_select_row(GTK_CLIST(lista), row, col);
			menu = create_ignore_list_menu(uin);

			gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL,
				       NULL, event->button, event->time);
		}
	}

	return TRUE;
}

void on_wyslij_sms_clicked(GtkButton * button, GGContact * kontakt)
{
	GtkWidget *widget, *textentry;
	GGSession *sesja;
	gchar *mobile, *msg;

	widget = lookup_widget(GTK_WIDGET(button), "sms_dialog");
	g_return_if_fail(widget != NULL);

	if ((sesja = gg_find_session(kontakt->uin)) == NULL) {
		sesja = gg_create_session(kontakt->uin);
		sessions = g_list_append(sessions, sesja);
	}
	textentry = lookup_widget(GTK_WIDGET(widget), "sms_number");
	g_return_if_fail(textentry != NULL);
	mobile = gtk_entry_get_text(GTK_ENTRY(textentry));

	textentry = lookup_widget(GTK_WIDGET(widget), "sms_text");
	g_return_if_fail(textentry != NULL);
	msg = gtk_editable_get_chars(GTK_EDITABLE(textentry), 0, -1);

	sesja->sms_pid = send_sms_prog(config.sms_send_app, mobile, msg);
	gtk_widget_destroy(widget);
}

void on_dodaj_ignore_clicked(GtkButton * button, GtkWidget * entry)
{
	gchar *text = NULL;
	guint *ignore_uin;
	guint uin = 0;

	text = gtk_entry_get_text(GTK_ENTRY(entry));
	if (text != NULL) {
		uin = atoi(text);
	}
	if (uin) {
		gint row;
		gchar *nick = NULL;
		GGContact *kontakt;
		GtkWidget *ignore_list;
		GdkPixmap *pixmap;
		GdkBitmap *mask;
		GdkColormap *colormap;
		gchar *fullpath;
		
		ignore_uin = g_new0(guint, 1);
		*ignore_uin = uin;
		ignore = g_list_append(ignore, ignore_uin);

		ignore_list = lookup_widget(ignore_window, "ignore_list");

		if ((kontakt = gg_get_contact_by_uin(uin)) != NULL)
			nick = g_strdup(kontakt->nick);
		else
			nick = g_strdup_printf("%d", uin);
		g_print("add uin -> %d\n", uin);
		row = gtk_clist_append(GTK_CLIST(ignore_list), &nick);
		gtk_clist_set_row_data(GTK_CLIST(ignore_list), row,
				       ignore_uin);

		colormap = gtk_widget_get_colormap(ignore_list);
		fullpath = GPP(GG_IGNORED);
		pixmap =
		    gdk_pixmap_colormap_create_from_xpm(NULL, colormap,
							&mask, NULL,
							fullpath);
		g_free(fullpath);
		if (pixmap != NULL) {
			gtk_clist_set_pixtext(GTK_CLIST(ignore_list),
					      row, 0, nick, 3, pixmap,
					      mask);
		}
		g_free(nick);
	}
	gtk_entry_set_text(GTK_ENTRY(entry), "");
}

void on_zmiana_hasla_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *dialog;
	GtkWidget *textentry;

	dialog = create_chpass();
	if (config.email != NULL && strlen(config.email) > 0) {
		textentry =
		    lookup_widget(GTK_WIDGET(dialog), "chpass_email");
		g_return_if_fail(textentry != NULL);
		gtk_entry_set_text(GTK_ENTRY(textentry), config.email);
	}

	gtk_widget_show(dialog);
}

void on_chpass_okbutton_clicked(GtkButton * button, GtkWidget * dialog)
{
	GtkWidget *textentry;
	gchar *password1, *password2, *email;

	textentry = lookup_widget(GTK_WIDGET(dialog), "chpass_password1");
	g_return_if_fail(textentry != NULL);
	password1 = gtk_entry_get_text(GTK_ENTRY(textentry));

	textentry = lookup_widget(GTK_WIDGET(dialog), "chpass_password2");
	g_return_if_fail(textentry != NULL);
	password2 = gtk_entry_get_text(GTK_ENTRY(textentry));

	textentry = lookup_widget(GTK_WIDGET(dialog), "chpass_email");
	g_return_if_fail(textentry != NULL);
	email = gtk_entry_get_text(GTK_ENTRY(textentry));

	if (!password1|| !*password1 || !password2 || !*password2
	    || !email || !*email) {
		show_error_dialog(_("Musisz wypeni wszystkie pola!!!"));
		return;
	}
	if (strcmp(password1, password2) != 0) {
		show_error_dialog(_("Hasa nie s jednakowe!!!"));
		return;
	}
	gg_change_password(password1, email);
	gtk_widget_destroy(dialog);
}

#ifdef USE_APPLET
gint
applet_save_session(GtkWidget * widget,
		    const gchar * privcfgpath, const gchar * globcfgpath)
{
	write_config();
	write_contacts();
#ifdef DEBUG
	g_print("applet_save_session(): session saved.\n");
#endif
	return FALSE;
}

#ifdef HAVE_PANEL_PIXEL_SIZE

/*this is when the panel size changes*/
void applet_change_pixel_size(GtkWidget * widget, gint size, gpointer data)
{
	GtkWidget *applet_frame;
#ifdef DEBUG
	g_print("applet_change_pixel_size(): Got size of %d pixels\n",
		size);
#endif
	applet_frame = lookup_widget(widget, "applet_frame");
	g_return_if_fail(applet_frame != NULL);

	gtk_widget_set_usize(GTK_WIDGET(applet_frame), size, size);
}
#endif

#endif

void on_przypomnij_haslo_activate(GtkMenuItem * menuitem,
				  gpointer user_data)
{
	gg_restore_password();
}

void config_dialog()
{
	GtkWidget *dialog;

	dialog = create_newuser();
	gtk_widget_show(dialog);
}

void on_register_okbutton_clicked(GtkButton * button, GtkWidget * dialog)
{
	GtkWidget *textentry;
	gchar *password1, *password2, *email;

	textentry = lookup_widget(GTK_WIDGET(dialog), "password1");
	g_return_if_fail(textentry != NULL);
	password1 = gtk_entry_get_text(GTK_ENTRY(textentry));

	textentry = lookup_widget(GTK_WIDGET(dialog), "password2");
	g_return_if_fail(textentry != NULL);
	password2 = gtk_entry_get_text(GTK_ENTRY(textentry));

	textentry = lookup_widget(GTK_WIDGET(dialog), "email");
	g_return_if_fail(textentry != NULL);
	email = gtk_entry_get_text(GTK_ENTRY(textentry));

	if (!password1|| !*password1 || !password2 || !*password2
	    || !email || !*email) {
		show_error_dialog(_("Musisz wypeni wszystkie pola!!!"));
		return;
	}
	if (strcmp(password1, password2) != 0) {
		show_error_dialog(_("Hasa nie s jednakowe!!!"));
		return;
	}
	g_print("PASSWORD %s EMAIL %s\n", password1, email);
	gg_register(password1, email);
	gtk_widget_destroy(dialog);
}


void on_import_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gg_import_userlist();
}

void on_export_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gg_export_userlist();
}

void on_delete_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gg_delete_userlist();
}


void on_katalog_publiczny_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkWidget *widget;
    struct gg_change_info_request *r = g_new0(struct gg_change_info_request, 1);
    
    widget = create_pubdir_info();
    gtk_widget_show(widget);
    if (read_pubdir_from_file(r) != -1) {
	GtkWidget *text;
	gchar *tmp;
	
	text = lookup_widget(widget, "first_name");
	g_return_if_fail(text != NULL);
	
	gtk_entry_set_text(GTK_ENTRY(text), r->first_name);

	text = lookup_widget(widget, "last_name");
	g_return_if_fail(text != NULL);
	
	gtk_entry_set_text(GTK_ENTRY(text), r->last_name);
	
	text = lookup_widget(widget, "nick");
	g_return_if_fail(text != NULL);
	
	gtk_entry_set_text(GTK_ENTRY(text), r->nick);


	text = lookup_widget(widget, "born");
	g_return_if_fail(text != NULL);
	
	tmp = g_strdup_printf("%d", r->born);
	gtk_entry_set_text(GTK_ENTRY(text), tmp);
	g_free(tmp);
	
	text = lookup_widget(widget, "gender");
	g_return_if_fail(text != NULL);
	if (r->gender == 1) {
	    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(text)->entry), "Kobieta");
	} else {
	    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(text)->entry), "Mczyzna");
	}

	text = lookup_widget(widget, "city");
	g_return_if_fail(text != NULL);

	gtk_entry_set_text(GTK_ENTRY(text), r->city);

//	text = lookup_widget(widget, "familyname");
//	g_return_if_fail(text != NULL);

//	gtk_entry_set_text(GTK_ENTRY(text), r->familyname);

//	text = lookup_widget(widget, "familycity");
//	g_return_if_fail(text != NULL);
	
//	gtk_entry_set_text(GTK_ENTRY(text), r->familycity);
	
    }
    g_free(r);
}

void on_go_chat_clicked(GtkButton * button, GGSession *sesja) 
{
    GtkWidget *window;
    
    if (sesja != NULL) {
	if (sesja->chat_window == NULL) {
	// ||
	//    !GTK_IS_WIDGET(sesja->chat_window)) {
	    sesja->chat_window = create_chat(sesja);
	}
	window = lookup_widget(GTK_WIDGET(button), "sendmsg");
	if (window == NULL) {
	    window = lookup_widget(GTK_WIDGET(button), "msg");
	}
	g_return_if_fail(window != NULL);
	gtk_widget_destroy(window);
	gtk_widget_show(sesja->chat_window);
    }
}

void on_go_msg_clicked(GtkButton * button, GGSession *sesja) 
{
    GtkWidget *window;
    
    if (sesja != NULL) {
	window = lookup_widget(GTK_WIDGET(button), "chat");
	
	g_return_if_fail(window != NULL);
	gtk_widget_hide(window);
	
	window = create_sendmsg(sesja);
	gtk_widget_show(window);
    }
}

void on_uaktualnij_pubdir_clicked(GtkButton * button, gpointer user_data) 
{
    GtkWidget *dialog = user_data;
    GtkWidget *text;
    struct gg_change_info_request *r = g_new0(struct gg_change_info_request, 1);
    gchar *tmp;
    
    text = lookup_widget(dialog, "first_name");
    g_return_if_fail(text != NULL);

    r->first_name = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);

    text = lookup_widget(dialog, "last_name");
    g_return_if_fail(text != NULL);

    r->last_name = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);

    text = lookup_widget(dialog, "nick");
    g_return_if_fail(text != NULL);

    r->nick = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);

//    text = lookup_widget(dialog, "familycity");
//    g_return_if_fail(text != NULL);
//    r->familycity = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);

//    text = lookup_widget(dialog, "familyname");
//    g_return_if_fail(text != NULL);
//    r->familyname = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);

    text = lookup_widget(dialog, "born");
    g_return_if_fail(text != NULL);

    tmp = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);
    r->born = atoi(tmp);
    g_free(tmp);
    
    text = lookup_widget(dialog, "gender");
    g_return_if_fail(text != NULL);

    tmp = gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(text)->entry), 0, -1);

    if (!strcasecmp("Mczyzna", tmp)) {
	r->gender = GG_GENDER_MALE;
    } else if (!strcasecmp("Kobieta", tmp)) {
	r->gender = GG_GENDER_FEMALE;
    }
    
    g_free(tmp);
    
    text = lookup_widget(dialog, "city");
    g_return_if_fail(text != NULL);

    r->city = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);

    g_print("on_uaktualnij_pubdir_clicked(): %s %s %s\n%d %s\n", r->first_name, r->last_name, r->familycity, r->born, r->city);
    
    gg_change_pubdir_info(r);
    write_pubdir_to_file(r);
    
    g_free(r->first_name);
    g_free(r->last_name);
    g_free(r->nick);
    g_free(r->city);
    g_free(r->familycity);
    g_free(r->familyname);

    g_free(r);
    
    gtk_widget_destroy(dialog);
}

void on_wyczysc_clicked(GtkButton * button, gpointer user_data) 
{
    GGContact *k = user_data;
    GtkWidget *text;
    FILE *fp;
    gchar *tmp;
    
    tmp = g_strdup_printf("%s/history/%d", config.homedir, k->uin);
    
    fp = fopen(tmp, "w");
    if (!fp) {
	show_error_dialog("Nie mog otworzy pliku z histori!!!");
	return;
    }
    fclose(fp);
    
    text = lookup_widget(GTK_WIDGET(button), "text");
    
    g_return_if_fail(text != NULL);
    
    gtk_editable_delete_text(GTK_EDITABLE(text), 0, -1);
}
void on_ok_zapisz_clicked(GtkButton * button, gpointer user_data)
{
    GtkWidget *file_selector = lookup_widget(GTK_WIDGET(button), "file_selector");
    gchar *inpath, *outpath;
    FILE *in, *out;
    GGContact *k = user_data;
    gchar buf[1024];
    
    g_return_if_fail(file_selector != NULL);
    g_return_if_fail(k != NULL);
    
    inpath = g_strdup_printf("%s/history/%d", config.homedir, k->uin);
    outpath = gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_selector));
    
    in = fopen(inpath, "r");
    
    g_free(inpath);
    
    if (!in) {
	show_error_dialog("Nie mog otworzy pliku z histori!!!");
	return;
    }
    
    out = fopen(outpath, "w");

    if (!out) {
	show_error_dialog("Nie mog otworzy pliku docelowego!!!");
	return;
    }    
    
    while (fgets(buf, 1024, in)) {
	fputs(buf, out);
    }
    
    fclose(in);
    fclose(out);
}

void on_zapisz_jako_clicked(GtkButton * button, gpointer user_data) 
{
    GtkWidget *file_selector;
    
    file_selector = gtk_file_selection_new("Wybierz nazw pliku");
    
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
	       "clicked", GTK_SIGNAL_FUNC (on_ok_zapisz_clicked), user_data);
    gtk_widget_ref(file_selector);
    gtk_object_set_data_full(GTK_OBJECT(file_selector), "file_selector", file_selector,
			    (GtkDestroyNotify) gtk_widget_unref);
			    	        	       
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
				  "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
    				    (gpointer) file_selector);
							      
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
				  "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
				 (gpointer) file_selector);

    gtk_widget_show (file_selector);
}

void set_optionmenu_menu(gint state)
{
    GtkWidget *optionmenu;
    GtkWidget *statusmenu;
    gint index;
    
    optionmenu = lookup_widget(window, "optionmenu");
    statusmenu = gtk_option_menu_get_menu(GTK_OPTION_MENU(optionmenu));
    gtk_widget_ref(statusmenu);

    switch (state) {
	case GG_STATUS_ONLINE:
		index = MENU_ONLINE_IDX;
		break;
	case GG_STATUS_AWAY:
		index = MENU_AWAY_IDX;
		break;
	case GG_STATUS_INVISIBLE:
		index = MENU_INVISIBLE_IDX;
		break;
	case GG_STATUS_OFFLINE:
		index = MENU_OFFLINE_IDX;
		break;
	default:
		index = MENU_DESCR_IDX;
		break;
    }

    gtk_option_menu_remove_menu(GTK_OPTION_MENU(optionmenu));
    gtk_menu_set_active(GTK_MENU(statusmenu), index);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu), statusmenu);
}

void on_status_anuluj_clicked(GtkButton * button, gpointer user_data) 
{
    GtkWidget *widget;

    set_optionmenu_menu(status.state);
    
    widget = (GtkWidget *) user_data;
    g_return_if_fail(widget != NULL);
    
    gtk_widget_destroy(widget);
}

void on_status_ok_clicked(GtkButton * button, gpointer user_data) 
{
    GtkWidget *widget;
    GtkWidget *radiobutton;
    GtkWidget *entry;
#ifdef USE_XMMS
    GtkWidget *xmms_descr;
    gint use_xmms = 0;
#endif
    GSList *group;
    guint index = 0;
    gchar *text;

    widget = (GtkWidget *) user_data;
    g_return_if_fail(widget != NULL);

    radiobutton = lookup_widget(widget, "radio_offline");
    g_return_if_fail(radiobutton != NULL);
    
    group = gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton));
    
    while (group) {
	GtkWidget *elem = group->data;
	if (GTK_IS_WIDGET(elem) && 
	    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(elem))) {
	    break;
	}
	index++;
	group = group->next;
    }

    entry = lookup_widget(widget, "description");
    g_return_if_fail(entry != NULL);

    text = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);

#ifdef USE_XMMS
    xmms_descr = lookup_widget(widget, "xmms_descr");
    g_return_if_fail(xmms_descr != NULL);
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(xmms_descr)) == TRUE) {
	use_xmms = 1;
	g_free(text);
	if (oldtitle) text = g_strdup(oldtitle);
	xmms_playlist_activate();
    }
#endif
    if (!text || !*text) {
	show_error_dialog("Nie wpisae opisu!");
        g_free(text);
	return;
    }

    g_free(config.reason);
    config.reason = g_strdup(text);
    iso_to_cp(text);
    
    switch (index) {
	case 0:
		gg_change_status_descr(GG_STATUS_OFFLINE_DESCR, text);
		set_status_img_status(GG_STATUS_OFFLINE_DESCR);
		gtk_window_set_title(GTK_WINDOW(window), _(TITLE));
		gg_close_connection();
		break;
	case 1:
		gg_change_status_descr(GG_STATUS_INVISIBLE_DESCR, text);
		set_status_img_status(GG_STATUS_INVISIBLE_DESCR);
		config.status = GG_STATUS_INVISIBLE_DESCR;
		break;
	case 2:
		gg_change_status_descr(GG_STATUS_AWAY_DESCR, text);
		set_status_img_status(GG_STATUS_AWAY_DESCR);
		config.status = GG_STATUS_AWAY_DESCR;
		break;
	case 3: 
		gg_change_status_descr(GG_STATUS_ONLINE_DESCR, text);
		set_status_img_status(GG_STATUS_ONLINE_DESCR);
		config.status = GG_STATUS_ONLINE_DESCR;
		break;
    }

    gtk_widget_destroy(widget);
    g_free(text);
    
    if (index && !status.connected) {
		status.retry = config.auto_reconnect;
		gg_connect_to_server();
    }

}
#ifdef USE_XMMS
gint xmms_descr_update(gpointer user_data)
{
    int xmms_running;
    int position;
    char *title = NULL;
    
    switch (status.state) {
	case GG_STATUS_ONLINE_DESCR:
	case GG_STATUS_AWAY_DESCR:
	case GG_STATUS_INVISIBLE_DESCR:
	    xmms_running = xmms_remote_is_running(xmms_session);
    	    if (!xmms_running) return TRUE;
    	    position = xmms_remote_get_playlist_pos(xmms_session);
    	    title = xmms_remote_get_playlist_title(xmms_session, position);
    	    if (strcmp(oldtitle, title) != 0) {
    	    	gg_change_status_descr(status.state, title);
    	    }
    	    oldtitle = xmms_remote_get_playlist_title(xmms_session, position);
	    g_free(title);
	    break;
	default:
	    return FALSE;
    }
    return TRUE;
}

void xmms_playlist_activate()
{
	if (xmms_timeout)
	    gtk_timeout_remove(xmms_timeout);
	xmms_descr_update(NULL);
	xmms_timeout = gtk_timeout_add(5000, (GtkFunction) xmms_descr_update, NULL);
}

#endif


void on_wiecej_clicked(GtkButton * button, gpointer user_data) 
{
    GtkWidget *wyniki_lista = lookup_widget(wyniki_szukaj, "wyniki_lista");
    GList *tmplist;
    GGSearch *s;
    
    gtk_clist_clear(GTK_CLIST(wyniki_lista));
    tmplist = wyniki_kontakty;
	
    while (tmplist) {
	    GGContact *k;
	    
	    k = tmplist->data;
	    g_print("Freeing: k->uin = %d\n", k->uin);
	    free_contact(k);
	    tmplist = tmplist->next;
    }
    g_list_free(wyniki_kontakty);
    wyniki_kontakty = NULL;

    s = gtk_object_get_data(GTK_OBJECT(wyniki_szukaj), "search_data");
    gg_search(s);
}
