/* $Id: gg.h,v 1.13 2003/01/25 15:46:02 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik. Released under terms of GPL license. 
*/

#include "gg-types.h"

#ifndef GG_H
#define GG_H
/* Cz definesw moe by zdublowana, spowodowane jest to 
prba ujednolicenia ich z EKG i libgadu */

#define GG_DEFAULT_HOST "217.17.41.84"
#define GG_DEFAULT_PORT 8074
#define GG_FAKE_PORT	443
#define GG_APPMSG_HOST		"appmsg.gadu-gadu.pl"
#define GG_RETR_HOST		"retr.gadu-gadu.pl"
#define GG_REGISTER_HOST	"register.gadu-gadu.pl"
#define GG_PUBDIR_HOST		"pubdir.gadu-gadu.pl"

// Tak si przedstawimy serwerowi WWW
#define USER_AGENT "Mozilla/4.7 (compatible; GNU; GNU Gadu)"

#define GG_GREY 30000

// Rne Timeaty
#define GG_CONNECT_TIMEOUT 40000
#define GG_HTTP_TIMEOUT 30
#define GG_RECONNECT_TIMEOUT 5000

// pubdirowe stringi
#define GG_PWDSEND_SUCCESS "pwdsend_success"
#define GG_REG_SUCCESS "reg_success:"

// rozne definicje protokolowe
#define GG_NULL_COMMAND 0x00
#define GG_LOGIN_MSG 0x01
#define GG_LOGIN_ANSWER 0x0c
#define GG_LOGIN_OK 0x03
#define GG_LOGIN_ERROR 0x09
#define GG_LOGIN_EXT 0x13
#define GG_VERSION 0x18		// wersja programu gg

/* status */
#define GG_STATUS_OFFLINE 0x01
#define GG_STATUS_OFFLINE_DESCR 0x15
#define GG_STATUS_ONLINE 0x02
#define GG_STATUS_ONLINE_DESCR 0x04
#define GG_STATUS_AWAY 0x03
#define GG_STATUS_AWAY_DESCR 0x05
#define GG_STATUS_INVISIBLE 0x14
#define GG_STATUS_INVISIBLE_DESCR 0x16
#define GG_STATUS_BLOCKED 0x06

#define GG_STATUS_FRIENDS_MASK 0x8000

/* 
   moje wlasne rozszerzenie na potrzeby programu,
   takiego statusu w gg tak naprawde nie ma...
*/
#define GG_STATUS_MOBILE_ONLY 0xffff
#define GG_STATUS_NEW_MSG 0xfffe
#define GG_EMPTY 0x0000

#define GG_STATUS 0x02

#define GG_CLIENT_ONLINE_CONFIRM 0x07
#define GG_CLIENT_ONLINE 0x08
#define GG_SEND_MESSAGE 0x0b

#define GG_RECV_MSG 0x0a

#define GG_SEND_MSG_ACK 0x0005

#define GG_SEND_MSG 0x000b
#define GG_NOTIFY_REPLY 0x0c
#define GG_ACK_DELIVERED 0x0002
#define GG_ACK_QUEUED 0x0003

#define GG_ADD_USER_TO_LIST 0x0d
#define GG_NOTIFY 0x0010
#define GG_NOTIFY_DATALEN 0x05
#define GG_NOTIFY_ADD 0x000d

#define GG_CLASS_MSG 0x0004
#define GG_CLASS_CHAT 0x0008

#define GG_MAX_MSG_LEN 2000
#define GG_RESET_CONNECTION 0x0b
#define GG_CLASS_MSG 0x0004
#define GG_CLASS_CHAT 0x0008
#define GG_SEND_MSG_ACK 0x0005
#define GG_ACK_DELIVERED 0x0002
#define GG_ACK_QUEUED 0x0003

#include "gg-pixmaps.h"

// Typy GGWatch
#define GG_NONE 0x0000;
#define GG_HTTP_QUERY 0x0001

// Rodzaje zapyta na HTTP
#define GG_RESOLVE_SERVER  0x0001
#define GG_CHANGE_PASSWORD 0x0002
#define GG_REMIND_PASSWORD 0x0003
#define GG_SEARCH          0x0004
#define GG_REGISTER	   0x0005
#define GG_DELETE_USERLIST 0x0006
#define GG_EXPORT_USERLIST 0x0007
#define GG_IMPORT_USERLIST 0x0008
#define GG_CHANGE_PUBDIR_INFO 0x0009


#define GG_PUBDIR50_REQUEST 0x0014

#define GG_PUBDIR50_WRITE 0x01
#define GG_PUBDIR50_READ 0x02
#define GG_PUBDIR50_SEARCH 0x03
#define GG_PUBDIR50_SEARCH_REQUEST GG_PUBDIR50_SEARCH
#define GG_PUBDIR50_SEARCH_REPLY 0x05

#define GG_PUBDIR50_REPLY 0x000e

#define GG_SEARCH50_UIN "FmNumber"
#define GG_SEARCH50_STATUS "FmStatus"
#define GG_SEARCH50_FIRSTNAME "firstname"
#define GG_SEARCH50_LASTNAME "lastname"
#define GG_SEARCH50_NICKNAME "nickname"
#define GG_SEARCH50_BIRTHYEAR "birthyear"
#define GG_SEARCH50_CITY "city"
#define GG_SEARCH50_GENDER "gender"
#define GG_SEARCH50_GENDER_FEMALE "1"
#define GG_SEARCH50_GENDER_MALE "2"
#define GG_SEARCH50_ACTIVE "ActiveOnly"
#define GG_SEARCH50_ACTIVE_TRUE "1"
#define GG_SEARCH50_ACTIVE_FALSE "0"
#define GG_SEARCH50_START "fmstart"
#define GG_SEARCH50_FAMILYNAME "familyname"
#define GG_SEARCH50_FAMILYCITY "familycity"

#define GG_MIN_WIDTH	160
#define GG_MIN_HEIGHT	300

// pe

#define GG_GENDER_NONE 0
#define GG_GENDER_FEMALE 1
#define GG_GENDER_MALE 2

// powinno to si usunc
#define GG_CMD_HEADER_LEN 8
#define GG_LOGIN_DATALEN 22

enum {
    MENU_ONLINE_IDX,
    MENU_AWAY_IDX,
    MENU_INVISIBLE_IDX,
    MENU_OFFLINE_IDX,
    MENU_DESCR_IDX
};

//unsigned int gg_hash_passwd(unsigned char *passwd, unsigned int seed);

void gg_connect_to_server(void);

void gg_http_server_info_get(void);

void gg_get_resolve_data(void);

void gg_resolve_server(void);

/* par rzeczy trzeba zrobi jak si zalogujemy */
void gg_login_ok(void);

/* obsuga przychodzcej wiadomoci */
void gg_recv_msg(GGCmd * cmd);

gboolean gg_send_message(guint uin, guint class, gchar * text,
			 gint text_len);
			 
//void gg_add_kontakt(guint uin, gchar * nick);

void gg_add_kontakt(GGContact *kontakt);

void gg_notify_replay(GGCmd * cmd);

void gg_change_contact_status(GGCmd * cmd);

void gg_msg_send_ack(GGCmd * cmd);

GGSession *gg_find_session(guint uin);

GGSession *gg_create_session(guint uin);

gchar *gg_get_nick_by_uin(guint uin);

GGContact *gg_get_contact_by_uin(guint uin);

gchar *gg_get_status_as_string(guint uin);

#define close_connection gg_close_connection

void gg_close_connection(void);

gboolean gg_is_ignored(guint uin);

void gg_change_find_kontakt_status(GtkWidget * lista, GGContact * kontakt);

void gg_connection_error(void);

GGSession *gg_find_session_by_sms_pid(gint sms_pid);

void gg_change_password(gchar *password, gchar *email);

void gg_change_password_res(GGWatch *r);

void gg_restore_password();

void gg_restore_password_res(GGWatch *r);

void gg_connect();

void gg_send_query(GGWatch *r);

void gg_resolve_callback(GGWatch *r);

void gg_connect_resolve(GGWatch *r);

gint gg_async_http_query(GGHTTPQuery *q, gchar *host);

void gg_register_res(GGWatch *r);

void gg_register();

void gg_reconnect();

void gg_delete_userlist();
void gg_export_userlist();
void gg_import_userlist();
void gg_change_pubdir_info(struct gg_change_info_request *req);

void gg_delete_userlist_res(GGWatch *r);
void gg_export_userlist_res(GGWatch *r);
void gg_import_userlist_res(GGWatch *r);
void gg_change_pubdir_info_res(GGWatch *r);

void gg_remove_watch(gint type);


gint read_pubdir_from_file(struct gg_change_info_request *req);
gint write_pubdir_to_file(struct gg_change_info_request *req);

void free_contact(GGContact *k);

void gg_new_msg_animate_off();
#endif