/* $Id: http.c,v 1.3 2002/10/18 11:25:34 thrull Exp $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <unistd.h>
#include <glib.h>
#include <string.h>

#include "net.h"
#include "http.h"

#define MAX_BUF 1024

int http_read_line(int sock, char *buf, int len)
{
	int res;
	int cnt = 0;
	while ((res = read(sock, buf, 1)) == 1) {

		if (*buf == '\n' || cnt >= len) {
			buf++;
			cnt++;
			*buf = 0;
			return 1;
		}
		buf++;
		cnt++;
	}
	return 0;
}

gboolean
http_query_send(struct in_addr * a, gchar * query, gint len, int *sock)
{
	gint res;

	*sock = connect_to_server(a, HTTP_PORT, 0);

	if (*sock == -1)
		return FALSE;

	res = write(*sock, query, len);

	if (res != len) {
		close(*sock);
		return FALSE;
	}
#ifdef DEBUG
	g_print("http_query_send_to_ip(): query send %d %d\n\n%s", len,
		res, query);
#endif
	return TRUE;
}

gboolean http_query_send_to_sock(gchar * query, gint len, int sock)
{
	gint res;

	if (sock == -1)
		return FALSE;

	res = write(sock, query, len);

	if (res != len) {
		close(sock);
		return FALSE;
	}
#ifdef DEBUG
	g_print("http_query_send_to_sock(): query send %d %d\n\n%s", len,
		res, query);
#endif
	return TRUE;
}

gchar *http_query_read(gint sock)
{
	gchar line[MAX_BUF];
	gchar *buf = NULL;
	
	http_read_line(sock, line, MAX_BUF - 1);

	if (strlen(line) < 16 || strncmp(line + 9, "200", 3)) {
		return NULL;
	}
	while (http_read_line(sock, line, MAX_BUF - 1)) {
#ifdef DEBUG
		g_print("http_head: %s", line);
#endif
		if (strcmp(line, "\r\n") == 0 || strcmp(line, "\n") == 0) {
			break;
		}
	}
	memset(line, 0, MAX_BUF);

	while (http_read_line(sock, line, MAX_BUF - 1)) {
		gchar *tmpbuf = NULL;
#ifdef DEBUG
		g_print("http_body: %s\n", line);
#endif
		if (buf == NULL) {
		    buf = g_strdup(line);
		} else {
		    tmpbuf = g_strjoin(NULL, buf, line, NULL);
		    buf = tmpbuf;
		}
	}
	return buf;
}

gint http_query_read_head(gint sock)
{
	gchar *buf;
	gint datalen = 0;
	buf = g_malloc0(MAX_BUF);

	http_read_line(sock, buf, MAX_BUF - 1);

	if (strlen(buf) < 16 || strncmp(buf + 9, "200", 3)) {
		g_free(buf);
		return 0;
	}
	while (http_read_line(sock, buf, MAX_BUF - 1)) {
#ifdef DEBUG
		g_print("http_head: %s", buf);
#endif
//		if (g_strncasecmp(buf, "Content-Length: ", 16) == 0) {
//			datalen = atoi(buf + 16);
//#ifdef DEBUG
//			g_print("Content-Length: %d\n", datalen);
//#endif
//		}


		if (strcmp(buf, "\r\n") == 0 || strcmp(buf, "") == 0) {
			break;
		}
	}
	g_free(buf);
	return datalen;
}
