/* $Id: interface.c,v 1.31 2003/02/05 18:10:22 thrull Exp $ */

/*
 * (C) Copyright 2001 Igor Popik. Released under terms of GPL license.
 *
 * Interjefs uytkownika
 */
#include "common.h"
#include <string.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include "gg.h"
#include "gg-types.h"
#include "callbacks.h"
#include "support.h"
#include "interface.h"
#include "dock.h"

extern GGConfig config;
#ifdef USE_GNOME
#include <gnome.h>

static GnomeUIInfo import_export_uiinfo[] = {
	{
	 GNOME_APP_UI_ITEM, N_("Import listy z serwera"),
	 NULL,
	 (gpointer) on_import_activate, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType) 0, NULL},
	{
	 GNOME_APP_UI_ITEM, N_("Eksport listy na serwer"),
	 NULL,
	 (gpointer) on_export_activate, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType) 0, NULL},
	{
	 GNOME_APP_UI_ITEM, N_("Usu list z serwera"),
	 NULL,
	 (gpointer) on_delete_activate, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType) 0, NULL},
	 
	 GNOMEUIINFO_END
};
static GnomeUIInfo gnu_gadu_menu_uiinfo[] = {
	{
	 GNOME_APP_UI_ITEM, N_("Dodaj kontakt"),
	 NULL,
	 (gpointer) on_dodaj_activate, NULL, NULL,
	 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	 GDK_N, (GdkModifierType) GDK_CONTROL_MASK, NULL},
	{
	 GNOME_APP_UI_ITEM, N_("Szukaj znajomych..."),
	 NULL,
	 (gpointer) on_szukaj_activate, NULL, NULL,
	 GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
	 GDK_F, (GdkModifierType) GDK_CONTROL_MASK, NULL},
	{
	 GNOME_APP_UI_ITEM, N_("Lista ignorowanych"),
	 NULL,
	 (gpointer) on_lista_ignorowanych_activate, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType) 0, NULL},
	GNOMEUIINFO_SEPARATOR,

	{
	 GNOME_APP_UI_SUBTREE, N_("Lista uytkownikw"),
	 NULL,
	 import_export_uiinfo, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType) 0, NULL},

	{
	 GNOME_APP_UI_ITEM, N_("Zmiana hasa..."),
	 NULL,
	 (gpointer) on_zmiana_hasla_activate, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType) 0, NULL},

	{
	 GNOME_APP_UI_ITEM, N_("Przypomnij haso"),
	 NULL,
	 (gpointer) on_przypomnij_haslo_activate, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType) 0, NULL},
	{
	 GNOME_APP_UI_ITEM, N_("Katalog publiczny"),
	 NULL,
	 (gpointer) on_katalog_publiczny_activate, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType) 0, NULL},

	GNOMEUIINFO_MENU_PREFERENCES_ITEM(on_konfiguracja_activate, NULL),
	{
	 GNOME_APP_UI_ITEM, N_("Zapisz ustawienia"),
	 NULL,
	 (gpointer) on_zapisz_ustawienia_activate, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 GDK_S, (GdkModifierType) GDK_CONTROL_MASK, NULL},
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_ABOUT_ITEM(on_informacje_o_activate, NULL),
	GNOMEUIINFO_MENU_EXIT_ITEM(on_wyjscie_activate, NULL),
	GNOMEUIINFO_END
};
static GnomeUIInfo menubar_uiinfo[] = {
	{
	 GNOME_APP_UI_SUBTREE, N_("GNU Gadu"),
	 NULL,
	 gnu_gadu_menu_uiinfo, NULL, NULL,
	 GNOME_APP_PIXMAP_NONE, NULL,
	 0, (GdkModifierType) 0, NULL},
	GNOMEUIINFO_END
};

#endif

#define SP_GG_ONLINE 1
#define SP_GG_ONLINE_DESCR 1

#define SP_GG_AWAY 2
#define SP_GG_AWAY_DESCR 2

static 
gint sort_order(gint status)
{
    switch (status) {
	case GG_STATUS_ONLINE:
	case GG_STATUS_ONLINE_DESCR:
	    return 0;
	case GG_STATUS_AWAY:
	case GG_STATUS_AWAY_DESCR:
	    return 1;
	case GG_STATUS_OFFLINE:
	case GG_STATUS_OFFLINE_DESCR:
	    return 2;
	default:
	    return 100;
    }
}
static
gint my_compare(GtkCList * lista, gconstpointer ptr1, gconstpointer ptr2)
{
	GGContact *k1, *k2;
	gint order1, order2;
	
	if (((GtkCListRow *) ptr1)->data == NULL
	    || ((GtkCListRow *) ptr2)->data == NULL)
		return 0;

	k1 = (GGContact *) ((GtkCListRow *) ptr1)->data;
	k2 = (GGContact *) ((GtkCListRow *) ptr2)->data;

	if (k1->uin == k2->uin) // oba bez gg# tylko z telefonem uin == 0
		return strcasecmp(k1->nick, k2->nick);

	if (!k1->uin) return 1; // jeden z dwch bez gg#
	    else if (!k2->uin) return -1;
	
	if (k1->status == k2->status) // identyczne statusy
		return strcasecmp(k1->nick, k2->nick);
	
	order1 = sort_order(k1->status);
	order2 = sort_order(k2->status);
	
	if (order1 == order2)
	    return strcasecmp(k1->nick, k2->nick);
	else if (order1 < order2)
	    return -1;
	else
	    return 1;
}

GtkWidget *create_quick_info(GtkWidget *window) 
{
    GtkWidget *box;
    GtkWidget *label;
    GtkStyle *style;
        
    box = gtk_vbox_new(FALSE, 0);
    
    label = gtk_label_new(NULL);
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
    gtk_misc_set_padding(GTK_MISC(label), 3, 0);
    
    gtk_widget_ref(label);
    gtk_object_set_data_full(GTK_OBJECT(window), "quick_info_label",
				 label,
				 (GtkDestroyNotify) gtk_widget_unref);
    
    gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
    gtk_container_set_resize_mode(GTK_CONTAINER(box), GTK_RESIZE_IMMEDIATE);
    style = gtk_style_copy(gtk_widget_get_style(label));

    if (style)
        style->font = gdk_font_load("-*-helvetica-medium-r-normal-*-10-*-*-*-p-*-iso8859-2");
    
    // prbujemy wykorzystac alternatywne czcionki
    if (!style->font) {
    	g_warning("Nie mog zaadowa domylnej czcionki, prbuje alternatywn: -*-lucida-medium-r-normal-*-10-*-*-*-p-*-iso8859-2");
	style->font = gdk_font_load("-*-lucida-medium-r-normal-*-10-*-*-*-p-*-iso8859-2");
    }
    
    if (!style->font) {
    	g_warning("Nie mog zaadowa alternatywnej czcionki, prbuje nastpn: -*-helvetica-medium-r-normal-*-10-*-*-*-p-*-*");
	style->font = gdk_font_load("-*-helvetica-medium-r-normal-*-10-*-*-*-p-*-*");
    }
    
    // jesli jaka si zaadowaa
    if (style && style->font) 
	gtk_widget_set_style(label, style);    
    else
	g_free(style);

    return box;
}

GtkWidget *create_main_window(void)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *menubar;
	GtkWidget *scrolledwindow;
	GtkWidget *optionmenu;
	GtkWidget *status_menu;
	GtkWidget *status_menu_item;
	GtkWidget *hbox_menu;
	GtkWidget *pixmap;
	GtkWidget *label;
	GtkWidget *lista;
	GtkWidget *hbox;
	GtkStyle *style;
	GtkWidget *quick_info;
#ifdef USE_GNOME
	GtkWidget *dock;
#else
	guint tmp_key;
	GtkWidget *gadu;
	GtkWidget *gadu_menu;
	GtkWidget *lista_menu;
	GtkAccelGroup *gadu_menu_accels;
	GtkWidget *menuitem;
	GtkAccelGroup *accel_group;
	GtkWidget *handlebox;

	accel_group = gtk_accel_group_new();
#endif

#ifdef USE_GNOME
	window = gnome_app_new("gnu_gadu", NULL);
	dock = GNOME_APP(window)->dock;
	gtk_widget_ref(window);
	gtk_object_set_data_full(GTK_OBJECT(window), "dock", dock,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(dock);
#else
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
#endif
	gtk_object_set_data(GTK_OBJECT(window), "window", window);
	gtk_widget_set_usize(window, GG_MIN_WIDTH, GG_MIN_HEIGHT);
	gtk_window_set_title(GTK_WINDOW(window), _(TITLE));
	window_set_icon(window, NULL, GG_ONLINE_MAIN);
	gtk_widget_realize(window);
#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP
	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
			   GTK_SIGNAL_FUNC(show_hide_main), NULL);
#endif

#if !(USE_APPLET || USE_DOCKLET || USE_DOCKAPP)
	gtk_signal_connect(GTK_OBJECT(window), "destroy",
			   GTK_SIGNAL_FUNC(destroy_window), NULL);
#endif
	gtk_widget_set_style(GTK_WIDGET(window),
			     gtk_widget_get_default_style());

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
#ifdef USE_GNOME
	gnome_app_set_contents(GNOME_APP(window), vbox);
#else
	gtk_container_add(GTK_CONTAINER(window), vbox);
	handlebox = gtk_handle_box_new();
	gtk_widget_show(handlebox);
	gtk_box_pack_start(GTK_BOX(vbox), handlebox, FALSE, FALSE, 0);
#endif
	menubar = gtk_menu_bar_new();
	gtk_widget_ref(menubar);
	gtk_widget_show(menubar);
#ifndef USE_GNOME
	gtk_container_add(GTK_CONTAINER(handlebox), menubar);
#endif
#ifdef USE_GNOME
	gnome_app_create_menus(GNOME_APP(window), menubar_uiinfo);
#else
	gadu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(gadu)->child),
					_("_GNU Gadu"));
	gtk_widget_add_accelerator(gadu, "activate_item", accel_group,
				   tmp_key, GDK_MOD1_MASK,
				   (GtkAccelFlags) 0);
	gtk_widget_ref(gadu);
	gtk_widget_show(gadu);
	gtk_container_add(GTK_CONTAINER(menubar), gadu);

	gadu_menu = gtk_menu_new();
	gtk_widget_ref(gadu_menu);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(gadu), gadu_menu);
	gadu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(gadu_menu));

/* Menu items - start */

	menuitem = gtk_menu_item_new_with_label(_("Dodaj kontakt..."));
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);
	gtk_widget_add_accelerator(menuitem, "activate", accel_group,
				   GDK_N, GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_dodaj_activate), NULL);


	menuitem = gtk_menu_item_new_with_label(_("Szukaj znajomych..."));
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);
	gtk_widget_add_accelerator(menuitem, "activate", accel_group,
				   GDK_F, GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_szukaj_activate), NULL);

	menuitem = gtk_menu_item_new_with_label(_("Lista ignorowanych"));
	gtk_widget_show(menuitem);
	gtk_widget_add_accelerator(menuitem, "activate", accel_group,
				   GDK_K, GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_lista_ignorowanych_activate),
			   NULL);

	menuitem = gtk_menu_item_new();
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);
	
	lista_menu = gtk_menu_new();
	
	menuitem = gtk_menu_item_new_with_label(_("Import listy z serwera"));
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(lista_menu), menuitem);
	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_import_activate),
			   NULL);

	menuitem = gtk_menu_item_new_with_label(_("Eksport listy na serwer"));
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(lista_menu), menuitem);
	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_export_activate),
			   NULL);

	menuitem = gtk_menu_item_new_with_label(_("Usu list z sewera"));
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(lista_menu), menuitem);
	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_delete_activate),
			   NULL);
	
	menuitem = gtk_menu_item_new_with_label(_("Lista uytkownikw"));
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), lista_menu);
	
	menuitem = gtk_menu_item_new_with_label(_("Zmiana hasa..."));
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_zmiana_hasla_activate),
			   NULL);

	menuitem = gtk_menu_item_new_with_label(_("Przypomnij haso"));
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_przypomnij_haslo_activate),
			   NULL);

	menuitem = gtk_menu_item_new_with_label(_("Katalog publiczny"));
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_katalog_publiczny_activate),
			   NULL);

	menuitem = gtk_menu_item_new_with_label(_("Konfiguracja..."));
	gtk_widget_show(menuitem);
	gtk_widget_add_accelerator(menuitem, "activate", accel_group,
				   GDK_K, GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_konfiguracja_activate),
			   NULL);

	menuitem = gtk_menu_item_new_with_label(_("Zapisz ustawienia"));
	gtk_widget_show(menuitem);
	gtk_widget_add_accelerator(menuitem, "activate", accel_group,
				   GDK_S, GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_zapisz_ustawienia_activate),
			   NULL);

	menuitem = gtk_menu_item_new();
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);

	menuitem = gtk_menu_item_new_with_label(_("Informacje o..."));
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);

	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_informacje_o_activate),
			   NULL);

	menuitem = gtk_menu_item_new_with_label(_("Wyjcie"));
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(gadu_menu), menuitem);
	gtk_widget_add_accelerator(menuitem, "activate", accel_group,
				   GDK_Q, GDK_CONTROL_MASK,
				   GTK_ACCEL_VISIBLE);
	gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
			   GTK_SIGNAL_FUNC(on_wyjscie_activate), NULL);


/* Menu items - end */
#endif
	scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow);
	gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
				       (GtkPolicyType) GTK_POLICY_NEVER,
				       (GtkPolicyType)
				       GTK_POLICY_AUTOMATIC);
	lista = gtk_clist_new(1);
	gtk_widget_ref(lista);
	gtk_object_set_data_full(GTK_OBJECT(window), "lista", lista,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(lista);
	
	gtk_container_add(GTK_CONTAINER(scrolledwindow), lista);

	gtk_clist_set_compare_func(GTK_CLIST(lista),
				   (GtkCListCompareFunc) my_compare);
	gtk_clist_set_auto_sort(GTK_CLIST(lista), TRUE);

	gtk_clist_set_row_height(GTK_CLIST(lista), 16);

	gtk_signal_connect(GTK_OBJECT(lista), "button_press_event",
			   GTK_SIGNAL_FUNC(on_lista_button_press_event),
			   NULL);

	quick_info = create_quick_info(window);
	gtk_widget_show(quick_info);
	gtk_box_pack_start(GTK_BOX(vbox), quick_info, FALSE, FALSE, 0);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

	status_menu = gtk_menu_new();
	style = gtk_widget_get_style(status_menu);

	gtk_widget_realize(status_menu);

	status_menu_item = gtk_menu_item_new();

	hbox_menu = gtk_hbox_new(FALSE, 6);
	pixmap = create_pixmap(window, ONLINE_CON_IMG);
	gtk_widget_ref(pixmap);
	gtk_object_set_data_full(GTK_OBJECT(window), "online_pixmap",
				 pixmap,
				 (GtkDestroyNotify) gtk_widget_unref);

	label = gtk_label_new("Dostpny");

	gtk_box_pack_start(GTK_BOX(hbox_menu), pixmap, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_menu), label, FALSE, FALSE, 0);

	gtk_widget_show(pixmap);
	gtk_widget_show(label);
	gtk_widget_show(hbox_menu);
	gtk_widget_show(status_menu_item);

	gtk_container_add(GTK_CONTAINER(status_menu_item), hbox_menu);
	gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
	gtk_signal_connect(GTK_OBJECT(status_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_available_activate), NULL);


	status_menu_item = gtk_menu_item_new();

	hbox_menu = gtk_hbox_new(FALSE, 6);
	gtk_widget_ref(pixmap);
	gtk_object_set_data_full(GTK_OBJECT(window), "away_pixmap",
				 pixmap,
				 (GtkDestroyNotify) gtk_widget_unref);

	pixmap = create_pixmap(window, AWAY_IMG);
	label = gtk_label_new("Zaraz wracam");

	gtk_box_pack_start(GTK_BOX(hbox_menu), pixmap, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_menu), label, FALSE, FALSE, 0);

	gtk_widget_show(pixmap);
	gtk_widget_show(label);
	gtk_widget_show(hbox_menu);
	gtk_widget_show(status_menu_item);

	gtk_container_add(GTK_CONTAINER(status_menu_item), hbox_menu);
	gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
	gtk_signal_connect(GTK_OBJECT(status_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_away_activate), NULL);

	status_menu_item = gtk_menu_item_new();

	hbox_menu = gtk_hbox_new(FALSE, 6);
	pixmap = create_pixmap(window, INVISIBLE_IMG);
	label = gtk_label_new("Niewidoczny");

	gtk_box_pack_start(GTK_BOX(hbox_menu), pixmap, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_menu), label, FALSE, FALSE, 0);

	gtk_widget_show(pixmap);
	gtk_widget_show(label);
	gtk_widget_show(hbox_menu);
	gtk_widget_show(status_menu_item);

	gtk_container_add(GTK_CONTAINER(status_menu_item), hbox_menu);
	gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
	gtk_signal_connect(GTK_OBJECT(status_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_invisible_activate), NULL);

	status_menu_item = gtk_menu_item_new();

	hbox_menu = gtk_hbox_new(FALSE, 6);
	pixmap = create_pixmap(window, OFFLINE_IMG);
	label = gtk_label_new("Niedostpny");

	gtk_box_pack_start(GTK_BOX(hbox_menu), pixmap, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_menu), label, FALSE, FALSE, 0);

	gtk_widget_show(pixmap);
	gtk_widget_show(label);
	gtk_widget_show(hbox_menu);
	gtk_widget_show(status_menu_item);

	gtk_container_add(GTK_CONTAINER(status_menu_item), hbox_menu);
	gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
	gtk_signal_connect(GTK_OBJECT(status_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_not_available_activate),
			   NULL);

	status_menu_item = gtk_menu_item_new();

	hbox_menu = gtk_hbox_new(FALSE, 6);
	pixmap = create_pixmap(window, ONLINE_DESCR_IMG);
	gtk_widget_ref(pixmap);
	gtk_object_set_data_full(GTK_OBJECT(window), "descr_pixmap",
				 pixmap,
				 (GtkDestroyNotify) gtk_widget_unref);

	label = gtk_label_new("Z Opisem...");

	gtk_box_pack_start(GTK_BOX(hbox_menu), pixmap, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_menu), label, FALSE, FALSE, 0);

	gtk_widget_show(pixmap);
	gtk_widget_show(label);
	gtk_widget_show(hbox_menu);
	gtk_widget_show(status_menu_item);

	gtk_container_add(GTK_CONTAINER(status_menu_item), hbox_menu);
	gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
	gtk_signal_connect(GTK_OBJECT(status_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_status_description_activate), NULL);

	optionmenu = gtk_option_menu_new();
	gtk_widget_ref(optionmenu);
	gtk_object_set_data_full(GTK_OBJECT(window), "optionmenu",
				 optionmenu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(optionmenu);
	gtk_box_pack_start(GTK_BOX(hbox), optionmenu, TRUE, TRUE, 0);

	gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu), status_menu);
#ifndef USE_GNOME
	gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);
#endif
	gtk_window_set_default_size (GTK_WINDOW (window), config.width, config.height);
	return window;
}

GtkWidget *create_newuser(void)
{
	GtkWidget *dialog;
	GtkWidget *dialog_vbox;
	GtkWidget *ramka;
	GtkWidget *vbox;
	GSList *vbox_group = NULL;
	GtkWidget *haveuin;
	GtkWidget *hbox;
	GtkWidget *idlabel;
	GtkWidget *uin;
	GtkWidget *label2;
	GtkWidget *password;
	GtkWidget *newuser;
	GtkWidget *action_area;
	GtkWidget *okbutton;
	GtkWidget *cancelbutton;
	GtkTooltips *tooltips;


	tooltips = gtk_tooltips_new();

	dialog = gtk_dialog_new();
	gtk_object_set_data(GTK_OBJECT(dialog), "dialog", dialog);
	gtk_window_set_title(GTK_WINDOW(dialog),
			     _("Konfiguracja GNU Gadu"));
	GTK_WINDOW(dialog)->type = GTK_WINDOW_DIALOG;
	gtk_window_set_policy(GTK_WINDOW(dialog), TRUE, TRUE, FALSE);

	dialog_vbox = GTK_DIALOG(dialog)->vbox;
	gtk_widget_show(dialog_vbox);

	ramka = gtk_frame_new(_("Konfiguracja"));
	gtk_widget_show(ramka);
	gtk_box_pack_start(GTK_BOX(dialog_vbox), ramka, TRUE, TRUE, 0);
	gtk_widget_set_usize(ramka, 400, 300);
	gtk_container_set_border_width(GTK_CONTAINER(ramka), 5);
	gtk_frame_set_shadow_type(GTK_FRAME(ramka), GTK_SHADOW_ETCHED_OUT);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(ramka), vbox);

	haveuin =
	    gtk_radio_button_new_with_label(vbox_group,
					    _("Posiadam numer GG"));
	vbox_group = gtk_radio_button_group(GTK_RADIO_BUTTON(haveuin));
	gtk_widget_ref(haveuin);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "haveuin", haveuin,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(haveuin);
	gtk_box_pack_start(GTK_BOX(vbox), haveuin, FALSE, FALSE, 0);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 3);

	idlabel = gtk_label_new(_("Twj numer:"));
	gtk_widget_show(idlabel);
	gtk_box_pack_start(GTK_BOX(hbox), idlabel, FALSE, FALSE, 0);
	gtk_widget_set_usize(idlabel, 67, -2);
	gtk_label_set_justify(GTK_LABEL(idlabel), GTK_JUSTIFY_LEFT);

	uin = gtk_entry_new();
	gtk_widget_ref(uin);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "uin", uin,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(uin);
	gtk_box_pack_start(GTK_BOX(hbox), uin, FALSE, FALSE, 0);
	gtk_tooltips_set_tip(tooltips, uin, _("Tu wpisz swj numer GG"),
			     NULL);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 3);

	label2 = gtk_label_new(_("Haso: "));
	gtk_widget_show(label2);
	gtk_box_pack_start(GTK_BOX(hbox), label2, FALSE, FALSE, 0);
	gtk_widget_set_usize(label2, 67, -2);
	gtk_label_set_justify(GTK_LABEL(label2), GTK_JUSTIFY_LEFT);

	password = gtk_entry_new();
	gtk_widget_ref(password);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "password", password,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(password);
	gtk_box_pack_start(GTK_BOX(hbox), password, FALSE, TRUE, 0);
	gtk_widget_set_usize(password, 158, -2);
	gtk_tooltips_set_tip(tooltips, password,
			     _("Tu wpisz haso na serwer GG"), NULL);
	gtk_entry_set_visibility(GTK_ENTRY(password), FALSE);

	newuser =
	    gtk_radio_button_new_with_label(vbox_group,
					    _
					    ("Jestem nowym uytkownikiem"));
	vbox_group = gtk_radio_button_group(GTK_RADIO_BUTTON(newuser));
	gtk_widget_ref(newuser);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "newuser", newuser,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(newuser);
	gtk_box_pack_start(GTK_BOX(vbox), newuser, FALSE, FALSE, 0);

	action_area = GTK_DIALOG(dialog)->action_area;
	gtk_object_set_data(GTK_OBJECT(dialog), "action_area",
			    action_area);
	gtk_widget_show(action_area);
	gtk_container_set_border_width(GTK_CONTAINER(action_area), 10);

	okbutton = gtk_button_new_with_label(_("Ok"));
	gtk_widget_ref(okbutton);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "okbutton", okbutton,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(okbutton);
	gtk_box_pack_start(GTK_BOX(action_area), okbutton, FALSE, FALSE,
			   0);
	gtk_widget_set_usize(okbutton, 70, -2);

	cancelbutton = gtk_button_new_with_label(_("Anuluj"));
	gtk_widget_ref(cancelbutton);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "cancelbutton",
				 cancelbutton,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cancelbutton);
	gtk_box_pack_start(GTK_BOX(action_area), cancelbutton, FALSE,
			   FALSE, 0);
	gtk_widget_set_usize(cancelbutton, 70, -2);

	gtk_signal_connect(GTK_OBJECT(okbutton), "clicked",
			   GTK_SIGNAL_FUNC(on_okbutton_clicked), dialog);
	gtk_signal_connect(GTK_OBJECT(cancelbutton), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   dialog);

	gtk_object_set_data(GTK_OBJECT(dialog), "tooltips", tooltips);

	return dialog;
}

GtkWidget *create_simple_dialog(gchar * title)
{
	GtkWidget *simple_dialog;
	GtkWidget *dialog_vbox1;
	GtkWidget *label;
	GtkWidget *dialog_action_area;
	GtkWidget *okbutton;

	simple_dialog = gtk_dialog_new();
	gtk_object_set_data(GTK_OBJECT(simple_dialog), "errordialog",
			    simple_dialog);
	gtk_window_set_title(GTK_WINDOW(simple_dialog), title);
	gtk_window_set_position(GTK_WINDOW(simple_dialog),
				GTK_WIN_POS_CENTER);
	gtk_window_set_policy(GTK_WINDOW(simple_dialog), TRUE, TRUE,
			      FALSE);
	gtk_window_set_modal(GTK_WINDOW(simple_dialog), TRUE);

	dialog_vbox1 = GTK_DIALOG(simple_dialog)->vbox;
	gtk_widget_show(dialog_vbox1);

	label = gtk_label_new(_(""));
	gtk_object_set_data(GTK_OBJECT(simple_dialog), "label", label);
	gtk_widget_ref(label);
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(dialog_vbox1), label, FALSE, FALSE, 0);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	gtk_misc_set_padding(GTK_MISC(label), 20, 35);

	dialog_action_area = GTK_DIALOG(simple_dialog)->action_area;
	gtk_object_set_data(GTK_OBJECT(simple_dialog),
			    "dialog_action_area", dialog_action_area);
	gtk_widget_show(dialog_action_area);
	gtk_container_set_border_width(GTK_CONTAINER(dialog_action_area),
				       10);

	okbutton = gtk_button_new_with_label(_("OK"));
	gtk_widget_ref(okbutton);
	gtk_widget_show(okbutton);
	gtk_box_pack_start(GTK_BOX(dialog_action_area), okbutton, FALSE,
			   FALSE, 0);
	gtk_widget_set_usize(okbutton, 60, -2);
	GTK_WIDGET_SET_FLAGS(okbutton, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(okbutton), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   simple_dialog);

	return simple_dialog;
}

GtkWidget *create_msg(GGSession * sesja)
{
	GtkWidget *msg;
	GtkWidget *vbox;
	GtkWidget *scrolledwindow1;
	GtkWidget *text;
	GtkWidget *hbox2;
	GtkWidget *hbox3;
	GtkWidget *vbox2;
	GtkWidget *alignment;
	GtkWidget *odpowiedzmsg;
	GtkWidget *zamknijmsg;
	GtkWidget *button;
	GtkWidget *pixmap;
	
	msg = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data(GTK_OBJECT(msg), "msg", msg);
	gtk_widget_set_usize(msg, 410, 300);
	gtk_window_set_title(GTK_WINDOW(msg), _("Wiadomo"));
	gtk_window_set_position(GTK_WINDOW(msg), GTK_WIN_POS_CENTER);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(msg), vbox);

	scrolledwindow1 = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow1);
	gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
				       (scrolledwindow1), GTK_POLICY_NEVER,
				       GTK_POLICY_ALWAYS);

	text = gtk_text_new(NULL, NULL);
	gtk_widget_ref(text);
	gtk_object_set_data_full(GTK_OBJECT(msg), "text", text,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(text);
	gtk_container_add(GTK_CONTAINER(scrolledwindow1), text);
	gtk_widget_set_usize(text, -2, 200);
	GTK_WIDGET_UNSET_FLAGS(text, GTK_CAN_FOCUS);

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox2);
	gtk_box_pack_start(GTK_BOX(vbox), hbox2, FALSE, FALSE, 0);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_box_pack_start(GTK_BOX(hbox2), vbox2, TRUE, TRUE, 0);

	hbox3 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox3);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox3, FALSE, FALSE, 0);

//	hbuttonbox1 = gtk_hbutton_box_new();
//	gtk_widget_show(hbuttonbox1);
//	gtk_box_pack_start(GTK_BOX(vbox), hbuttonbox1, TRUE, FALSE, 0);

	odpowiedzmsg = gtk_button_new_with_label(_("Odpowiedz"));
	gtk_widget_ref(odpowiedzmsg);
	gtk_object_set_data_full(GTK_OBJECT(msg), "odpowiedzmsg",
				 odpowiedzmsg,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(odpowiedzmsg);
//	gtk_container_add(GTK_CONTAINER(hbox3), odpowiedzmsg);
	gtk_box_pack_start(GTK_BOX(hbox3), odpowiedzmsg, FALSE, FALSE, 2);
	gtk_widget_set_usize(odpowiedzmsg, 70, -2);

	button = gtk_button_new();
	pixmap = create_pixmap(msg, "go-chat.xpm");
	gtk_container_add(GTK_CONTAINER(button), pixmap);
	gtk_widget_show(pixmap);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(hbox3), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_go_chat_clicked), sesja);

	button = gtk_button_new();
	pixmap = create_pixmap(msg, "search_unknown.xpm");
	gtk_container_add(GTK_CONTAINER(button), pixmap);
	gtk_widget_show(pixmap);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(hbox3), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_search_unknown_clicked), sesja);


	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_box_pack_start(GTK_BOX(hbox2), vbox2, TRUE, TRUE, 0);

	hbox3 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox3);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox3, FALSE, FALSE, 0);

	alignment = gtk_alignment_new(0.5, 0.5, 1, 1);
	gtk_widget_show(alignment);
	gtk_box_pack_end(GTK_BOX(hbox3), alignment, FALSE, TRUE, 0);

	zamknijmsg = gtk_button_new_with_label(_("Zamknij"));
	gtk_widget_ref(zamknijmsg);
	gtk_object_set_data_full(GTK_OBJECT(msg), "zamknijmsg", zamknijmsg,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(zamknijmsg);
	gtk_widget_set_usize(zamknijmsg, 70, -2);
	gtk_container_add(GTK_CONTAINER(alignment), zamknijmsg);


	gtk_signal_connect(GTK_OBJECT(odpowiedzmsg), "clicked",
			   GTK_SIGNAL_FUNC(on_odpowiedzmsg_clicked),
			   sesja);
	gtk_signal_connect(GTK_OBJECT(zamknijmsg), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   msg);
	gtk_signal_connect(GTK_OBJECT(msg), "destroy",
			   GTK_SIGNAL_FUNC(destroy_msg_window), sesja);


	window_set_icon(msg, NULL, GG_MSG_IMG);
	return msg;
}

GtkWidget *create_dodaj(void)
{
	GtkWidget *dodaj;
	GtkWidget *dodaj_vbox;
	GtkWidget *osoba_frame;
	GtkWidget *osoba_vbox;
	GtkWidget *osoba_hbox;
	GtkWidget *osoba_pixmap;
	GtkWidget *osoba_vbox2;
	GtkWidget *osoba_hbox1;
	GtkWidget *edycja_label1;
	GtkWidget *first_name;
	GtkWidget *edycja_label2;
	GtkWidget *last_name;
	GtkWidget *osboba_hbox2;
	GtkWidget *edycja_label3;
	GtkWidget *nick;
	GtkWidget *uinmobile_hbox;
	GtkWidget *uin_frame;
	GtkWidget *uin_hbox;
	GtkWidget *uin;
	GtkWidget *mobile_frame;
	GtkWidget *mobile_hbox;
	GtkWidget *mobile;
	GtkWidget *buttonbox;
	GtkWidget *dodaj_button;
	GtkWidget *cancel;

	dodaj = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(dodaj), "dodaj", dodaj);
	gtk_widget_set_usize(dodaj, 450, 250);
	gtk_window_set_title(GTK_WINDOW(dodaj), _("Dodaj kontakt"));
	gtk_window_set_position(GTK_WINDOW(dodaj), GTK_WIN_POS_CENTER);

	dodaj_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(dodaj_vbox);
	gtk_container_add(GTK_CONTAINER(dodaj), dodaj_vbox);

	osoba_frame = gtk_frame_new(_("Osoba"));
	gtk_widget_show(osoba_frame);
	gtk_box_pack_start(GTK_BOX(dodaj_vbox), osoba_frame, TRUE, TRUE,
			   3);
	gtk_container_set_border_width(GTK_CONTAINER(osoba_frame), 3);

	osoba_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(osoba_vbox);
	gtk_container_add(GTK_CONTAINER(osoba_frame), osoba_vbox);

	osoba_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(osoba_hbox);
	gtk_box_pack_start(GTK_BOX(osoba_vbox), osoba_hbox, TRUE, TRUE, 0);

	osoba_pixmap = create_pixmap(dodaj, "malehead.xpm");
	gtk_widget_show(osoba_pixmap);
	gtk_box_pack_start(GTK_BOX(osoba_hbox), osoba_pixmap, FALSE, FALSE,
			   0);

	osoba_vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(osoba_vbox2);
	gtk_box_pack_start(GTK_BOX(osoba_hbox), osoba_vbox2, TRUE, TRUE,
			   0);

	osoba_hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(osoba_hbox1);
	gtk_box_pack_start(GTK_BOX(osoba_vbox2), osoba_hbox1, TRUE, TRUE,
			   0);

	edycja_label1 = gtk_label_new(_("Imi: "));
	gtk_widget_show(edycja_label1);
	gtk_box_pack_start(GTK_BOX(osoba_hbox1), edycja_label1, FALSE,
			   FALSE, 5);
	gtk_widget_set_usize(edycja_label1, 45, -2);

	first_name = gtk_entry_new();
	gtk_widget_ref(first_name);
	gtk_object_set_data_full(GTK_OBJECT(dodaj), "first_name",
				 first_name,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(first_name);
	gtk_box_pack_start(GTK_BOX(osoba_hbox1), first_name, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(first_name, 120, -2);

	edycja_label2 = gtk_label_new(_("Nazwisko: "));
	gtk_widget_show(edycja_label2);
	gtk_box_pack_start(GTK_BOX(osoba_hbox1), edycja_label2, FALSE,
			   FALSE, 10);

	last_name = gtk_entry_new();
	gtk_widget_ref(last_name);
	gtk_object_set_data_full(GTK_OBJECT(dodaj), "last_name", last_name,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(last_name);
	gtk_box_pack_start(GTK_BOX(osoba_hbox1), last_name, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(last_name, 120, -2);

	osboba_hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(osboba_hbox2);
	gtk_box_pack_start(GTK_BOX(osoba_vbox2), osboba_hbox2, TRUE, TRUE,
			   0);

	edycja_label3 = gtk_label_new(_("Pseudo:"));
	gtk_widget_show(edycja_label3);
	gtk_box_pack_start(GTK_BOX(osboba_hbox2), edycja_label3, FALSE,
			   FALSE, 5);
	gtk_widget_set_usize(edycja_label3, 45, -2);

	nick = gtk_entry_new();
	gtk_widget_ref(nick);
	gtk_object_set_data_full(GTK_OBJECT(dodaj), "nick", nick,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(nick);
	gtk_box_pack_start(GTK_BOX(osboba_hbox2), nick, FALSE, TRUE, 0);
	gtk_widget_set_usize(nick, 120, -2);

	uinmobile_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(uinmobile_hbox);
	gtk_box_pack_start(GTK_BOX(dodaj_vbox), uinmobile_hbox, TRUE, TRUE,
			   0);

	uin_frame = gtk_frame_new(_("Numer G*du-G*du"));
	gtk_widget_show(uin_frame);
	gtk_box_pack_start(GTK_BOX(uinmobile_hbox), uin_frame, TRUE, TRUE,
			   0);
	gtk_container_set_border_width(GTK_CONTAINER(uin_frame), 3);

	uin_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(uin_hbox);
	gtk_container_add(GTK_CONTAINER(uin_frame), uin_hbox);

	uin = gtk_entry_new();
	gtk_widget_ref(uin);
	gtk_object_set_data_full(GTK_OBJECT(dodaj), "uin", uin,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(uin);
	gtk_box_pack_start(GTK_BOX(uin_hbox), uin, FALSE, TRUE, 5);
	gtk_widget_set_usize(uin, 100, -2);

	mobile_frame = gtk_frame_new(_("Tel. komrkowy"));
	gtk_widget_show(mobile_frame);
	gtk_box_pack_start(GTK_BOX(uinmobile_hbox), mobile_frame, TRUE,
			   TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(mobile_frame), 3);

	mobile_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(mobile_hbox);
	gtk_container_add(GTK_CONTAINER(mobile_frame), mobile_hbox);

	mobile = gtk_entry_new();
	gtk_widget_ref(mobile);
	gtk_object_set_data_full(GTK_OBJECT(dodaj), "mobile", mobile,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(mobile);
	gtk_box_pack_start(GTK_BOX(mobile_hbox), mobile, FALSE, FALSE, 5);
	gtk_widget_set_usize(mobile, 100, -2);

	buttonbox = gtk_hbutton_box_new();
	gtk_widget_show(buttonbox);
	gtk_box_pack_start(GTK_BOX(dodaj_vbox), buttonbox, FALSE, TRUE, 0);

	dodaj_button = gtk_button_new_with_label(_("Dodaj"));
	gtk_widget_show(dodaj_button);
	gtk_container_add(GTK_CONTAINER(buttonbox), dodaj_button);
	GTK_WIDGET_SET_FLAGS(dodaj_button, GTK_CAN_DEFAULT);

	cancel = gtk_button_new_with_label(_("Anuluj"));
	gtk_widget_show(cancel);
	gtk_container_add(GTK_CONTAINER(buttonbox), cancel);
	GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(dodaj_button), "clicked",
			   GTK_SIGNAL_FUNC(on_dodaj_clicked), dodaj);
	gtk_signal_connect(GTK_OBJECT(cancel), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   dodaj);

	return dodaj;
}

GtkWidget *create_sendmsg(GGSession * sesja)
{
	GtkWidget *sendmsg;
	GtkWidget *vbox;
	GtkWidget *scrolledwindow;
	GtkWidget *text;
	GtkWidget *hbox2;
	GtkWidget *vbox2;
	GtkWidget *hbox3;
	guint wyslij_key;
	GtkWidget *entersend;
	GtkWidget *vbox3;
	GtkWidget *hbox4;
	GtkWidget *alignment1;
	GtkWidget *pixmap;
	GtkWidget *button;
	guint zamknij_key;
	GtkWidget *zamknij;
	GtkAccelGroup *accel_group;
	gchar *title = NULL;
	
	accel_group = gtk_accel_group_new();

	sendmsg = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(sendmsg), "sendmsg", sendmsg);
	gtk_widget_set_usize(sendmsg, 400, 250);
	
	
	title =
	    g_strdup_printf("Wiadomo do %s (%d)",
			    gg_get_nick_by_uin(sesja->uin), sesja->uin);
	gtk_window_set_title(GTK_WINDOW(sendmsg), _(title));
	g_free(title);
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(sendmsg), vbox);

	scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow);
	gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
				       (scrolledwindow), GTK_POLICY_NEVER,
				       GTK_POLICY_ALWAYS);

	text = gtk_text_new(NULL, NULL);
	gtk_widget_ref(text);
	gtk_object_set_data_full(GTK_OBJECT(sendmsg), "text", text,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(text);
	gtk_container_add(GTK_CONTAINER(scrolledwindow), text);
	gtk_widget_set_usize(text, -2, 200);
	gtk_text_set_editable(GTK_TEXT(text), TRUE);

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox2);
	gtk_box_pack_start(GTK_BOX(vbox), hbox2, FALSE, FALSE, 0);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_box_pack_start(GTK_BOX(hbox2), vbox2, TRUE, TRUE, 0);

	hbox3 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox3);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox3, FALSE, FALSE, 0);

	button = gtk_button_new_with_label("");
	wyslij_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button)->child),
				  _("_Wylij"));
	gtk_widget_add_accelerator(button, "clicked", accel_group,
				   wyslij_key, GDK_MOD1_MASK,
				   (GtkAccelFlags) 0);
	gtk_widget_ref(button);
	gtk_object_set_data_full(GTK_OBJECT(sendmsg), "wyslij", button,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(hbox3), button, FALSE, FALSE, 2);
	gtk_widget_set_usize(button, 70, -2);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_wyslij_clicked), sesja);

	entersend = gtk_toggle_button_new();
	gtk_widget_ref(entersend);
	gtk_object_set_data_full(GTK_OBJECT(sendmsg), "entersend",
				 entersend,
				 (GtkDestroyNotify) gtk_widget_unref);
	pixmap = create_pixmap(sendmsg, ARROW_PIC);
	gtk_container_add(GTK_CONTAINER(entersend), pixmap);
	gtk_widget_show(pixmap);
	gtk_widget_show(entersend);
	gtk_box_pack_start(GTK_BOX(hbox3), entersend, FALSE, FALSE, 1);
	if (config.send_on_enter)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entersend),
					     TRUE);

	button = gtk_button_new();
	pixmap = create_pixmap(sendmsg, "go-chat.xpm");
	gtk_container_add(GTK_CONTAINER(button), pixmap);
	gtk_widget_show(pixmap);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(hbox3), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_go_chat_clicked), sesja);

	button = gtk_button_new();
	pixmap = create_pixmap(sendmsg, "search_unknown.xpm");
	gtk_container_add(GTK_CONTAINER(button), pixmap);
	gtk_widget_show(pixmap);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(hbox3), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_search_unknown_clicked), sesja);


	vbox3 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox3);
	gtk_box_pack_start(GTK_BOX(hbox2), vbox3, TRUE, TRUE, 0);

	hbox4 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox4);
	gtk_box_pack_start(GTK_BOX(vbox3), hbox4, FALSE, FALSE, 0);

	alignment1 = gtk_alignment_new(0.5, 0.5, 1, 1);
	gtk_widget_show(alignment1);
	gtk_box_pack_end(GTK_BOX(hbox4), alignment1, FALSE, TRUE, 0);

	zamknij = gtk_button_new_with_label("");
	zamknij_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(zamknij)->child),
				  _("_Zamknij"));
	gtk_widget_add_accelerator(zamknij, "clicked", accel_group,
				   zamknij_key, GDK_MOD1_MASK,
				   (GtkAccelFlags) 0);
	gtk_widget_ref(zamknij);
	gtk_widget_show(zamknij);
	gtk_container_add(GTK_CONTAINER(alignment1), zamknij);
	gtk_widget_set_usize(zamknij, 70, -2);

	gtk_signal_connect(GTK_OBJECT(zamknij), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   sendmsg);

	gtk_window_add_accel_group(GTK_WINDOW(sendmsg), accel_group);

	gtk_signal_connect(GTK_OBJECT(sendmsg), "destroy",
			   GTK_SIGNAL_FUNC(destroy_sendmsg_window), sesja);

	gtk_signal_connect(GTK_OBJECT(text), "key_press_event",
			   GTK_SIGNAL_FUNC(on_sendmsg_text_press_event),
			   sesja);
	window_set_icon(sendmsg, NULL, GG_MSG_IMG);
	return sendmsg;
}

GtkWidget *create_chat(GGSession * sesja)
{
	GtkWidget *chat;
	GtkWidget *paned;
	GtkWidget *vbox;
	GtkWidget *scrolledwindow;
	GtkWidget *chat_text;
	GtkWidget *text;
	GtkWidget *hbox2;
	GtkWidget *vbox2;
	GtkWidget *hbox3;
	guint wyslij_key;
	GtkWidget *entersend;
	GtkWidget *pixmap;
	GtkWidget *button;
	GtkWidget *vbox3;
	GtkWidget *hbox4;
	GtkWidget *alignment1;
	guint zamknij_key;
	GtkWidget *zamknij;
	GtkAccelGroup *accel_group;
	gchar *title = NULL;
	gchar *nick = NULL;
	
	accel_group = gtk_accel_group_new();

	chat = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(chat), "chat", chat);
	gtk_widget_set_usize(chat, 400, 310);

	gtk_window_set_position(GTK_WINDOW(chat), GTK_WIN_POS_CENTER);
	g_print("create_chat(): Chat window created\n");
	nick = gg_get_nick_by_uin(sesja->uin);
	title =
	    g_strdup_printf("Rozmowa z %s (%d) - %s",
			    (nick ? nick : ""), sesja->uin, 
			    gg_get_status_as_string(sesja->uin));
	gtk_window_set_title(GTK_WINDOW(chat), _(title));
	g_free(title);

	g_print("create_chat(): title set\n");

	paned = gtk_vpaned_new ();
	gtk_widget_show (paned);
	gtk_container_add(GTK_CONTAINER(chat), paned);
	
	scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow);
	gtk_paned_add1 (GTK_PANED (paned), scrolledwindow);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
				       (scrolledwindow), GTK_POLICY_NEVER,
				       GTK_POLICY_ALWAYS);

	g_print("create_chat(): creating text\n");

	chat_text = gtk_text_new(NULL, NULL);
	gtk_widget_ref(chat_text);
	gtk_object_set_data_full(GTK_OBJECT(chat), "chat_text", chat_text,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(chat_text);
	gtk_container_add(GTK_CONTAINER(scrolledwindow), chat_text);
	gtk_widget_set_usize(chat_text, -2, 180);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_paned_add2 (GTK_PANED (paned), vbox);

	scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow);
	gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
				       (scrolledwindow), GTK_POLICY_NEVER,
				       GTK_POLICY_ALWAYS);

	text = gtk_text_new(NULL, NULL);
	gtk_widget_ref(text);
	gtk_object_set_data_full(GTK_OBJECT(chat), "text", text,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(text);
	gtk_container_add(GTK_CONTAINER(scrolledwindow), text);
	gtk_widget_set_usize(text, -2, 100);
	gtk_text_set_editable(GTK_TEXT(text), TRUE);

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox2);
	gtk_box_pack_start(GTK_BOX(vbox), hbox2, FALSE, FALSE, 0);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_box_pack_start(GTK_BOX(hbox2), vbox2, TRUE, TRUE, 0);

	hbox3 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox3);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox3, TRUE, TRUE, 0);

	button = gtk_button_new_with_label("");
	wyslij_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button)->child),
				  _("_Wylij"));
	gtk_widget_add_accelerator(button, "clicked", accel_group,
				   wyslij_key, GDK_MOD1_MASK,
				   (GtkAccelFlags) 0);
	gtk_widget_ref(button);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(hbox3), button, FALSE, FALSE, 2);
	gtk_widget_set_usize(button, 70, -2);

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_wyslij_chat_clicked), sesja);

	entersend = gtk_toggle_button_new();
	gtk_widget_ref(entersend);
	gtk_object_set_data_full(GTK_OBJECT(chat), "entersend", entersend,
				 (GtkDestroyNotify) gtk_widget_unref);
	pixmap = create_pixmap(chat, ARROW_PIC);
	gtk_container_add(GTK_CONTAINER(entersend), pixmap);
	gtk_widget_show(pixmap);
	gtk_widget_show(entersend);
	gtk_box_pack_start(GTK_BOX(hbox3), entersend, FALSE, FALSE, 1);
	if (config.send_on_enter)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entersend),
					     TRUE);

	button = gtk_button_new();
	pixmap = create_pixmap(chat, "go-msg.xpm");
	gtk_container_add(GTK_CONTAINER(button), pixmap);
	gtk_widget_show(pixmap);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(hbox3), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_go_msg_clicked), sesja);

	button = gtk_button_new();
	pixmap = create_pixmap(chat, "search_unknown.xpm");
	gtk_container_add(GTK_CONTAINER(button), pixmap);
	gtk_widget_show(pixmap);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(hbox3), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_search_unknown_clicked), sesja);


	vbox3 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox3);
	gtk_box_pack_start(GTK_BOX(hbox2), vbox3, TRUE, TRUE, 0);

	hbox4 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox4);
	gtk_box_pack_start(GTK_BOX(vbox3), hbox4, FALSE, FALSE, 0);

	alignment1 = gtk_alignment_new(0.5, 0.5, 1, 1);
	gtk_widget_show(alignment1);
	gtk_box_pack_end(GTK_BOX(hbox4), alignment1, FALSE, TRUE, 0);

	zamknij = gtk_button_new_with_label("");
	zamknij_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(zamknij)->child),
				  _("_Zamknij"));
	gtk_widget_add_accelerator(zamknij, "clicked", accel_group,
				   zamknij_key, GDK_MOD1_MASK,
				   (GtkAccelFlags) 0);
	gtk_widget_ref(zamknij);
	gtk_widget_show(zamknij);
	gtk_container_add(GTK_CONTAINER(alignment1), zamknij);
	gtk_widget_set_usize(zamknij, 70, -2);

	gtk_signal_connect(GTK_OBJECT(zamknij), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_chat_clicked), chat);

	gtk_signal_connect(GTK_OBJECT(text), "key_press_event",
			   GTK_SIGNAL_FUNC(on_chat_text_press_event),
			   sesja);

	gtk_signal_connect(GTK_OBJECT(text), "key_release_event",
			   GTK_SIGNAL_FUNC(on_chat_text_press_event),
			   sesja);

	gtk_window_add_accel_group(GTK_WINDOW(chat), accel_group);

	gtk_signal_connect(GTK_OBJECT(chat), "destroy",
			   GTK_SIGNAL_FUNC(destroy_chat_window), sesja);

	window_set_icon(chat, NULL, GG_CHAT_IMG);

	return chat;
}

GtkWidget *create_szukaj(void)
{
	GtkWidget *szukaj;
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkWidget *label;
	GtkWidget *hbox1;
	GtkWidget *first_name;
	GtkWidget *last_name;
	GtkWidget *hbox2;
	GtkWidget *nick;
	GtkWidget *gender;
	GList *gender_items = NULL;
	GtkWidget *gender_text;
	GtkWidget *hbox3;
	GtkWidget *agemin;
	GtkWidget *agemax;
	GtkWidget *city;
	GtkWidget *active_only;
	GtkWidget *hbox4;
	GtkWidget *uin;
	GtkWidget *hbuttonbox1;
	GtkWidget *zamknij;
	GtkWidget *find;

	szukaj = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(szukaj), "szukaj", szukaj);
	gtk_widget_set_usize(szukaj, 450, 280);
	gtk_window_set_title(GTK_WINDOW(szukaj), _("Szukaj znajomych"));
	gtk_window_set_position(GTK_WINDOW(szukaj), GTK_WIN_POS_CENTER);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_container_add(GTK_CONTAINER(szukaj), vbox1);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox2);
	gtk_box_pack_start(GTK_BOX(vbox1), vbox2, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox2), 3);

	gtk_widget_set_usize(vbox2, -2, 250);

	label =
	    gtk_label_new(_
			  ("\nWpisujc odpowiednie dane moesz znale swoich znajomych w katalogu G*du-G*du\n\n"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(vbox2), label, FALSE, FALSE, 0);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);

	hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox1);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox1, TRUE, TRUE, 0);
	gtk_widget_set_usize(hbox1, -2, 1);

	label = gtk_label_new(_("Imi:"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox1), label, FALSE, FALSE, 0);
	gtk_widget_set_usize(label, 50, -2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);

	first_name = gtk_entry_new();
	gtk_widget_ref(first_name);
	gtk_object_set_data_full(GTK_OBJECT(szukaj), "first_name",
				 first_name,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(first_name);
	gtk_box_pack_start(GTK_BOX(hbox1), first_name, FALSE, FALSE, 0);
	gtk_widget_set_usize(first_name, 150, -2);

	label = gtk_label_new(_("Nazwisko:"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox1), label, FALSE, FALSE, 0);
	gtk_widget_set_usize(label, 80, -2);

	last_name = gtk_entry_new();
	gtk_widget_ref(last_name);
	gtk_object_set_data_full(GTK_OBJECT(szukaj), "last_name",
				 last_name,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(last_name);
	gtk_box_pack_start(GTK_BOX(hbox1), last_name, FALSE, FALSE, 0);
	gtk_widget_set_usize(last_name, 150, -2);

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox2);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox2, TRUE, TRUE, 0);
	gtk_widget_set_usize(hbox2, -2, 1);

	label = gtk_label_new(_("Pseudo:"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 0);
	gtk_widget_set_usize(label, 50, -2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);

	nick = gtk_entry_new();
	gtk_widget_ref(nick);
	gtk_object_set_data_full(GTK_OBJECT(szukaj), "nick", nick,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(nick);
	gtk_box_pack_start(GTK_BOX(hbox2), nick, FALSE, FALSE, 0);
	gtk_widget_set_usize(nick, 150, -2);

	label = gtk_label_new(_("Pe:"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 0);
	gtk_widget_set_usize(label, 80, -2);

	gender = gtk_combo_new();
	gtk_widget_ref(gender);
	gtk_object_set_data_full(GTK_OBJECT(szukaj), "gender", gender,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(gender);
	gtk_box_pack_start(GTK_BOX(hbox2), gender, FALSE, FALSE, 0);
	gtk_widget_set_usize(gender, 150, -2);
	gender_items = g_list_append(gender_items, (gpointer) "");
	gender_items =
	    g_list_append(gender_items, (gpointer) _("Kobieta"));
	gender_items =
	    g_list_append(gender_items, (gpointer) _("Mczyzna"));
	gtk_combo_set_popdown_strings(GTK_COMBO(gender), gender_items);
	g_list_free(gender_items);

	gender_text = GTK_COMBO(gender)->entry;
	gtk_widget_ref(gender_text);
	gtk_object_set_data_full(GTK_OBJECT(szukaj), "gender_text",
				 gender_text,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(gender_text);
	gtk_entry_set_editable(GTK_ENTRY(gender_text), FALSE);
	hbox3 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox3);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox3, TRUE, TRUE, 0);
	gtk_widget_set_usize(hbox3, -2, 1);

	label = gtk_label_new(_("Wiek od: "));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox3), label, FALSE, FALSE, 0);
	gtk_widget_set_usize(label, 50, -2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);

	agemin = gtk_entry_new();
	gtk_widget_ref(agemin);
	gtk_object_set_data_full(GTK_OBJECT(szukaj), "agemin", agemin,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(agemin);
	gtk_box_pack_start(GTK_BOX(hbox3), agemin, FALSE, FALSE, 0);
	gtk_widget_set_usize(agemin, 40, -2);

	label = gtk_label_new(_("do"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox3), label, FALSE, FALSE, 0);
	gtk_widget_set_usize(label, 20, -2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);

	agemax = gtk_entry_new();
	gtk_widget_ref(agemax);
	gtk_object_set_data_full(GTK_OBJECT(szukaj), "agemax", agemax,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(agemax);
	gtk_box_pack_start(GTK_BOX(hbox3), agemax, FALSE, FALSE, 0);
	gtk_widget_set_usize(agemax, 40, -2);

	label = gtk_label_new(_(""));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox3), label, FALSE, FALSE, 0);
	gtk_widget_set_usize(label, 50, -2);

	label = gtk_label_new(_("Miejscowo:"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox3), label, FALSE, FALSE, 0);
	gtk_widget_set_usize(label, 80, -2);

	city = gtk_entry_new();
	gtk_widget_ref(city);
	gtk_object_set_data_full(GTK_OBJECT(szukaj), "city", city,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(city);
	gtk_box_pack_start(GTK_BOX(hbox3), city, FALSE, FALSE, 0);


	hbox4 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox4);
	gtk_box_pack_start(GTK_BOX(vbox2), hbox4, FALSE, FALSE, 0);
	gtk_widget_set_usize(hbox4, -2, 24);

	label = gtk_label_new(_("Numer GG:"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox4), label, FALSE, FALSE, 0);
	gtk_widget_set_usize(label, 80, -2);

	uin = gtk_entry_new();
	gtk_widget_ref(uin);
	gtk_object_set_data_full(GTK_OBJECT(szukaj), "uin", uin,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(uin);
	gtk_box_pack_start(GTK_BOX(hbox4), uin, FALSE, FALSE, 0);

	active_only =
	    gtk_check_button_new_with_label(_
					    ("Wyszukuj tylko uytkownikw aktywnych"));
	gtk_widget_ref(active_only);
	gtk_object_set_data_full(GTK_OBJECT(szukaj), "active_only",
				 active_only,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(active_only);
	gtk_box_pack_start(GTK_BOX(vbox2), active_only, FALSE, FALSE, 0);

	hbuttonbox1 = gtk_hbutton_box_new();
	gtk_widget_show(hbuttonbox1);
	gtk_box_pack_start(GTK_BOX(vbox1), hbuttonbox1, TRUE, TRUE, 0);
	gtk_widget_set_usize(hbuttonbox1, -2, 33);

	zamknij = gtk_button_new_with_label(_("Zamknij"));
	gtk_widget_show(zamknij);
	gtk_container_add(GTK_CONTAINER(hbuttonbox1), zamknij);
	GTK_WIDGET_SET_FLAGS(zamknij, GTK_CAN_DEFAULT);

	find = gtk_button_new_with_label(_("Szukaj >>"));
	gtk_widget_show(find);
	gtk_container_add(GTK_CONTAINER(hbuttonbox1), find);
	GTK_WIDGET_SET_FLAGS(find, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(zamknij), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   szukaj);
	gtk_signal_connect(GTK_OBJECT(find), "clicked",
			   GTK_SIGNAL_FUNC(on_findbutton_clicked), szukaj);
	window_set_icon(szukaj, NULL, GG_SEARCH_IMG);
	return szukaj;
}

GtkWidget *create_wyniki_szukaj(void)
{
	GtkWidget *wyniki_szukaj;
	GtkWidget *vbox;
	GtkWidget *scrolledwindow;
	GtkWidget *wyniki_lista;
	GtkWidget *gg;
	GtkWidget *osoba;
	GtkWidget *wiek;
	GtkWidget *city;
	GtkWidget *hbuttonbox;
	GtkWidget *button;

	wyniki_szukaj = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data(GTK_OBJECT(wyniki_szukaj), "wyniki_szukaj",
			    wyniki_szukaj);
	gtk_window_set_title(GTK_WINDOW(wyniki_szukaj),
			     _("Szukaj znajomych"));
	gtk_window_set_position(GTK_WINDOW(wyniki_szukaj),
				GTK_WIN_POS_CENTER);
	gtk_widget_set_usize(wyniki_szukaj, 400, 350);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(wyniki_szukaj), vbox);

	scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow);
	gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);

	wyniki_lista = gtk_clist_new(4);
	gtk_widget_ref(wyniki_lista);
	gtk_object_set_data_full(GTK_OBJECT(wyniki_szukaj), "wyniki_lista",
				 wyniki_lista,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(wyniki_lista);
	gtk_container_add(GTK_CONTAINER(scrolledwindow), wyniki_lista);
	gtk_widget_set_usize(wyniki_lista, -2, 300);
	gtk_clist_set_column_width(GTK_CLIST(wyniki_lista), 0, 79);
	gtk_clist_set_column_width(GTK_CLIST(wyniki_lista), 1, 110);
	gtk_clist_set_column_width(GTK_CLIST(wyniki_lista), 2, 61);
	gtk_clist_set_column_width(GTK_CLIST(wyniki_lista), 3, 80);
	gtk_clist_column_titles_show(GTK_CLIST(wyniki_lista));

	gg = gtk_label_new(_("GG#"));
	gtk_widget_ref(gg);
	gtk_object_set_data_full(GTK_OBJECT(wyniki_szukaj), "gg", gg,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(gg);
	gtk_clist_set_column_widget(GTK_CLIST(wyniki_lista), 0, gg);

	osoba = gtk_label_new(_("Osoba"));
	gtk_widget_show(osoba);
	gtk_clist_set_column_widget(GTK_CLIST(wyniki_lista), 1, osoba);

	wiek = gtk_label_new(_("Rok ur."));
	gtk_widget_show(wiek);
	gtk_clist_set_column_widget(GTK_CLIST(wyniki_lista), 2, wiek);

	city = gtk_label_new(_("Miejscowo"));
	gtk_widget_show(city);
	gtk_clist_set_column_widget(GTK_CLIST(wyniki_lista), 3, city);

	hbuttonbox = gtk_hbutton_box_new();
	gtk_widget_show(hbuttonbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbuttonbox, FALSE, FALSE, 0);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox),
				  GTK_BUTTONBOX_EDGE);

	button = gtk_button_new_with_label(_("Szukaj ponownie"));
	gtk_widget_show(button);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_szukaj_activate),
			   NULL);

	button = gtk_button_new_with_label(_("Wicej..."));
	gtk_widget_show(button);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_ref(wyniki_szukaj);
	gtk_object_set_data_full(GTK_OBJECT(wyniki_szukaj), "wiecej",
				 button, (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_wiecej_clicked),
			   wyniki_szukaj);

	button = gtk_button_new_with_label(_("Zamknij"));
	gtk_widget_show(button);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   wyniki_szukaj);
	gtk_signal_connect(GTK_OBJECT(wyniki_lista), "button_press_event",
			   GTK_SIGNAL_FUNC
			   (on_wyniki_lista_button_press_event),
			   wyniki_szukaj);
	gtk_signal_connect(GTK_OBJECT(wyniki_szukaj), "destroy",
			   GTK_SIGNAL_FUNC(destroy_wyniki_window),
			   wyniki_lista);

	window_set_icon(wyniki_szukaj, NULL, GG_SEARCH_IMG);
	return wyniki_szukaj;
}

GtkWidget *create_edycja(GGContact * kontakt)
{
	GtkWidget *edycja;
	GtkWidget *edycja_vbox;
	GtkWidget *osoba_frame;
	GtkWidget *osoba_vbox;
	GtkWidget *osoba_hbox;
	GtkWidget *osoba_pixmap;
	GtkWidget *osoba_vbox2;
	GtkWidget *osoba_hbox1;
	GtkWidget *edycja_label1;
	GtkWidget *first_name;
	GtkWidget *edycja_label2;
	GtkWidget *last_name;
	GtkWidget *osboba_hbox2;
	GtkWidget *edycja_label3;
	GtkWidget *nick;
	GtkWidget *numergg_hbox;
	GtkWidget *numergg_frame;
	GtkWidget *uin_hbox;
	GtkWidget *uin;
	GtkWidget *mobile_frame;
	GtkWidget *mobile_hbox;
	GtkWidget *mobile;
	GtkWidget *hbuttonbox;
	GtkWidget *ok;
	GtkWidget *cancel;
	gchar *tmp;

	edycja = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(edycja), "edycja", edycja);
	gtk_widget_set_usize(edycja, 430, 250);
	gtk_window_set_title(GTK_WINDOW(edycja),
			     _("Edycja danych kontaktu"));
	gtk_window_set_position(GTK_WINDOW(edycja), GTK_WIN_POS_CENTER);
	gtk_window_set_modal(GTK_WINDOW(edycja), TRUE);
	
	edycja_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(edycja_vbox);
	gtk_container_add(GTK_CONTAINER(edycja), edycja_vbox);

	osoba_frame = gtk_frame_new(_("Osoba"));
	gtk_widget_show(osoba_frame);
	gtk_box_pack_start(GTK_BOX(edycja_vbox), osoba_frame, TRUE, TRUE,
			   3);
	gtk_container_set_border_width(GTK_CONTAINER(osoba_frame), 3);

	osoba_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(osoba_vbox);
	gtk_container_add(GTK_CONTAINER(osoba_frame), osoba_vbox);

	osoba_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(osoba_hbox);
	gtk_box_pack_start(GTK_BOX(osoba_vbox), osoba_hbox, TRUE, TRUE, 0);

	osoba_pixmap = create_pixmap(edycja, "malehead.xpm");
	gtk_widget_show(osoba_pixmap);
	gtk_box_pack_start(GTK_BOX(osoba_hbox), osoba_pixmap, FALSE, FALSE,
			   0);

	osoba_vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(osoba_vbox2);
	gtk_box_pack_start(GTK_BOX(osoba_hbox), osoba_vbox2, TRUE, TRUE,
			   0);

	osoba_hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(osoba_hbox1);
	gtk_box_pack_start(GTK_BOX(osoba_vbox2), osoba_hbox1, TRUE, TRUE,
			   0);

	edycja_label1 = gtk_label_new(_("Imi: "));
	gtk_widget_show(edycja_label1);
	gtk_box_pack_start(GTK_BOX(osoba_hbox1), edycja_label1, FALSE,
			   FALSE, 5);
	gtk_widget_set_usize(edycja_label1, 45, -2);

	first_name = gtk_entry_new();
	gtk_widget_ref(first_name);
	gtk_object_set_data_full(GTK_OBJECT(edycja), "first_name",
				 first_name,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(first_name);
	gtk_box_pack_start(GTK_BOX(osoba_hbox1), first_name, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(first_name, 110, -2);

	edycja_label2 = gtk_label_new(_("Nazwisko: "));
	gtk_widget_show(edycja_label2);
	gtk_box_pack_start(GTK_BOX(osoba_hbox1), edycja_label2, FALSE,
			   FALSE, 10);

	last_name = gtk_entry_new();
	gtk_widget_ref(last_name);
	gtk_object_set_data_full(GTK_OBJECT(edycja), "last_name",
				 last_name,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(last_name);
	gtk_box_pack_start(GTK_BOX(osoba_hbox1), last_name, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(last_name, 110, -2);

	osboba_hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(osboba_hbox2);
	gtk_box_pack_start(GTK_BOX(osoba_vbox2), osboba_hbox2, TRUE, TRUE,
			   0);

	edycja_label3 = gtk_label_new(_("Pseudo:"));
	gtk_widget_show(edycja_label3);
	gtk_box_pack_start(GTK_BOX(osboba_hbox2), edycja_label3, FALSE,
			   FALSE, 5);
	gtk_widget_set_usize(edycja_label3, 45, -2);

	nick = gtk_entry_new();
	gtk_widget_ref(nick);
	gtk_object_set_data_full(GTK_OBJECT(edycja), "nick", nick,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(nick);
	gtk_box_pack_start(GTK_BOX(osboba_hbox2), nick, FALSE, TRUE, 0);
	gtk_widget_set_usize(nick, 110, -2);

	numergg_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(numergg_hbox);
	gtk_box_pack_start(GTK_BOX(edycja_vbox), numergg_hbox, TRUE, TRUE,
				0);
	
	numergg_frame = gtk_frame_new(_("Numer G*du-G*du"));
	gtk_widget_show(numergg_frame);
	gtk_box_pack_start(GTK_BOX(numergg_hbox), numergg_frame, TRUE, TRUE,
			   0);
	gtk_container_set_border_width(GTK_CONTAINER(numergg_frame), 3);

	uin_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(uin_hbox);
	gtk_container_add(GTK_CONTAINER(numergg_frame), uin_hbox);

	uin = gtk_entry_new();
	gtk_widget_ref(uin);
	gtk_object_set_data_full(GTK_OBJECT(edycja), "uin", uin,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(uin);
	gtk_box_pack_start(GTK_BOX(uin_hbox), uin, FALSE, TRUE, 5);
	gtk_widget_set_usize(uin, 100, -2);

	mobile_frame = gtk_frame_new(_("Tel. komrkowy"));
	gtk_widget_show(mobile_frame);
	gtk_box_pack_start(GTK_BOX(numergg_hbox), mobile_frame, TRUE, TRUE,
			   0);
	gtk_container_set_border_width(GTK_CONTAINER(mobile_frame), 3);

	mobile_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(mobile_hbox);
	gtk_container_add(GTK_CONTAINER(mobile_frame), mobile_hbox);

	mobile = gtk_entry_new();
	gtk_widget_ref(mobile);
	gtk_object_set_data_full(GTK_OBJECT(edycja), "mobile", mobile,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(mobile);
	gtk_box_pack_start(GTK_BOX(mobile_hbox), mobile, FALSE, FALSE, 5);
	gtk_widget_set_usize(mobile, 100, -2);

	hbuttonbox = gtk_hbutton_box_new();
	gtk_widget_show(hbuttonbox);
	gtk_box_pack_start(GTK_BOX(edycja_vbox), hbuttonbox, FALSE, TRUE,
			   0);

	ok = gtk_button_new_with_label(_("Ok"));
	gtk_widget_show(ok);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), ok);
	GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);

	cancel = gtk_button_new_with_label(_("Anuluj"));
	gtk_widget_show(cancel);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), cancel);
	GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
	
	if (kontakt->uin) {
	    tmp = g_strdup_printf("%d", kontakt->uin);
	    gtk_entry_set_text(GTK_ENTRY(uin), tmp);
	    g_free(tmp);
	}

	if (kontakt->mobile != NULL)
		gtk_entry_set_text(GTK_ENTRY(mobile), kontakt->mobile);
	if (kontakt->nick != NULL)
		gtk_entry_set_text(GTK_ENTRY(nick), kontakt->nick);
	if (kontakt->first_name != NULL)
		gtk_entry_set_text(GTK_ENTRY(first_name),
				   kontakt->first_name);
	if (kontakt->last_name != NULL)
		gtk_entry_set_text(GTK_ENTRY(last_name),
				   kontakt->last_name);

	gtk_signal_connect(GTK_OBJECT(ok), "clicked",
			   GTK_SIGNAL_FUNC(on_edycja_ok_clicked), kontakt);
	gtk_signal_connect(GTK_OBJECT(cancel), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   edycja);

	return edycja;
}

GtkWidget *create_ignore_window(void)
{
	GtkWidget *ignore_window;
	GtkWidget *vbox1;
	GtkWidget *scrolledwindow1;
	GtkWidget *ignore_list;
	GtkWidget *label1;
	GtkWidget *hbuttonbox;
	GtkWidget *dodaj;
	GtkWidget *text;
	GtkWidget *hbox_text;

	ignore_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(ignore_window), "ignore_window",
			    ignore_window);
	gtk_widget_set_usize(ignore_window, 150, 250);
	gtk_window_set_title(GTK_WINDOW(ignore_window),
			     _("Lista ignorowanych"));
	gtk_window_set_position(GTK_WINDOW(ignore_window),
				GTK_WIN_POS_MOUSE);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_container_add(GTK_CONTAINER(ignore_window), vbox1);

	scrolledwindow1 = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow1);
	gtk_box_pack_start(GTK_BOX(vbox1), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
				       (scrolledwindow1), GTK_POLICY_NEVER,
				       GTK_POLICY_AUTOMATIC);

	ignore_list = gtk_clist_new(1);
	gtk_widget_ref(ignore_list);
	gtk_object_set_data_full(GTK_OBJECT(ignore_window), "ignore_list",
				 ignore_list,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ignore_list);
	gtk_container_add(GTK_CONTAINER(scrolledwindow1), ignore_list);
	gtk_clist_set_column_width(GTK_CLIST(ignore_list), 0, 80);
	gtk_clist_column_titles_hide(GTK_CLIST(ignore_list));

	gtk_signal_connect(GTK_OBJECT(ignore_list), "button_press_event",
			   GTK_SIGNAL_FUNC
			   (on_ignore_list_button_press_event), NULL);

	label1 = gtk_label_new(_("label1"));
	gtk_widget_show(label1);
	gtk_clist_set_column_widget(GTK_CLIST(ignore_list), 0, label1);

	hbox_text = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox_text);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox_text, FALSE, FALSE, 3);

	text = gtk_entry_new_with_max_length(8);
	gtk_widget_ref(text);
	gtk_object_set_data_full(GTK_OBJECT(ignore_window), "text", text,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(text);
	gtk_box_pack_end(GTK_BOX(hbox_text), text, FALSE, FALSE, 3);
	gtk_widget_set_usize(text, 80, -2);

	hbuttonbox = gtk_hbutton_box_new();
	gtk_widget_show(hbuttonbox);
	gtk_box_pack_start(GTK_BOX(vbox1), hbuttonbox, FALSE, TRUE, 0);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox),
				  GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbuttonbox), 23);

	dodaj = gtk_button_new_with_label(_("Dodaj"));
	gtk_widget_show(dodaj);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), dodaj);
	GTK_WIDGET_SET_FLAGS(dodaj, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(dodaj), "clicked",
			   GTK_SIGNAL_FUNC(on_dodaj_ignore_clicked), text);

	gtk_signal_connect(GTK_OBJECT(ignore_window), "destroy",
			   GTK_SIGNAL_FUNC(destroy_ignore_window), NULL);

	return ignore_window;
}

GtkWidget *create_history(GGContact * kontakt)
{
	GtkWidget *history_window;
	GtkWidget *vbox;
	GtkWidget *scrolledwindow;
        GtkWidget *hbuttonbox;
	GtkWidget *button;
	GtkWidget *text;
	gchar *title;

	history_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(history_window), "history_window",
			    history_window);
	gtk_widget_set_usize(history_window, 450, 300);

	gtk_window_set_position(GTK_WINDOW(history_window),
				GTK_WIN_POS_CENTER);
	title =
	    g_strdup_printf("Historia rozmw z %s (%d)",
			    gg_get_nick_by_uin(kontakt->uin),
			    kontakt->uin);
	gtk_window_set_title(GTK_WINDOW(history_window), _(title));
	g_free(title);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(history_window), vbox);

	scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow);
	gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
				       (scrolledwindow), GTK_POLICY_NEVER,
				       GTK_POLICY_AUTOMATIC);
	text = gtk_text_new(NULL, NULL);
	gtk_widget_ref(text);
	gtk_object_set_data_full(GTK_OBJECT(history_window), "text", text,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(text);
	gtk_container_add(GTK_CONTAINER(scrolledwindow), text);
	gtk_widget_set_usize(text, -2, 180);

	hbuttonbox = gtk_hbutton_box_new();
	gtk_widget_show(hbuttonbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbuttonbox, FALSE, FALSE, 0);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox),
				  GTK_BUTTONBOX_END);

	button = gtk_button_new_with_label(_("Wyczy"));
	gtk_widget_show(button);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_wyczysc_clicked),
			   kontakt);

	button = gtk_button_new_with_label(_("Zapisz jako..."));
	gtk_widget_show(button);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_zapisz_jako_clicked),
			   kontakt);

	button = gtk_button_new_with_label(_("Zamknij"));
	gtk_widget_show(button);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			  history_window);

	return history_window;
}

#ifdef USE_GNOME
#ifdef USE_APPLET
void about(AppletWidget * applet, gpointer data)
#else
void about(GtkWidget * applet, gpointer data)
#endif				/* USE_APPLET */
{
	gchar *fullpath;
	static GtkWidget *about_box = NULL;
	static const char *authors[] = {
		"Igor Popik <thrull@slackware.pl>",
		"Marcin Pawiski <plavi@linux.pl>",
		"Igor Truszkowski <igor@chaos.w.pl>",
		"Micha Nowikowski <godfryd@zamek.gda.pl>",
		"Mateusz Papiernik <mati@mati.rm.pl>",
		NULL
	};

	if (about_box != NULL) {
		gdk_window_show(about_box->window);
		gdk_window_raise(about_box->window);
		return;
	}
	fullpath = GPP("gg-logo.xpm");
	about_box = gnome_about_new(_("GNU Gadu - wolne gadanie"), VERSION,
				    _("Copyright 2001-2003 Igor Popik"),
				    authors,
				    _
				    ("Klient G*du-G*du na licencji GNU/GPL\n"
				     "\nhttp://gadu.gnu.pl\n"),
				    fullpath);
	g_free(fullpath);
	
	gtk_signal_connect(GTK_OBJECT(about_box), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			   &about_box);
	gtk_widget_show(about_box);
	return;
}

#endif				/* USE_GNOME */

#ifndef USE_GNOME
GtkWidget *create_about(void)
{
	GtkWidget *Informacje;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *name;
	GtkWidget *hseparator1;
	GtkWidget *copyright;
	GtkWidget *dialog_action_area1;
	GtkWidget *hbuttonbox1;
	GtkWidget *okbutton;
	GtkWidget *logo;

	Informacje = gtk_dialog_new();
	gtk_object_set_data(GTK_OBJECT(Informacje), "Informacje",
			    Informacje);
	gtk_widget_set_usize(Informacje, 320, -2);
	gtk_window_set_title(GTK_WINDOW(Informacje), _("Informacje o"));
	gtk_window_set_position(GTK_WINDOW(Informacje),
				GTK_WIN_POS_CENTER);
	gtk_window_set_policy(GTK_WINDOW(Informacje), TRUE, TRUE, FALSE);

	dialog_vbox1 = GTK_DIALOG(Informacje)->vbox;
	gtk_widget_show(dialog_vbox1);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_box_pack_start(GTK_BOX(dialog_vbox1), vbox1, TRUE, TRUE, 0);
	
	logo = create_pixmap(Informacje, "gg-logo.xpm");
	gtk_widget_show(logo);
	gtk_box_pack_start(GTK_BOX(vbox1), logo, FALSE, FALSE, 0);

	hseparator1 = gtk_hseparator_new();
	gtk_widget_show(hseparator1);
	gtk_box_pack_start(GTK_BOX(vbox1), hseparator1, TRUE, TRUE, 0);
	gtk_widget_set_usize(hseparator1, -2, 2);
	
	name =
	    gtk_label_new(_("\nGNU Gadu " VERSION " - wolne gadanie\n"));
	gtk_widget_show(name);
	gtk_box_pack_start(GTK_BOX(vbox1), name, FALSE, FALSE, 0);
	gtk_label_set_justify(GTK_LABEL(name), GTK_JUSTIFY_LEFT);

	hseparator1 = gtk_hseparator_new();
	gtk_widget_show(hseparator1);
	gtk_box_pack_start(GTK_BOX(vbox1), hseparator1, TRUE, TRUE, 0);
	gtk_widget_set_usize(hseparator1, -2, 2);

	copyright =
	    gtk_label_new(_
			  ("(C) 2001-2003 Igor Popik\n\nAutorzy: \nIgor Popik <thrull@slackware.pl>\nMarcin Pawiski <plavi@linux.pl>\nIgor Truszkowski <igor@chaos.w.pl>\nMicha Nowikowski <godfryd@zamek.gda.pl>\nMateusz Papiernik <mati@mati.rm.pl>\n\nhttp://gadu.gnu.pl\nKlient G*du-G*du na licencji GNU/GPL."));
	gtk_box_pack_start(GTK_BOX(vbox1), copyright, FALSE, FALSE, 0);
	gtk_widget_set_usize(copyright, -2, 170);
	gtk_label_set_justify(GTK_LABEL(copyright), GTK_JUSTIFY_FILL);
	gtk_widget_show(copyright);

	dialog_action_area1 = GTK_DIALOG(Informacje)->action_area;
	gtk_widget_show(dialog_action_area1);
	gtk_container_set_border_width(GTK_CONTAINER(dialog_action_area1),
				       10);

	hbuttonbox1 = gtk_hbutton_box_new();
	gtk_widget_show(hbuttonbox1);
	gtk_box_pack_start(GTK_BOX(dialog_action_area1), hbuttonbox1, TRUE,
			   TRUE, 0);

	okbutton = gtk_button_new_with_label(_("OK"));
	gtk_widget_show(okbutton);
	gtk_container_add(GTK_CONTAINER(hbuttonbox1), okbutton);
	GTK_WIDGET_SET_FLAGS(okbutton, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(okbutton), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   Informacje);

	gtk_widget_grab_default(okbutton);

	return Informacje;
}
#endif

GtkWidget *create_sms_dialog(GGContact * kontakt)
{
	GtkWidget *sms_dialog;
	GtkWidget *sms_vbox;
	GtkWidget *sms_frame;
	GtkWidget *sms_hbox;
	GtkWidget *sms_pixmap;
	GtkWidget *sms_label;
	GtkWidget *sms_number;
	GtkWidget *sms_scrolledwindow;
	GtkWidget *sms_text;
	GtkWidget *sms_hbuttonbox;
	GtkWidget *sms_wyslij;
	GtkWidget *sms_anuluj;

	sms_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(sms_dialog), "sms_dialog",
			    sms_dialog);
	gtk_widget_set_usize(sms_dialog, 400, 300);
	gtk_window_set_title(GTK_WINDOW(sms_dialog),
			     _("Krtka wiadomo tekstowa (SMS)"));
	gtk_window_set_position(GTK_WINDOW(sms_dialog),
				GTK_WIN_POS_CENTER);

	sms_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(sms_vbox);
	gtk_container_add(GTK_CONTAINER(sms_dialog), sms_vbox);

	sms_frame = gtk_frame_new(_("SMS"));
	gtk_widget_show(sms_frame);
	gtk_box_pack_start(GTK_BOX(sms_vbox), sms_frame, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(sms_frame), 3);

	sms_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(sms_hbox);
	gtk_container_add(GTK_CONTAINER(sms_frame), sms_hbox);
	gtk_widget_set_usize(sms_hbox, -2, 16);

	sms_pixmap = create_pixmap(sms_dialog, "cellphone.xpm");
	gtk_widget_show(sms_pixmap);
	gtk_box_pack_start(GTK_BOX(sms_hbox), sms_pixmap, FALSE, FALSE, 0);

	sms_label = gtk_label_new(_("Pod numer: "));
	gtk_widget_show(sms_label);
	gtk_box_pack_start(GTK_BOX(sms_hbox), sms_label, FALSE, FALSE, 0);
	gtk_widget_set_usize(sms_label, -2, 16);

	sms_number = gtk_entry_new();
	gtk_widget_ref(sms_number);
	gtk_object_set_data_full(GTK_OBJECT(sms_dialog), "sms_number",
				 sms_number,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(sms_number);
	gtk_box_pack_start(GTK_BOX(sms_hbox), sms_number, FALSE, FALSE, 0);
	gtk_widget_set_usize(sms_number, 100, -2);

	sms_scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(sms_scrolledwindow);
	gtk_box_pack_start(GTK_BOX(sms_vbox), sms_scrolledwindow, TRUE,
			   TRUE, 0);
	gtk_widget_set_usize(sms_scrolledwindow, -2, 150);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
				       (sms_scrolledwindow),
				       GTK_POLICY_NEVER,
				       GTK_POLICY_ALWAYS);

	sms_text = gtk_text_new(NULL, NULL);
	gtk_widget_ref(sms_text);
	gtk_object_set_data_full(GTK_OBJECT(sms_dialog), "sms_text",
				 sms_text,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(sms_text);
	gtk_container_add(GTK_CONTAINER(sms_scrolledwindow), sms_text);
	gtk_text_set_editable(GTK_TEXT(sms_text), TRUE);

	sms_hbuttonbox = gtk_hbutton_box_new();
	gtk_widget_show(sms_hbuttonbox);
	gtk_box_pack_start(GTK_BOX(sms_vbox), sms_hbuttonbox, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(sms_hbuttonbox, -2, 32);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(sms_hbuttonbox), 0);

	sms_wyslij = gtk_button_new_with_label(_("Wylij"));
	gtk_widget_show(sms_wyslij);
	gtk_container_add(GTK_CONTAINER(sms_hbuttonbox), sms_wyslij);
	GTK_WIDGET_SET_FLAGS(sms_wyslij, GTK_CAN_DEFAULT);

	sms_anuluj = gtk_button_new_with_label(_("Anuluj"));
	gtk_widget_show(sms_anuluj);
	gtk_container_add(GTK_CONTAINER(sms_hbuttonbox), sms_anuluj);
	GTK_WIDGET_SET_FLAGS(sms_anuluj, GTK_CAN_DEFAULT);

	gtk_entry_set_text(GTK_ENTRY(sms_number), kontakt->mobile);

	gtk_signal_connect(GTK_OBJECT(sms_wyslij), "clicked",
			   GTK_SIGNAL_FUNC(on_wyslij_sms_clicked),
			   kontakt);
	gtk_signal_connect(GTK_OBJECT(sms_anuluj), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   sms_dialog);

	gtk_widget_grab_default(sms_wyslij);
	return sms_dialog;
}

GtkWidget *create_chpass(void)
{
	GtkWidget *chpass;
	GtkWidget *chpass_vbox;
	GtkWidget *chpass_hbox;
	GtkWidget *chpass_label1;
	GtkWidget *chpass_password1;
	GtkWidget *chpass_hbox1;
	GtkWidget *chpass_label2;
	GtkWidget *chpass_password2;
	GtkWidget *chpass_label3;
	GtkWidget *chpass_hbox3;
	GtkWidget *chpass_label4;
	GtkWidget *chpass_email;
	GtkWidget *chpass_hbuttonbox;
	GtkWidget *chpass_okbutton;
	GtkWidget *chpass_anuluj;

	chpass = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(chpass), "chpass", chpass);
	gtk_widget_set_usize(chpass, 300, -2);
	gtk_window_set_title(GTK_WINDOW(chpass),
			     _("Zmiana hasa na serwer GG"));
	gtk_window_set_position(GTK_WINDOW(chpass), GTK_WIN_POS_CENTER);

	chpass_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(chpass_vbox);
	gtk_container_add(GTK_CONTAINER(chpass), chpass_vbox);

	chpass_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(chpass_hbox);
	gtk_box_pack_start(GTK_BOX(chpass_vbox), chpass_hbox, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(chpass_hbox, -2, 35);

	chpass_label1 = gtk_label_new(_("Nowe haso: "));
	gtk_widget_show(chpass_label1);
	gtk_box_pack_start(GTK_BOX(chpass_hbox), chpass_label1, FALSE,
			   TRUE, 0);
	gtk_widget_set_usize(chpass_label1, 90, -2);

	chpass_password1 = gtk_entry_new_with_max_length(50);
	gtk_widget_ref(chpass_password1);
	gtk_object_set_data_full(GTK_OBJECT(chpass), "chpass_password1",
				 chpass_password1,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(chpass_password1);
	gtk_box_pack_start(GTK_BOX(chpass_hbox), chpass_password1, FALSE,
			   TRUE, 0);
	gtk_entry_set_visibility(GTK_ENTRY(chpass_password1), FALSE);

	chpass_hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(chpass_hbox1);
	gtk_box_pack_start(GTK_BOX(chpass_vbox), chpass_hbox1, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(chpass_hbox1, -2, 35);

	chpass_label2 = gtk_label_new(_("Powtrz haso: "));
	gtk_widget_show(chpass_label2);
	gtk_box_pack_start(GTK_BOX(chpass_hbox1), chpass_label2, FALSE,
			   TRUE, 0);
	gtk_widget_set_usize(chpass_label2, 90, -2);

	chpass_password2 = gtk_entry_new_with_max_length(50);
	gtk_widget_ref(chpass_password2);
	gtk_object_set_data_full(GTK_OBJECT(chpass), "chpass_password2",
				 chpass_password2,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(chpass_password2);
	gtk_box_pack_start(GTK_BOX(chpass_hbox1), chpass_password2, FALSE,
			   TRUE, 0);
	gtk_entry_set_visibility(GTK_ENTRY(chpass_password2), FALSE);

	chpass_label3 =
	    gtk_label_new(_
			  ("Na ponizszy adres e-mail haso zostanie odesane\ndo Ciebie w przypadku gdy je zapomnisz."));
	gtk_widget_show(chpass_label3);
	gtk_box_pack_start(GTK_BOX(chpass_vbox), chpass_label3, FALSE,
			   FALSE, 0);
	gtk_widget_set_usize(chpass_label3, 90, -2);

	chpass_hbox3 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(chpass_hbox3);
	gtk_box_pack_start(GTK_BOX(chpass_vbox), chpass_hbox3, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(chpass_hbox3, -2, 35);

	chpass_label4 = gtk_label_new(_("Adres e-mail:"));
	gtk_widget_show(chpass_label4);
	gtk_box_pack_start(GTK_BOX(chpass_hbox3), chpass_label4, FALSE,
			   TRUE, 0);
	gtk_widget_set_usize(chpass_label4, 90, -2);

	chpass_email = gtk_entry_new_with_max_length(80);
	gtk_widget_ref(chpass_email);
	gtk_object_set_data_full(GTK_OBJECT(chpass), "chpass_email",
				 chpass_email,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(chpass_email);
	gtk_box_pack_start(GTK_BOX(chpass_hbox3), chpass_email, FALSE,
			   TRUE, 0);

	chpass_hbuttonbox = gtk_hbutton_box_new();
	gtk_widget_show(chpass_hbuttonbox);
	gtk_box_pack_start(GTK_BOX(chpass_vbox), chpass_hbuttonbox, FALSE,
			   TRUE, 0);

	chpass_okbutton = gtk_button_new_with_label(_("OK"));
	gtk_widget_show(chpass_okbutton);
	gtk_container_add(GTK_CONTAINER(chpass_hbuttonbox),
			  chpass_okbutton);
	GTK_WIDGET_SET_FLAGS(chpass_okbutton, GTK_CAN_DEFAULT);

	chpass_anuluj = gtk_button_new_with_label(_("Anuluj"));
	gtk_widget_show(chpass_anuluj);
	gtk_container_add(GTK_CONTAINER(chpass_hbuttonbox), chpass_anuluj);
	GTK_WIDGET_SET_FLAGS(chpass_anuluj, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(chpass_anuluj), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   chpass);
	gtk_signal_connect(GTK_OBJECT(chpass_okbutton), "clicked",
			   GTK_SIGNAL_FUNC(on_chpass_okbutton_clicked),
			   chpass);

	return chpass;
}

GtkWidget *create_register(void)
{
	GtkWidget *register_dialog;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *password1;
	GtkWidget *password2;
	GtkWidget *email;
	GtkWidget *hbuttonbox;
	GtkWidget *okbutton;
	GtkWidget *anuluj;

	register_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(register_dialog), "register_dialog", register_dialog);
	gtk_widget_set_usize(register_dialog, 300, -2);
	gtk_window_set_title(GTK_WINDOW(register_dialog),
			     _("Rejestracja nowego uytkownika"));
	gtk_window_set_position(GTK_WINDOW(register_dialog), GTK_WIN_POS_CENTER);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(register_dialog), vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(hbox, -2, 35);

	label = gtk_label_new(_("Haso: "));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,
			   TRUE, 0);
	gtk_widget_set_usize(label, 90, -2);

	password1 = gtk_entry_new_with_max_length(50);
	gtk_widget_ref(password1);
	gtk_object_set_data_full(GTK_OBJECT(register_dialog), "password1",
				 password1,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(password1);
	gtk_box_pack_start(GTK_BOX(hbox), password1, FALSE,
			   TRUE, 0);
	gtk_entry_set_visibility(GTK_ENTRY(password1), FALSE);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(hbox, -2, 35);

	label = gtk_label_new(_("Powtrz haso: "));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,
			   TRUE, 0);
	gtk_widget_set_usize(label, 90, -2);

	password2 = gtk_entry_new_with_max_length(50);
	gtk_widget_ref(password2);
	gtk_object_set_data_full(GTK_OBJECT(register_dialog), "password2",
				 password2,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(password2);
	gtk_box_pack_start(GTK_BOX(hbox), password2, FALSE,
			   TRUE, 0);
	gtk_entry_set_visibility(GTK_ENTRY(password2), FALSE);

	label =
	    gtk_label_new(_
			  ("Na ponizszy adres e-mail haso zostanie odesane\ndo Ciebie w przypadku gdy je zapomnisz."));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE,
			   FALSE, 0);
	gtk_widget_set_usize(label, 90, -2);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(hbox, -2, 35);

	label = gtk_label_new(_("Adres e-mail:"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,
			   TRUE, 0);
	gtk_widget_set_usize(label, 90, -2);

	email = gtk_entry_new_with_max_length(80);
	gtk_widget_ref(email);
	gtk_object_set_data_full(GTK_OBJECT(register_dialog), "email",
				 email,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(email);
	gtk_box_pack_start(GTK_BOX(hbox), email, FALSE,
			   TRUE, 0);

	hbuttonbox = gtk_hbutton_box_new();
	gtk_widget_show(hbuttonbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbuttonbox, FALSE,
			   TRUE, 0);

	okbutton = gtk_button_new_with_label(_("OK"));
	gtk_widget_show(okbutton);
	gtk_container_add(GTK_CONTAINER(hbuttonbox),
			  okbutton);
	GTK_WIDGET_SET_FLAGS(okbutton, GTK_CAN_DEFAULT);

	anuluj = gtk_button_new_with_label(_("Anuluj"));
	gtk_widget_show(anuluj);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), anuluj);
	GTK_WIDGET_SET_FLAGS(anuluj, GTK_CAN_DEFAULT);

	gtk_signal_connect(GTK_OBJECT(anuluj), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   register_dialog);
	gtk_signal_connect(GTK_OBJECT(okbutton), "clicked",
			   GTK_SIGNAL_FUNC(on_register_okbutton_clicked),
			   register_dialog);

	return register_dialog;
}


GtkWidget *create_pubdir_info()
{
	GtkWidget *pubdir;
	GtkWidget *main_vbox;
	GtkWidget *vbox;
	GtkWidget *vbox1;
	GtkWidget *frame;
	GtkWidget *hbox;
	GtkWidget *pixmap;
	GtkWidget *label;
	GtkWidget *entry;
	GtkWidget *hbuttonbox;
	GtkWidget *button;
	GtkWidget *combo;
	GList *gender_items = NULL;
	
	pubdir = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(pubdir), "pubdir", pubdir);
	gtk_widget_set_usize(pubdir, 450, 255);
	gtk_window_set_title(GTK_WINDOW(pubdir),
			     _("Edycja danych w katalogu publicznym"));
	gtk_window_set_position(GTK_WINDOW(pubdir), GTK_WIN_POS_CENTER);
	gtk_window_set_modal(GTK_WINDOW(pubdir), TRUE);
	
	
	main_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(main_vbox);
	gtk_container_add(GTK_CONTAINER(pubdir), main_vbox);

	frame = gtk_frame_new(_("Osoba"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, TRUE, TRUE,
			   3);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 3);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_box_pack_start(GTK_BOX(hbox), vbox1, TRUE, TRUE,
			   0);

	pixmap = create_pixmap(pubdir, "pubdir_info.xpm");
	gtk_widget_show(pixmap);
	gtk_box_pack_start(GTK_BOX(vbox1), pixmap, FALSE, FALSE,
			   0);


	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE,
			   0);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE,
			   0);

	label = gtk_label_new(_("Imi: "));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,
			   FALSE, 5);
	gtk_widget_set_usize(label, 75, -2);

	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(pubdir), "first_name",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(entry, 110, -2);

	label = gtk_label_new(_("Nazwisko:"));
	gtk_widget_set_usize(label, 55, -2);

	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,
			   FALSE, 10);

	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(pubdir), "last_name",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(entry, 110, -2);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE,
			   0);

	label = gtk_label_new(_("Pseudo:"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,
			   FALSE, 5);
	gtk_widget_set_usize(label, 75, -2);

	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(pubdir), "nick",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(entry, 110, -2);

	label = gtk_label_new(_("Rok ur.:"));
	gtk_widget_set_usize(label, 55, -2);

	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 10);

	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(pubdir), "born",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(entry, 110, -2);


	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE,
			   0);

	label = gtk_label_new(_("Miejscowo:"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,
			   FALSE, 5);
	gtk_widget_set_usize(label, 75, -2);

	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(pubdir), "city",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(entry, 110, -2);

	label = gtk_label_new(_("Pe:"));
	gtk_widget_set_usize(label, 55, -2);

	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 10);

	combo = gtk_combo_new();
	gtk_widget_ref(combo);
	gtk_object_set_data_full(GTK_OBJECT(pubdir), "gender", combo,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(combo);
	gtk_box_pack_start(GTK_BOX(hbox), combo, FALSE, FALSE, 0);
	gtk_widget_set_usize(combo, 110, -2);
	gender_items = g_list_append(gender_items, (gpointer) "");
	gender_items =
	    g_list_append(gender_items, (gpointer) _("Kobieta"));
	gender_items =
	    g_list_append(gender_items, (gpointer) _("Mczyzna"));
	gtk_combo_set_popdown_strings(GTK_COMBO(combo), gender_items);
	g_list_free(gender_items);

	entry = GTK_COMBO(combo)->entry;
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(pubdir), "gender_text",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_entry_set_editable(GTK_ENTRY(entry), FALSE);

/*	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE,
			   0);

	label = gtk_label_new(_("Nazwisko panieskie: "));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,
			   FALSE, 5);
	gtk_widget_set_usize(label, 75, -2);

	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(pubdir), "familyname",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(entry, 110, -2);

	label = gtk_label_new(_("Miejscowo ur.:"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE,
			   FALSE, 5);
	gtk_widget_set_usize(label, 75, -2);

	entry = gtk_entry_new();

	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(pubdir), "familycity",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, TRUE,
			   0);
	gtk_widget_set_usize(entry, 110, -2);

*/
	hbuttonbox = gtk_hbutton_box_new();
	gtk_widget_show(hbuttonbox);
	gtk_box_pack_start(GTK_BOX(main_vbox), hbuttonbox, FALSE, TRUE,
			   0);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox),
				  GTK_BUTTONBOX_END);

/*	button = gtk_button_new_with_label(_("Pobierz"));
	gtk_widget_show(button);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked), pubdir);
*/
	button = gtk_button_new_with_label(_("Uaktualnij"));
	gtk_widget_show(button);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_uaktualnij_pubdir_clicked), pubdir);

	button = gtk_button_new_with_label(_("Anuluj"));
	gtk_widget_show(button);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   pubdir);
			   
	gtk_widget_grab_default(button);

	return pubdir;
}
static
GtkWidget *create_radio_button_label(gchar *pixmap_path, gchar *text)
{
    GtkWidget *hbox;
    GtkWidget *label;
    GtkWidget *pixmap;
    
    hbox = gtk_hbox_new(FALSE, 0);
    pixmap = create_pixmap(hbox, pixmap_path);
    gtk_box_pack_start(GTK_BOX(hbox), pixmap, FALSE, FALSE, 2);
    label = gtk_label_new(text);   
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
    return hbox;
}
GtkWidget *create_status_description_dialog()
{
	GtkWidget *dialog;
	GtkWidget *main_vbox;
	GtkWidget *hbuttonbox;
	GtkWidget *button;
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *radiobutton;
	GtkWidget *frame;
	GtkWidget *label;
	GtkWidget *entry;
#ifdef USE_XMMS
	GtkWidget *xmms_descr;
#endif		
	GSList *group = NULL;
	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_object_set_data(GTK_OBJECT(dialog), "status_descr", dialog);
	gtk_widget_set_usize(dialog, 350, 180);
	gtk_window_set_title(GTK_WINDOW(dialog),
			     _("Zmiana statusu..."));
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

	main_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(main_vbox);
	gtk_container_add(GTK_CONTAINER(dialog), main_vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	
	gtk_box_pack_start(GTK_BOX(main_vbox), hbox, TRUE, TRUE,
			   3);
	
	frame = gtk_frame_new(_("Status"));
	
	gtk_box_pack_start(GTK_BOX(hbox), frame, FALSE, FALSE,
			   1);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 1);
	
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	
	radiobutton = gtk_radio_button_new(group);
	gtk_container_add(GTK_CONTAINER(radiobutton), create_radio_button_label(ONLINE_DESCR_IMG, "Dostepny"));
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton));
	gtk_widget_ref(radiobutton);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "radio_available", radiobutton, 
				    (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start(GTK_BOX(vbox), radiobutton, FALSE, FALSE, 0);

	radiobutton = gtk_radio_button_new(group);
	gtk_container_add(GTK_CONTAINER(radiobutton), create_radio_button_label(AWAY_DESCR_IMG, "Zaraz wracam"));
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton));
	gtk_widget_ref(radiobutton);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "radio_away", radiobutton, 
				    (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start(GTK_BOX(vbox), radiobutton, FALSE, FALSE, 0);

	radiobutton = gtk_radio_button_new(group);
	gtk_container_add(GTK_CONTAINER(radiobutton), create_radio_button_label(INVISIBLE_DESCR_IMG, "Niewidoczny"));
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton));
	gtk_widget_ref(radiobutton);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "radio_invisible", radiobutton, 
				    (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start(GTK_BOX(vbox), radiobutton, FALSE, FALSE, 0);

	radiobutton = gtk_radio_button_new(group);
	gtk_container_add(GTK_CONTAINER(radiobutton), create_radio_button_label(OFFLINE_DESCR_IMG, "Niedostpny"));
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton));
	gtk_widget_ref(radiobutton);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "radio_offline", radiobutton, 
				    (GtkDestroyNotify) gtk_widget_unref);
	gtk_box_pack_start(GTK_BOX(vbox), radiobutton, FALSE, FALSE, 0);
	
	frame = gtk_frame_new(_("Opis"));
	
	gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE,
			   1);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 1);
	
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	label = gtk_label_new("Do poniszego pola wpisz opis\n(max. 40 znakw)");
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, TRUE, 2);
	
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 1);
		
	entry = gtk_entry_new_with_max_length(40);
	gtk_widget_set_usize(entry, 180, -2);
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "description", entry, 
				    (GtkDestroyNotify) gtk_widget_unref);

	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, FALSE, 1);
	gtk_entry_set_text(GTK_ENTRY(entry), config.reason);
#ifdef USE_XMMS
	xmms_descr =
	    gtk_check_button_new_with_label(_("Uyj opisu z programu XMMS"));
	gtk_widget_ref(xmms_descr);
	gtk_object_set_data_full(GTK_OBJECT(dialog), "xmms_descr", xmms_descr, 
				    (GtkDestroyNotify) gtk_widget_unref);

	gtk_box_pack_start(GTK_BOX(vbox), xmms_descr, TRUE, FALSE, 1);
#endif	
	hbuttonbox = gtk_hbutton_box_new();
	gtk_widget_show(hbuttonbox);
	gtk_box_pack_start(GTK_BOX(main_vbox), hbuttonbox, FALSE, TRUE,
			   0);

	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox),
				  GTK_BUTTONBOX_END);

	button = gtk_button_new_with_label(_("Ok"));
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_status_ok_clicked),
			   dialog);
	
	gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

	button = gtk_button_new_with_label(_("Anuluj"));
	
	gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_status_anuluj_clicked),
			   dialog);

	gtk_widget_show_all(dialog);

	return dialog;
}
