/* $Id: net.c,v 1.8 2003/01/25 15:46:02 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik. Released under GPL license.
 */

#include <glib.h>
#include <gdk/gdk.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>

#include "gg.h"
#include "ggcore.h"
#include "support.h"
#include "search.h"

#define MY_GDK_INPUT_ERROR 0x03

extern GList *watches;
extern GGConfig config;
extern GGStatus status;

/* Wczenie obsugi zdarze na deskryptorze */
void
tcp_watch_setup(gint * input, gint sock, GdkInputFunction input_function)
{
	if (*input != 0)
		gdk_input_remove(*input);
	*input = gdk_input_add(sock,
			       GDK_INPUT_READ | GDK_INPUT_EXCEPTION,
			       (GdkInputFunction) input_function, input);
}

void tcp_watch_cleanup(gint * input)
{
	if (input != NULL && *input != 0) {
		g_source_remove(*input);
		*input = 0;
	}
}

void tcp_watch_destroy(GGWatch * r)
{
	g_print("WATCH iz %d\n", (int) r);
	if (r != NULL) {
		g_source_remove(r->watch);
		g_free(r->data);
		g_free(r);
		r = NULL;
	}
}

void
tcp_watch_setup_full(gint * watch, gint sock,
		     GdkInputFunction input_function, GGWatch * r)
{
	if (*watch != 0)
		gdk_input_remove(*watch);
	*watch = gdk_input_add(sock,
			       GDK_INPUT_READ | GDK_INPUT_EXCEPTION,
			       (GdkInputFunction) input_function, r);
	watches = g_list_append(watches, r);
}

void
tcp_watch_setup_full_write(gint * watch, gint sock,
			   GdkInputFunction input_function, GGWatch * r)
{
	if (*watch != 0)
		gdk_input_remove(*watch);
	*watch = gdk_input_add(sock,
			       GDK_INPUT_WRITE | GDK_INPUT_EXCEPTION,
			       (GdkInputFunction) input_function, r);
	watches = g_list_append(watches, r);
}

void
tcp_watch_setup_rw(gint * input, gint sock,
		   GdkInputFunction input_function)
{
	if (*input != 0)
		gdk_input_remove(*input);
	*input = gdk_input_add(sock,
			       GDK_INPUT_WRITE | GDK_INPUT_READ |
			       GDK_INPUT_EXCEPTION,
			       (GdkInputFunction) input_function, input);
}

gboolean resolve_callback(GIOChannel *chan, GIOCondition cond, gpointer data)
{

	g_print("in resolve cond=%d\n", cond);
	
	if (cond & G_IO_IN) {
		gg_resolve_callback(data);
		return FALSE;
	}

	if (cond & G_IO_ERR || cond & G_IO_HUP) {

		g_print("in resolve (ERROR)\n");
		((GGWatch *)data)->timeout = 0;
		return FALSE;
	}

	return FALSE;
}

gboolean http_query_write(GIOChannel *chan, GIOCondition cond, gpointer data)
{
	g_print("handle_http_query_write(): incoming pipe data %d\n", cond);

	if (cond & G_IO_OUT) {
		gg_send_query(data);
		return FALSE;
	}

	if ((cond & G_IO_ERR) || (cond & G_IO_HUP)) {
		((GGWatch *)data)->timeout = 0;
		return FALSE;
	}

	return FALSE;
}

gboolean http_result(GIOChannel *chan, GIOCondition cond, gpointer data)
{
	g_print("HTTP RESULT cond=%d\n", cond);

	if (cond & G_IO_IN) {
		GGHTTPQuery *q;

		q = ((GGWatch *) data)->data;
    		switch (q->type) {
		case GG_CHANGE_PASSWORD:
			gg_change_password_res((GGWatch *) data);
			break;
		case GG_REMIND_PASSWORD:
			gg_restore_password_res((GGWatch *) data);
			break;
		case GG_RESOLVE_SERVER:
			gg_connect_resolve((GGWatch *) data);
			break;
		case GG_SEARCH:
			gg_http_search_get_res((GGWatch *) data);
			break;
		case GG_REGISTER:
			gg_register_res((GGWatch *) data);
			break;
		case GG_EXPORT_USERLIST:
			gg_export_userlist_res((GGWatch *) data);
			break;
		case GG_IMPORT_USERLIST:
			gg_import_userlist_res((GGWatch *) data);
			break;
		case GG_DELETE_USERLIST:
			gg_delete_userlist_res((GGWatch *) data);
			break;
		case GG_CHANGE_PUBDIR_INFO:
			gg_change_pubdir_info_res((GGWatch *) data);
			break;
		default:
			tcp_watch_destroy(data);
		}
		return TRUE;
	}

	if (cond & G_IO_ERR || cond & G_IO_HUP) {
		((GGWatch *)data)->timeout = 0;
	}
	return FALSE;
}

gint handle_find_http_incoming(gpointer data, gint sock,
			       GdkInputCondition cond)
{
	if (cond & GDK_INPUT_READ) {
		gg_http_search_get_res(NULL);
		return TRUE;
	}
	if (cond & MY_GDK_INPUT_ERROR) {
		show_error_dialog("Serwer odmwi poczenia!");
		tcp_watch_cleanup((gint *) data);
		return FALSE;
	}

	return FALSE;
}

gboolean socket_callback(GIOChannel *chan, GIOCondition cond, gpointer data)
//gint handle_incoming(gpointer data, gint sock, GdkInputCondition cond)
{
	GGCmd *cmd;
	gint sock = g_io_channel_unix_get_fd(chan);
	
	g_print("handle_incoming(): Cought something.cond=%d\n", cond);

	if (cond & G_IO_ERR || cond & G_IO_HUP) {
		gg_connection_error();
		return FALSE;
	}
	
//	if (cond & MY_GDK_INPUT_ERROR) {
//		tcp_watch_cleanup((gint *) data);
//		return FALSE;
//	}

	if (cond & G_IO_IN) {
		cmd = gg_read_cmd(sock);

		if (cmd == NULL) {
		    if (!status.resume_cmd) {    
			gg_connection_error();
			return FALSE;
		    } else 
			return TRUE;
		}
		
		g_print("handle_incoming(): cmd->type=%d\n", cmd->type);

		switch (cmd->type) {
		case GG_RESET_CONNECTION:
			close_connection();
			break;
		case GG_LOGIN_MSG:
			if (config.status == GG_STATUS_OFFLINE || 
			    config.status == GG_STATUS_OFFLINE_DESCR) {
			    config.status = GG_STATUS_ONLINE;
			}
			gg_login(sock, cmd, config.status ? config.status : GG_STATUS_ONLINE, config.reason ? config.reason : NULL);
			if (config.server) g_free(config.server);
			config.server = g_strdup_printf("%s:%d", status.hostname, status.port);
			break;
		case GG_LOGIN_OK:
			gg_login_ok();
			break;
		case GG_LOGIN_ERROR:
			close_connection();
			show_error_dialog("Logowanie nie powiodo si!!!");
			break;
		case GG_STATUS:
			gg_change_contact_status(cmd);
			break;
		case GG_CLIENT_ONLINE_CONFIRM:
			g_print("handle_incoming(): Serwer: PONG!\n");
			break;
		case GG_RECV_MSG:
			gg_recv_msg(cmd);
			break;
		case GG_NOTIFY_REPLY:
			gg_notify_replay(cmd);
			break;
		case GG_SEND_MSG_ACK:
			gg_msg_send_ack(cmd);
			break;
		case GG_PUBDIR50_REPLY:
			gg_search_get_res(cmd);
			break;
		default:
			g_warning
			    ("Nie rozumiem co serwer do mnie mwi: %d\n",
			     cmd->type);
			break;
		}
		g_free(cmd->data);
		g_free(cmd);
	}
	return TRUE;
}

/*
 * gg_resolve() // funkcja wewntrzna
 *
 * tworzy pipe'y, forkuje si i w drugim procesie zaczyna resolvowa 
 * podanego hosta. zapisuje w sesji deskryptor pipe'u. jeli co tam
 * bdzie gotowego, znaczy, e mona wczyta ,,struct in_addr''. jeli
 * nie znajdzie, zwraca INADDR_NONE.
 *
 *  - fd - wskanik gdzie wrzuci deskryptor,
 *  - pid - gdzie wrzuci pid dzieciaka,
 *  - hostname - nazwa hosta do zresolvowania.
 *
 * zwraca 0 jeli udao si odpali proces lub -1 w przypadku bdu.
 */
int ekg_resolve(int *fd, int *pid, char *hostname)
{
	int pipes[2], res;
	struct in_addr a;

	if (!fd | !pid) {
		errno = EFAULT;
		return -1;
	}

	if (pipe(pipes) == -1)
		return -1;

	if ((res = fork()) == -1)
		return -1;

	if (!res) {
		fd_set wfd;
		struct timeval tv;
		    
		FD_ZERO(&wfd);
		FD_SET(pipes[1], &wfd);
		
		if ((a.s_addr = inet_addr(hostname)) == INADDR_NONE) {
			struct hostent *he;

			if (!(he = gethostbyname(hostname)))
				a.s_addr = INADDR_NONE;
			else
				memcpy((char *) &a, he->h_addr, sizeof(a));
		}
		
		tv.tv_sec = 1;
		tv.tv_usec = 0;
		
		usleep(100);
		select(2, NULL, &wfd, NULL, &tv);
		write(pipes[1], &a, sizeof(a));

		_exit(0);
	}

	close(pipes[1]);

	*fd = pipes[0];
	*pid = res;

	return 0;
}

int connect_to_server(struct in_addr *a, int port, int async)
{
	struct sockaddr_in sck;
	int sock, one = 1;

	sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

	if (!sock) {
		g_warning
		    ("connect_to_server(): Cannot create socket (sock=%d)\n",
		     sock);
		return -1;
	}

	if (async) {
		if (ioctl(sock, FIONBIO, &one) == -1) {
			g_print("ioctl() failed.n");
			return -1;
		}
	}

	sck.sin_family = PF_INET;
	sck.sin_port = htons(port);
	sck.sin_addr.s_addr = a->s_addr;

	if (connect(sock, (struct sockaddr *) &sck, sizeof(sck)) < 0) {
		if (errno && (!async || errno != EINPROGRESS)) {
			g_warning("Cannot connect!\n");
			return -1;
		}
	}
	g_print("connect_to_server_ip(): Connected to: %ld.%d\n",
		(long) a->s_addr, ntohs(sck.sin_port));
	return sock;
}

/*int connect_to_server(char *host, int port, int async)
{
	long ip;
	struct hostent *hp;
	struct sockaddr_in sck;
	int sock, one = 1;

	if ((ip = inet_addr(host)) < 0) {
		if (!(hp = gethostbyname(host))) {
			g_warning("Cannot resolve hostname\n");
			return -1;
		}
		memcpy(&ip, hp->h_addr, 4);
	}

	sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

	if (!sock) {
		g_warning("connect_to_server(): Cannot create socket\n");
		return -1;
	}

	if (async) {
		if (ioctl(sock, FIONBIO, &one) == -1) {
#ifdef DEBUG
			g_print("ioctl() failed.n");
#endif
			return -1;
		}
	}

	sck.sin_family = PF_INET;
	sck.sin_port = htons(port);
	sck.sin_addr.s_addr = ip;

	if (connect(sock, (struct sockaddr *) &sck, sizeof(sck)) < 0) {
		if (errno && (!async || errno != EINPROGRESS)) {
			g_warning("Cannot connect!\n");
			return -1;
		}
	}
#ifdef DEBUG
	g_print("connect_to_server(): Connected to: %s.%d\n", host, ntohs(sck.sin_port));
#endif
	return sock;
}
*/
