/* $Id: preferences.c,v 1.6 2002/11/27 16:52:02 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik. Released under terms of GPL license.
 *
 * Preferencje uytkownika
 */
#include "common.h"
#include <string.h>

#include "callbacks.h"
#include "gg-types.h"

#include "support.h"
//#include "dock.h"

#ifdef USE_GNOME
#include <gnome.h>
#endif

extern GGConfig config;

static
void on_konfiguracja_ok_clicked(GtkButton * button, GtkWidget * dialog)
{
	GtkWidget *textentry, *checkbox;
	gchar *tmptext;

	textentry = lookup_widget(dialog, "uin");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	config.uin = atoi(tmptext);

	textentry = lookup_widget(dialog, "password");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	if (config.password != NULL)
		g_free(config.password);
	config.password = g_strdup(tmptext);

	textentry = lookup_widget(dialog, "email");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	if (config.email != NULL)
		g_free(config.email);
	config.email = g_strdup(tmptext);

	checkbox = lookup_widget(dialog, "send_on_enter");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.send_on_enter = 1;
	} else {
		config.send_on_enter = 0;
	}
	checkbox = lookup_widget(dialog, "history");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.log = 1;
	} else {
		config.log = 0;
	}
#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP
	checkbox = lookup_widget(dialog, "main_on_start");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.main_on_start = 1;
	} else {
		config.main_on_start = 0;
	}
#endif
	checkbox = lookup_widget(dialog, "private");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.private = 1;
	} else {
		config.private = 0;
	}

	checkbox = lookup_widget(dialog, "save_config_on_exit");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.save_config_on_exit = 1;
	} else {
		config.save_config_on_exit = 0;
	}

	checkbox = lookup_widget(dialog, "save_contacts_on_exit");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.save_contacts_on_exit = 1;
	} else {
		config.save_contacts_on_exit = 0;
	}

#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP
	checkbox = lookup_widget(dialog, "popup_msg_windows");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.popup_msg_windows = 1;
	} else {
		config.popup_msg_windows = 0;
	}
#endif
	checkbox = lookup_widget(dialog, "proxy_switch");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.use_proxy = 1;
	} else {
		config.use_proxy = 0;
	}

	checkbox = lookup_widget(dialog, "connect_on_start");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.connect_on_start = 1;
	} else {
		config.connect_on_start = 0;
	}

	textentry = lookup_widget(dialog, "proxy_host");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	if (config.proxy_host != NULL)
		g_free(config.proxy_host);
	config.proxy_host = g_strdup(tmptext);

	textentry = lookup_widget(dialog, "proxy_port");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	config.proxy_port = atoi(tmptext);

	textentry = lookup_widget(dialog, "sms_send_app");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	if (config.sms_send_app != NULL)
		g_free(config.sms_send_app);
	config.sms_send_app = g_strdup(tmptext);

#if HAVE_ESD || HAVE_ARTS
	checkbox = lookup_widget(dialog, "user_sound");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.user_sound = 1;
	} else {
		config.user_sound = 0;
	}

	checkbox = lookup_widget(dialog, "login_sound");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.login_sound = 1;
	} else {
		config.login_sound = 0;
	}

	checkbox = lookup_widget(dialog, "msg_sound");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.msg_sound = 1;
	} else {
		config.msg_sound = 0;
	}

	textentry = lookup_widget(dialog, "login_sound_path");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	if (config.login_sound_path != NULL)
		g_free(config.login_sound_path);
	config.login_sound_path = g_strdup(tmptext);

	textentry = lookup_widget(dialog, "user_sound_path");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	if (config.user_sound_path != NULL)
		g_free(config.user_sound_path);
	config.user_sound_path = g_strdup(tmptext);

	textentry = lookup_widget(dialog, "msg_sound_path");
	g_return_if_fail(textentry != NULL);
	tmptext = gtk_entry_get_text(GTK_ENTRY(textentry));
	if (config.msg_sound_path != NULL)
		g_free(config.msg_sound_path);
	config.msg_sound_path = g_strdup(tmptext);

#endif /* HAVE_ESD */

	checkbox = lookup_widget(dialog, "away_msg_ask");
	g_return_if_fail(checkbox != NULL);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbox))
	    == TRUE) {
		config.away_msg_ask = 1;
	} else {
		config.away_msg_ask = 0;
	}


	write_config();

#ifndef USE_GNOME
	gtk_widget_destroy(dialog);
#endif
}
static
void on_get_away_message_ok_clicked (GtkWidget *widget, GtkWidget *dialog)
{
	GtkWidget *item;
	
	item = lookup_widget(dialog, "away_msg");
	g_return_if_fail(item != NULL);
	config.away_msg =
		gtk_editable_get_chars(GTK_EDITABLE (item), 0,
				       gtk_text_get_length (GTK_TEXT (item)));

	item = lookup_widget(dialog, "away_msg_send");
	g_return_if_fail(item != NULL);
	if(GTK_TOGGLE_BUTTON(item)->active)
		config.away_msg_send = 1;
	else
		config.away_msg_send = 0;

	gtk_widget_destroy(dialog);
}

void get_away_message (GtkWidget *widget, gpointer d)
{
	GtkWidget *window;
	GtkWidget *away_msg;
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *cb;
#ifndef USE_GNOME
	GtkWidget *button;
#endif

#ifdef USE_GNOME
	window = gnome_dialog_new(_("Przyczyna nieobecnoci"),
				  GNOME_STOCK_BUTTON_OK,
				  GNOME_STOCK_BUTTON_CANCEL, NULL);
	gnome_dialog_set_default(GNOME_DIALOG(window), 0);
	gnome_dialog_button_connect(GNOME_DIALOG(window), 0,
				    GTK_SIGNAL_FUNC
				    (on_get_away_message_ok_clicked),
				    window);
	gnome_dialog_button_connect(GNOME_DIALOG(window), 1,
				    GTK_SIGNAL_FUNC
				    (on_zamknij_anuluj_clicked),
				    window);
#else
	window = gtk_dialog_new();
	gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
	gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);

#endif /* USE_GNOME */

	frame = gtk_frame_new(_("Podaj przyczyn nieobecnoci"));
	gtk_widget_show(frame);
#ifdef USE_GNOME
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(window)->vbox),
			   frame, FALSE, FALSE, 0);
#else
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
			   frame, FALSE, FALSE, 0);
#endif /* USE_GNOME */

	table = gtk_table_new(1, 2, FALSE);
	gtk_widget_show(table);
	gtk_container_add(GTK_CONTAINER(frame), table);

	away_msg = gtk_text_new(NULL, NULL);
	gtk_widget_ref(away_msg);
	gtk_object_set_data_full(GTK_OBJECT(window), "away_msg", away_msg,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(away_msg);
	gtk_widget_set_usize(away_msg, 300, 150);
	gtk_text_set_line_wrap(GTK_TEXT(away_msg), TRUE);
	gtk_text_set_editable(GTK_TEXT(away_msg), TRUE);
	gtk_text_freeze(GTK_TEXT(away_msg));
	gtk_text_insert(GTK_TEXT(away_msg), NULL, NULL, NULL,
			config.away_msg, strlen(config.away_msg));
	gtk_text_thaw(GTK_TEXT(away_msg));
	gtk_table_attach(GTK_TABLE(table), away_msg, 0, 1, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 4);
	
	cb = gtk_check_button_new_with_label
		(_("Wysyaj ten komunikat w odpowiedzi"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(window), "away_msg_send", cb,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				    config.away_msg_send);

#ifndef USE_GNOME
	button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_get_away_message_ok_clicked),
			   window);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
			   button, TRUE, TRUE, 1);

	button = gtk_button_new_with_label(_("Anuluj"));
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   window);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
			   button, TRUE, TRUE, 1);

#endif /* USE_GNOME */

	gtk_widget_show(window);
}

static 
void sound_path_set(GtkWidget * button, gpointer user_data)
{
    GtkWidget *fileselection;
    GtkWidget *konfiguracja;
    gchar *filename;
    
    g_return_if_fail(user_data != NULL);
       
    fileselection = lookup_widget(button, "fileselection");
    filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fileselection));
    if (filename && *filename) {
	gtk_entry_set_text(GTK_ENTRY(user_data), filename);
    }
    gtk_widget_destroy(fileselection);
    
    konfiguracja = lookup_widget(user_data, "konfiguracja");
#ifdef USE_GNOME
    gnome_property_box_changed(GNOME_PROPERTY_BOX(konfiguracja));
#endif
}

static
void sound_path_select(GtkWidget * button, gpointer user_data)
{
    GtkWidget *fileselection;
    GtkWidget *ok_button;
    GtkWidget *cancel_button;
    
    fileselection = gtk_file_selection_new(_("Wybierz plik"));
    gtk_file_selection_complete(GTK_FILE_SELECTION(fileselection), "*.wav");
    gtk_object_set_data(GTK_OBJECT(fileselection), "fileselection", fileselection);
    gtk_container_set_border_width(GTK_CONTAINER(fileselection), 10);
    GTK_WINDOW(fileselection)->type = GTK_WINDOW_DIALOG;
    gtk_window_set_position(GTK_WINDOW(fileselection), GTK_WIN_POS_CENTER);
    gtk_window_set_modal(GTK_WINDOW(fileselection), TRUE);
    
    ok_button = GTK_FILE_SELECTION(fileselection)->ok_button;
    gtk_widget_show(ok_button);

    gtk_signal_connect(GTK_OBJECT(ok_button), "clicked",
			   GTK_SIGNAL_FUNC(sound_path_set), user_data);
    
    cancel_button = GTK_FILE_SELECTION(fileselection)->cancel_button;
    gtk_widget_show(cancel_button);

    gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked), fileselection);
    gtk_widget_show(fileselection);
    
}

static
void toggle_proxy(GtkWidget * button, GtkWidget * konfiguracja)
{
	GtkWidget *proxy_host;
	GtkWidget *proxy_port;
	GtkWidget *proxy_host_label;
	GtkWidget *proxy_port_label;

	proxy_host_label = lookup_widget(konfiguracja, "proxy_host_label");
	gtk_widget_set_sensitive(proxy_host_label,
				 GTK_TOGGLE_BUTTON(button)->active);
	proxy_port_label = lookup_widget(konfiguracja, "proxy_port_label");
	gtk_widget_set_sensitive(proxy_port_label,
				 GTK_TOGGLE_BUTTON(button)->active);
	proxy_host = lookup_widget(konfiguracja, "proxy_host");
	gtk_widget_set_sensitive(proxy_host,
				 GTK_TOGGLE_BUTTON(button)->active);
	proxy_port = lookup_widget(konfiguracja, "proxy_port");
	gtk_widget_set_sensitive(proxy_port,
				 GTK_TOGGLE_BUTTON(button)->active);
#ifdef USE_GNOME
	gnome_property_box_changed(GNOME_PROPERTY_BOX(konfiguracja));
#endif
}

#ifdef USE_GNOME
static
void propbox_changed(GtkWidget * widget, GtkWidget * box)
{
	gnome_property_box_changed(GNOME_PROPERTY_BOX(box));
}

static
void apply_changes(GtkWidget * widget, gint page, gpointer d)
{
	if (page == -1)
		on_konfiguracja_ok_clicked(NULL, widget);
}

GtkWidget *create_konfiguracja(void)
{
	GtkWidget *konfiguracja;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *label;
	GtkTooltips *tooltips;
	GtkWidget *cb;
	GtkWidget *button;

	GtkWidget *uin;
	GtkWidget *password;
	GtkWidget *email;
	GtkWidget *entry;
	GSList *sms_group = NULL;
	GtkWidget *sms_prog;
	GtkWidget *sms_send_app;
	GtkWidget *sms_express;
	GtkWidget *proxy_switch;
	GtkWidget *proxy_host;
	GtkWidget *proxy_port;
	GtkObject *reconnect_adj;
	GtkWidget *reconnect;

	tooltips = gtk_tooltips_new();

	konfiguracja = gnome_property_box_new();
	gtk_object_set_data(GTK_OBJECT(konfiguracja), "konfiguracja",
			    konfiguracja);
	gtk_window_set_title(GTK_WINDOW(konfiguracja),
			     _("Konfiguracja GNU Gadu"));
	gtk_signal_connect(GTK_OBJECT(konfiguracja), "apply",
			   GTK_SIGNAL_FUNC(apply_changes), NULL);

	/* podstawowe */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	label = gtk_label_new(_("Podstawowe"));
	gtk_widget_show(label);
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(konfiguracja),
				       vbox, label);

	frame = gtk_frame_new(_("Ustawienia uytkownika"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	table = gtk_table_new(2, 3, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	label = gtk_label_new(_("Twj numer:"));
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	uin = gtk_entry_new();
	gtk_widget_ref(uin);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "uin", uin,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(uin);
	gtk_table_attach(GTK_TABLE(table), uin, 1, 2, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(uin, 158, -2);
	gtk_tooltips_set_tip(tooltips, uin, _("Tu wpisz swj numer GG"),
			     NULL);
	gtk_signal_connect(GTK_OBJECT(uin), "changed",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	label = gtk_label_new(_("Haso:"));
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	password = gtk_entry_new();
	gtk_widget_ref(password);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "password",
				 password,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(password);
	gtk_table_attach(GTK_TABLE(table), password, 1, 2, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(password, 158, -2);
	gtk_tooltips_set_tip(tooltips, password,
			     _("Tu wpisz haso na serwer GG"), NULL);
	gtk_entry_set_visibility(GTK_ENTRY(password), FALSE);
	gtk_signal_connect(GTK_OBJECT(password), "changed",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	label = gtk_label_new(_("Adres e-mail:"));
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	email = gtk_entry_new();
	gtk_widget_ref(email);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "email",
				 email,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(email);
	gtk_table_attach(GTK_TABLE(table), email, 1, 2, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(email, 158, -2);
	gtk_tooltips_set_tip(tooltips, email,
			     _
			     ("Tu wpisz swj adres poczty elektronicznej"),
			     NULL);
	gtk_signal_connect(GTK_OBJECT(email), "changed",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	frame = gtk_frame_new(_("Zachowanie"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	table = gtk_table_new(1, 7, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	cb = gtk_check_button_new_with_label
	    (_("Wysyaj wiadomo po naciniciu " "klawisza 'Enter'."));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "send_on_enter",
				 cb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.send_on_enter);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	cb = gtk_check_button_new_with_label
	    (_("Zapisuj wszystkie rozmowy do historii."));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "history",
				 cb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.log);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	cb = gtk_check_button_new_with_label
	    (_("Uywaj trybu 'tylko dla znajomych'"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "private",
				 cb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.private);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP
	cb = gtk_check_button_new_with_label
	    (_("Wywietl gwne okno po uruchomieniu."));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "main_on_start",
				 cb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 3, 4,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.main_on_start);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);
#endif

	cb = gtk_check_button_new_with_label
	    (_("Zapisz konfiguracj przy wyjciu z programu."));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "save_config_on_exit",
				 cb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 4, 5,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.save_config_on_exit);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	cb = gtk_check_button_new_with_label
	    (_("Zapisz kontakty przy wyjciu z programu."));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "save_contacts_on_exit",
				 cb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 5, 6,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.save_contacts_on_exit);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP
	cb = gtk_check_button_new_with_label
	    (_("Okienka z wiadomociami wyskakuj na ekran"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "popup_msg_windows",
				 cb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 7, 8,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.popup_msg_windows);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);
#endif
	/* poczenie */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	label = gtk_label_new(_("Poczenie"));
	gtk_widget_show(label);
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(konfiguracja),
				       vbox, label);

	frame = gtk_frame_new(_("Ustawienia poczenia:"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	table = gtk_table_new(1, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	cb = gtk_check_button_new_with_label
				(_("Pocz do serwera po uruchomieniu programu."));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "connect_on_start", cb,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.connect_on_start);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_table_attach(GTK_TABLE(table), hbox, 0, 1, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);

	label = gtk_label_new(_("Ilo prb poczenia z serwerem: "));
	gtk_widget_show(label);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

	reconnect_adj = gtk_adjustment_new(config.auto_reconnect, 0, 100, 1, 10, 1);

	reconnect = gtk_spin_button_new(GTK_ADJUSTMENT(reconnect_adj), 1, 0);
	gtk_widget_ref(reconnect);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "reconnect",
				 reconnect,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(reconnect);
	gtk_box_pack_start(GTK_BOX(hbox), reconnect, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(reconnect), "changed",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	frame = gtk_frame_new(_("Ustawienia HTTP Proxy"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	table = gtk_table_new(2, 3, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	proxy_switch = gtk_check_button_new_with_label
	    (_("Do pocze HTTP wykorzystuj serwer Proxy"));
	gtk_widget_ref(proxy_switch);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "proxy_switch",
				 proxy_switch,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(proxy_switch);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(proxy_switch),
				     config.use_proxy);
	gtk_table_attach(GTK_TABLE(table), proxy_switch, 0, 2, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_signal_connect(GTK_OBJECT(proxy_switch), "toggled",
			   GTK_SIGNAL_FUNC(toggle_proxy), konfiguracja);

	label = gtk_label_new(_("Adres serwera proxy:"));
	gtk_widget_ref(label);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "proxy_host_label", label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	proxy_host = gtk_entry_new();
	gtk_widget_ref(proxy_host);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "proxy_host",
				 proxy_host,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(proxy_host);
	gtk_table_attach(GTK_TABLE(table), proxy_host, 1, 2, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(proxy_host, 158, -2);
	gtk_tooltips_set_tip(tooltips, proxy_host,
			     _
			     ("Adres serwer Proxy np. proxy.twojadomena.pl."),
			     NULL);
	gtk_signal_connect(GTK_OBJECT(proxy_host), "changed",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	label = gtk_label_new(_("Port:"));
	gtk_widget_ref(label);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "proxy_port_label", label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	proxy_port = gtk_entry_new_with_max_length(5);
	gtk_widget_ref(proxy_port);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "proxy_port",
				 proxy_port,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(proxy_port);
	gtk_table_attach(GTK_TABLE(table), proxy_port, 1, 2, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(proxy_port, 158, -2);
	gtk_tooltips_set_tip(tooltips, proxy_port,
			     _("Numer portu serwera proxy np. 8080"),
			     NULL);
	gtk_signal_connect(GTK_OBJECT(proxy_port), "changed",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	/* we need to call toggle_proxy() yet before the dialog is shown
	 * to set up widgets' sensitivity
	 */
	gtk_signal_emit_by_name(GTK_OBJECT(proxy_switch), "toggled");

	/* inne */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	label = gtk_label_new(_("Inne"));
	gtk_widget_show(label);
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(konfiguracja),
				       vbox, label);

	frame = gtk_frame_new(_("SMS"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	table = gtk_table_new(2, 3, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	sms_prog = gtk_radio_button_new_with_label(sms_group,
						   _
						   ("Uywaj zewntrznego programu "
						    "do wysyania sms'w."));
	sms_group = gtk_radio_button_group(GTK_RADIO_BUTTON(sms_prog));
	gtk_widget_ref(sms_prog);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "sms_prog",
				 sms_prog,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(sms_prog);
	gtk_table_attach(GTK_TABLE(table), sms_prog, 0, 2, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_signal_connect(GTK_OBJECT(sms_prog), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	label = gtk_label_new(_("cieka do programu:"));
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	sms_send_app = gtk_entry_new();
	gtk_widget_ref(sms_send_app);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "sms_send_app",
				 sms_send_app,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(sms_send_app);
	gtk_table_attach(GTK_TABLE(table), sms_send_app, 1, 2, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_signal_connect(GTK_OBJECT(sms_send_app), "changed",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

	sms_express = gtk_radio_button_new_with_label(sms_group,
						      _
						      ("Wykorzystaj system SMS-Express (G*du-G*du)."));
	sms_group = gtk_radio_button_group(GTK_RADIO_BUTTON(sms_express));
	gtk_widget_ref(sms_express);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "sms_express",
				 sms_express,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(sms_express);
	gtk_table_attach(GTK_TABLE(table), sms_express, 0, 2, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_widget_set_sensitive(sms_express, FALSE);
	gtk_signal_connect(GTK_OBJECT(sms_express), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);


	frame = gtk_frame_new(_("Dwiki"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
#if !(HAVE_ESD || HAVE_ARTS) 
	gtk_widget_set_sensitive(frame, FALSE);
#endif

	table = gtk_table_new(4, 4, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);
	
	cb = gtk_check_button_new_with_label(_("Zmiana statusu uytkownika"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "user_sound", cb,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);

	gtk_table_attach(GTK_TABLE(table), cb, 0, 2, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);

#if (HAVE_ESD || HAVE_ARTS) 
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.user_sound);
#endif
	
	cb = gtk_check_button_new_with_label(_("Logowanie"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "login_sound", cb,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 2, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 0);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);
#if (HAVE_ESD || HAVE_ARTS) 
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.login_sound);
#endif	

	cb = gtk_check_button_new_with_label(_("Nadejcie wiadomoci"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "msg_sound", cb,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 2, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);
#if (HAVE_ESD || HAVE_ARTS) 
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.msg_sound);
#endif
	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "user_sound_path",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_table_attach(GTK_TABLE(table), entry, 2, 3, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(entry, 158, -2);

	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "login_sound_path",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_table_attach(GTK_TABLE(table), entry, 2, 3, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(entry, 158, -2);

	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "msg_sound_path",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_table_attach(GTK_TABLE(table), entry, 2, 3, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(entry, 158, -2);

	cb = gtk_button_new_with_label(_("..."));
	gtk_signal_connect(GTK_OBJECT(cb), "clicked",
			   GTK_SIGNAL_FUNC(sound_path_select), lookup_widget(konfiguracja, "user_sound_path"));

	gtk_table_attach(GTK_TABLE(table), cb, 3, 4, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_widget_show(cb);
	
	cb = gtk_button_new_with_label(_("..."));
	gtk_signal_connect(GTK_OBJECT(cb), "clicked",
			   GTK_SIGNAL_FUNC(sound_path_select), lookup_widget(konfiguracja, "login_sound_path"));

	gtk_table_attach(GTK_TABLE(table), cb, 3, 4, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_widget_show(cb);
	
	cb = gtk_button_new_with_label(_("..."));
	gtk_signal_connect(GTK_OBJECT(cb), "clicked",
			   GTK_SIGNAL_FUNC(sound_path_select), lookup_widget(konfiguracja, "msg_sound_path"));
	gtk_table_attach(GTK_TABLE(table), cb, 3, 4, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_widget_show(cb);

	frame = gtk_frame_new(_("Zaraz wracam"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	table = gtk_table_new(2, 1, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	cb = gtk_check_button_new_with_label
		(_("Zawsze wywietlaj pytanie o przyczyn"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "away_msg_ask", cb,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_signal_connect(GTK_OBJECT(cb), "toggled",
			   GTK_SIGNAL_FUNC(propbox_changed), konfiguracja);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.away_msg_ask);
	
	button = gtk_button_new_with_label(_("Ustawienia..."));
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(get_away_message), NULL);
	gtk_widget_show(button);
	gtk_table_attach(GTK_TABLE(table), button, 1, 2, 0, 1,
			 GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 4, 1);

	return konfiguracja;
}
#else
GtkWidget *create_konfiguracja(void)
{
	GtkWidget *konfiguracja;
	GtkWidget *konfiguracja_box;
	GtkWidget *vbox;
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *uin;
	GtkWidget *password;
	GtkWidget *email;
	GtkWidget *label;
	GtkWidget *send_on_enter;
	GtkWidget *history;
	GtkWidget *private;
#ifdef USE_APPLET
	GtkWidget *main_on_start;
#endif
	GtkWidget *reconnect_frame;
	GtkWidget *connect_on_start;
	GtkWidget *reconnect_hbox;
	GtkWidget *reconnect_label;
	GtkObject *reconnect_adj;
	GtkWidget *reconnect;
	GtkWidget *proxy_switch;
	GtkWidget *proxy_host;
	GtkWidget *proxy_port;
	GtkWidget *hbuttonbox;
	GtkWidget *ok;
	GtkWidget *zamknij;
	GtkTooltips *tooltips;
	GtkWidget *main_vbox;
	GSList *sms_group = NULL;
	GtkWidget *sms_prog;
	GtkWidget *sms_send_app;
	GtkWidget *sms_express;
	GtkWidget *cb;
	GtkWidget *button;
	GtkWidget *entry;
	
	tooltips = gtk_tooltips_new();

	konfiguracja = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data(GTK_OBJECT(konfiguracja), "konfiguracja",
			    konfiguracja);
	gtk_widget_set_usize(konfiguracja, 465, 0);
	gtk_window_set_policy(GTK_WINDOW(konfiguracja), FALSE, FALSE, FALSE);
	gtk_window_position(GTK_WINDOW(konfiguracja), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(konfiguracja),
			     _("Konfiguracja GNU Gadu"));

	main_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(main_vbox);
	gtk_widget_show(main_vbox);
	gtk_container_add(GTK_CONTAINER(konfiguracja), main_vbox);

	konfiguracja_box = gtk_notebook_new();
	gtk_widget_ref(konfiguracja_box);
	gtk_widget_show(konfiguracja_box);
	gtk_box_pack_start(GTK_BOX(main_vbox), konfiguracja_box, TRUE,
			   TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(konfiguracja_box),
				       10);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(vbox);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(konfiguracja_box), vbox);

/* uytkownik */
	frame = gtk_frame_new(_("Ustawienia uytkownika"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	table = gtk_table_new(2, 3, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	label = gtk_label_new(_("Twj numer:"));
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	uin = gtk_entry_new();
	gtk_widget_ref(uin);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "uin", uin,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(uin);
	gtk_table_attach(GTK_TABLE(table), uin, 1, 2, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(uin, 158, -2);
	gtk_tooltips_set_tip(tooltips, uin, _("Tu wpisz swj numer GG"),
			     NULL);

	label = gtk_label_new(_("Haso:"));
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	password = gtk_entry_new();
	gtk_widget_ref(password);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "password",
				 password,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(password);
	gtk_table_attach(GTK_TABLE(table), password, 1, 2, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(password, 158, -2);
	gtk_tooltips_set_tip(tooltips, password,
			     _("Tu wpisz haso na serwer GG"), NULL);
	gtk_entry_set_visibility(GTK_ENTRY(password), FALSE);

	label = gtk_label_new(_("Adres e-mail:"));
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	email = gtk_entry_new();
	gtk_widget_ref(email);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "email",
				 email,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(email);
	gtk_table_attach(GTK_TABLE(table), email, 1, 2, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(email, 158, -2);
	gtk_tooltips_set_tip(tooltips, email,
			     _
			     ("Tu wpisz swj adres poczty elektronicznej"),
			     NULL);

/* zachowanie */

	frame = gtk_frame_new(_("Zachowanie"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	table = gtk_table_new(1, 7, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	send_on_enter = gtk_check_button_new_with_label
	    (_("Wysyaj wiadomo po naciniciu " "klawisza 'Enter'."));
	gtk_widget_ref(send_on_enter);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "send_on_enter",
				 send_on_enter,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(send_on_enter);
	gtk_table_attach(GTK_TABLE(table), send_on_enter, 0, 1, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(send_on_enter),
				     config.send_on_enter);
	history = gtk_check_button_new_with_label
	    (_("Zapisuj wszystkie rozmowy do historii."));
	gtk_widget_ref(history);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "history",
				 history,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(history);
	gtk_table_attach(GTK_TABLE(table), history, 0, 1, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(history),
				     config.log);
	private = gtk_check_button_new_with_label
	    (_("Uywaj trybu 'tylko dla znajomych'"));
	gtk_widget_ref(private);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "private",
				 private,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(private);
	gtk_table_attach(GTK_TABLE(table), private, 0, 1, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(private),
				     config.private);

#if (USE_DOCKLET || USE_DOCKAPP)
	cb = gtk_check_button_new_with_label
	    (_("Wywietl gwne okno po uruchomieniu."));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "main_on_start",
				 cb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 3, 4,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.main_on_start);
#endif

	cb = gtk_check_button_new_with_label
	    (_("Zapisz konfiguracj przy wyjciu z programu."));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "save_config_on_exit",
				 cb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 4, 5,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.save_config_on_exit);

	cb = gtk_check_button_new_with_label
	    (_("Zapisz kontakty przy wyjciu z programu."));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "save_contacts_on_exit",
				 cb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 5, 6,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.save_contacts_on_exit);

#if USE_APPLET || USE_DOCKLET || USE_DOCKAPP
	cb = gtk_check_button_new_with_label
	    (_("Okienka z wiadomociami wyskakuj na ekran"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "popup_msg_windows",
				 cb, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 7, 8,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.popup_msg_windows);
#endif
	label = gtk_label_new(_("Uytkownik"));
	gtk_widget_ref(label);
	gtk_widget_show(label);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(konfiguracja_box),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK
							     (konfiguracja_box),
							     0), label);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(vbox);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(konfiguracja_box), vbox);

	reconnect_frame = gtk_frame_new(_("Ustawienia poczenia:"));
	gtk_widget_ref(reconnect_frame);
	gtk_widget_show(reconnect_frame);
	gtk_box_pack_start(GTK_BOX(vbox), reconnect_frame, FALSE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(reconnect_frame), 10);

	table = gtk_table_new(2, 1, FALSE);
	gtk_widget_ref(table);
	gtk_widget_show(table);
	gtk_container_add(GTK_CONTAINER(reconnect_frame), table);
	gtk_container_set_border_width(GTK_CONTAINER(table), 5);
	gtk_table_set_row_spacings(GTK_TABLE(table), 5);
	gtk_table_set_col_spacings(GTK_TABLE(table), 5);

	connect_on_start =
	    gtk_check_button_new_with_label(_
					    ("Pocz do serwera po uruchomieniu programu."));
	gtk_widget_ref(connect_on_start);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "connect_on_start", connect_on_start,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(connect_on_start);
	gtk_table_attach(GTK_TABLE(table), connect_on_start, 0, 1, 0, 1,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(connect_on_start),
				     config.connect_on_start);

	reconnect_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_ref(reconnect_hbox);
	gtk_widget_show(reconnect_hbox);
	gtk_table_attach(GTK_TABLE(table), reconnect_hbox, 0, 1, 1, 2,
			 (GtkAttachOptions) (GTK_FILL),
			 (GtkAttachOptions) (GTK_FILL), 0, 0);

	reconnect_label =
	    gtk_label_new(_("Ilo prb poczenia z serwerem: "));
	gtk_widget_ref(reconnect_label);
	gtk_widget_show(reconnect_label);
	gtk_box_pack_start(GTK_BOX(reconnect_hbox), reconnect_label, FALSE,
			   FALSE, 0);

	reconnect_adj = gtk_adjustment_new(config.auto_reconnect, 0, 100, 1, 1, 1);
	reconnect =
	    gtk_spin_button_new(GTK_ADJUSTMENT(reconnect_adj), 1, 0);
	gtk_widget_ref(reconnect);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "reconnect",
				 reconnect,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(reconnect);
	gtk_box_pack_start(GTK_BOX(reconnect_hbox), reconnect, TRUE, TRUE,
			   0);

	frame = gtk_frame_new(_("Ustawienia HTTP Proxy"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	table = gtk_table_new(2, 3, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	proxy_switch = gtk_check_button_new_with_label
	    (_("Do pocze HTTP wykorzystuj serwer Proxy"));
	gtk_widget_ref(proxy_switch);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "proxy_switch",
				 proxy_switch,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(proxy_switch);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(proxy_switch),
				     config.use_proxy);
	gtk_table_attach(GTK_TABLE(table), proxy_switch, 0, 2, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_signal_connect(GTK_OBJECT(proxy_switch), "toggled",
			   GTK_SIGNAL_FUNC(toggle_proxy), konfiguracja);

	label = gtk_label_new(_("Adres serwera proxy:"));
	gtk_widget_ref(label);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "proxy_host_label", label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	proxy_host = gtk_entry_new();
	gtk_widget_ref(proxy_host);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "proxy_host",
				 proxy_host,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(proxy_host);
	gtk_table_attach(GTK_TABLE(table), proxy_host, 1, 2, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(proxy_host, 158, -2);
	gtk_tooltips_set_tip(tooltips, proxy_host,
			     _
			     ("Adres serwer Proxy np. proxy.twojadomena.pl."),
			     NULL);

	label = gtk_label_new(_("Port:"));
	gtk_widget_ref(label);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "proxy_port_label", label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	proxy_port = gtk_entry_new_with_max_length(5);
	gtk_widget_ref(proxy_port);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "proxy_port",
				 proxy_port,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(proxy_port);
	gtk_table_attach(GTK_TABLE(table), proxy_port, 1, 2, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(proxy_port, 158, -2);
	gtk_tooltips_set_tip(tooltips, proxy_port,
			     _("Numer portu serwera proxy np. 8080"),
			     NULL);

	/* we need to call toggle_proxy() yet before the dialog is shown
	 * to set up widgets' sensitivity
	 */
	gtk_signal_emit_by_name(GTK_OBJECT(proxy_switch), "toggled");


	label = gtk_label_new(_("Poczenie"));
	gtk_widget_ref(label);
	gtk_widget_show(label);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(konfiguracja_box),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK
							     (konfiguracja_box),
							     1), label);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(vbox);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(konfiguracja_box), vbox);

	frame = gtk_frame_new(_("SMS"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	table = gtk_table_new(2, 3, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	sms_prog = gtk_radio_button_new_with_label(sms_group,
						   _
						   ("Uywaj zewntrznego programu "
						    "do wysyania sms'w."));
	sms_group = gtk_radio_button_group(GTK_RADIO_BUTTON(sms_prog));
	gtk_widget_ref(sms_prog);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "sms_prog",
				 sms_prog,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(sms_prog);
	gtk_table_attach(GTK_TABLE(table), sms_prog, 0, 2, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);

	label = gtk_label_new(_("cieka do programu:"));
	gtk_widget_show(label);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);

	sms_send_app = gtk_entry_new();
	gtk_widget_ref(sms_send_app);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "sms_send_app",
				 sms_send_app,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(sms_send_app);
	gtk_table_attach(GTK_TABLE(table), sms_send_app, 1, 2, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 1);

	sms_express = gtk_radio_button_new_with_label(sms_group,
						      _
						      ("Wykorzystaj system SMS-Express (G*du-G*du)."));
	sms_group = gtk_radio_button_group(GTK_RADIO_BUTTON(sms_express));
	gtk_widget_ref(sms_express);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "sms_express",
				 sms_express,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(sms_express);
	gtk_table_attach(GTK_TABLE(table), sms_express, 0, 2, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_widget_set_sensitive(sms_express, FALSE);

	frame = gtk_frame_new(_("Dwiki"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
#if !(HAVE_ESD || HAVE_ARTS)
	gtk_widget_set_sensitive(frame, FALSE);
#endif

	table = gtk_table_new(2, 3, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);
	
	cb = gtk_check_button_new_with_label(_("Zmiana statusu uytkownika"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "user_sound", cb,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 2, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
#if HAVE_ESD || HAVE_ARTS
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.user_sound);
#endif

	cb = gtk_check_button_new_with_label(_("Logowanie"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "login_sound", cb,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 2, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 0);
#if HAVE_ESD || HAVE_ARTS
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.login_sound);
#endif	

	cb = gtk_check_button_new_with_label(_("Nadejcie wiadomoci"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "msg_sound", cb,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 2, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 1);
#if HAVE_ESD || HAVE_ARTS
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.msg_sound);
#endif
	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "user_sound_path",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_table_attach(GTK_TABLE(table), entry, 2, 3, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(entry, 158, -2);

	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "login_sound_path",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_table_attach(GTK_TABLE(table), entry, 2, 3, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(entry, 158, -2);

	entry = gtk_entry_new();
	gtk_widget_ref(entry);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja), "msg_sound_path",
				 entry,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry);
	gtk_table_attach(GTK_TABLE(table), entry, 2, 3, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 2);
	gtk_widget_set_usize(entry, 158, -2);

	cb = gtk_button_new_with_label(_("..."));
	gtk_signal_connect(GTK_OBJECT(cb), "clicked",
			   GTK_SIGNAL_FUNC(sound_path_select), lookup_widget(konfiguracja, "user_sound_path"));

	gtk_table_attach(GTK_TABLE(table), cb, 3, 4, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_widget_show(cb);
	
	cb = gtk_button_new_with_label(_("..."));
	gtk_signal_connect(GTK_OBJECT(cb), "clicked",
			   GTK_SIGNAL_FUNC(sound_path_select), lookup_widget(konfiguracja, "login_sound_path"));

	gtk_table_attach(GTK_TABLE(table), cb, 3, 4, 1, 2,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_widget_show(cb);
	
	cb = gtk_button_new_with_label(_("..."));
	gtk_signal_connect(GTK_OBJECT(cb), "clicked",
			   GTK_SIGNAL_FUNC(sound_path_select), lookup_widget(konfiguracja, "msg_sound_path"));
	gtk_table_attach(GTK_TABLE(table), cb, 3, 4, 2, 3,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_widget_show(cb);

	frame = gtk_frame_new(_("Zaraz wracam"));
	gtk_widget_show(frame);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 10);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

	table = gtk_table_new(2, 1, FALSE);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	cb = gtk_check_button_new_with_label
		(_("Zawsze wywietlaj pytanie o przyczyn"));
	gtk_widget_ref(cb);
	gtk_object_set_data_full(GTK_OBJECT(konfiguracja),
				 "away_msg_ask", cb,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cb);
	gtk_table_attach(GTK_TABLE(table), cb, 0, 1, 0, 1,
			 GTK_FILL, GTK_FILL, 4, 1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb),
				     config.away_msg_ask);
	
	button = gtk_button_new_with_label(_("Ustawienia..."));
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(get_away_message), NULL);
	gtk_widget_show(button);
	gtk_table_attach(GTK_TABLE(table), button, 1, 2, 0, 1,
			 GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 4, 1);

	label = gtk_label_new(_("Inne"));
	gtk_widget_ref(label);
	gtk_widget_show(label);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(konfiguracja_box),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK
							     (konfiguracja_box),
							     2), label);

	hbuttonbox = gtk_hbutton_box_new();
	gtk_widget_ref(hbuttonbox);
	gtk_widget_show(hbuttonbox);
	gtk_box_pack_start(GTK_BOX(main_vbox), hbuttonbox, FALSE, TRUE, 0);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox),
				  GTK_BUTTONBOX_EDGE);

	ok = gtk_button_new_with_label(_("OK"));
	gtk_widget_ref(ok);
	gtk_widget_show(ok);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), ok);
	GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);

	zamknij = gtk_button_new_with_label(_("Zamknij"));
	gtk_widget_ref(zamknij);
	gtk_widget_show(zamknij);
	gtk_container_add(GTK_CONTAINER(hbuttonbox), zamknij);

	GTK_WIDGET_SET_FLAGS(zamknij, GTK_CAN_DEFAULT);
	
	gtk_signal_connect(GTK_OBJECT(ok), "clicked",
			   GTK_SIGNAL_FUNC(on_konfiguracja_ok_clicked),
			   konfiguracja);
	gtk_signal_connect(GTK_OBJECT(zamknij), "clicked",
			   GTK_SIGNAL_FUNC(on_zamknij_anuluj_clicked),
			   konfiguracja);
	return konfiguracja;
}
#endif				/* USE_GNOME */

