/* $Id: sound.c,v 1.2 2002/10/30 17:02:52 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik. Released under terms of GPL license.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_ESD
#include <esd.h>
#endif

#ifdef HAVE_ARTS
#include "sound-arts.h"
#endif

#if HAVE_ESD || HAVE_ARTS
#include <unistd.h>
#include <glib.h>

#include "support.h"
#include "sound.h"
#include "gg-types.h"

extern GGConfig config;

void gg_play_sound(guint id)
{
	gchar *filename = NULL;
	switch (id) {
	case GG_SOUND_LOGIN_OK:
		if (config.login_sound_path) {
		    filename = config.login_sound_path;
		} else {
		    filename = GG_SOUND_LOGIN_OK_FILENAME;
		}
		break;
	case GG_SOUND_MSG:
		if (config.msg_sound_path) {
		    filename = config.msg_sound_path;
		} else {
		    filename = GG_SOUND_MSG_FILENAME;
		}
		break;
	case GG_SOUND_NOTIFY:
		if (config.user_sound_path) {
		    filename = config.user_sound_path;
		} else {
		    filename = GG_SOUND_NOTIFY_FILENAME;
		}
		break;

	default:
		filename = NULL;
		break;
	}

	if (filename != NULL) {
		gint pid;

		if ((pid = fork()) == -1)
			return;

		if (!pid) {
#ifdef HAVE_ESD
			esd_play_file(g_get_prgname(),
				      get_sound_path(filename), 1);
#elif HAVE_ARTS
			arts_play_file(get_sound_path(filename));
#endif
			_exit(0);
		}
	}
}

#endif
