/* $Id: support.h,v 1.10 2002/10/30 21:24:03 thrull Exp $ */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#ifndef _GTK_H
#include <gtk/gtk.h>
#endif
#include <unistd.h>
#include <time.h>
/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif


/*
 * Public Functions.
 */

/*
 * This function returns a widget in a component created by Glade.
 * Call it with the toplevel widget in the component (i.e. a window/dialog),
 * or alternatively any widget in the component, and the name of the widget
 * you want returned.
 */
GtkWidget *lookup_widget(GtkWidget * widget, const gchar * widget_name);

/* get_widget() is deprecated. Use lookup_widget instead. */
#define get_widget lookup_widget

/* Use this function to set the directory containing installed pixmaps. */
void add_pixmap_directory(const gchar * directory);
void add_sound_directory(const gchar * directory);

/*
 * Private Functions.
 */

/* This is used to create the pixmaps in the interface. */
GtkWidget *create_pixmap(GtkWidget * widget, const gchar * filename);

gchar *get_pixmap_path(gchar * filename);

#define GPP(x) get_pixmap_path(x)

gchar *get_sound_path(gchar * filename);

void window_set_icon(GtkWidget *window, const char **icon, const gchar *file);

/* Other support functions */

#define gg_error show_error_dialog

void show_message_dialog(gchar * message);

void show_error_dialog(gchar * message);

GtkWidget *create_dialog(void);

gchar *get_timestamp(time_t t);

gchar *get_full_timestamp(time_t t);

void cp_to_iso(unsigned char *buf);

void iso_to_cp(unsigned char *buf);

void remove_cr(gchar *buf);

gchar *insert_cr(gchar *buf);

gint send_sms_prog(gchar *progname, gchar *mobile, gchar *text);

gchar *gg_urlencode(gchar * str);

char *base64_decode(char *);
char *base64_encode(char *);

void change_pixmap(GtkWidget *pixmap_widget, GdkPixmap *pixmap, GdkBitmap *mask);
