/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "ggobi-data.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 93 "data.gob"

#include "vars.h"
#include "externs.h"

#line 29 "ggobi-data.c"
/* self casting macros */
#define SELF(x) GGOBI_DATA(x)
#define SELF_CONST(x) GGOBI_DATA_CONST(x)
#define IS_SELF(x) GGOBI_IS_DATA(x)
#define TYPE_SELF GGOBI_TYPE_DATA
#define SELF_CLASS(x) GGOBI_DATA_CLASS(x)

#define SELF_GET_CLASS(x) GGOBI_DATA_GET_CLASS(x)

/* self typedefs */
typedef GGobiData Self;
typedef GGobiDataClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void ggobi_data_class_init (GGobiDataClass * c) G_GNUC_UNUSED;
static void ggobi_data_rows_in_plot_changed (GGobiData * self, int arg1, int arg2, ggobid * arg3) G_GNUC_UNUSED;
static void ggobi_data_init (GGobiData * self) G_GNUC_UNUSED;
static GObject * ___8_ggobi_data_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__rows_in_plot_changed(object,func,data)	ggobi_data_connect__rows_in_plot_changed((object),(func),(data))
#define self_connect_after__rows_in_plot_changed(object,func,data)	ggobi_data_connect_after__rows_in_plot_changed((object),(func),(data))
#define self_connect_data__rows_in_plot_changed(object,func,data,destroy_data,flags)	ggobi_data_connect_data__rows_in_plot_changed((object),(func),(data),(destroy_data),(flags))
#define self_connect__col_name_changed(object,func,data)	ggobi_data_connect__col_name_changed((object),(func),(data))
#define self_connect_after__col_name_changed(object,func,data)	ggobi_data_connect_after__col_name_changed((object),(func),(data))
#define self_connect_data__col_name_changed(object,func,data,destroy_data,flags)	ggobi_data_connect_data__col_name_changed((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (GGobiData *, gint , gint , gpointer , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 4);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((GGobiData *)data1,
		(gint ) g_value_get_int (param_values + 1),
		(gint ) g_value_get_int (param_values + 2),
		(gpointer ) g_value_get_pointer (param_values + 3),
		data2);
}


typedef void  (*___Sig2) (GGobiData *, gint , gpointer);

static void
___marshal_Sig2 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig2 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig2) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((GGobiData *)data1,
		(gint ) g_value_get_int (param_values + 1),
		data2);
}


enum {
	ROWS_IN_PLOT_CHANGED_SIGNAL,
	COL_NAME_CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_NROWS,
	PROP_NCOLS
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_nrows ggobi_data_get_nrows
#define self_set_nrows ggobi_data_set_nrows
#define self_get_ncols ggobi_data_get_ncols
#define self_set_ncols ggobi_data_set_ncols
#define self_rows_in_plot_changed ggobi_data_rows_in_plot_changed
#define self_col_name_changed ggobi_data_col_name_changed
#define self_new ggobi_data_new
#define self_get_name ggobi_data_get_name
#define self_set_name ggobi_data_set_name
#define self_get_n_cols ggobi_data_get_n_cols
#define self_get_n_rows ggobi_data_get_n_rows
#define self_get_col_name ggobi_data_get_col_name
#define self_set_col_name ggobi_data_set_col_name
#define self_get_transformed_col_name ggobi_data_get_transformed_col_name
#define self_set_transformed_col_name ggobi_data_set_transformed_col_name
#define self_set_missing ggobi_data_set_missing
#define self_is_missing ggobi_data_is_missing
#define self_has_missings ggobi_data_has_missings
#define self_get_col_n_missing ggobi_data_get_col_n_missing
#define self_set_raw_values ggobi_data_set_raw_values
#define self_set_raw_value ggobi_data_set_raw_value
#define self_get_string_value ggobi_data_get_string_value
#define self_has_edges ggobi_data_has_edges
#define self_has_variables ggobi_data_has_variables
GType
ggobi_data_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GGobiDataClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) ggobi_data_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GGobiData),
			0 /* n_preallocs */,
			(GInstanceInitFunc) ggobi_data_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "GGobiData", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GGobiData *)g_object_new(ggobi_data_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GGobiData * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GGobiData *
GET_NEW_VARG (const char *first, ...)
{
	GGobiData *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GGobiData *)g_object_new_valist (ggobi_data_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
ggobi_data_class_init (GGobiDataClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "GGobi:Data::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[ROWS_IN_PLOT_CHANGED_SIGNAL] =
		g_signal_new ("rows_in_plot_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST),
			G_STRUCT_OFFSET (GGobiDataClass, rows_in_plot_changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 3,
			G_TYPE_INT,
			G_TYPE_INT,
			G_TYPE_POINTER);
	if ___GOB_UNLIKELY(sizeof(int ) != sizeof(gint ) || sizeof(int ) != sizeof(gint ) || sizeof(ggobid * ) != sizeof(gpointer ) || parent_class == NULL /* avoid warning */) {
		g_error("data.gob line 191: Type mismatch of \"rows_in_plot_changed\" signal signature");
	}
	object_signals[COL_NAME_CHANGED_SIGNAL] =
		g_signal_new ("col_name_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (GGobiDataClass, col_name_changed),
			NULL, NULL,
			___marshal_Sig2,
			G_TYPE_NONE, 1,
			G_TYPE_INT);
	if ___GOB_UNLIKELY(sizeof(int ) != sizeof(gint ) || parent_class == NULL /* avoid warning */) {
		g_error("data.gob line 193: Type mismatch of \"col_name_changed\" signal signature");
	}

	c->rows_in_plot_changed = NULL;
	c->col_name_changed = NULL;
#line 204 "data.gob"
	g_object_class->constructor = ___8_ggobi_data_constructor;
#line 250 "ggobi-data.c"
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_uint
		("nrows" /* name */,
		 "nrows" /* nick */,
		 "Number of rows in the dataset" /* blurb */,
		 0 /* minimum */,
		 INT_MAX /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_NROWS,
		param_spec);
	param_spec = g_param_spec_uint
		("ncols" /* name */,
		 "ncols" /* nick */,
		 "Number of cols in the dataset" /* blurb */,
		 0 /* minimum */,
		 INT_MAX /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_NCOLS,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 195 "data.gob"
static void 
ggobi_data_init (GGobiData * self G_GNUC_UNUSED)
#line 284 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::init"
 {
#line 195 "data.gob"

  sphere_init(self); 
  
  self_set_name(self, "unknown", NULL);

  self->nearest_point = -1;
  self->missings_show_p = true;

#line 297 "ggobi-data.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "GGobi:Data::set_property"
{
	GGobiData *self G_GNUC_UNUSED;

	self = GGOBI_DATA (object);

	switch (property_id) {
	case PROP_NROWS:
		{
#line 182 "data.gob"
self->nrows = g_value_get_uint (VAL);
#line 318 "ggobi-data.c"
		}
		break;
	case PROP_NCOLS:
		{
#line 186 "data.gob"
self->ncols = g_value_get_uint (VAL);
#line 325 "ggobi-data.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "GGobi:Data::get_property"
{
	GGobiData *self G_GNUC_UNUSED;

	self = GGOBI_DATA (object);

	switch (property_id) {
	case PROP_NROWS:
		{
#line 182 "data.gob"
g_value_set_uint (VAL, self->nrows);
#line 356 "ggobi-data.c"
		}
		break;
	case PROP_NCOLS:
		{
#line 186 "data.gob"
g_value_set_uint (VAL, self->ncols);
#line 363 "ggobi-data.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 182 "data.gob"
guint 
ggobi_data_get_nrows (GGobiData * self)
#line 382 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::get_nrows"
{
#line 182 "data.gob"
		guint val; g_object_get (G_OBJECT (self), "nrows", &val, NULL); return val;
}}
#line 389 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 182 "data.gob"
void 
ggobi_data_set_nrows (GGobiData * self, guint val)
#line 395 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::set_nrows"
{
#line 182 "data.gob"
		g_object_set (G_OBJECT (self), "nrows", val, NULL);
}}
#line 402 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 186 "data.gob"
guint 
ggobi_data_get_ncols (GGobiData * self)
#line 408 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::get_ncols"
{
#line 186 "data.gob"
		guint val; g_object_get (G_OBJECT (self), "ncols", &val, NULL); return val;
}}
#line 415 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 186 "data.gob"
void 
ggobi_data_set_ncols (GGobiData * self, guint val)
#line 421 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::set_ncols"
{
#line 186 "data.gob"
		g_object_set (G_OBJECT (self), "ncols", val, NULL);
}}
#line 428 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 191 "data.gob"
static void 
ggobi_data_rows_in_plot_changed (GGobiData * self, int arg1, int arg2, ggobid * arg3)
#line 434 "ggobi-data.c"
{
	GValue ___param_values[4];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 191 "data.gob"
	g_return_if_fail (self != NULL);
#line 191 "data.gob"
	g_return_if_fail (GGOBI_IS_DATA (self));
#line 446 "ggobi-data.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_INT);
	g_value_set_int (&___param_values[1], (gint ) arg1);

	___param_values[2].g_type = 0;
	g_value_init (&___param_values[2], G_TYPE_INT);
	g_value_set_int (&___param_values[2], (gint ) arg2);

	___param_values[3].g_type = 0;
	g_value_init (&___param_values[3], G_TYPE_POINTER);
	g_value_set_pointer (&___param_values[3], (gpointer ) arg3);

	g_signal_emitv (___param_values,
		object_signals[ROWS_IN_PLOT_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
	g_value_unset (&___param_values[2]);
	g_value_unset (&___param_values[3]);
}

#line 193 "data.gob"
void 
ggobi_data_col_name_changed (GGobiData * self, int j)
#line 478 "ggobi-data.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 193 "data.gob"
	g_return_if_fail (self != NULL);
#line 193 "data.gob"
	g_return_if_fail (GGOBI_IS_DATA (self));
#line 490 "ggobi-data.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_INT);
	g_value_set_int (&___param_values[1], (gint ) j);

	g_signal_emitv (___param_values,
		object_signals[COL_NAME_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}


#line 204 "data.gob"
static GObject * 
___8_ggobi_data_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_properties)
#line 513 "ggobi-data.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_properties) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_properties): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "GGobi:Data::constructor"
{
#line 206 "data.gob"
	
  GGobiData* d = (GGobiData*) PARENT_HANDLER(type, n_construct_properties, construct_properties);
  /* we can put these here OR we can put them in the setter for the 'ncols'
     property, since we know that comes last (after 'nrows' has been set) */
  
  d->nrows_in_plot = d->nrows;  /*-- for now --*/

  arrayf_alloc (&d->raw, d->nrows, d->ncols); //FIXME: probably leaks memory
  //arrays_alloc (&d->missing, d->nrows, d->ncols);
  arrays_alloc_zero (&d->missing, d->nrows, d->ncols);

  rowlabels_alloc (d);

  vartable_alloc (d);
  vartable_init (d);

  br_glyph_ids_alloc (d);
  br_glyph_ids_init (d);

  br_color_ids_alloc (d);
  br_color_ids_init (d);

  br_hidden_alloc (d);
  br_hidden_init (d);


  return((GObject *)d);
}}
#line 550 "ggobi-data.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 235 "data.gob"
GGobiData * 
ggobi_data_new (guint nrows, guint ncols)
#line 557 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::new"
{
#line 237 "data.gob"
	
  GGobiData* d = (GGobiData*) g_object_new(GGOBI_TYPE_DATA, "ncols", ncols, "nrows", nrows, NULL);
  return(d);
}}
#line 566 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 248 "data.gob"
gchar * 
ggobi_data_get_name (GGobiData * self)
#line 572 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::get_name"
#line 248 "data.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 248 "data.gob"
	g_return_val_if_fail (GGOBI_IS_DATA (self), (gchar * )0);
#line 579 "ggobi-data.c"
{
#line 250 "data.gob"
	
  return (g_strdup(self->name));
}}
#line 585 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 254 "data.gob"
void 
ggobi_data_set_name (GGobiData * self, gchar * name, gchar * nickname)
#line 591 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::set_name"
#line 254 "data.gob"
	g_return_if_fail (self != NULL);
#line 254 "data.gob"
	g_return_if_fail (GGOBI_IS_DATA (self));
#line 598 "ggobi-data.c"
{
#line 256 "data.gob"
	
  if (name == NULL) name = g_strdup("unknown");
  if (nickname == NULL) nickname = g_strndup(name, 5);

  self->name = g_strdup(name);
  self->nickname = g_strndup(name, 5);
}}
#line 608 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 264 "data.gob"
guint 
ggobi_data_get_n_cols (GGobiData * self)
#line 614 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::get_n_cols"
#line 264 "data.gob"
	g_return_val_if_fail (self != NULL, (guint )0);
#line 264 "data.gob"
	g_return_val_if_fail (GGOBI_IS_DATA (self), (guint )0);
#line 621 "ggobi-data.c"
{
#line 265 "data.gob"
	
  return self->ncols;
}}
#line 627 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 269 "data.gob"
guint 
ggobi_data_get_n_rows (GGobiData * self)
#line 633 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::get_n_rows"
#line 269 "data.gob"
	g_return_val_if_fail (self != NULL, (guint )0);
#line 269 "data.gob"
	g_return_val_if_fail (GGOBI_IS_DATA (self), (guint )0);
#line 640 "ggobi-data.c"
{
#line 270 "data.gob"
	
  return self->nrows;
}}
#line 646 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 275 "data.gob"
gchar * 
ggobi_data_get_col_name (GGobiData * self, guint j)
#line 652 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::get_col_name"
#line 275 "data.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 275 "data.gob"
	g_return_val_if_fail (GGOBI_IS_DATA (self), (gchar * )0);
#line 659 "ggobi-data.c"
{
#line 277 "data.gob"
	
  vartabled* vt = vartable_element_get (j, self);
  return(vt->collab);
}}
#line 666 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 282 "data.gob"
void 
ggobi_data_set_col_name (GGobiData * self, guint j, gchar * value)
#line 672 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::set_col_name"
#line 282 "data.gob"
	g_return_if_fail (self != NULL);
#line 282 "data.gob"
	g_return_if_fail (GGOBI_IS_DATA (self));
#line 679 "ggobi-data.c"
{
#line 284 "data.gob"
	
  vartabled* vt = vartable_element_get (j, self);

  //if (vt->collab) g_object_unref(vt->collab); 
	//if (vt->nickname) g_object_unref(vt->nickname);
  //if (vt->collab_tform) g_object_unref(vt->collab_tform);

  if (value == NULL) value = g_strdup_printf("V%d", j + 1);

  vt->collab = g_strdup(value);
  vt->collab_tform = g_strdup(value);
  vt->nickname = g_strndup (vt->collab, 2);

  g_signal_emit_by_name (self, "col_name_changed", (gpointer) self, j);

  // SEND COLUMN NAME CHANGED SIGNAL
  // Listeners:
  //  * vartable_collab_set_by_var (j, d);
  //  * varpanel_label_set (j, d);   /*-- checkboxes --*/
  //  * varcircle_label_set (j, d);  /*-- variable circles --*/
  //  * tform_label_update (jvar, d);
  
}}
#line 705 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 309 "data.gob"
gchar * 
ggobi_data_get_transformed_col_name (GGobiData * self, guint j)
#line 711 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::get_transformed_col_name"
#line 309 "data.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 309 "data.gob"
	g_return_val_if_fail (GGOBI_IS_DATA (self), (gchar * )0);
#line 718 "ggobi-data.c"
{
#line 311 "data.gob"
	
  vartabled* vt = vartable_element_get (j, self);
  return(vt->collab_tform);
}}
#line 725 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 316 "data.gob"
void 
ggobi_data_set_transformed_col_name (GGobiData * self, guint j, gchar * value)
#line 731 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::set_transformed_col_name"
#line 316 "data.gob"
	g_return_if_fail (self != NULL);
#line 316 "data.gob"
	g_return_if_fail (GGOBI_IS_DATA (self));
#line 738 "ggobi-data.c"
{
#line 318 "data.gob"
	
  vartabled* vt = vartable_element_get (j, self);
  //if (vt->collab_tform) g_object_unref(vt->collab_tform);  //is this necessary?
  vt->collab_tform = g_strdup(value);
}}
#line 746 "ggobi-data.c"
#undef __GOB_FUNCTION__

/**
 * ggobi_data_set_missing:
 *
 * Set specified cell to be a missing value
 **/
#line 330 "data.gob"
void 
ggobi_data_set_missing (GGobiData * self, guint i, guint j)
#line 757 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::set_missing"
#line 330 "data.gob"
	g_return_if_fail (self != NULL);
#line 330 "data.gob"
	g_return_if_fail (GGOBI_IS_DATA (self));
#line 764 "ggobi-data.c"
{
#line 332 "data.gob"
	
  self->missing.vals[i][j] = 1;
  self->raw.vals[i][j] = 0;
  self->missings = TRUE;
}}
#line 772 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 338 "data.gob"
gboolean 
ggobi_data_is_missing (GGobiData * self, guint i, guint j)
#line 778 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::is_missing"
#line 338 "data.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 338 "data.gob"
	g_return_val_if_fail (GGOBI_IS_DATA (self), (gboolean )0);
#line 785 "ggobi-data.c"
{
#line 340 "data.gob"
	
  return self->missings && (self->missing.vals[i][j] == 1);  
}}
#line 791 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 344 "data.gob"
gboolean 
ggobi_data_has_missings (GGobiData * self)
#line 797 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::has_missings"
#line 344 "data.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 344 "data.gob"
	g_return_val_if_fail (GGOBI_IS_DATA (self), (gboolean )0);
#line 804 "ggobi-data.c"
{
#line 346 "data.gob"
	
  return self->missings;
}}
#line 810 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 351 "data.gob"
guint 
ggobi_data_get_col_n_missing (GGobiData * self, guint j)
#line 816 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::get_col_n_missing"
#line 351 "data.gob"
	g_return_val_if_fail (self != NULL, (guint )0);
#line 351 "data.gob"
	g_return_val_if_fail (GGOBI_IS_DATA (self), (guint )0);
#line 823 "ggobi-data.c"
{
#line 352 "data.gob"
	
  guint i, n = 0;

  for(i = 0; i < self->nrows; i++) {
    if (self_is_missing(self, i, j)) n++;
  }
  
  return(n);
}}
#line 835 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 362 "data.gob"
void 
ggobi_data_set_raw_values (GGobiData * self, guint j, gdouble * values)
#line 841 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::set_raw_values"
#line 362 "data.gob"
	g_return_if_fail (self != NULL);
#line 362 "data.gob"
	g_return_if_fail (GGOBI_IS_DATA (self));
#line 848 "ggobi-data.c"
{
#line 364 "data.gob"
	
  gint i;
  for (i = 0; i < self->nrows; i++) {
    self_set_raw_value(self, i, j, values[i]);
  }
}}
#line 857 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 371 "data.gob"
void 
ggobi_data_set_raw_value (GGobiData * self, guint i, guint j, gdouble value)
#line 863 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::set_raw_value"
#line 371 "data.gob"
	g_return_if_fail (self != NULL);
#line 371 "data.gob"
	g_return_if_fail (GGOBI_IS_DATA (self));
#line 870 "ggobi-data.c"
{
#line 373 "data.gob"
	
  if(GGobiMissingValue && GGobiMissingValue(value))
    self_set_missing(self, i, j);
  else self->raw.vals[i][j] = value;
}}
#line 878 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 419 "data.gob"
gchar * 
ggobi_data_get_string_value (GGobiData * self, guint i, guint j, gboolean transformed)
#line 884 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::get_string_value"
#line 419 "data.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 419 "data.gob"
	g_return_val_if_fail (GGOBI_IS_DATA (self), (gchar * )0);
#line 891 "ggobi-data.c"
{
#line 421 "data.gob"
	
  gint n = 0, lval = -1;
  vartabled *vt = vartable_element_get(j, self);
  gdouble raw = transformed ? self->tform.vals[i][j] : self->raw.vals[i][j];
  
  if (self_is_missing(self, i, j)) 
    return g_strdup("NA");
  if (vt->vartype != categorical)
    return g_strdup_printf("%g", raw);
  
  for (n = 0; n < vt->nlevels; n++) {
    if (vt->level_values[n] == raw) {
      lval = n;
      break;
    }
  }
  if (lval == -1) {
    g_printerr ("The levels for %s aren't specified correctly\n",            vt->collab);
    return(NULL);
  }
  
  return vt->level_names[lval];
}}
#line 917 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 445 "data.gob"
gboolean 
ggobi_data_has_edges (GGobiData * self)
#line 923 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::has_edges"
#line 445 "data.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 445 "data.gob"
	g_return_val_if_fail (GGOBI_IS_DATA (self), (gboolean )0);
#line 930 "ggobi-data.c"
{
#line 447 "data.gob"
	
  return (self->edge.n > 0);
}}
#line 936 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 451 "data.gob"
gboolean 
ggobi_data_has_variables (GGobiData * self)
#line 942 "ggobi-data.c"
{
#define __GOB_FUNCTION__ "GGobi:Data::has_variables"
#line 451 "data.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 451 "data.gob"
	g_return_val_if_fail (GGOBI_IS_DATA (self), (gboolean )0);
#line 949 "ggobi-data.c"
{
#line 453 "data.gob"
	
  return (self->ncols > 0);
}}
#line 955 "ggobi-data.c"
#undef __GOB_FUNCTION__

#line 475 "data.gob"

void
datad_free (GGobiData *d, ggobid *gg) 
{
  arrayf_free (&d->raw, 0, 0);
  pipeline_arrays_free (d, gg);

  arrays_free (&d->missing, 0, 0);

   /* rowIds and idTable are intrinsically linked !*/
  if(d->idTable) {
    g_hash_table_foreach(d->idTable, freeLevelHashEntry, d->idTable);
    g_hash_table_destroy(d->idTable); 
  }

  if(d->rowIds) 
    g_free(d->rowIds);

  g_free (d);
}

displayd *
datad_init (GGobiData *d, ggobid *gg, gboolean cleanup)
{
  /* GGobi assumes datasets have at least one row */
  g_return_val_if_fail(d->nrows > 0, NULL);
  d->gg = gg;
  gg->d = g_slist_append (gg->d, d);
  displayd *display = NULL;

  if (cleanup) {
    varpanel_clear (d, gg);
  }

  varpanel_populate (d, gg);   /*-- toggles */
  /*-- circles: build but don't show --*/
  varcircles_populate (d, gg);

  pipeline_init (d, gg);
  clusters_set (d, gg);  /*-- find the clusters for data just read in --*/

  if (cleanup || g_list_length(gg->displays) == 0) {
    display_free_all (gg);  /*-- destroy any existing displays --*/
    gg->pmode = NULL_PMODE;

    /*-- initialize the first display --*/
    if(sessionOptions->info->createInitialScatterPlot && d->ncols > 0) {
/*XXX allow this to be specified as a gtk type name on the command
      line, initialization file, etc.  and invoke the corresponding
      create() method. */
      display = scatterplot_new (true, false, NULL, d, gg);
        /* Need to make certain this is the only one there. */

      if (display != NULL) {
        gg->displays = g_list_append (gg->displays, (gpointer) display);
	    gg->current_splot = (splotd *)
        	g_list_nth_data (display->splots, 0);
        display->current_splot = gg->current_splot;
        display_set_current (display, gg);

        /*-- turn on event handling in the very first plot --*/
        /*-- ... but will it cause trouble for later plots?  ok so far
	  --*/
	/* Is imode set yet?  I hope so. */
        sp_event_handlers_toggle (gg->current_splot, on, gg->pmode, gg->imode);
      }
    }
  }

  if (gg->current_display != NULL)
    varpanel_refresh (gg->current_display, gg);

  if (g_slist_index(gg->d, (gpointer)d) == 0)
    varpanel_set_sensitive (d, true, gg);

  g_signal_emit (G_OBJECT (gg), GGobiSignals[DATAD_ADDED_SIGNAL], 0, d);

  display_menu_build (gg);

  return (display);
}




/*------------------------------------------------------------------------*/
/*                          row labels                                    */
/*------------------------------------------------------------------------*/
/* This initializes rowIds to row numbers if ids are not provided */
void
datad_record_ids_set(GGobiData *d, gchar **ids, gboolean duplicate)
{
  gint i;
  guint *index;
  gchar *tmp;

  d->idTable = g_hash_table_new(g_str_hash, g_str_equal);
  d->rowIds = (gchar **) g_malloc(sizeof(gchar *) * d->nrows);
  for(i = 0; i < d->nrows; i++) {
     if(ids)
       tmp = duplicate ? g_strdup(ids[i]) : ids[i];
     else {
       char buf[10];
       sprintf(buf, "%d", i+1);
       tmp = g_strdup(buf);
     }
     index = (guint *) g_malloc(sizeof(guint));
     *index = i;
     g_hash_table_insert(d->idTable, tmp, index);
     d->rowIds[i] = tmp;     
     /* do not free anything here */
  }
}

/* Add a record id */
void
datad_record_id_add (gchar *id, GGobiData *d)
{
  gint i;
  guint *index;

  d->rowIds = (gchar **) g_realloc (d->rowIds, sizeof(gchar *) * d->nrows);
  i = d->nrows - 1;

  index = (guint *) g_malloc(sizeof(guint));
  *index = i;
  g_hash_table_insert (d->idTable, id, index);
  d->rowIds[i] = id;

/*
 * I don't really understand why I can't free this
 * when it's freed in datad_record_ids_set, but purify is
 * quite clear on this point.  -- dfs
*/
  /*g_free (index);*/
}

/* FIXME: this only works the first time */
void
ggobi_data_set_row_labels(GGobiData *d, gchar **labels)
{
	gint i;
	for (i = 0; i < d->nrows; i++) {
		gchar *label;
		if (labels && labels[i])
			label = g_strdup(labels[i]);
		else label = g_strdup_printf("%d", i);
		g_array_append_val(d->rowlab, label);
	}
}

void 
rowlabels_free (GGobiData *d)
{
  g_array_free (d->rowlab, true);
}


void
rowlabels_alloc (GGobiData *d) 
{
  if (d->rowlab != NULL) rowlabels_free (d);
  d->rowlab = g_array_sized_new (false, false, sizeof (gchar *), d->nrows);
}

void
rowlabel_add (gchar *label, GGobiData *d) 
{
  g_array_append_val (d->rowlab, label);

  g_assert (d->rowlab->len == d->nrows);
}



#line 1134 "ggobi-data.c"
