-- | Test for GHC 7.10+'s @BinaryLiterals@ extensions (see GHC #9224)

{-# LANGUAGE BinaryLiterals #-}
{-# LANGUAGE MagicHash #-}
{-# LANGUAGE NegativeLiterals #-}

module Main where

import GHC.Types
import GHC.Int

main = do
    print [ I# 0B0#, I# -0B0#, I# 0B1#, I# -0B1#
          , I# 0B00000000000000000000000000000000000000000000000000000000000000000000000000001#
          , I# -0B00000000000000000000000000000000000000000000000000000000000000000000000000001#
          , I# -0B11001001#, I# -0B11001001#
          , I# -0B11111111#, I# -0B11111111#
          ]
    print [ W# 0B0##, W# 0B1##, W# 0B11001001##, W# 0B11##, W# 0B11111111##
          , W# 0B00000000000000000000000000000000000000000000000000000000000000000000000000001##
          ]

    print [ 0B0, 0B1, 0B10, 0B11, 0B100, 0B101, 0B110, 0B111 :: Integer
          , -0B0, -0B1, -0B10, -0B11, -0B100, -0B101, -0B110, -0B111
          , 0B11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
          , -0B11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111
          ]

    print [ I8# -0B10000000#, I8# 0B1111111# ]
