module Win32Palette where

import StdDIS
import Win32Types
import GDITypes


----------------------------------------------------------------
-- Palettes
----------------------------------------------------------------

type StockPalette   = WORD

dEFAULT_PALETTE :: StockPalette
dEFAULT_PALETTE =
  unsafePerformIO(
    prim_dEFAULT_PALETTE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Palette_stub_ffi.h prim_dEFAULT_PALETTE" prim_dEFAULT_PALETTE :: IO (Word16)

getStockPalette :: StockPalette -> IO HPALETTE
getStockPalette arg1 =
  prim_getStockPalette arg1
  >>= \ gc_result ->
  access_prim_getStockPalette_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getStockPalette_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getStockPalette_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall unsafe "Win32Palette_stub_ffi.h prim_getStockPalette" prim_getStockPalette :: Word16 -> IO (Addr)
foreign import ccall unsafe "access_prim_getStockPalette_res1" access_prim_getStockPalette_res1 :: Addr -> IO (Addr)
foreign import ccall unsafe "access_prim_getStockPalette_gc_failed" access_prim_getStockPalette_gc_failed :: Addr -> IO (Int)
foreign import ccall unsafe "access_prim_getStockPalette_gc_failstring" access_prim_getStockPalette_gc_failstring :: Addr -> IO (Addr)

deletePalette :: HPALETTE -> IO ()
deletePalette arg1 =
  prim_deletePalette arg1
  >>= \ gc_result ->
  access_prim_deletePalette_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_deletePalette_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall unsafe "Win32Palette_stub_ffi.h prim_deletePalette" prim_deletePalette :: Addr -> IO (Addr)
foreign import ccall unsafe "access_prim_deletePalette_gc_failed" access_prim_deletePalette_gc_failed :: Addr -> IO (Int)
foreign import ccall unsafe "access_prim_deletePalette_gc_failstring" access_prim_deletePalette_gc_failstring :: Addr -> IO (Addr)

pALETTERGB :: BYTE -> BYTE -> BYTE -> COLORREF
pALETTERGB arg1 arg2 arg3 =
  unsafePerformIO(
    prim_pALETTERGB arg1 arg2 arg3
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Palette_stub_ffi.h prim_pALETTERGB" prim_pALETTERGB :: Word8 -> Word8 -> Word8 -> IO (Word32)
pALETTEINDEX :: WORD -> COLORREF
pALETTEINDEX arg1 =
  unsafePerformIO(
    prim_pALETTEINDEX arg1
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "Win32Palette_stub_ffi.h prim_pALETTEINDEX" prim_pALETTEINDEX :: Word16 -> IO (Word32)

----------------------------------------------------------------
-- End
----------------------------------------------------------------
