{-# OPTIONS -fglasgow-exts -cpp #-}
module CmmParse ( parseCmmFile ) where

import CgMonad
import CgHeapery
import CgUtils
import CgProf
import CgTicky
import CgInfoTbls
import CgForeignCall
import CgTailCall	( pushUnboxedTuple )
import CgStackery	( emitPushUpdateFrame )
import ClosureInfo	( C_SRT(..) )
import CgCallConv	( smallLiveness )
import CgClosure	( emitBlackHoleCode )
import CostCentre	( dontCareCCS )

import Cmm
import PprCmm
import CmmUtils		( mkIntCLit )
import CmmLex
import CLabel
import MachOp
import SMRep		( fixedHdrSize, CgRep(..) )
import Lexer

import ForeignCall	( CCallConv(..) )
import Literal		( mkMachInt )
import Unique
import UniqFM
import SrcLoc
import CmdLineOpts	( DynFlags, DynFlag(..), opt_SccProfilingOn )
import Packages		( HomeModules )
import ErrUtils		( printError, dumpIfSet_dyn, showPass )
import StringBuffer	( hGetStringBuffer )
import FastString
import Panic		( panic )
import Constants	( wORD_SIZE )
import Outputable

import Monad		( when )

#include "HsVersions.h"
import Array
#if __GLASGOW_HASKELL__ >= 503
import GHC.Exts
#else
import GlaExts
#endif

-- parser produced by Happy Version 1.15

newtype HappyAbsSyn  = HappyAbsSyn (() -> ())
happyIn4 :: (ExtCode) -> (HappyAbsSyn )
happyIn4 x = unsafeCoerce# x
{-# INLINE happyIn4 #-}
happyOut4 :: (HappyAbsSyn ) -> (ExtCode)
happyOut4 x = unsafeCoerce# x
{-# INLINE happyOut4 #-}
happyIn5 :: (ExtCode) -> (HappyAbsSyn )
happyIn5 x = unsafeCoerce# x
{-# INLINE happyIn5 #-}
happyOut5 :: (HappyAbsSyn ) -> (ExtCode)
happyOut5 x = unsafeCoerce# x
{-# INLINE happyOut5 #-}
happyIn6 :: (ExtCode) -> (HappyAbsSyn )
happyIn6 x = unsafeCoerce# x
{-# INLINE happyIn6 #-}
happyOut6 :: (HappyAbsSyn ) -> (ExtCode)
happyOut6 x = unsafeCoerce# x
{-# INLINE happyOut6 #-}
happyIn7 :: ([ExtFCode [CmmStatic]]) -> (HappyAbsSyn )
happyIn7 x = unsafeCoerce# x
{-# INLINE happyIn7 #-}
happyOut7 :: (HappyAbsSyn ) -> ([ExtFCode [CmmStatic]])
happyOut7 x = unsafeCoerce# x
{-# INLINE happyOut7 #-}
happyIn8 :: (ExtFCode [CmmStatic]) -> (HappyAbsSyn )
happyIn8 x = unsafeCoerce# x
{-# INLINE happyIn8 #-}
happyOut8 :: (HappyAbsSyn ) -> (ExtFCode [CmmStatic])
happyOut8 x = unsafeCoerce# x
{-# INLINE happyOut8 #-}
happyIn9 :: ([ExtFCode CmmExpr]) -> (HappyAbsSyn )
happyIn9 x = unsafeCoerce# x
{-# INLINE happyIn9 #-}
happyOut9 :: (HappyAbsSyn ) -> ([ExtFCode CmmExpr])
happyOut9 x = unsafeCoerce# x
{-# INLINE happyOut9 #-}
happyIn10 :: (ExtCode) -> (HappyAbsSyn )
happyIn10 x = unsafeCoerce# x
{-# INLINE happyIn10 #-}
happyOut10 :: (HappyAbsSyn ) -> (ExtCode)
happyOut10 x = unsafeCoerce# x
{-# INLINE happyOut10 #-}
happyIn11 :: (ExtFCode (CLabel, [CmmLit],[CmmLit])) -> (HappyAbsSyn )
happyIn11 x = unsafeCoerce# x
{-# INLINE happyIn11 #-}
happyOut11 :: (HappyAbsSyn ) -> (ExtFCode (CLabel, [CmmLit],[CmmLit]))
happyOut11 x = unsafeCoerce# x
{-# INLINE happyOut11 #-}
happyIn12 :: ([CmmLit]) -> (HappyAbsSyn )
happyIn12 x = unsafeCoerce# x
{-# INLINE happyIn12 #-}
happyOut12 :: (HappyAbsSyn ) -> ([CmmLit])
happyOut12 x = unsafeCoerce# x
{-# INLINE happyOut12 #-}
happyIn13 :: (ExtCode) -> (HappyAbsSyn )
happyIn13 x = unsafeCoerce# x
{-# INLINE happyIn13 #-}
happyOut13 :: (HappyAbsSyn ) -> (ExtCode)
happyOut13 x = unsafeCoerce# x
{-# INLINE happyOut13 #-}
happyIn14 :: (ExtCode) -> (HappyAbsSyn )
happyIn14 x = unsafeCoerce# x
{-# INLINE happyIn14 #-}
happyOut14 :: (HappyAbsSyn ) -> (ExtCode)
happyOut14 x = unsafeCoerce# x
{-# INLINE happyOut14 #-}
happyIn15 :: ([FastString]) -> (HappyAbsSyn )
happyIn15 x = unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn ) -> ([FastString])
happyOut15 x = unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: (ExtCode) -> (HappyAbsSyn )
happyIn16 x = unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn ) -> (ExtCode)
happyOut16 x = unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: (ExtFCode BoolExpr) -> (HappyAbsSyn )
happyIn17 x = unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn ) -> (ExtFCode BoolExpr)
happyOut17 x = unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (ExtFCode BoolExpr) -> (HappyAbsSyn )
happyIn18 x = unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn ) -> (ExtFCode BoolExpr)
happyOut18 x = unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: (Maybe [GlobalReg]) -> (HappyAbsSyn )
happyIn19 x = unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn ) -> (Maybe [GlobalReg])
happyOut19 x = unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: ([GlobalReg]) -> (HappyAbsSyn )
happyIn20 x = unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn ) -> ([GlobalReg])
happyOut20 x = unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: (Maybe (Int,Int)) -> (HappyAbsSyn )
happyIn21 x = unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn ) -> (Maybe (Int,Int))
happyOut21 x = unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: ([([Int],ExtCode)]) -> (HappyAbsSyn )
happyIn22 x = unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn ) -> ([([Int],ExtCode)])
happyOut22 x = unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: (([Int],ExtCode)) -> (HappyAbsSyn )
happyIn23 x = unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn ) -> (([Int],ExtCode))
happyOut23 x = unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: ([Int]) -> (HappyAbsSyn )
happyIn24 x = unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn ) -> ([Int])
happyOut24 x = unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: (Maybe ExtCode) -> (HappyAbsSyn )
happyIn25 x = unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn ) -> (Maybe ExtCode)
happyOut25 x = unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: (ExtCode) -> (HappyAbsSyn )
happyIn26 x = unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn ) -> (ExtCode)
happyOut26 x = unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: (ExtFCode CmmExpr) -> (HappyAbsSyn )
happyIn27 x = unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn ) -> (ExtFCode CmmExpr)
happyOut27 x = unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: (ExtFCode CmmExpr) -> (HappyAbsSyn )
happyIn28 x = unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn ) -> (ExtFCode CmmExpr)
happyOut28 x = unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: (MachRep) -> (HappyAbsSyn )
happyIn29 x = unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn ) -> (MachRep)
happyOut29 x = unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: ([ExtFCode (CmmExpr, MachHint)]) -> (HappyAbsSyn )
happyIn30 x = unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn ) -> ([ExtFCode (CmmExpr, MachHint)])
happyOut30 x = unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: ([ExtFCode (CmmExpr, MachHint)]) -> (HappyAbsSyn )
happyIn31 x = unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn ) -> ([ExtFCode (CmmExpr, MachHint)])
happyOut31 x = unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: (ExtFCode (CmmExpr, MachHint)) -> (HappyAbsSyn )
happyIn32 x = unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn ) -> (ExtFCode (CmmExpr, MachHint))
happyOut32 x = unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: ([ExtFCode CmmExpr]) -> (HappyAbsSyn )
happyIn33 x = unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn ) -> ([ExtFCode CmmExpr])
happyOut33 x = unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: ([ExtFCode CmmExpr]) -> (HappyAbsSyn )
happyIn34 x = unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn ) -> ([ExtFCode CmmExpr])
happyOut34 x = unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: (ExtFCode CmmExpr) -> (HappyAbsSyn )
happyIn35 x = unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn ) -> (ExtFCode CmmExpr)
happyOut35 x = unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: (ExtFCode CmmReg) -> (HappyAbsSyn )
happyIn36 x = unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn ) -> (ExtFCode CmmReg)
happyOut36 x = unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: (BlockId) -> (HappyAbsSyn )
happyIn37 x = unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn ) -> (BlockId)
happyOut37 x = unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: (MachRep) -> (HappyAbsSyn )
happyIn38 x = unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn ) -> (MachRep)
happyOut38 x = unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: (MachRep) -> (HappyAbsSyn )
happyIn39 x = unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn ) -> (MachRep)
happyOut39 x = unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyInTok :: Located CmmToken -> (HappyAbsSyn )
happyInTok x = unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn ) -> Located CmmToken
happyOutTok x = unsafeCoerce# x
{-# INLINE happyOutTok #-}

happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\xbc\x01\x00\x00\x68\x03\xbc\x01\x00\x00\x00\x00\x8c\x00\x00\x00\x6f\x03\x00\x00\x98\x03\x97\x03\x95\x03\x92\x03\x8a\x03\x89\x03\x53\x03\x4f\x03\x48\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x03\x15\x00\x7b\x03\x6a\x03\x6c\x03\x5f\x03\x3a\x03\x39\x03\x37\x03\x2c\x03\x2b\x03\x29\x03\x56\x03\x00\x00\x15\x00\x00\x00\x55\x03\x15\x00\x15\x00\x4d\x03\x52\x03\x0c\x00\x00\x00\xff\x02\x67\x00\x9f\x00\xfb\x02\x40\x03\x00\x00\x09\x00\xee\xff\x00\x00\x35\x03\x34\x03\x32\x03\x27\x03\x26\x03\x18\x03\x00\x00\xcb\x01\xf4\x02\x00\x00\x28\x03\x00\x00\x00\x00\x1d\x03\xcb\x01\xff\xff\x24\x03\x17\x03\xe3\x02\x16\x03\x0f\x03\xd6\x02\xd5\x02\xd0\x02\xc8\x02\xc7\x02\xc0\x02\xf3\x02\x00\x00\x9f\x00\x9f\x00\xb8\x02\x9f\x00\x35\x01\xe1\x02\x00\x00\xef\x02\x9f\x00\x9f\x00\xb5\x02\x9f\x00\x00\x00\x00\x00\x00\x00\xd1\x02\xd1\x02\x06\x00\x00\x00\xc1\x02\x67\x00\x67\x00\xe6\x02\x00\x00\x9f\x00\x00\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x21\x01\xab\x02\xbe\x01\x00\x00\x00\x00\x6c\x00\xdb\x02\x48\x02\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x9f\x00\x15\x00\x4b\x00\x4b\x00\x00\x00\x52\x02\x00\x00\x07\x00\xd3\x02\x00\x00\x48\x02\x9f\x00\x9e\x02\x00\x00\x30\x02\xbf\x02\x49\x01\x99\x02\xbb\x02\x00\x00\x83\x02\xc2\x02\xb0\x02\xaf\x02\xae\x02\x9b\x02\x9a\x02\x00\x00\x02\x00\x9c\x02\x62\x02\x5f\x02\x0d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x88\x02\x77\x02\x00\x00\x45\x02\x76\x02\x43\x02\x41\x02\x40\x02\x3c\x02\x34\x02\x4b\x02\x9f\x00\x33\x02\x6a\x02\x9f\x00\x20\x02\x14\x02\x9f\x00\x3f\x02\xa4\x01\x00\x00\x9f\x00\x00\x00\x6c\x00\x28\x02\x37\x02\xad\x02\xad\x02\xad\x02\xad\x02\x6d\x00\x6d\x00\xad\x02\xad\x02\x8d\x01\xed\x01\x12\x00\x07\x00\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3e\x02\x9f\x00\x00\x00\x17\x02\x9f\x00\x1e\x02\x32\x02\x00\x00\xaa\x00\xad\x00\x31\x02\x00\x00\x22\x02\x29\x02\xfd\x01\xfc\x01\xf0\x01\x00\x00\x00\x00\x9f\x00\x85\x02\x15\x02\x0c\x02\x0b\x02\x0a\x02\x09\x02\x00\x02\x13\x02\x12\x02\x01\x02\xf6\x01\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x01\xb1\x01\xae\x01\xad\x01\xab\x01\x00\x00\x00\x00\xfe\x01\xe6\x01\xd3\x01\x00\x00\xe0\x01\xd6\x01\x00\x00\x9f\x00\xd1\x01\x00\x00\x00\x00\x00\x00\x00\x00\xd2\x01\xf6\x00\x9f\x00\xcc\x01\x00\x00\x15\x00\xc7\x01\x8e\x01\x00\x00\xc4\x01\x00\x00\x89\x01\xb7\x01\x9f\x00\xaf\x01\xa7\x01\xa6\x01\xa5\x01\x95\x01\x66\x01\x6c\x01\x65\x01\x98\x01\x5c\x01\x54\x01\x76\x01\x15\x00\x00\x00\x15\x00\x88\x01\x69\x01\x00\x00\x78\x01\x70\x01\x6d\x01\x00\x00\x39\x01\x00\x00\x67\x01\x5d\x01\x46\x01\x38\x01\x37\x01\x00\x00\x24\x01\x23\x01\x1e\x01\x00\x00\xfc\x00\xe9\x00\x00\x00\xe8\x00\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x01\xf8\x00\xeb\x00\xb3\x00\xb1\x00\x00\x00\xe5\x00\xca\x00\x00\x00\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\xf5\x00\x00\x00\x00\x00\xea\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x00\x00\x00\xb9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x83\x01\x00\x00\x00\x00\x71\x01\x68\x01\x00\x00\x00\x00\xb8\x00\x00\x00\x96\x00\x6d\x02\xb6\x03\x00\x00\xa5\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x9e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\xad\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe9\x02\xa8\x03\x00\x00\x9f\x03\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x03\x91\x03\x00\x00\x8c\x03\x00\x00\x00\x00\x00\x00\x9b\x00\x97\x00\x00\x00\x00\x00\x00\x00\x60\x02\x53\x02\x00\x00\x00\x00\x83\x03\x00\x00\x7e\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x03\x70\x03\x67\x03\x62\x03\x59\x03\x54\x03\x4b\x03\x46\x03\x3d\x03\x38\x03\x2f\x03\x2a\x03\x21\x03\x1c\x03\x13\x03\x0e\x03\x64\x01\x51\x02\x46\x00\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\xdb\x00\x0a\x00\x00\x00\xd7\x02\x00\x00\x00\x00\x00\x00\xe0\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf7\x02\x00\x00\x00\x00\xf2\x02\x50\x00\x00\x00\x00\x00\x3d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\xf0\xff\x4d\x00\x00\x00\x00\x00\xae\x00\x56\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\x02\x00\x00\x00\x00\x60\x01\x00\x00\x30\x00\x00\x00\x00\x00\x00\x00\xfb\xff\x00\x00\x55\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x01\x00\x00\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x00\x00\x00\x00\xf8\xff\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\xfe\xff\x00\x00\x00\x00\xfe\xff\xfb\xff\xfc\xff\x00\x00\xfa\xff\x00\x00\x8b\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\xff\x8a\xff\x89\xff\x88\xff\x87\xff\x86\xff\x00\x00\xe1\xff\x00\x00\xdb\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\xff\xe1\xff\xfd\xff\x00\x00\xe1\xff\xe1\xff\x00\x00\x00\x00\x00\x00\xd9\xff\x00\x00\x00\x00\x00\x00\x00\x00\xc2\xff\x8e\xff\x8d\xff\x00\x00\xde\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdc\xff\xf7\xff\x00\x00\xdd\xff\x00\x00\xe9\xff\xda\xff\x00\x00\xf7\xff\x00\x00\x8b\xff\x00\x00\x00\x00\x8c\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8f\xff\x95\xff\x00\x00\x00\x00\x00\x00\x00\x00\xa5\xff\xa1\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\xff\x91\xff\xa2\xff\x9d\xff\x9d\xff\x00\x00\xcd\xff\xcc\xff\x00\x00\x00\x00\x00\x00\x8d\xff\x00\x00\xd8\xff\x00\x00\xdf\xff\xe0\xff\xeb\xff\x00\x00\x00\x00\x00\x00\xd0\xff\xc9\xff\x00\x00\xcd\xff\xcc\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\xff\x00\x00\x00\x00\xa3\xff\x00\x00\xa4\xff\xa7\xff\x00\x00\xa8\xff\x00\x00\x00\x00\x00\x00\xcf\xff\x00\x00\x00\x00\x00\x00\x93\xff\x00\x00\x94\xff\x00\x00\xed\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf5\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf3\xff\xf6\xff\xf8\xff\xf4\xff\x00\x00\xed\xff\xef\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc1\xff\x00\x00\x9b\xff\x00\x00\x00\x00\x9e\xff\x95\xff\x9c\xff\xca\xff\xcb\xff\x00\x00\xaa\xff\xa9\xff\xac\xff\xae\xff\xb2\xff\xb3\xff\xab\xff\xad\xff\xaf\xff\xb0\xff\xb1\xff\xb4\xff\xb5\xff\xb6\xff\xb7\xff\xb8\xff\xc8\xff\x00\x00\x00\x00\xd7\xff\x00\x00\x00\x00\xba\xff\x00\x00\xa0\xff\x00\x00\x97\xff\x00\x00\x9a\xff\x99\xff\x00\x00\xbb\xff\xc1\xff\x00\x00\x92\xff\xd2\xff\x00\x00\xed\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\xff\xee\xff\xf2\xff\xf1\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf9\xff\xec\xff\x00\x00\x00\x00\xbe\xff\xc0\xff\x00\x00\x00\x00\xc3\xff\x00\x00\xc7\xff\x96\xff\xa6\xff\x9f\xff\xce\xff\x00\x00\x00\x00\x9b\xff\x00\x00\xd6\xff\xe1\xff\x00\x00\x00\x00\x98\xff\x00\x00\xd1\xff\x00\x00\x00\x00\x9b\xff\x00\x00\xe3\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\xff\xbd\xff\xe1\xff\x00\x00\xc5\xff\xd5\xff\x00\x00\xc7\xff\x00\x00\xb9\xff\x00\x00\xc6\xff\x00\x00\x00\x00\xc7\xff\x00\x00\xe3\xff\xe4\xff\x00\x00\x00\x00\x00\x00\xe5\xff\x00\x00\x00\x00\xe2\xff\x00\x00\x00\x00\xbf\xff\xbc\xff\xc4\xff\xd4\xff\xd3\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\xff\x00\x00\x00\x00\xe6\xff\xe7\xff"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x02\x00\x12\x00\x13\x00\x03\x00\x04\x00\x07\x00\x0f\x00\x06\x00\x03\x00\x0b\x00\x03\x00\x04\x00\x0e\x00\x0f\x00\x14\x00\x07\x00\x05\x00\x09\x00\x0c\x00\x0d\x00\x0e\x00\x08\x00\x02\x00\x09\x00\x0a\x00\x0f\x00\x0c\x00\x12\x00\x13\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x22\x00\x23\x00\x08\x00\x20\x00\x21\x00\x3a\x00\x3b\x00\x22\x00\x23\x00\x1a\x00\x1b\x00\x10\x00\x20\x00\x21\x00\x22\x00\x23\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x29\x00\x3d\x00\x10\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x3b\x00\x0f\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x07\x00\x0d\x00\x0e\x00\x18\x00\x0b\x00\x22\x00\x23\x00\x0e\x00\x0f\x00\x05\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x14\x00\x17\x00\x07\x00\x15\x00\x1f\x00\x16\x00\x0b\x00\x22\x00\x23\x00\x0e\x00\x0f\x00\x17\x00\x18\x00\x07\x00\x1a\x00\x1b\x00\x1c\x00\x0b\x00\x05\x00\x1f\x00\x0e\x00\x0f\x00\x22\x00\x23\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x17\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x05\x00\x2f\x00\x20\x00\x21\x00\x02\x00\x03\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x07\x00\x17\x00\x18\x00\x0b\x00\x0b\x00\x1b\x00\x1c\x00\x0e\x00\x0f\x00\x1f\x00\x19\x00\x07\x00\x22\x00\x23\x00\x19\x00\x20\x00\x11\x00\x21\x00\x0e\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x0b\x00\x0b\x00\x17\x00\x18\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x1f\x00\x0b\x00\x0b\x00\x22\x00\x23\x00\x08\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3c\x00\x00\x00\x01\x00\x02\x00\x08\x00\x3d\x00\x3c\x00\x06\x00\x07\x00\x17\x00\x18\x00\x0a\x00\x00\x00\x01\x00\x02\x00\x02\x00\x1e\x00\x1f\x00\x06\x00\x07\x00\x22\x00\x23\x00\x0a\x00\x02\x00\x16\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x22\x00\x23\x00\x16\x00\x02\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x08\x00\x22\x00\x23\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x02\x00\x3c\x00\x3c\x00\x08\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x02\x00\x3c\x00\x16\x00\x16\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x05\x00\x03\x00\x16\x00\x16\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x09\x00\x0a\x00\x04\x00\x0c\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x09\x00\x0a\x00\x04\x00\x0c\x00\x09\x00\x0a\x00\x02\x00\x0c\x00\x09\x00\x0a\x00\x3a\x00\x0c\x00\x05\x00\x20\x00\x21\x00\x22\x00\x23\x00\x09\x00\x0a\x00\x04\x00\x0c\x00\x08\x00\x16\x00\x20\x00\x21\x00\x22\x00\x23\x00\x20\x00\x21\x00\x22\x00\x23\x00\x20\x00\x21\x00\x22\x00\x23\x00\x09\x00\x0a\x00\x06\x00\x0c\x00\x3c\x00\x20\x00\x21\x00\x22\x00\x23\x00\x09\x00\x0a\x00\x3b\x00\x0c\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x08\x00\x3c\x00\x3c\x00\x20\x00\x21\x00\x22\x00\x23\x00\x1a\x00\x1b\x00\x3d\x00\x06\x00\x16\x00\x20\x00\x21\x00\x22\x00\x23\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x03\x00\x16\x00\x16\x00\x16\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x06\x00\x16\x00\x3d\x00\x03\x00\x3a\x00\x02\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x08\x00\x03\x00\x05\x00\x01\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x04\x00\x29\x00\x2a\x00\x01\x00\x3d\x00\x16\x00\x3d\x00\x3d\x00\x30\x00\x22\x00\x3d\x00\x3c\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x2b\x00\x3b\x00\x02\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x07\x00\x3b\x00\x1a\x00\x1b\x00\x08\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x02\x00\x02\x00\x16\x00\x02\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x07\x00\x16\x00\x16\x00\x16\x00\x16\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x3d\x00\x32\x00\x06\x00\x33\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x07\x00\x16\x00\x08\x00\x08\x00\x04\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x28\x00\x09\x00\x20\x00\x0a\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x08\x00\x3d\x00\x32\x00\x08\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x0d\x00\x0e\x00\x0d\x00\x0e\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x17\x00\x18\x00\x17\x00\x18\x00\x02\x00\x0d\x00\x0e\x00\x3c\x00\x1f\x00\x3d\x00\x1f\x00\x22\x00\x23\x00\x22\x00\x23\x00\x17\x00\x18\x00\x3d\x00\x0d\x00\x0e\x00\x06\x00\x3d\x00\x3d\x00\x1f\x00\x3d\x00\x3c\x00\x22\x00\x23\x00\x17\x00\x18\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x1f\x00\x16\x00\x06\x00\x22\x00\x23\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x3d\x00\x3b\x00\x02\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x16\x00\x16\x00\x2f\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x08\x00\x16\x00\x16\x00\x16\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x18\x00\x16\x00\x3b\x00\x07\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x17\x00\x18\x00\x08\x00\x1a\x00\x1b\x00\x1c\x00\x3c\x00\x02\x00\x1f\x00\x19\x00\x0a\x00\x22\x00\x23\x00\x17\x00\x18\x00\x3b\x00\x1a\x00\x1b\x00\x1c\x00\x05\x00\x3d\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x3b\x00\x09\x00\x1d\x00\x1e\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x3d\x00\x3d\x00\x1d\x00\x1e\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x3d\x00\x17\x00\x18\x00\x01\x00\x1f\x00\x3d\x00\x3d\x00\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x05\x00\x17\x00\x18\x00\x07\x00\x1f\x00\x3d\x00\x04\x00\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x05\x00\x17\x00\x18\x00\x04\x00\x1f\x00\x16\x00\x3b\x00\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x3c\x00\x17\x00\x18\x00\x3b\x00\x1f\x00\x16\x00\x16\x00\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x05\x00\x17\x00\x18\x00\x16\x00\x1f\x00\x16\x00\x16\x00\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x01\x00\x17\x00\x18\x00\x09\x00\x1f\x00\x02\x00\x04\x00\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x02\x00\x17\x00\x18\x00\x3b\x00\x1f\x00\x3b\x00\x3b\x00\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x03\x00\x17\x00\x18\x00\x3b\x00\x1f\x00\x3b\x00\x3b\x00\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x02\x00\x17\x00\x18\x00\x16\x00\x1f\x00\x03\x00\x3b\x00\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x3c\x00\x17\x00\x18\x00\x3b\x00\x1f\x00\x07\x00\x07\x00\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x07\x00\x17\x00\x18\x00\x07\x00\x1f\x00\x07\x00\x07\x00\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\x3f\x00\x17\x00\x18\x00\x3b\x00\x1f\x00\xff\xff\xff\xff\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\xff\xff\x17\x00\x18\x00\xff\xff\x1f\x00\xff\xff\xff\xff\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\xff\xff\x17\x00\x18\x00\xff\xff\x1f\x00\xff\xff\xff\xff\x22\x00\x23\x00\x1f\x00\x17\x00\x18\x00\x22\x00\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\xff\xff\x22\x00\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\xad\x00\x08\x01\xea\x00\xad\x00\x47\x00\x5f\x00\x46\x01\xb4\x00\x8d\x00\x60\x00\x46\x00\x47\x00\x61\x00\x62\x00\x2d\x01\x57\x00\x6f\x00\x8f\xff\x7d\x00\x7e\x00\x7f\x00\x44\x01\x30\x00\x38\x01\x2a\x00\x34\x01\x2b\x00\xe9\x00\xea\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x48\x00\x49\x00\x28\x01\x8e\x00\x8f\x00\x36\x00\x56\x00\x48\x00\x49\x00\x87\x00\x88\x00\x49\x01\x2c\x00\x2d\x00\x2e\x00\x09\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x11\x00\xb5\x00\x2f\x01\x31\x00\x32\x00\x33\x00\x34\x00\x13\x00\x35\x00\x1d\x00\x18\x01\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x36\x00\x37\x00\x38\x00\x6b\x00\xc7\x00\x68\x00\x0f\x01\x60\x00\xc6\x00\x09\x00\x61\x00\x62\x00\x04\x01\x5c\x00\x69\x00\x5b\x00\x5d\x00\x09\x00\x06\x01\x6c\x00\x5f\x00\x09\x01\x5c\x00\x11\x01\x60\x00\x5d\x00\x09\x00\x61\x00\x62\x00\xe4\x00\x5b\x00\x6b\x00\x2b\x01\xe6\x00\xe7\x00\x60\x00\xf8\x00\x5c\x00\x61\x00\x62\x00\x5d\x00\x09\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x6c\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\xba\x00\x76\x00\x8e\x00\x8f\x00\x27\x00\x28\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x5f\x00\xe4\x00\x5b\x00\x45\x00\x60\x00\x1a\x01\xe7\x00\x61\x00\x62\x00\x5c\x00\x8f\x00\x5f\x00\x5d\x00\x09\x00\x91\x00\x54\x00\x57\x00\x6c\x00\x61\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x25\x00\x1b\x00\x05\x01\x5b\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x5c\x00\x1e\x00\x25\x00\x5d\x00\x09\x00\x55\x01\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x0f\x01\x28\x00\x03\x00\x04\x00\x56\x01\x53\x01\x54\x01\x05\x00\x06\x00\x9c\x00\x5b\x00\x07\x00\x02\x00\x03\x00\x04\x00\x17\x01\xec\x00\x5c\x00\x05\x00\x06\x00\x5d\x00\x09\x00\x07\x00\x4c\x01\x50\x01\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x08\x00\x09\x00\x51\x01\xb0\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x52\x01\x08\x00\x09\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xde\x00\x4d\x01\x4e\x01\x42\x01\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x99\x00\x4f\x01\x43\x01\x44\x01\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x1a\x01\xc0\x00\x2a\x01\x46\x01\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x39\x01\x2a\x00\x48\x01\x2b\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x32\x01\x2a\x00\x49\x01\x2b\x00\xc9\x00\x2a\x00\x4b\x01\x2b\x00\x71\x00\x2a\x00\x31\x01\x2b\x00\x1a\x01\x2c\x00\x2d\x00\x2e\x00\x09\x00\x72\x00\x2a\x00\x36\x01\x2b\x00\x3b\x01\x37\x01\x2c\x00\x2d\x00\x2e\x00\x09\x00\x2c\x00\x2d\x00\x2e\x00\x09\x00\x2c\x00\x2d\x00\x2e\x00\x09\x00\x29\x00\x2a\x00\x38\x01\x2b\x00\x3c\x01\x2c\x00\x2d\x00\x2e\x00\x09\x00\x43\x00\x2a\x00\x3d\x01\x2b\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x3e\x01\x3f\x01\x41\x01\x2c\x00\x2d\x00\x2e\x00\x09\x00\x87\x00\x88\x00\x40\x01\xe3\x00\x26\x01\x2c\x00\x2d\x00\x2e\x00\x09\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x2d\x01\x27\x01\x28\x01\x2a\x01\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\xdc\x00\x2b\x01\x08\x01\x2f\x01\x31\x01\x32\x01\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x34\x01\x18\x01\x1a\x01\x1c\x01\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x1d\x01\x11\x00\x12\x00\x1f\x01\x21\x01\x1e\x01\x22\x01\x23\x01\x13\x00\x4b\x00\x24\x01\x25\x01\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x4c\x00\x1a\x00\xfb\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x4d\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x20\x01\x4e\x00\x87\x00\x88\x00\xfc\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xfd\x00\xfe\x00\xff\x00\x04\x01\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x15\x01\x00\x01\x01\x01\x02\x01\x03\x01\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x08\x01\xec\x00\x0c\x01\x0b\x01\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\xc2\x00\x0d\x01\x0e\x01\x11\x01\xe1\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x13\x01\xe0\x00\x8e\x00\xe4\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\xc5\x00\xe9\x00\xec\x00\xf1\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xc8\x00\x68\x00\x78\x00\x68\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x69\x00\x5b\x00\x69\x00\x5b\x00\xee\x00\x79\x00\x7a\x00\xef\x00\x5c\x00\xf2\x00\x5c\x00\x5d\x00\x09\x00\x5d\x00\x09\x00\x7b\x00\x5b\x00\xf3\x00\x67\x00\x68\x00\xf7\x00\xf4\x00\xf5\x00\x5c\x00\xf6\x00\xf8\x00\x5d\x00\x09\x00\x69\x00\x5b\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x5c\x00\xbc\x00\xfa\x00\x5d\x00\x09\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xbc\x00\xb1\x00\xb2\x00\xb3\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xbf\x00\xb6\x00\xb7\x00\xbd\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x00\x00\x00\x00\xbe\x00\xb8\x00\xb9\x00\xba\x00\x87\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\xc1\x00\xbc\x00\xc3\x00\xc6\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\xe4\x00\x5b\x00\xdb\x00\x15\x01\xe6\x00\xe7\x00\xdd\x00\x78\x00\x5c\x00\x91\x00\x98\x00\x5d\x00\x09\x00\xe4\x00\x5b\x00\x94\x00\xe5\x00\xe6\x00\xe7\x00\x97\x00\x9b\x00\x5c\x00\x9c\x00\x5b\x00\x5d\x00\x09\x00\xa1\x00\xa0\x00\xe1\x00\x9e\x00\x5c\x00\x9c\x00\x5b\x00\x5d\x00\x09\x00\xa2\x00\xa3\x00\x9d\x00\x9e\x00\x5c\x00\x13\x01\x5b\x00\x5d\x00\x09\x00\xa4\x00\xde\x00\x5b\x00\xa7\x00\x5c\x00\xa5\x00\xa6\x00\x5d\x00\x09\x00\x5c\x00\xef\x00\x5b\x00\x5d\x00\x09\x00\xa8\x00\xc3\x00\x5b\x00\xaa\x00\x5c\x00\xa9\x00\xaf\x00\x5d\x00\x09\x00\x5c\x00\xca\x00\x5b\x00\x5d\x00\x09\x00\xab\x00\xcb\x00\x5b\x00\x45\x00\x5c\x00\x4f\x00\x1d\x00\x5d\x00\x09\x00\x5c\x00\xcc\x00\x5b\x00\x5d\x00\x09\x00\x5a\x00\xcd\x00\x5b\x00\x6e\x00\x5c\x00\x50\x00\x51\x00\x5d\x00\x09\x00\x5c\x00\xce\x00\x5b\x00\x5d\x00\x09\x00\x59\x00\xcf\x00\x5b\x00\x52\x00\x5c\x00\x53\x00\x54\x00\x5d\x00\x09\x00\x5c\x00\xd0\x00\x5b\x00\x5d\x00\x09\x00\x70\x00\xd1\x00\x5b\x00\x71\x00\x5c\x00\x39\x00\x74\x00\x5d\x00\x09\x00\x5c\x00\xd2\x00\x5b\x00\x5d\x00\x09\x00\x40\x00\xd3\x00\x5b\x00\x3a\x00\x5c\x00\x3b\x00\x3c\x00\x5d\x00\x09\x00\x5c\x00\xd4\x00\x5b\x00\x5d\x00\x09\x00\x41\x00\xd5\x00\x5b\x00\x3d\x00\x5c\x00\x3e\x00\x3f\x00\x5d\x00\x09\x00\x5c\x00\xd6\x00\x5b\x00\x5d\x00\x09\x00\x43\x00\xd7\x00\x5b\x00\x42\x00\x5c\x00\x1b\x00\x1d\x00\x5d\x00\x09\x00\x5c\x00\xd8\x00\x5b\x00\x5d\x00\x09\x00\x1e\x00\xd9\x00\x5b\x00\x1d\x00\x5c\x00\x20\x00\x21\x00\x5d\x00\x09\x00\x5c\x00\x74\x00\x5b\x00\x5d\x00\x09\x00\x22\x00\x76\x00\x5b\x00\x23\x00\x5c\x00\x24\x00\x25\x00\x5d\x00\x09\x00\x5c\x00\x92\x00\x5b\x00\x5d\x00\x09\x00\xff\xff\x94\x00\x5b\x00\x1d\x00\x5c\x00\x00\x00\x00\x00\x5d\x00\x09\x00\x5c\x00\x95\x00\x5b\x00\x5d\x00\x09\x00\x00\x00\x99\x00\x5b\x00\x00\x00\x5c\x00\x00\x00\x00\x00\x5d\x00\x09\x00\x5c\x00\x9b\x00\x5b\x00\x5d\x00\x09\x00\x00\x00\xab\x00\x5b\x00\x00\x00\x5c\x00\x00\x00\x00\x00\x5d\x00\x09\x00\x5c\x00\x5a\x00\x5b\x00\x5d\x00\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5c\x00\x00\x00\x00\x00\x5d\x00\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = array (1, 121) [
	(1 , happyReduce_1),
	(2 , happyReduce_2),
	(3 , happyReduce_3),
	(4 , happyReduce_4),
	(5 , happyReduce_5),
	(6 , happyReduce_6),
	(7 , happyReduce_7),
	(8 , happyReduce_8),
	(9 , happyReduce_9),
	(10 , happyReduce_10),
	(11 , happyReduce_11),
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121)
	]

happy_n_terms = 64 :: Int
happy_n_nonterms = 36 :: Int

happyReduce_1 = happySpecReduce_0 0# happyReduction_1
happyReduction_1  =  happyIn4
		 (return ()
	)

happyReduce_2 = happySpecReduce_2 0# happyReduction_2
happyReduction_2 happy_x_2
	happy_x_1
	 =  case happyOut5 happy_x_1 of { happy_var_1 -> 
	case happyOut4 happy_x_2 of { happy_var_2 -> 
	happyIn4
		 (do happy_var_1; happy_var_2
	)}}

happyReduce_3 = happySpecReduce_1 1# happyReduction_3
happyReduction_3 happy_x_1
	 =  case happyOut10 happy_x_1 of { happy_var_1 -> 
	happyIn5
		 (happy_var_1
	)}

happyReduce_4 = happySpecReduce_1 1# happyReduction_4
happyReduction_4 happy_x_1
	 =  case happyOut6 happy_x_1 of { happy_var_1 -> 
	happyIn5
		 (happy_var_1
	)}

happyReduce_5 = happySpecReduce_1 1# happyReduction_5
happyReduction_5 happy_x_1
	 =  case happyOut14 happy_x_1 of { happy_var_1 -> 
	happyIn5
		 (happy_var_1
	)}

happyReduce_6 = happyReduce 8# 1# happyReduction_6
happyReduction_6 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_3 of { (L _ (CmmT_Name	happy_var_3)) -> 
	case happyOutTok happy_x_5 of { (L _ (CmmT_Name	happy_var_5)) -> 
	case happyOut9 happy_x_6 of { happy_var_6 -> 
	happyIn5
		 (do lits <- sequence happy_var_6;
		     staticClosure happy_var_3 happy_var_5 (map getLit lits)
	) `HappyStk` happyRest}}}

happyReduce_7 = happyReduce 5# 2# happyReduction_7
happyReduction_7 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (L _ (CmmT_String	happy_var_2)) -> 
	case happyOut7 happy_x_4 of { happy_var_4 -> 
	happyIn6
		 (do ss <- sequence happy_var_4;
		     code (emitData (section happy_var_2) (concat ss))
	) `HappyStk` happyRest}}

happyReduce_8 = happySpecReduce_0 3# happyReduction_8
happyReduction_8  =  happyIn7
		 ([]
	)

happyReduce_9 = happySpecReduce_2 3# happyReduction_9
happyReduction_9 happy_x_2
	happy_x_1
	 =  case happyOut8 happy_x_1 of { happy_var_1 -> 
	case happyOut7 happy_x_2 of { happy_var_2 -> 
	happyIn7
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_10 = happySpecReduce_2 4# happyReduction_10
happyReduction_10 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_Name	happy_var_1)) -> 
	happyIn8
		 (return [CmmDataLabel (mkRtsDataLabelFS happy_var_1)]
	)}

happyReduce_11 = happySpecReduce_3 4# happyReduction_11
happyReduction_11 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_2 of { happy_var_2 -> 
	happyIn8
		 (do e <- happy_var_2;
			     return [CmmStaticLit (getLit e)]
	)}

happyReduce_12 = happySpecReduce_2 4# happyReduction_12
happyReduction_12 happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	happyIn8
		 (return [CmmUninitialised
							(machRepByteWidth happy_var_1)]
	)}

happyReduce_13 = happyReduce 5# 4# happyReduction_13
happyReduction_13 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_4 of { (L _ (CmmT_String	happy_var_4)) -> 
	happyIn8
		 (return [CmmString happy_var_4]
	) `HappyStk` happyRest}

happyReduce_14 = happyReduce 5# 4# happyReduction_14
happyReduction_14 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_3 of { (L _ (CmmT_Int		happy_var_3)) -> 
	happyIn8
		 (return [CmmUninitialised 
							(fromIntegral happy_var_3)]
	) `HappyStk` happyRest}

happyReduce_15 = happyReduce 5# 4# happyReduction_15
happyReduction_15 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut39 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_3 of { (L _ (CmmT_Int		happy_var_3)) -> 
	happyIn8
		 (return [CmmUninitialised 
						(machRepByteWidth happy_var_1 * 
							fromIntegral happy_var_3)]
	) `HappyStk` happyRest}}

happyReduce_16 = happySpecReduce_3 4# happyReduction_16
happyReduction_16 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_2 of { (L _ (CmmT_Int		happy_var_2)) -> 
	happyIn8
		 (return [CmmAlign (fromIntegral happy_var_2)]
	)}

happyReduce_17 = happyReduce 5# 4# happyReduction_17
happyReduction_17 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_3 of { (L _ (CmmT_Name	happy_var_3)) -> 
	case happyOut9 happy_x_4 of { happy_var_4 -> 
	happyIn8
		 (do lits <- sequence happy_var_4;
		     return $ map CmmStaticLit $
		       mkStaticClosure (mkRtsInfoLabelFS happy_var_3) 
			 dontCareCCS (map getLit lits) [] []
	) `HappyStk` happyRest}}

happyReduce_18 = happySpecReduce_0 5# happyReduction_18
happyReduction_18  =  happyIn9
		 ([]
	)

happyReduce_19 = happySpecReduce_3 5# happyReduction_19
happyReduction_19 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_2 of { happy_var_2 -> 
	case happyOut9 happy_x_3 of { happy_var_3 -> 
	happyIn9
		 (happy_var_2 : happy_var_3
	)}}

happyReduce_20 = happyReduce 4# 6# happyReduction_20
happyReduction_20 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut11 happy_x_1 of { happy_var_1 -> 
	case happyOut13 happy_x_3 of { happy_var_3 -> 
	happyIn10
		 (do  (info_lbl, info1, info2) <- happy_var_1;
		      stmts <- getCgStmtsEC (loopDecls happy_var_3)
		      blks <- code (cgStmtsToBlocks stmts)
		      code (emitInfoTableAndCode info_lbl info1 info2 [] blks)
	) `HappyStk` happyRest}}

happyReduce_21 = happySpecReduce_2 6# happyReduction_21
happyReduction_21 happy_x_2
	happy_x_1
	 =  case happyOut11 happy_x_1 of { happy_var_1 -> 
	happyIn10
		 (do (info_lbl, info1, info2) <- happy_var_1;
		     code (emitInfoTableAndCode info_lbl info1 info2 [] [])
	)}

happyReduce_22 = happyReduce 4# 6# happyReduction_22
happyReduction_22 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (L _ (CmmT_Name	happy_var_1)) -> 
	case happyOut13 happy_x_3 of { happy_var_3 -> 
	happyIn10
		 (do stmts <- getCgStmtsEC (loopDecls happy_var_3);
		     blks <- code (cgStmtsToBlocks stmts)
		     code (emitProc [] (mkRtsCodeLabelFS happy_var_1) [] blks)
	) `HappyStk` happyRest}}

happyReduce_23 = happyReduce 14# 7# happyReduction_23
happyReduction_23 (happy_x_14 `HappyStk`
	happy_x_13 `HappyStk`
	happy_x_12 `HappyStk`
	happy_x_11 `HappyStk`
	happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_3 of { (L _ (CmmT_Name	happy_var_3)) -> 
	case happyOutTok happy_x_5 of { (L _ (CmmT_Int		happy_var_5)) -> 
	case happyOutTok happy_x_7 of { (L _ (CmmT_Int		happy_var_7)) -> 
	case happyOutTok happy_x_9 of { (L _ (CmmT_Int		happy_var_9)) -> 
	case happyOutTok happy_x_11 of { (L _ (CmmT_String	happy_var_11)) -> 
	case happyOutTok happy_x_13 of { (L _ (CmmT_String	happy_var_13)) -> 
	happyIn11
		 (stdInfo happy_var_3 happy_var_5 happy_var_7 0 happy_var_9 happy_var_11 happy_var_13
	) `HappyStk` happyRest}}}}}}

happyReduce_24 = happyReduce 16# 7# happyReduction_24
happyReduction_24 (happy_x_16 `HappyStk`
	happy_x_15 `HappyStk`
	happy_x_14 `HappyStk`
	happy_x_13 `HappyStk`
	happy_x_12 `HappyStk`
	happy_x_11 `HappyStk`
	happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_3 of { (L _ (CmmT_Name	happy_var_3)) -> 
	case happyOutTok happy_x_5 of { (L _ (CmmT_Int		happy_var_5)) -> 
	case happyOutTok happy_x_7 of { (L _ (CmmT_Int		happy_var_7)) -> 
	case happyOutTok happy_x_9 of { (L _ (CmmT_Int		happy_var_9)) -> 
	case happyOutTok happy_x_11 of { (L _ (CmmT_String	happy_var_11)) -> 
	case happyOutTok happy_x_13 of { (L _ (CmmT_String	happy_var_13)) -> 
	case happyOutTok happy_x_15 of { (L _ (CmmT_Int		happy_var_15)) -> 
	happyIn11
		 (funInfo happy_var_3 happy_var_5 happy_var_7 happy_var_9 happy_var_11 happy_var_13 happy_var_15
	) `HappyStk` happyRest}}}}}}}

happyReduce_25 = happyReduce 16# 7# happyReduction_25
happyReduction_25 (happy_x_16 `HappyStk`
	happy_x_15 `HappyStk`
	happy_x_14 `HappyStk`
	happy_x_13 `HappyStk`
	happy_x_12 `HappyStk`
	happy_x_11 `HappyStk`
	happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_3 of { (L _ (CmmT_Name	happy_var_3)) -> 
	case happyOutTok happy_x_5 of { (L _ (CmmT_Int		happy_var_5)) -> 
	case happyOutTok happy_x_7 of { (L _ (CmmT_Int		happy_var_7)) -> 
	case happyOutTok happy_x_9 of { (L _ (CmmT_Int		happy_var_9)) -> 
	case happyOutTok happy_x_11 of { (L _ (CmmT_Int		happy_var_11)) -> 
	case happyOutTok happy_x_13 of { (L _ (CmmT_String	happy_var_13)) -> 
	case happyOutTok happy_x_15 of { (L _ (CmmT_String	happy_var_15)) -> 
	happyIn11
		 (stdInfo happy_var_3 happy_var_5 happy_var_7 happy_var_9 happy_var_11 happy_var_13 happy_var_15
	) `HappyStk` happyRest}}}}}}}

happyReduce_26 = happyReduce 12# 7# happyReduction_26
happyReduction_26 (happy_x_12 `HappyStk`
	happy_x_11 `HappyStk`
	happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_3 of { (L _ (CmmT_Name	happy_var_3)) -> 
	case happyOutTok happy_x_5 of { (L _ (CmmT_Int		happy_var_5)) -> 
	case happyOutTok happy_x_7 of { (L _ (CmmT_Int		happy_var_7)) -> 
	case happyOutTok happy_x_9 of { (L _ (CmmT_String	happy_var_9)) -> 
	case happyOutTok happy_x_11 of { (L _ (CmmT_String	happy_var_11)) -> 
	happyIn11
		 (basicInfo happy_var_3 (mkIntCLit (fromIntegral happy_var_5)) 0 happy_var_7 happy_var_9 happy_var_11
	) `HappyStk` happyRest}}}}}

happyReduce_27 = happyReduce 11# 7# happyReduction_27
happyReduction_27 (happy_x_11 `HappyStk`
	happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_3 of { (L _ (CmmT_Name	happy_var_3)) -> 
	case happyOutTok happy_x_5 of { (L _ (CmmT_Int		happy_var_5)) -> 
	case happyOutTok happy_x_7 of { (L _ (CmmT_Int		happy_var_7)) -> 
	case happyOutTok happy_x_9 of { (L _ (CmmT_Int		happy_var_9)) -> 
	case happyOut12 happy_x_10 of { happy_var_10 -> 
	happyIn11
		 (retInfo happy_var_3 happy_var_5 happy_var_7 happy_var_9 happy_var_10
	) `HappyStk` happyRest}}}}}

happyReduce_28 = happySpecReduce_0 8# happyReduction_28
happyReduction_28  =  happyIn12
		 ([]
	)

happyReduce_29 = happySpecReduce_3 8# happyReduction_29
happyReduction_29 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_2 of { (L _ (CmmT_Name	happy_var_2)) -> 
	case happyOut12 happy_x_3 of { happy_var_3 -> 
	happyIn12
		 (CmmLabel (mkRtsCodeLabelFS happy_var_2) : happy_var_3
	)}}

happyReduce_30 = happySpecReduce_0 9# happyReduction_30
happyReduction_30  =  happyIn13
		 (return ()
	)

happyReduce_31 = happySpecReduce_2 9# happyReduction_31
happyReduction_31 happy_x_2
	happy_x_1
	 =  case happyOut14 happy_x_1 of { happy_var_1 -> 
	case happyOut13 happy_x_2 of { happy_var_2 -> 
	happyIn13
		 (do happy_var_1; happy_var_2
	)}}

happyReduce_32 = happySpecReduce_2 9# happyReduction_32
happyReduction_32 happy_x_2
	happy_x_1
	 =  case happyOut16 happy_x_1 of { happy_var_1 -> 
	case happyOut13 happy_x_2 of { happy_var_2 -> 
	happyIn13
		 (do happy_var_1; happy_var_2
	)}}

happyReduce_33 = happySpecReduce_3 10# happyReduction_33
happyReduction_33 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut15 happy_x_2 of { happy_var_2 -> 
	happyIn14
		 (mapM_ (newLocal happy_var_1) happy_var_2
	)}}

happyReduce_34 = happySpecReduce_3 10# happyReduction_34
happyReduction_34 happy_x_3
	happy_x_2
	happy_x_1
	 =  happyIn14
		 (return ()
	)

happyReduce_35 = happySpecReduce_3 10# happyReduction_35
happyReduction_35 happy_x_3
	happy_x_2
	happy_x_1
	 =  happyIn14
		 (return ()
	)

happyReduce_36 = happySpecReduce_1 11# happyReduction_36
happyReduction_36 happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_Name	happy_var_1)) -> 
	happyIn15
		 ([happy_var_1]
	)}

happyReduce_37 = happySpecReduce_3 11# happyReduction_37
happyReduction_37 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_Name	happy_var_1)) -> 
	case happyOut15 happy_x_3 of { happy_var_3 -> 
	happyIn15
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_38 = happySpecReduce_1 12# happyReduction_38
happyReduction_38 happy_x_1
	 =  happyIn16
		 (nopEC
	)

happyReduce_39 = happySpecReduce_2 12# happyReduction_39
happyReduction_39 happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	happyIn16
		 (code (labelC happy_var_1)
	)}

happyReduce_40 = happyReduce 4# 12# happyReduction_40
happyReduction_40 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut36 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn16
		 (do reg <- happy_var_1; e <- happy_var_3; stmtEC (CmmAssign reg e)
	) `HappyStk` happyRest}}

happyReduce_41 = happyReduce 7# 12# happyReduction_41
happyReduction_41 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	case happyOut27 happy_x_6 of { happy_var_6 -> 
	happyIn16
		 (doStore happy_var_1 happy_var_3 happy_var_6
	) `HappyStk` happyRest}}}

happyReduce_42 = happyMonadReduce 8# 12# happyReduction_42
happyReduction_42 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_2 of { (L _ (CmmT_String	happy_var_2)) -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	case happyOut30 happy_x_5 of { happy_var_5 -> 
	case happyOut19 happy_x_7 of { happy_var_7 -> 
	 foreignCall happy_var_2 [] happy_var_3 happy_var_5 happy_var_7}}}}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_43 = happyMonadReduce 10# 12# happyReduction_43
happyReduction_43 (happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut36 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_4 of { (L _ (CmmT_String	happy_var_4)) -> 
	case happyOut27 happy_x_5 of { happy_var_5 -> 
	case happyOut30 happy_x_7 of { happy_var_7 -> 
	case happyOut19 happy_x_9 of { happy_var_9 -> 
	 let result = do r <- happy_var_1; return (r,NoHint) in
		   foreignCall happy_var_4 [result] happy_var_5 happy_var_7 happy_var_9}}}}}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_44 = happyMonadReduce 11# 12# happyReduction_44
happyReduction_44 (happy_x_11 `HappyStk`
	happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { (L _ (CmmT_String	happy_var_1)) -> 
	case happyOut36 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_5 of { (L _ (CmmT_String	happy_var_5)) -> 
	case happyOut27 happy_x_6 of { happy_var_6 -> 
	case happyOut30 happy_x_8 of { happy_var_8 -> 
	case happyOut19 happy_x_10 of { happy_var_10 -> 
	 do h <- parseHint happy_var_1;
		      let result = do r <- happy_var_2; return (r,h) in
		      foreignCall happy_var_5 [result] happy_var_6 happy_var_8 happy_var_10}}}}}}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_45 = happyMonadReduce 5# 12# happyReduction_45
happyReduction_45 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { (L _ (CmmT_Name	happy_var_1)) -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	 stmtMacro happy_var_1 happy_var_3}}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_46 = happyReduce 7# 12# happyReduction_46
happyReduction_46 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut21 happy_x_2 of { happy_var_2 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	case happyOut22 happy_x_5 of { happy_var_5 -> 
	case happyOut25 happy_x_6 of { happy_var_6 -> 
	happyIn16
		 (doSwitch happy_var_2 happy_var_3 happy_var_5 happy_var_6
	) `HappyStk` happyRest}}}}

happyReduce_47 = happySpecReduce_3 12# happyReduction_47
happyReduction_47 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_2 of { happy_var_2 -> 
	happyIn16
		 (stmtEC (CmmBranch happy_var_2)
	)}

happyReduce_48 = happySpecReduce_3 12# happyReduction_48
happyReduction_48 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_2 of { happy_var_2 -> 
	happyIn16
		 (do e <- happy_var_2; stmtEC (CmmJump e [])
	)}

happyReduce_49 = happyReduce 6# 12# happyReduction_49
happyReduction_49 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut17 happy_x_2 of { happy_var_2 -> 
	case happyOut13 happy_x_4 of { happy_var_4 -> 
	case happyOut26 happy_x_6 of { happy_var_6 -> 
	happyIn16
		 (ifThenElse happy_var_2 happy_var_4 happy_var_6
	) `HappyStk` happyRest}}}

happyReduce_50 = happySpecReduce_1 13# happyReduction_50
happyReduction_50 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn17
		 (happy_var_1
	)}

happyReduce_51 = happySpecReduce_1 13# happyReduction_51
happyReduction_51 happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn17
		 (do e <- happy_var_1; return (BoolTest e)
	)}

happyReduce_52 = happySpecReduce_3 14# happyReduction_52
happyReduction_52 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut17 happy_x_3 of { happy_var_3 -> 
	happyIn18
		 (do e1 <- happy_var_1; e2 <- happy_var_3; 
					  return (BoolAnd e1 e2)
	)}}

happyReduce_53 = happySpecReduce_3 14# happyReduction_53
happyReduction_53 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut17 happy_x_3 of { happy_var_3 -> 
	happyIn18
		 (do e1 <- happy_var_1; e2 <- happy_var_3; 
					  return (BoolOr e1 e2)
	)}}

happyReduce_54 = happySpecReduce_2 14# happyReduction_54
happyReduction_54 happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_2 of { happy_var_2 -> 
	happyIn18
		 (do e <- happy_var_2; return (BoolNot e)
	)}

happyReduce_55 = happySpecReduce_3 14# happyReduction_55
happyReduction_55 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_2 of { happy_var_2 -> 
	happyIn18
		 (happy_var_2
	)}

happyReduce_56 = happySpecReduce_0 15# happyReduction_56
happyReduction_56  =  happyIn19
		 (Nothing
	)

happyReduce_57 = happySpecReduce_3 15# happyReduction_57
happyReduction_57 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut20 happy_x_2 of { happy_var_2 -> 
	happyIn19
		 (Just happy_var_2
	)}

happyReduce_58 = happySpecReduce_1 16# happyReduction_58
happyReduction_58 happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_GlobalReg   happy_var_1)) -> 
	happyIn20
		 ([happy_var_1]
	)}

happyReduce_59 = happySpecReduce_3 16# happyReduction_59
happyReduction_59 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_GlobalReg   happy_var_1)) -> 
	case happyOut20 happy_x_3 of { happy_var_3 -> 
	happyIn20
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_60 = happyReduce 5# 17# happyReduction_60
happyReduction_60 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (L _ (CmmT_Int		happy_var_2)) -> 
	case happyOutTok happy_x_4 of { (L _ (CmmT_Int		happy_var_4)) -> 
	happyIn21
		 (Just (fromIntegral happy_var_2, fromIntegral happy_var_4)
	) `HappyStk` happyRest}}

happyReduce_61 = happySpecReduce_0 17# happyReduction_61
happyReduction_61  =  happyIn21
		 (Nothing
	)

happyReduce_62 = happySpecReduce_0 18# happyReduction_62
happyReduction_62  =  happyIn22
		 ([]
	)

happyReduce_63 = happySpecReduce_2 18# happyReduction_63
happyReduction_63 happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_1 of { happy_var_1 -> 
	case happyOut22 happy_x_2 of { happy_var_2 -> 
	happyIn22
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_64 = happyReduce 6# 19# happyReduction_64
happyReduction_64 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut24 happy_x_2 of { happy_var_2 -> 
	case happyOut13 happy_x_5 of { happy_var_5 -> 
	happyIn23
		 ((happy_var_2, happy_var_5)
	) `HappyStk` happyRest}}

happyReduce_65 = happySpecReduce_1 20# happyReduction_65
happyReduction_65 happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_Int		happy_var_1)) -> 
	happyIn24
		 ([ fromIntegral happy_var_1 ]
	)}

happyReduce_66 = happySpecReduce_3 20# happyReduction_66
happyReduction_66 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_Int		happy_var_1)) -> 
	case happyOut24 happy_x_3 of { happy_var_3 -> 
	happyIn24
		 (fromIntegral happy_var_1 : happy_var_3
	)}}

happyReduce_67 = happyReduce 5# 21# happyReduction_67
happyReduction_67 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut13 happy_x_4 of { happy_var_4 -> 
	happyIn25
		 (Just happy_var_4
	) `HappyStk` happyRest}

happyReduce_68 = happySpecReduce_0 21# happyReduction_68
happyReduction_68  =  happyIn25
		 (Nothing
	)

happyReduce_69 = happySpecReduce_0 22# happyReduction_69
happyReduction_69  =  happyIn26
		 (nopEC
	)

happyReduce_70 = happyReduce 4# 22# happyReduction_70
happyReduction_70 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut13 happy_x_3 of { happy_var_3 -> 
	happyIn26
		 (happy_var_3
	) `HappyStk` happyRest}

happyReduce_71 = happySpecReduce_3 23# happyReduction_71
happyReduction_71 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_U_Quot [happy_var_1,happy_var_3]
	)}}

happyReduce_72 = happySpecReduce_3 23# happyReduction_72
happyReduction_72 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_Mul [happy_var_1,happy_var_3]
	)}}

happyReduce_73 = happySpecReduce_3 23# happyReduction_73
happyReduction_73 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_U_Rem [happy_var_1,happy_var_3]
	)}}

happyReduce_74 = happySpecReduce_3 23# happyReduction_74
happyReduction_74 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_Sub [happy_var_1,happy_var_3]
	)}}

happyReduce_75 = happySpecReduce_3 23# happyReduction_75
happyReduction_75 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_Add [happy_var_1,happy_var_3]
	)}}

happyReduce_76 = happySpecReduce_3 23# happyReduction_76
happyReduction_76 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_U_Shr [happy_var_1,happy_var_3]
	)}}

happyReduce_77 = happySpecReduce_3 23# happyReduction_77
happyReduction_77 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_Shl [happy_var_1,happy_var_3]
	)}}

happyReduce_78 = happySpecReduce_3 23# happyReduction_78
happyReduction_78 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_And [happy_var_1,happy_var_3]
	)}}

happyReduce_79 = happySpecReduce_3 23# happyReduction_79
happyReduction_79 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_Xor [happy_var_1,happy_var_3]
	)}}

happyReduce_80 = happySpecReduce_3 23# happyReduction_80
happyReduction_80 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_Or [happy_var_1,happy_var_3]
	)}}

happyReduce_81 = happySpecReduce_3 23# happyReduction_81
happyReduction_81 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_U_Ge [happy_var_1,happy_var_3]
	)}}

happyReduce_82 = happySpecReduce_3 23# happyReduction_82
happyReduction_82 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_U_Gt [happy_var_1,happy_var_3]
	)}}

happyReduce_83 = happySpecReduce_3 23# happyReduction_83
happyReduction_83 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_U_Le [happy_var_1,happy_var_3]
	)}}

happyReduce_84 = happySpecReduce_3 23# happyReduction_84
happyReduction_84 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_U_Lt [happy_var_1,happy_var_3]
	)}}

happyReduce_85 = happySpecReduce_3 23# happyReduction_85
happyReduction_85 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_Ne [happy_var_1,happy_var_3]
	)}}

happyReduce_86 = happySpecReduce_3 23# happyReduction_86
happyReduction_86 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn27
		 (mkMachOp MO_Eq [happy_var_1,happy_var_3]
	)}}

happyReduce_87 = happySpecReduce_2 23# happyReduction_87
happyReduction_87 happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_2 of { happy_var_2 -> 
	happyIn27
		 (mkMachOp MO_Not [happy_var_2]
	)}

happyReduce_88 = happySpecReduce_2 23# happyReduction_88
happyReduction_88 happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_2 of { happy_var_2 -> 
	happyIn27
		 (mkMachOp MO_S_Neg [happy_var_2]
	)}

happyReduce_89 = happyMonadReduce 5# 23# happyReduction_89
happyReduction_89 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_3 of { (L _ (CmmT_Name	happy_var_3)) -> 
	case happyOut28 happy_x_5 of { happy_var_5 -> 
	 do { mo <- nameToMachOp happy_var_3 ;
					        return (mkMachOp mo [happy_var_1,happy_var_5]) }}}}
	) (\r -> happyReturn (happyIn27 r))

happyReduce_90 = happySpecReduce_1 23# happyReduction_90
happyReduction_90 happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 (happy_var_1
	)}

happyReduce_91 = happySpecReduce_2 24# happyReduction_91
happyReduction_91 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_Int		happy_var_1)) -> 
	case happyOut29 happy_x_2 of { happy_var_2 -> 
	happyIn28
		 (return (CmmLit (CmmInt happy_var_1 happy_var_2))
	)}}

happyReduce_92 = happySpecReduce_2 24# happyReduction_92
happyReduction_92 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_Float	happy_var_1)) -> 
	case happyOut29 happy_x_2 of { happy_var_2 -> 
	happyIn28
		 (return (CmmLit (CmmFloat happy_var_1 happy_var_2))
	)}}

happyReduce_93 = happySpecReduce_1 24# happyReduction_93
happyReduction_93 happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_String	happy_var_1)) -> 
	happyIn28
		 (do s <- code (mkStringCLit happy_var_1); 
				      return (CmmLit s)
	)}

happyReduce_94 = happySpecReduce_1 24# happyReduction_94
happyReduction_94 happy_x_1
	 =  case happyOut35 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 (happy_var_1
	)}

happyReduce_95 = happyReduce 4# 24# happyReduction_95
happyReduction_95 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn28
		 (do e <- happy_var_3; return (CmmLoad e happy_var_1)
	) `HappyStk` happyRest}}

happyReduce_96 = happyMonadReduce 5# 24# happyReduction_96
happyReduction_96 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_2 of { (L _ (CmmT_Name	happy_var_2)) -> 
	case happyOut33 happy_x_4 of { happy_var_4 -> 
	 exprOp happy_var_2 happy_var_4}}
	) (\r -> happyReturn (happyIn28 r))

happyReduce_97 = happySpecReduce_3 24# happyReduction_97
happyReduction_97 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_2 of { happy_var_2 -> 
	happyIn28
		 (happy_var_2
	)}

happyReduce_98 = happySpecReduce_0 25# happyReduction_98
happyReduction_98  =  happyIn29
		 (wordRep
	)

happyReduce_99 = happySpecReduce_2 25# happyReduction_99
happyReduction_99 happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_2 of { happy_var_2 -> 
	happyIn29
		 (happy_var_2
	)}

happyReduce_100 = happySpecReduce_0 26# happyReduction_100
happyReduction_100  =  happyIn30
		 ([]
	)

happyReduce_101 = happySpecReduce_1 26# happyReduction_101
happyReduction_101 happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	happyIn30
		 (happy_var_1
	)}

happyReduce_102 = happySpecReduce_1 27# happyReduction_102
happyReduction_102 happy_x_1
	 =  case happyOut32 happy_x_1 of { happy_var_1 -> 
	happyIn31
		 ([happy_var_1]
	)}

happyReduce_103 = happySpecReduce_3 27# happyReduction_103
happyReduction_103 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut31 happy_x_3 of { happy_var_3 -> 
	happyIn31
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_104 = happySpecReduce_1 28# happyReduction_104
happyReduction_104 happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn32
		 (do e <- happy_var_1; return (e, inferHint e)
	)}

happyReduce_105 = happyMonadReduce 2# 28# happyReduction_105
happyReduction_105 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (L _ (CmmT_String	happy_var_2)) -> 
	 do h <- parseHint happy_var_2;
					      return $ do
						e <- happy_var_1; return (e,h)}}
	) (\r -> happyReturn (happyIn32 r))

happyReduce_106 = happySpecReduce_0 29# happyReduction_106
happyReduction_106  =  happyIn33
		 ([]
	)

happyReduce_107 = happySpecReduce_1 29# happyReduction_107
happyReduction_107 happy_x_1
	 =  case happyOut34 happy_x_1 of { happy_var_1 -> 
	happyIn33
		 (happy_var_1
	)}

happyReduce_108 = happySpecReduce_1 30# happyReduction_108
happyReduction_108 happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn34
		 ([ happy_var_1 ]
	)}

happyReduce_109 = happySpecReduce_3 30# happyReduction_109
happyReduction_109 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	case happyOut34 happy_x_3 of { happy_var_3 -> 
	happyIn34
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_110 = happySpecReduce_1 31# happyReduction_110
happyReduction_110 happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_Name	happy_var_1)) -> 
	happyIn35
		 (lookupName happy_var_1
	)}

happyReduce_111 = happySpecReduce_1 31# happyReduction_111
happyReduction_111 happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_GlobalReg   happy_var_1)) -> 
	happyIn35
		 (return (CmmReg (CmmGlobal happy_var_1))
	)}

happyReduce_112 = happySpecReduce_1 32# happyReduction_112
happyReduction_112 happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_Name	happy_var_1)) -> 
	happyIn36
		 (do e <- lookupName happy_var_1;
				     return $
				       case e of 
					CmmReg r -> r
					other -> pprPanic "CmmParse:" (ftext happy_var_1 <> text " not a register")
	)}

happyReduce_113 = happySpecReduce_1 32# happyReduction_113
happyReduction_113 happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_GlobalReg   happy_var_1)) -> 
	happyIn36
		 (return (CmmGlobal happy_var_1)
	)}

happyReduce_114 = happySpecReduce_1 33# happyReduction_114
happyReduction_114 happy_x_1
	 =  case happyOutTok happy_x_1 of { (L _ (CmmT_Name	happy_var_1)) -> 
	happyIn37
		 (BlockId (newTagUnique (getUnique happy_var_1) 'L')
	)}

happyReduce_115 = happySpecReduce_1 34# happyReduction_115
happyReduction_115 happy_x_1
	 =  happyIn38
		 (I8
	)

happyReduce_116 = happySpecReduce_1 34# happyReduction_116
happyReduction_116 happy_x_1
	 =  case happyOut39 happy_x_1 of { happy_var_1 -> 
	happyIn38
		 (happy_var_1
	)}

happyReduce_117 = happySpecReduce_1 35# happyReduction_117
happyReduction_117 happy_x_1
	 =  happyIn39
		 (I16
	)

happyReduce_118 = happySpecReduce_1 35# happyReduction_118
happyReduction_118 happy_x_1
	 =  happyIn39
		 (I32
	)

happyReduce_119 = happySpecReduce_1 35# happyReduction_119
happyReduction_119 happy_x_1
	 =  happyIn39
		 (I64
	)

happyReduce_120 = happySpecReduce_1 35# happyReduction_120
happyReduction_120 happy_x_1
	 =  happyIn39
		 (F32
	)

happyReduce_121 = happySpecReduce_1 35# happyReduction_121
happyReduction_121 happy_x_1
	 =  happyIn39
		 (F64
	)

happyNewToken action sts stk
	= cmmlex(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	L _ CmmT_EOF -> happyDoAction 63# (error "reading EOF!") action sts stk;
	L _ (CmmT_SpecChar ':') -> cont 1#;
	L _ (CmmT_SpecChar ';') -> cont 2#;
	L _ (CmmT_SpecChar '{') -> cont 3#;
	L _ (CmmT_SpecChar '}') -> cont 4#;
	L _ (CmmT_SpecChar '[') -> cont 5#;
	L _ (CmmT_SpecChar ']') -> cont 6#;
	L _ (CmmT_SpecChar '(') -> cont 7#;
	L _ (CmmT_SpecChar ')') -> cont 8#;
	L _ (CmmT_SpecChar '=') -> cont 9#;
	L _ (CmmT_SpecChar '`') -> cont 10#;
	L _ (CmmT_SpecChar '~') -> cont 11#;
	L _ (CmmT_SpecChar '/') -> cont 12#;
	L _ (CmmT_SpecChar '*') -> cont 13#;
	L _ (CmmT_SpecChar '%') -> cont 14#;
	L _ (CmmT_SpecChar '-') -> cont 15#;
	L _ (CmmT_SpecChar '+') -> cont 16#;
	L _ (CmmT_SpecChar '&') -> cont 17#;
	L _ (CmmT_SpecChar '^') -> cont 18#;
	L _ (CmmT_SpecChar '|') -> cont 19#;
	L _ (CmmT_SpecChar '>') -> cont 20#;
	L _ (CmmT_SpecChar '<') -> cont 21#;
	L _ (CmmT_SpecChar ',') -> cont 22#;
	L _ (CmmT_SpecChar '!') -> cont 23#;
	L _ (CmmT_DotDot) -> cont 24#;
	L _ (CmmT_DoubleColon) -> cont 25#;
	L _ (CmmT_Shr) -> cont 26#;
	L _ (CmmT_Shl) -> cont 27#;
	L _ (CmmT_Ge) -> cont 28#;
	L _ (CmmT_Le) -> cont 29#;
	L _ (CmmT_Eq) -> cont 30#;
	L _ (CmmT_Ne) -> cont 31#;
	L _ (CmmT_BoolAnd) -> cont 32#;
	L _ (CmmT_BoolOr) -> cont 33#;
	L _ (CmmT_CLOSURE) -> cont 34#;
	L _ (CmmT_INFO_TABLE) -> cont 35#;
	L _ (CmmT_INFO_TABLE_RET) -> cont 36#;
	L _ (CmmT_INFO_TABLE_FUN) -> cont 37#;
	L _ (CmmT_INFO_TABLE_CONSTR) -> cont 38#;
	L _ (CmmT_INFO_TABLE_SELECTOR) -> cont 39#;
	L _ (CmmT_else) -> cont 40#;
	L _ (CmmT_export) -> cont 41#;
	L _ (CmmT_section) -> cont 42#;
	L _ (CmmT_align) -> cont 43#;
	L _ (CmmT_goto) -> cont 44#;
	L _ (CmmT_if) -> cont 45#;
	L _ (CmmT_jump) -> cont 46#;
	L _ (CmmT_foreign) -> cont 47#;
	L _ (CmmT_import) -> cont 48#;
	L _ (CmmT_switch) -> cont 49#;
	L _ (CmmT_case) -> cont 50#;
	L _ (CmmT_default) -> cont 51#;
	L _ (CmmT_bits8) -> cont 52#;
	L _ (CmmT_bits16) -> cont 53#;
	L _ (CmmT_bits32) -> cont 54#;
	L _ (CmmT_bits64) -> cont 55#;
	L _ (CmmT_float32) -> cont 56#;
	L _ (CmmT_float64) -> cont 57#;
	L _ (CmmT_GlobalReg   happy_dollar_dollar) -> cont 58#;
	L _ (CmmT_Name	happy_dollar_dollar) -> cont 59#;
	L _ (CmmT_String	happy_dollar_dollar) -> cont 60#;
	L _ (CmmT_Int		happy_dollar_dollar) -> cont 61#;
	L _ (CmmT_Float	happy_dollar_dollar) -> cont 62#;
	_ -> happyError'
	})

happyError_ tk = happyError'

happyThen :: () => P a -> (a -> P b) -> P b
happyThen = (>>=)
happyReturn :: () => a -> P a
happyReturn = (return)
happyThen1 = happyThen
happyReturn1 :: () => a -> P a
happyReturn1 = happyReturn
happyError' :: () => P a
happyError' = happyError

cmmParse = happySomeParser where
  happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut4 x))

happySeq = happyDontSeq

section :: String -> Section
section "text"	 = Text
section "data" 	 = Data
section "rodata" = ReadOnlyData
section "bss"	 = UninitialisedData
section s	 = OtherSection s

-- mkMachOp infers the type of the MachOp from the type of its first
-- argument.  We assume that this is correct: for MachOps that don't have
-- symmetrical args (e.g. shift ops), the first arg determines the type of
-- the op.
mkMachOp :: (MachRep -> MachOp) -> [ExtFCode CmmExpr] -> ExtFCode CmmExpr
mkMachOp fn args = do
  arg_exprs <- sequence args
  return (CmmMachOp (fn (cmmExprRep (head arg_exprs))) arg_exprs)

getLit :: CmmExpr -> CmmLit
getLit (CmmLit l) = l
getLit (CmmMachOp (MO_S_Neg _) [CmmLit (CmmInt i r)])  = CmmInt (negate i) r
getLit _ = panic "invalid literal" -- TODO messy failure

nameToMachOp :: FastString -> P (MachRep -> MachOp)
nameToMachOp name = 
  case lookupUFM machOps name of
	Nothing -> fail ("unknown primitive " ++ unpackFS name)
	Just m  -> return m

exprOp :: FastString -> [ExtFCode CmmExpr] -> P (ExtFCode CmmExpr)
exprOp name args_code =
  case lookupUFM exprMacros name of
     Just f  -> return $ do
        args <- sequence args_code
	return (f args)
     Nothing -> do
	mo <- nameToMachOp name
	return $ mkMachOp mo args_code

exprMacros :: UniqFM ([CmmExpr] -> CmmExpr)
exprMacros = listToUFM [
  ( FSLIT("ENTRY_CODE"),   \ [x] -> entryCode x ),
  ( FSLIT("GET_ENTRY"),    \ [x] -> entryCode (closureInfoPtr x) ),
  ( FSLIT("STD_INFO"),     \ [x] -> infoTable x ),
  ( FSLIT("GET_STD_INFO"), \ [x] -> infoTable (closureInfoPtr x) ),
  ( FSLIT("GET_FUN_INFO"), \ [x] -> funInfoTable (closureInfoPtr x) ),
  ( FSLIT("INFO_TYPE"),    \ [x] -> infoTableClosureType x ),
  ( FSLIT("INFO_PTRS"),    \ [x] -> infoTablePtrs x ),
  ( FSLIT("INFO_NPTRS"),   \ [x] -> infoTableNonPtrs x ),
  ( FSLIT("RET_VEC"),      \ [info, conZ] -> retVec info conZ )
  ]

-- we understand a subset of C-- primitives:
machOps = listToUFM $
	map (\(x, y) -> (mkFastString x, y)) [
	( "add",	MO_Add ),
	( "sub",	MO_Sub ),
	( "eq",		MO_Eq ),
	( "ne",		MO_Ne ),
	( "mul",	MO_Mul ),
	( "neg",	MO_S_Neg ),
	( "quot",	MO_S_Quot ),
	( "rem",	MO_S_Rem ),
	( "divu",	MO_U_Quot ),
	( "modu",	MO_U_Rem ),

	( "ge",		MO_S_Ge ),
	( "le",		MO_S_Le ),
	( "gt",		MO_S_Gt ),
	( "lt",		MO_S_Lt ),

	( "geu",	MO_U_Ge ),
	( "leu",	MO_U_Le ),
	( "gtu",	MO_U_Gt ),
	( "ltu",	MO_U_Lt ),

	( "flt",	MO_S_Lt ),
	( "fle",	MO_S_Le ),
	( "feq",	MO_Eq ),
	( "fne",	MO_Ne ),
	( "fgt",	MO_S_Gt ),
	( "fge",	MO_S_Ge ),
	( "fneg",	MO_S_Neg ),

	( "and",	MO_And ),
	( "or",		MO_Or ),
	( "xor",	MO_Xor ),
	( "com",	MO_Not ),
	( "shl",	MO_Shl ),
	( "shrl",	MO_U_Shr ),
	( "shra",	MO_S_Shr ),

	( "lobits8",  flip MO_U_Conv I8  ),
	( "lobits16", flip MO_U_Conv I16 ),
	( "lobits32", flip MO_U_Conv I32 ),
	( "lobits64", flip MO_U_Conv I64 ),
	( "sx16",     flip MO_S_Conv I16 ),
	( "sx32",     flip MO_S_Conv I32 ),
	( "sx64",     flip MO_S_Conv I64 ),
	( "zx16",     flip MO_U_Conv I16 ),
	( "zx32",     flip MO_U_Conv I32 ),
	( "zx64",     flip MO_U_Conv I64 ),
	( "f2f32",    flip MO_S_Conv F32 ),  -- TODO; rounding mode
	( "f2f64",    flip MO_S_Conv F64 ),  -- TODO; rounding mode
	( "f2i8",     flip MO_S_Conv I8 ),
	( "f2i16",    flip MO_S_Conv I8 ),
	( "f2i32",    flip MO_S_Conv I8 ),
	( "f2i64",    flip MO_S_Conv I8 ),
	( "i2f32",    flip MO_S_Conv F32 ),
	( "i2f64",    flip MO_S_Conv F64 )
	]

parseHint :: String -> P MachHint
parseHint "ptr"    = return PtrHint
parseHint "signed" = return SignedHint
parseHint "float"  = return FloatHint
parseHint str      = fail ("unrecognised hint: " ++ str)

-- labels are always pointers, so we might as well infer the hint
inferHint :: CmmExpr -> MachHint
inferHint (CmmLit (CmmLabel _)) = PtrHint
inferHint (CmmReg (CmmGlobal g)) | isPtrGlobalReg g = PtrHint
inferHint _ = NoHint

isPtrGlobalReg Sp		= True
isPtrGlobalReg SpLim		= True
isPtrGlobalReg Hp		= True
isPtrGlobalReg HpLim		= True
isPtrGlobalReg CurrentTSO	= True
isPtrGlobalReg CurrentNursery	= True
isPtrGlobalReg _		= False

happyError :: P a
happyError = srcParseFail

-- -----------------------------------------------------------------------------
-- Statement-level macros

stmtMacro :: FastString -> [ExtFCode CmmExpr] -> P ExtCode
stmtMacro fun args_code = do
  case lookupUFM stmtMacros fun of
    Nothing -> fail ("unknown macro: " ++ unpackFS fun)
    Just fcode -> return $ do
	args <- sequence args_code
	code (fcode args)

stmtMacros :: UniqFM ([CmmExpr] -> Code)
stmtMacros = listToUFM [
  ( FSLIT("CCS_ALLOC"),		   \[words,ccs]  -> profAlloc words ccs ),
  ( FSLIT("CLOSE_NURSERY"),	   \[]  -> emitCloseNursery ),
  ( FSLIT("ENTER_CCS_PAP_CL"),     \[e] -> enterCostCentrePAP e ),
  ( FSLIT("ENTER_CCS_THUNK"),      \[e] -> enterCostCentreThunk e ),
  ( FSLIT("HP_CHK_GEN"),           \[words,liveness,reentry] -> 
                                      hpChkGen words liveness reentry ),
  ( FSLIT("HP_CHK_NP_ASSIGN_SP0"), \[e,f] -> hpChkNodePointsAssignSp0 e f ),
  ( FSLIT("LOAD_THREAD_STATE"),    \[] -> emitLoadThreadState ),
  ( FSLIT("LDV_ENTER"),            \[e] -> ldvEnter e ),
  ( FSLIT("LDV_RECORD_CREATE"),    \[e] -> ldvRecordCreate e ),
  ( FSLIT("OPEN_NURSERY"),	   \[]  -> emitOpenNursery ),
  ( FSLIT("PUSH_UPD_FRAME"),	   \[sp,e] -> emitPushUpdateFrame sp e ),
  ( FSLIT("SAVE_THREAD_STATE"),    \[] -> emitSaveThreadState ),
  ( FSLIT("SET_HDR"),		   \[ptr,info,ccs] -> 
					emitSetDynHdr ptr info ccs ),
  ( FSLIT("STK_CHK_GEN"),          \[words,liveness,reentry] -> 
                                      stkChkGen words liveness reentry ),
  ( FSLIT("STK_CHK_NP"),	   \[e] -> stkChkNodePoints e ),
  ( FSLIT("TICK_ALLOC_PRIM"), 	   \[hdr,goods,slop] -> 
					tickyAllocPrim hdr goods slop ),
  ( FSLIT("TICK_ALLOC_PAP"),       \[goods,slop] -> 
					tickyAllocPAP goods slop ),
  ( FSLIT("TICK_ALLOC_UP_THK"),    \[goods,slop] -> 
					tickyAllocThunk goods slop ),
  ( FSLIT("UPD_BH_UPDATABLE"),       \[] -> emitBlackHoleCode False ),
  ( FSLIT("UPD_BH_SINGLE_ENTRY"),    \[] -> emitBlackHoleCode True ),

  ( FSLIT("RET_P"),	\[a] ->       emitRetUT [(PtrArg,a)]),
  ( FSLIT("RET_N"),	\[a] ->       emitRetUT [(NonPtrArg,a)]),
  ( FSLIT("RET_PP"),	\[a,b] ->     emitRetUT [(PtrArg,a),(PtrArg,b)]),
  ( FSLIT("RET_NN"),	\[a,b] ->     emitRetUT [(NonPtrArg,a),(NonPtrArg,b)]),
  ( FSLIT("RET_NP"),	\[a,b] ->     emitRetUT [(NonPtrArg,a),(PtrArg,b)]),
  ( FSLIT("RET_PPP"),	\[a,b,c] ->   emitRetUT [(PtrArg,a),(PtrArg,b),(PtrArg,c)]),
  ( FSLIT("RET_NNP"),	\[a,b,c] ->   emitRetUT [(NonPtrArg,a),(NonPtrArg,b),(PtrArg,c)]),
  ( FSLIT("RET_NNNP"),	\[a,b,c,d] -> emitRetUT [(NonPtrArg,a),(NonPtrArg,b),(NonPtrArg,c),(PtrArg,d)]),
  ( FSLIT("RET_NPNP"),	\[a,b,c,d] -> emitRetUT [(NonPtrArg,a),(PtrArg,b),(NonPtrArg,c),(PtrArg,d)])

 ]

-- -----------------------------------------------------------------------------
-- Our extended FCode monad.

-- We add a mapping from names to CmmExpr, to support local variable names in
-- the concrete C-- code.  The unique supply of the underlying FCode monad
-- is used to grab a new unique for each local variable.

-- In C--, a local variable can be declared anywhere within a proc,
-- and it scopes from the beginning of the proc to the end.  Hence, we have
-- to collect declarations as we parse the proc, and feed the environment
-- back in circularly (to avoid a two-pass algorithm).

type Decls = [(FastString,CmmExpr)]
type Env   = UniqFM CmmExpr

newtype ExtFCode a = EC { unEC :: Env -> Decls -> FCode (Decls, a) }

type ExtCode = ExtFCode ()

returnExtFC a = EC $ \e s -> return (s, a)
thenExtFC (EC m) k = EC $ \e s -> do (s',r) <- m e s; unEC (k r) e s'

instance Monad ExtFCode where
  (>>=) = thenExtFC
  return = returnExtFC

-- This function takes the variable decarations and imports and makes 
-- an environment, which is looped back into the computation.  In this
-- way, we can have embedded declarations that scope over the whole
-- procedure, and imports that scope over the entire module.
loopDecls :: ExtFCode a -> ExtFCode a
loopDecls (EC fcode) = 
   EC $ \e s -> fixC (\ ~(decls,a) -> fcode (addListToUFM e decls) [])

getEnv :: ExtFCode Env
getEnv = EC $ \e s -> return (s, e)

addVarDecl :: FastString -> CmmExpr -> ExtCode
addVarDecl var expr = EC $ \e s -> return ((var,expr):s, ())

newLocal :: MachRep -> FastString -> ExtCode
newLocal ty name  = do
   u <- code newUnique
   addVarDecl name (CmmReg (CmmLocal (LocalReg u ty)))

-- Unknown names are treated as if they had been 'import'ed.
-- This saves us a lot of bother in the RTS sources, at the expense of
-- deferring some errors to link time.
lookupName :: FastString -> ExtFCode CmmExpr
lookupName name = do
  env <- getEnv
  return $ 
     case lookupUFM env name of
	Nothing -> CmmLit (CmmLabel (mkRtsCodeLabelFS name))
	Just e  -> e

-- Lifting FCode computations into the ExtFCode monad:
code :: FCode a -> ExtFCode a
code fc = EC $ \e s -> do r <- fc; return (s, r)

code2 :: (FCode (Decls,b) -> FCode ((Decls,b),c))
	 -> ExtFCode b -> ExtFCode c
code2 f (EC ec) = EC $ \e s -> do ((s',b),c) <- f (ec e s); return (s',c)

nopEC = code nopC
stmtEC stmt = code (stmtC stmt)
stmtsEC stmts = code (stmtsC stmts)
getCgStmtsEC = code2 getCgStmts'

forkLabelledCodeEC ec = do
  stmts <- getCgStmtsEC ec
  code (forkCgStmts stmts)

retInfo name size live_bits cl_type vector = do
  let liveness = smallLiveness (fromIntegral size) (fromIntegral live_bits)
      info_lbl = mkRtsRetInfoLabelFS name
      (info1,info2) = mkRetInfoTable info_lbl liveness NoC_SRT 
				(fromIntegral cl_type) vector
  return (info_lbl, info1, info2)

stdInfo name ptrs nptrs srt_bitmap cl_type desc_str ty_str =
  basicInfo name (packHalfWordsCLit ptrs nptrs) 
	srt_bitmap cl_type desc_str ty_str

basicInfo name layout srt_bitmap cl_type desc_str ty_str = do
  lit1 <- if opt_SccProfilingOn 
		   then code $ mkStringCLit desc_str
		   else return (mkIntCLit 0)
  lit2 <- if opt_SccProfilingOn 
		   then code $ mkStringCLit ty_str
		   else return (mkIntCLit 0)
  let info1 = mkStdInfoTable lit1 lit2 (fromIntegral cl_type) 
			(fromIntegral srt_bitmap)
			layout
  return (mkRtsInfoLabelFS name, info1, [])

funInfo name ptrs nptrs cl_type desc_str ty_str fun_type = do
  (label,info1,_) <- stdInfo name ptrs nptrs 0{-srt_bitmap-}
			 cl_type desc_str ty_str 
  let info2 = mkFunGenInfoExtraBits (fromIntegral fun_type) 0 zero zero zero
		-- we leave most of the fields zero here.  This is only used
		-- to generate the BCO info table in the RTS at the moment.
  return (label,info1,info2)
 where
   zero = mkIntCLit 0


staticClosure :: FastString -> FastString -> [CmmLit] -> ExtCode
staticClosure cl_label info payload
  = code $ emitDataLits (mkRtsDataLabelFS cl_label) lits
  where  lits = mkStaticClosure (mkRtsInfoLabelFS info) dontCareCCS payload [] []

foreignCall
	:: String
	-> [ExtFCode (CmmReg,MachHint)]
	-> ExtFCode CmmExpr
	-> [ExtFCode (CmmExpr,MachHint)]
	-> Maybe [GlobalReg] -> P ExtCode
foreignCall "C" results_code expr_code args_code vols
  = return $ do
	results <- sequence results_code
	expr <- expr_code
	args <- sequence args_code
	stmtEC (CmmCall (CmmForeignCall expr CCallConv) results args vols)
foreignCall conv _ _ _ _
  = fail ("unknown calling convention: " ++ conv)

doStore :: MachRep -> ExtFCode CmmExpr  -> ExtFCode CmmExpr -> ExtCode
doStore rep addr_code val_code
  = do addr <- addr_code
       val <- val_code
	-- if the specified store type does not match the type of the expr
	-- on the rhs, then we insert a coercion that will cause the type
	-- mismatch to be flagged by cmm-lint.  If we don't do this, then
	-- the store will happen at the wrong type, and the error will not
	-- be noticed.
       let coerce_val 
		| cmmExprRep val /= rep = CmmMachOp (MO_U_Conv rep rep) [val]
		| otherwise             = val
       stmtEC (CmmStore addr coerce_val)

-- Return an unboxed tuple.
emitRetUT :: [(CgRep,CmmExpr)] -> Code
emitRetUT args = do
  tickyUnboxedTupleReturn (length args)  -- TICK
  (sp, stmts) <- pushUnboxedTuple 0 args
  emitStmts stmts
  when (sp /= 0) $ stmtC (CmmAssign spReg (cmmRegOffW spReg (-sp)))
  stmtC (CmmJump (entryCode (CmmLoad (cmmRegOffW spReg sp) wordRep)) [])

-- -----------------------------------------------------------------------------
-- If-then-else and boolean expressions

data BoolExpr
  = BoolExpr `BoolAnd` BoolExpr
  | BoolExpr `BoolOr`  BoolExpr
  | BoolNot BoolExpr
  | BoolTest CmmExpr

-- ToDo: smart constructors which simplify the boolean expression.

ifThenElse cond then_part else_part = do
     then_id <- code newLabelC
     join_id <- code newLabelC
     c <- cond
     emitCond c then_id
     else_part
     stmtEC (CmmBranch join_id)
     code (labelC then_id)
     then_part
     -- fall through to join
     code (labelC join_id)

-- 'emitCond cond true_id'  emits code to test whether the cond is true,
-- branching to true_id if so, and falling through otherwise.
emitCond (BoolTest e) then_id = do
  stmtEC (CmmCondBranch e then_id)
emitCond (BoolNot (BoolTest (CmmMachOp op args))) then_id
  | Just op' <- maybeInvertComparison op
  = emitCond (BoolTest (CmmMachOp op' args)) then_id
emitCond (BoolNot e) then_id = do
  else_id <- code newLabelC
  emitCond e else_id
  stmtEC (CmmBranch then_id)
  code (labelC else_id)
emitCond (e1 `BoolOr` e2) then_id = do
  emitCond e1 then_id
  emitCond e2 then_id
emitCond (e1 `BoolAnd` e2) then_id = do
	-- we'd like to invert one of the conditionals here to avoid an
	-- extra branch instruction, but we can't use maybeInvertComparison
	-- here because we can't look too closely at the expression since
	-- we're in a loop.
  and_id <- code newLabelC
  else_id <- code newLabelC
  emitCond e1 and_id
  stmtEC (CmmBranch else_id)
  code (labelC and_id)
  emitCond e2 then_id
  code (labelC else_id)


-- -----------------------------------------------------------------------------
-- Table jumps

-- We use a simplified form of C-- switch statements for now.  A
-- switch statement always compiles to a table jump.  Each arm can
-- specify a list of values (not ranges), and there can be a single
-- default branch.  The range of the table is given either by the
-- optional range on the switch (eg. switch [0..7] {...}), or by
-- the minimum/maximum values from the branches.

doSwitch :: Maybe (Int,Int) -> ExtFCode CmmExpr -> [([Int],ExtCode)]
         -> Maybe ExtCode -> ExtCode
doSwitch mb_range scrut arms deflt
   = do 
	-- Compile code for the default branch
	dflt_entry <- 
		case deflt of
		  Nothing -> return Nothing
		  Just e  -> do b <- forkLabelledCodeEC e; return (Just b)

	-- Compile each case branch
	table_entries <- mapM emitArm arms

	-- Construct the table
	let
	    all_entries = concat table_entries
	    ixs = map fst all_entries
	    (min,max) 
		| Just (l,u) <- mb_range = (l,u)
		| otherwise              = (minimum ixs, maximum ixs)

	    entries = elems (accumArray (\_ a -> Just a) dflt_entry (min,max)
				all_entries)
	expr <- scrut
	-- ToDo: check for out of range and jump to default if necessary
        stmtEC (CmmSwitch expr entries)
   where
	emitArm :: ([Int],ExtCode) -> ExtFCode [(Int,BlockId)]
	emitArm (ints,code) = do
	   blockid <- forkLabelledCodeEC code
	   return [ (i,blockid) | i <- ints ]


-- -----------------------------------------------------------------------------
-- Putting it all together

-- The initial environment: we define some constants that the compiler
-- knows about here.
initEnv :: Env
initEnv = listToUFM [
  ( FSLIT("SIZEOF_StgHeader"), 
	CmmLit (CmmInt (fromIntegral (fixedHdrSize * wORD_SIZE)) wordRep) ),
  ( FSLIT("SIZEOF_StgInfoTable"),
        CmmLit (CmmInt (fromIntegral stdInfoTableSizeB) wordRep) )
  ]

parseCmmFile :: DynFlags -> HomeModules -> FilePath -> IO (Maybe Cmm)
parseCmmFile dflags hmods filename = do
  showPass dflags "ParseCmm"
  buf <- hGetStringBuffer filename
  let
	init_loc = mkSrcLoc (mkFastString filename) 1 0
	init_state = (mkPState buf init_loc dflags) { lex_state = [0] }
		-- reset the lex_state: the Lexer monad leaves some stuff
		-- in there we don't want.
  case unP cmmParse init_state of
    PFailed span err -> do printError span err; return Nothing
    POk _ code -> do
	cmm <- initC dflags hmods no_module (getCmm (unEC code initEnv [] >> return ()))
	dumpIfSet_dyn dflags Opt_D_dump_cmm "Cmm" (pprCmms [cmm])
	return (Just cmm)
  where
	no_module = panic "parseCmmFile: no module"
{-# LINE 1 "GenericTemplate.hs" #-}
-- $Id$













{-# LINE 27 "GenericTemplate.hs" #-}



data Happy_IntList = HappyCons Int# Happy_IntList






































infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
	happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
	(happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
	= {- nothing -}


	  case action of
		0#		  -> {- nothing -}
				     happyFail i tk st
		-1# 	  -> {- nothing -}
				     happyAccept i tk st
		n | (n <# (0# :: Int#)) -> {- nothing -}

				     (happyReduceArr ! rule) i tk st
				     where rule = (I# ((negateInt# ((n +# (1# :: Int#))))))
		n		  -> {- nothing -}


				     happyShift new_state i tk st
				     where new_state = (n -# (1# :: Int#))
   where off    = indexShortOffAddr happyActOffsets st
	 off_i  = (off +# i)
	 check  = if (off_i >=# (0# :: Int#))
			then (indexShortOffAddr happyCheck off_i ==#  i)
			else False
 	 action | check     = indexShortOffAddr happyTable off_i
		| otherwise = indexShortOffAddr happyDefActions st











indexShortOffAddr (HappyA# arr) off =
#if __GLASGOW_HASKELL__ > 500
	narrow16Int# i
#elif __GLASGOW_HASKELL__ == 500
	intToInt16# i
#else
	(i `iShiftL#` 16#) `iShiftRA#` 16#
#endif
  where
#if __GLASGOW_HASKELL__ >= 503
	i = word2Int# ((high `uncheckedShiftL#` 8#) `or#` low)
#else
	i = word2Int# ((high `shiftL#` 8#) `or#` low)
#endif
	high = int2Word# (ord# (indexCharOffAddr# arr (off' +# 1#)))
	low  = int2Word# (ord# (indexCharOffAddr# arr off'))
	off' = off *# 2#





data HappyAddr = HappyA# Addr#




-----------------------------------------------------------------------------
-- HappyState data type (not arrays)

{-# LINE 169 "GenericTemplate.hs" #-}


-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case unsafeCoerce# x of { (I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k -# (1# :: Int#)) sts of
	 sts1@((HappyCons (st1@(action)) (_))) ->
        	let r = fn stk in  -- it doesn't hurt to always seq here...
       		happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
        happyThen1 (fn stk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))
       where sts1@((HappyCons (st1@(action)) (_))) = happyDrop k (HappyCons (st) (sts))
             drop_stk = happyDropStk k stk

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n -# (1# :: Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n -# (1#::Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off    = indexShortOffAddr happyGotoOffsets st
	 off_i  = (off +# nt)
 	 new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail  0# tk old_st _ stk =
--	trace "failing" $ 
    	happyError_ tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
						(saved_tok `HappyStk` _ `HappyStk` stk) =
--	trace ("discarding state, depth " ++ show (length stk))  $
	happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail  i tk (action) sts stk =
--      trace "entering error recovery" $
	happyDoAction 0# tk action sts ( (unsafeCoerce# (I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--	happySeq = happyDoSeq
-- otherwise it emits
-- 	happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.
