with Ada.Text_IO; use Ada.Text_IO;
with Ada.Command_Line; use Ada.Command_Line;
with Version; use Version;

package body Bug is
   procedure Disp_Bug_Box (Except : Exception_Occurrence)
   is
      Id : Exception_Id;
   begin
      New_Line (Standard_Error);
      Put_Line
        (Standard_Error,
         "******************** GHDL Bug occured ****************************");
      Put_Line
        (Standard_Error,
         "Please, report this bug to ghdl@free.fr, with all the output.");
      Put_Line (Standard_Error, "GHDL version: " & Ghdl_Version);
      --Put_Line
      --  ("Program name: " & Command_Name);
      --Put_Line
      --  ("Program arguments:");
      --for I in 1 .. Argument_Count loop
      --   Put_Line ("  " & Argument (I));
      --end loop;
      Put_Line (Standard_Error, "Command line:");
      Put (Standard_Error, Command_Name);
      for I in 1 .. Argument_Count loop
         Put (Standard_Error, ' ');
         Put (Standard_Error, Argument (I));
      end loop;
      New_Line (Standard_Error);
      Id := Exception_Identity (Except);
      if Id /= Null_Id then
         Put_Line (Standard_Error,
                   "Exception " & Exception_Name (Id) & " raised");
         --Put_Line ("exception message: " & Exception_Message (Except));
         Put_Line (Standard_Error,
                   "Exception information:");
         Put (Standard_Error, Exception_Information (Except));
      end if;
      Put_Line
        (Standard_Error,
         "******************************************************************");
   end Disp_Bug_Box;
end Bug;
