with Types; use Types;
with Iirs; use Iirs;
with GNAT.Table;

package Configuration is
   package Design_Units is new GNAT.Table
     (Table_Component_Type => Iir_Design_Unit,
      Table_Index_Type => Natural,
      Table_Low_Bound => 1,
      Table_Initial => 16,
      Table_Increment => 100);

   --  Get the top configuration to build a design hierarchy whose top is
   --  PRIMARY + SECONDARY.
   --  PRIMARY must designate a configuration declaration or an entity
   --  declaration.  In the last case, SECONDARY must be null_identifier or
   --  designates an architecture declaration.
   --
   --  creates a list of design unit.
   --  and return the top configuration.
   --  Note: this set the Elab_Flag on units.
   function Configure (Primary_Id : Name_Id; Secondary_Id : Name_Id)
     return Iir;

   --  Add design unit UNIT (with its dependences) in the design_units table.
   procedure Add_Design_Unit (Unit : Iir_Design_Unit; From : Iir);

   --  If set, all design units (even package bodies) are loaded.
   Flag_Load_All_Design_Units : Boolean := True;

   Flag_Build_File_Dependence : Boolean := False;
end Configuration;
