with GNAT.OS_Lib; use GNAT.OS_Lib;
with Ghdlmain; use Ghdlmain;
with Iirs; use Iirs;

package Ghdllocal is
   type Command_Lib is abstract new Command_Type with null record;

   --  Setup GHDL.
   procedure Init (Cmd : in out Command_Lib);

   --  Handle:
   --  --std=xx, --work=xx, -Pxxx, --workdir=x, --ieee=x, -Px, and -v
   procedure Decode_Option (Cmd : in out Command_Lib;
                            Option : String;
                            Arg : String;
                            Res : out Option_Res);

   --  Disp detailled help.
   procedure Disp_Long_Help (Cmd : Command_Lib);

   --  Set with -v option.
   Flag_Verbose : Boolean := False;

   --  Suffix for asm files.
   Asm_Suffix : constant String := ".s";

   --  Suffix for post files.
   Post_Suffix : constant String := ".on";

   --  Suffix for list files.
   List_Suffix : constant String := ".lst";

   --  Prefix for elab files.
   Elab_Prefix : constant String := "e~";

   --  Path prefix for libraries.
   Prefix_Path : String_Access := null;

   Nul : constant Character := Character'Val (0);

   --  Return FILENAME without the extension.
   function Get_Base_Name (Filename : String; Remove_Dir : Boolean := True)
                           return String;

   function Append_Suffix (File : String; Suffix : String)
                          return String_Access;

   --  Return TRUE is UNIT can be at the apex of a design hierarchy.
   function Is_Top_Entity (Unit : Iir) return Boolean;

   --  Display the name of library unit UNIT.
   procedure Disp_Library_Unit (Unit : Iir);

   --  Translate vhdl version into a path element.
   --  Used to search Std and IEEE libraries.
   function Get_Version_Path return String;

   --  Setup standard libaries path.  If LOAD is true, then load them now.
   procedure Setup_Libraries (Load : Boolean);

   --  Setup library, analyze FILES, and if SAVE_LIBRARY is set save the
   --  work library only
   procedure Analyze_Files (Files : Argument_List; Save_Library : Boolean);

   procedure Register_Commands;
end Ghdllocal;
