with System; use System;
with Grt.Types; use Grt.Types;
with Grt.Rtis; use Grt.Rtis;
with Grt.Rtis_Addr; use Grt.Rtis_Addr;
with Grt.Vstrings; use Grt.Vstrings;
with Grt.Stdio; use Grt.Stdio;

package Grt.Rtis_Utils is
   --  Action to perform after a node was handled by the user function:
   --  Traverse_Ok: continue to process.
   --  Traverse_Skip: do not traverse children.
   --  Traverse_Stop: end of walk.
   type Traverse_Result is (Traverse_Ok, Traverse_Skip, Traverse_Stop);

   --  Traverse all blocks (package, entities, architectures, block, generate,
   --  processes).
   generic
      with function Process (Ctxt : Rti_Context;
                             Obj : Ghdl_Rti_Access)
                            return Traverse_Result;
   function Traverse_Blocks (Ctxt : Rti_Context) return Traverse_Result;

   generic
      with procedure Process (Val_Addr : Address;
                              Val_Name : Vstring;
                              Val_Type : Ghdl_Rti_Access);
   procedure Foreach_Scalar (Ctxt : Rti_Context;
                             Obj_Type : Ghdl_Rti_Access;
                             Obj_Addr : Address;
                             Is_Sig : Boolean);

   procedure Get_Value (Str : in out Vstring;
                        Value : Value_Union;
                        Type_Rti : Ghdl_Rti_Access);

   --  Disp a value.
   procedure Disp_Value (Stream : FILEs;
                         Value : Value_Union;
                         Type_Rti : Ghdl_Rti_Access);

   --  Get context as a path name.
   --  If IS_INSTANCE is true, the architecture name of entities is added.
   procedure Get_Path_Name (Rstr : in out Rstring;
                            Last_Ctxt : Rti_Context;
                            Sep : Character;
                            Is_Instance : Boolean := True);

   --  Disp a context as a path.
   procedure Put (Stream : FILEs; Ctxt : Rti_Context);

   --  Well-know RTIs.
   Std_Standard_Bit_RTI : aliased Ghdl_Rtin_Type_Enum;

   Std_Standard_Boolean_RTI : aliased Ghdl_Rtin_Type_Enum;

   Ieee_Std_Logic_1164_Std_Ulogic_RTI : aliased Ghdl_Rtin_Type_Enum;
private
   pragma Import (C, Std_Standard_Bit_RTI,
                  "std__standard__bit__RTI");

   pragma Import (C, Std_Standard_Boolean_RTI,
                  "std__standard__boolean__RTI");

   pragma Import (C, Ieee_Std_Logic_1164_Std_Ulogic_RTI,
                  "ieee__std_logic_1164__std_ulogic__RTI");
   pragma Weak_External (Ieee_Std_Logic_1164_Std_Ulogic_RTI);
end Grt.Rtis_Utils;
