with Ortho_Front;
with Iirs; use Iirs;

package Translation is
   --  Initialize the package: create internal nodes.
   procedure Initialize;

   --  Translate (generate code) for design unit UNIT.
   --  If MAIN is true, the unit is really the unit being compiled (not an
   --  external unit).  Code shouldn't be generated for external units.
   procedure Translate (Unit : Iir_Design_Unit; Main : Boolean);

   --  Translate std.standard.
   procedure Translate_Standard (Main : Boolean);

   package Chap12 is
      --  Primary unit + secondary unit (architecture name which may be null)
      --  to elaborate.
      procedure Elaborate (Primary : Ortho_Front.String_Acc;
                           Secondary : Ortho_Front.String_Acc;
                           Filelist : Ortho_Front.String_Acc;
                           Whole : Boolean);
   end Chap12;

   --  If set, generate Run-Time Information nodes.
   Flag_Rti : Boolean := True;

   --  If set, do not generate 64 bits integer types and operations.
   Flag_Only_32b : Boolean := False;

   --  If set, do not generate code for unused subprograms.
   --  Be careful: unless you are in whole compilation mode, this
   --  flag shouldn't be set for packages and entities.
   Flag_Discard_Unused : Boolean := False;

   --  If set, do not generate code for unused implicit subprograms.
   Flag_Discard_Unused_Implicit : Boolean := False;
end Translation;
