with Types; use Types;
with Iirs; use Iirs;

package Xrefs is
   type Xref_Kind is
     (
      --  Declaration of an identifier.
      Xref_Decl,

      --  Identifier after the 'end' keyword.
      Xref_End,

      --  Body of a declaration (for package, subprograms or protected type).
      Xref_Body,

      --  Use of a named entity.
      Xref_Ref
     );

   procedure Init;

   procedure Add_Xref (Loc : Location_Type; Ref : Iir; Kind : Xref_Kind);

   --  Add a declaration of an identifier.
   procedure Xref_Decl (Decl : Iir);
   pragma Inline (Xref_Decl);

   procedure Xref_Ref (Name : Iir; Decl : Iir);
   pragma Inline (Xref_Ref);

   procedure Xref_Body (Bod : Iir; Spec : Iir);
   pragma Inline (Xref_Body);

   procedure Xref_Name (Name : Iir);
   pragma Inline (Xref_Name);

   procedure Xref_End (Loc : Location_Type; Decl : Iir);
   pragma Inline (Xref_End);

   --  Sort the xref table.  This is required before searching.
   procedure Sort;

   subtype Xref is Natural;

   Bad_Xref : constant Xref := 0;
   First_Xref : constant Xref := 1;

   --  Find a reference by location.
   --  Returns BAD_REF is does not exist.
   function Find (Loc : Location_Type) return Xref;

   function Get_Last_Xref return Xref;

   function Get_Xref_Location (N : Xref) return Location_Type;
   function Get_Xref_Kind (N : Xref) return Xref_Kind;
   function Get_Xref_Node (N : Xref) return Iir;
end Xrefs;
