library ieee;
use ieee.std_logic_1164.all;


library ieee;
use ieee.numeric_std.all;

entity qq6_code6_table is
	port (
		clk : in  std_logic;
		ra0_data : out std_logic_vector(31 downto 0);
		ra0_addr : in  std_logic_vector(5 downto 0)
	);
end qq6_code6_table;
architecture augh of qq6_code6_table is

	-- Embedded RAM

	type ram_type is array (0 to 63) of std_logic_vector(31 downto 0);
	signal ram : ram_type := ("11111111111111111111111101111000", "11111111111111111111111101111000", "11111111111111111111111101111000", "11111111111111111111111101111000", "11111111111111111001111100011000", "11111111111111111010101001110000", "11111111111111111011010111000000", "11111111111111111011111011000000", "11111111111111111100010101111000", "11111111111111111100101100111000", "11111111111111111101000000001000", "11111111111111111101010001001000", "11111111111111111101100000001000", "11111111111111111101101101110000", "11111111111111111101111010000000", "11111111111111111110000101010000", "11111111111111111110001111101000", "11111111111111111110011001010000", "11111111111111111110100010010000", "11111111111111111110101010110000", "11111111111111111110110010110000", "11111111111111111110111010010000", "11111111111111111111000001011000", "11111111111111111111001000001000", "11111111111111111111001110100000", "11111111111111111111010100101000", "11111111111111111111011010100000", "11111111111111111111100000010000", "11111111111111111111100101101000", "11111111111111111111101010110000", "11111111111111111111101111110000", "11111111111111111111110100101000", "00000000000000000110000011101000", "00000000000000000101010110010000", "00000000000000000100101001000000", "00000000000000000100000101000000", "00000000000000000011101010001000", "00000000000000000011010011001000", "00000000000000000010111111111000", "00000000000000000010101110111000", "00000000000000000010011111111000", "00000000000000000010010010010000", "00000000000000000010000110000000", "00000000000000000001111010110000", "00000000000000000001110000011000", "00000000000000000001100110110000", "00000000000000000001011101110000", "00000000000000000001010101010000", "00000000000000000001001101010000", "00000000000000000001000101110000", "00000000000000000000111110101000", "00000000000000000000110111111000", "00000000000000000000110001100000", "00000000000000000000101011011000", "00000000000000000000100101100000", "00000000000000000000011111110000", "00000000000000000000011010011000", "00000000000000000000010101010000", "00000000000000000000010000010000", "00000000000000000000001011011000", "00000000000000000000000110110000", "00000000000000000000000010001000", "11111111111111111111111001010000", "11111111111111111111111101111000");


	-- Little utility functions to make VHDL syntactically correct
	--   with the syntax to_integer(unsigned(vector)) when 'vector' is a std_logic.
	--   This happens when accessing arrays with <= 2 cells, for example.

	function to_integer(B: std_logic) return integer is
		variable V: std_logic_vector(0 to 0);
	begin
		V(0) := B;
		return to_integer(unsigned(V));
	end;

	function to_integer(V: std_logic_vector) return integer is
	begin
		return to_integer(unsigned(V));
	end;

begin

	-- The component is a ROM.
	-- There is no Write side.

	-- The Read side (the outputs)

	ra0_data <= ram( to_integer(ra0_addr) );

end architecture;
