// TRAJVIEW_DIALOG.CPP

// Copyright (C) 2002 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "trajview_dialog.h"

#include <iostream>
#include <strstream>
using namespace std;

/*################################################################################################*/

trajview_dialog::trajview_dialog(gtk_project * p1) : glade_dialog("glade/trajview_dialog.glade")
{
	prj = p1;
	
	dialog = glade_xml_get_widget(xml, "trajview_dialog");
	if (dialog == NULL) { cout << "trajview_dialog : glade_xml_get_widget() failed!!!" << endl; return; }
	
	// connect the handlers...
	
	glade_xml_signal_connect_data(xml, "on_dialog_destroy", (GtkSignalFunc) handler_Destroy, (gpointer) this);
	
	glade_xml_signal_connect_data(xml, "on_button_begin_clicked", (GtkSignalFunc) handler_ButtonBegin, (gpointer) this);
	glade_xml_signal_connect_data(xml, "on_button_prev_clicked", (GtkSignalFunc) handler_ButtonPrev, (gpointer) this);
	glade_xml_signal_connect_data(xml, "on_button_play_clicked", (GtkSignalFunc) handler_ButtonPlay, (gpointer) this);
	glade_xml_signal_connect_data(xml, "on_button_next_clicked", (GtkSignalFunc) handler_ButtonNext, (gpointer) this);
	glade_xml_signal_connect_data(xml, "on_button_end_clicked", (GtkSignalFunc) handler_ButtonEnd, (gpointer) this);
	
	glade_xml_signal_connect_data(xml, "on_button_close_clicked", (GtkSignalFunc) handler_ButtonClose, (gpointer) this);
	
	gtk_widget_show(dialog);	// MODELESS
}

trajview_dialog::~trajview_dialog(void)
{
	prj->CloseTrajectory();
}

void trajview_dialog::handler_Destroy(GtkWidget *, gpointer data)
{
	trajview_dialog * ref = (trajview_dialog *) data;
	//cout << "handler_Destroy() : ref = " << ref << endl;
}

void trajview_dialog::handler_ButtonBegin(GtkWidget *, gpointer data)
{
	trajview_dialog * ref = (trajview_dialog *) data;
	
	i32s frame = 0;
	ref->prj->SetCurrentFrame(frame);
	ref->prj->ReadFrame();
	
	char mbuff1[128]; ostrstream str1(mbuff1, sizeof(mbuff1));
	str1 << "frame = " << ref->prj->GetCurrentFrame() << endl << ends;
	ref->prj->PrintToLog(mbuff1);
	
	ref->prj->UpdateAllGraphicsViews(true);
}

void trajview_dialog::handler_ButtonPrev(GtkWidget *, gpointer data)
{
	trajview_dialog * ref = (trajview_dialog *) data;
	
	i32s frame = ref->prj->GetCurrentFrame() - 1;
	i32s max = ref->prj->GetTotalFrames();
	
	if (frame < 0) frame = 0;
	if (frame >= max) frame = max - 1;
	
	ref->prj->SetCurrentFrame(frame);
	ref->prj->ReadFrame();
	
	char mbuff1[128]; ostrstream str1(mbuff1, sizeof(mbuff1));
	str1 << "frame = " << ref->prj->GetCurrentFrame() << endl << ends;
	ref->prj->PrintToLog(mbuff1);
	
	ref->prj->UpdateAllGraphicsViews(true);
}

void trajview_dialog::handler_ButtonPlay(GtkWidget *, gpointer data)
{
	trajview_dialog * ref = (trajview_dialog *) data;

	i32s max = ref->prj->GetTotalFrames();
	for (i32s loop = 0;loop < max;loop++)
	{
		ref->prj->SetCurrentFrame(loop);
		ref->prj->ReadFrame();
		
		ref->prj->UpdateAllGraphicsViews(true);
	}
}

void trajview_dialog::handler_ButtonNext(GtkWidget *, gpointer data)
{
	trajview_dialog * ref = (trajview_dialog *) data;

	i32s frame = ref->prj->GetCurrentFrame() + 1;
	i32s max = ref->prj->GetTotalFrames();
	
	if (frame < 0) frame = 0;
	if (frame >= max) frame = max - 1;
	
	ref->prj->SetCurrentFrame(frame);
	ref->prj->ReadFrame();
	
	char mbuff1[128]; ostrstream str1(mbuff1, sizeof(mbuff1));
	str1 << "frame = " << ref->prj->GetCurrentFrame() << endl << ends;
	ref->prj->PrintToLog(mbuff1);
	
	ref->prj->UpdateAllGraphicsViews(true);
}

void trajview_dialog::handler_ButtonEnd(GtkWidget *, gpointer data)
{
	trajview_dialog * ref = (trajview_dialog *) data;

	i32s frame = ref->prj->GetTotalFrames() - 1;
	ref->prj->SetCurrentFrame(frame);
	ref->prj->ReadFrame();
	
	char mbuff1[128]; ostrstream str1(mbuff1, sizeof(mbuff1));
	str1 << "frame = " << ref->prj->GetCurrentFrame() << endl << ends;
	ref->prj->PrintToLog(mbuff1);
	
	ref->prj->UpdateAllGraphicsViews(true);
}

void trajview_dialog::handler_ButtonClose(GtkWidget *, gpointer data)
{
	trajview_dialog * ref = (trajview_dialog *) data;
	//cout << "handler_ButtonClose() : ref = " << ref << endl;
	
	// close the dialog...
	// ^^^^^^^^^^^^^^^^^^^
	
	gtk_widget_destroy(ref->dialog);
}

/*################################################################################################*/

// eof
