// MAIN.H : a bonobo control factory and related stuff for the control(s).

// Copyright (C) 2003 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef MAIN_H
#define MAIN_H

#include "ghemicalconfig2.h"

#include "gtk_project.h"

#include <glib.h>

#ifdef ENABLE_BONOBO
#include <bonobo.h>
#endif	// ENABLE_BONOBO

#include <unistd.h>

// uncomment this if you wish to have the traditional short toolbar labels.
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//#define USE_SHORT_TOOLBAR_LABELS

/*################################################################################################*/

// this part is related to the GTK+ application.
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

class gtk_app
{
	private:
	
	static gtk_app * instance;
	static gtk_project * prj;
	
	protected:
	
	static GtkActionEntry entries1[];
	static GtkToggleActionEntry entries2[];
	static const char * ui_description;
	
	static GtkUIManager * ui_manager;
	
	static GtkWidget * main_window;
	static GtkWidget * main_vbox;
	
	static GtkWidget * main_menubar;
	static GtkWidget * main_toolbar;
	
#ifdef ENABLE_SHORTCUTS
	static GtkWidget * shortcuts_toolbar;
#endif  // ENABLE_SHORTCUTS
	
static GtkWidget * mtb_mtool_draw;
static GtkWidget * mtb_mtool_erase;
static GtkWidget * mtb_mtool_select;
static GtkWidget * mtb_mtool_zoom;
static GtkWidget * mtb_mtool_clipping;
static GtkWidget * mtb_mtool_transl_xy;
static GtkWidget * mtb_mtool_transl_z;
static GtkWidget * mtb_mtool_orbit_xy;
static GtkWidget * mtb_mtool_orbit_z;
static GtkWidget * mtb_mtool_rotate_xy;
static GtkWidget * mtb_mtool_rotate_z;
static GtkWidget * mtb_mtool_measure;
//static GtkWidget * mtb_dial_element;
//static GtkWidget * mtb_dial_bondtype;
//static GtkWidget * mtb_dial_setup;
	
	friend class file_open_dialog;
	
	private:
	
// the constructor is private so that only a single instance
// of the class can be created (by calling GetInstance()).
	gtk_app(void);
	
	public:
	
	~gtk_app(void);
	
	static gtk_app * GetInstance(void);
	static gtk_project * GetPrj(void) { return prj; }
	
	protected:
	
	static gboolean DeleteEventHandler(GtkWidget *, GdkEvent *, gpointer);
	static void DestroyHandler(GtkWidget *, gpointer);
	
	static void SetNewProject(void);
	
	public:
	
	static void mainmenu_FileNew(gpointer, guint, GtkWidget *);
	static void mainmenu_FileOpen(gpointer, guint, GtkWidget *);
	static void mainmenu_FileClose(gpointer, guint, GtkWidget *);

	static void mainmenu_HelpHelp(gpointer, guint, GtkWidget *);
	static void mainmenu_HelpAbout(gpointer, guint, GtkWidget *);
	
	static void HandleToggleButtons(mouse_tool *);
	static void maintb_tool_Draw(gpointer, guint, GtkWidget *);
	static void maintb_tool_Erase(gpointer, guint, GtkWidget *);
	static void maintb_tool_Select(gpointer, guint, GtkWidget *);
	static void maintb_tool_Zoom(gpointer, guint, GtkWidget *);
	static void maintb_tool_Clipping(gpointer, guint, GtkWidget *);
	static void maintb_tool_TranslXY(gpointer, guint, GtkWidget *);
	static void maintb_tool_TranslZ(gpointer, guint, GtkWidget *);
	static void maintb_tool_OrbitXY(gpointer, guint, GtkWidget *);
	static void maintb_tool_OrbitZ(gpointer, guint, GtkWidget *);
	static void maintb_tool_RotateXY(gpointer, guint, GtkWidget *);
	static void maintb_tool_RotateZ(gpointer, guint, GtkWidget *);
	static void maintb_tool_Measure(gpointer, guint, GtkWidget *);
	
	static void maintb_dial_Element(gpointer, guint, GtkWidget *);
	static void maintb_dial_BondType(gpointer, guint, GtkWidget *);
	static void maintb_dial_Setup(gpointer, guint, GtkWidget *);
	
#ifdef ENABLE_SHORTCUTS
	static void shortcutstb_dial_Geomopt(gpointer, guint, GtkWidget *);
	static void shortcutstb_dial_ConstrainBondLength(gpointer, guint, GtkWidget *);
	static void shortcutstb_action_AddH(gpointer, guint, GtkWidget *);
	static void shortcutstb_action_RemoveH(gpointer, guint, GtkWidget *);
	static void shortcutstb_action_SelectAll(gpointer, guint, GtkWidget *);
	static void shortcutstb_action_InvertSelection(gpointer, guint, GtkWidget *);
	static void shortcutstb_action_SelectNone(gpointer, guint, GtkWidget *);
	static void shortcutstb_action_LockSelected(gpointer, guint, GtkWidget *);
	static void shortcutstb_action_UnlockSelected(gpointer, guint, GtkWidget *);
#ifdef ENABLE_GAMESS
	static void shortcutstb_dial_Gamess(gpointer, guint, GtkWidget *);
#endif  // ENABLE_GAMESS
#endif  // ENABLE_SHORTCUTS
	
	static GtkUIManager * GetUIManager(void) { return ui_manager; }
	static GtkWidget * GetMainWindow(void) { return main_window; }
};

// this part is related to the bonobo server.
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

#ifdef ENABLE_BONOBO

static BonoboObject * control_factory(BonoboGenericFactory *, const char *, void *);

#endif	// ENABLE_BONOBO

// the main function.
// ^^^^^^^^^^^^^^^^^^

int main(int, char **);

/*################################################################################################*/

#endif	// MAIN_H

// eof
