/* ghostess - A GUI host for DSSI plugins.
 *
 * Much of this code comes from aube 0.30.2, copyright (c) 2002
 * Conrad Parker, with modifications by Sean Bolton,
 * copyright (c) 2006.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#ifndef __EYECANDY_H__
#define __EYECANDY_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ==== Blinky ==== */

#define BLINKY(obj)		GTK_CHECK_CAST(obj, blinky_get_type (), Blinky)
#define BLINKY_CLASS(klass)	GTK_CHECK_CLASS_CAST(klass, blinky_get_type (), BlinkyClass)
#define IS_BLINKY(obj)		GTK_CHECK_TYPE(obj, blinky_get_type())

  typedef struct _Blinky Blinky;
  typedef struct _BlinkyClass BlinkyClass;

  struct _Blinky {
    GtkWidget widget;

    guint state;
  };

  struct _BlinkyClass {
    GtkWidgetClass parent_class;
  };

  GtkWidget *blinky_new(guint state);
  guint blinky_get_type(void);
  guint blinky_get_state(Blinky * blinky);
  void blinky_set_state(Blinky * blinky, guint state);

#ifdef __cpluscplus
}

#endif
#endif  /* __EYECANDY_H__ */
