/*
 * $Id: gt_version.c,v 1.1 2003/11/08 12:39:20 hipnod Exp $
 *
 * Copyright (C) 2003 giFT project (gift.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#include "gt_gnutella.h"

#include "gt_version.h"

/*****************************************************************************/

typedef uint32_t gt_version_t;

/*****************************************************************************/

/* dataset containing all the nodes that have newer versions than us */
static Dataset *newer;

/*****************************************************************************/

char *gt_version (void)
{
	return "giFT-Gnutella/" GT_VERSION;
}

static gt_version_t make_version (int major, int minor, int micro)
{
	major &= 0xff;
	minor &= 0xff;
	micro &= 0xff;

	return (major << 16 | minor << 8 | micro);
}

static gt_version_t get_version (const char *version)
{
	int n;
	int major, minor, micro;

	if (!version)
		return 0;

	n = sscanf (version, "giFT-Gnutella/%d.%d.%d", &major, &minor, &micro);

	if (n != 3)
		return 0;

	return make_version (major, minor, micro);
}

static gt_version_t our_version (void)
{
	return make_version (gift_strtoul (GT_MAJOR_VERSION),
	                     gift_strtoul (GT_MINOR_VERSION),
	                     gift_strtoul (GT_MICRO_VERSION));
}

void gt_version_warn_if_newer (in_addr_t ip, const char *version_str)
{
	gt_version_t theirs;
	gt_version_t ours;

	if (!ip || !version_str)
		return;

	if ((theirs = get_version (version_str)) == 0)
		return;

	ours = our_version ();
	assert (ours > 0);

	if (theirs > ours)
	{
		/* put a limitation on how many 'newer' entries are allowed */
		if (dataset_length (newer) >= 10)
			return;

		dataset_insert (&newer, &ip, sizeof (ip), &theirs, sizeof (theirs));

		/*
		 * Let the user know a new version may be out there.
		 */
		if (dataset_length (newer) >= 5)
		{
			GT->message (GT, "A newer version of the Gnutella plugin may "
			                 "be available.  You might want to consider "
			                 "upgrading.  Check out http://www.giftproject."
			                 "org/ to see if a new version is available.");
		}
	}
}
