/*
 *  
 *  $Id: controladorlog.h 3518 2011-03-16 13:53:24Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <api/api.h>
#include <map>

//esto es por comodidad para las historias dl nucleo
#ifndef GINKGOLOGDEBUG
#ifdef LOGGER
#define GINKGOLOGDEBUG(mensaje) {std::ostringstream  _buf;                   \
	_buf << mensaje;									 \
	GNC::GCS::ControladorLog::Instance()->Log(LOGGER,_buf.str(),GNC::GCS::IControladorLog::DebugLog);}
#else
#define GINKGOLOGDEBUG(mensaje) {std::ostringstream  _buf;                   \
	_buf << mensaje;									 \
	GNC::GCS::ControladorLog::Instance()->Log(_buf.str(),GNC::GCS::IControladorLog::DebugLog);}
#endif
#endif


#ifndef GINKGOLOGINFO
#ifdef LOGGER
#define GINKGOLOGINFO(mensaje) {std::ostringstream  _buf;                   \
	_buf << mensaje;									 \
	GNC::GCS::ControladorLog::Instance()->Log(LOGGER,_buf.str(),GNC::GCS::IControladorLog::InfoLog);}
#else
#define GINKGOLOGINFO(mensaje) {std::ostringstream  _buf;                   \
	_buf << mensaje;									 \
	GNC::GCS::ControladorLog::Instance()->Log(_buf.str(),GNC::GCS::IControladorLog::InfoLog);}
#endif
#endif

#ifndef GINKGOLOGWARN
#ifdef LOGGER
#define GINKGOLOGWARN(mensaje) {std::ostringstream  _buf;                   \
	_buf << mensaje;									 \
	GNC::GCS::ControladorLog::Instance()->Log(LOGGER,_buf.str(),GNC::GCS::IControladorLog::WarnLog);}
#else
#define GINKGOLOGWARN(mensaje) {std::ostringstream  _buf;                   \
	_buf << mensaje;									 \
	GNC::GCS::ControladorLog::Instance()->Log(_buf.str(),GNC::GCS::IControladorLog::WarnLog);}
#endif
#endif

#ifndef GINKGOLOGERROR
#ifdef LOGGER
#define GINKGOLOGERROR(mensaje) {std::ostringstream  _buf;                   \
	_buf << mensaje;									 \
	GNC::GCS::ControladorLog::Instance()->Log(LOGGER,_buf.str(),GNC::GCS::IControladorLog::ErrorLog);}
#else
#define GINKGOLOGERROR(mensaje) {std::ostringstream  _buf;                   \
	_buf << mensaje;									 \
	GNC::GCS::ControladorLog::Instance()->Log(_buf.str(),GNC::GCS::IControladorLog::ErrorLog);}
#endif
#endif

#ifndef GINKGOLOGFATAL
#ifdef LOGGER
#define GINKGOLOGFATAL(mensaje) {std::ostringstream  _buf;                   \
	_buf << mensaje;									 \
	GNC::GCS::ControladorLog::Instance()->Log(LOGGER,_buf.str(),GNC::GCS::IControladorLog::FatalLog);}
#else
#define GINKGOLOGFATAL(mensaje) {std::ostringstream  _buf;                   \
	_buf << mensaje;									 \
	GNC::GCS::ControladorLog::Instance()->Log(_buf.str(),GNC::GCS::IControladorLog::FatalLog);}
#endif
#endif

#include <string>
#include <api/icontroladorlog.h>
//-------------------------------------------------------------------------------------------------
namespace GNC {
	namespace GCS {
		class EXTAPI ControladorLog : public IControladorLog
		{
			//region "Patron singleton"
		public:
			
			static ControladorLog* Instance();
			static void FreeInstance();

			static ControladorLog* m_pInstance;
			//endregion

		protected:
			//--- Constructores
			ControladorLog();
			~ControladorLog();
		public:			
			//log en el logger por defecto
			virtual void Log(const std::string& mensaje,LogLevel logLevel = DebugLog);
			//log en otro logger
			virtual void Log(const std::string& logger, const std::string& mensaje,LogLevel logLevel = DebugLog);
			//logs con contexto
			virtual void LogConContexto(const std::string& contexto, const std::string& mensaje,LogLevel logLevel = DebugLog);
			//logs en logger especifico con contexto
			virtual void LogConContexto(const std::string& logger, const std::string& contexto, const std::string& mensaje,LogLevel logLevel = DebugLog);
			
			virtual bool IsEnabledFor(GNC::GCS::IControladorLog::LogLevel logLevel);
			
			void GetLogLevelsMap(GNC::GCS::IControladorLog::MapaLogLevels& levels);
			virtual int GetLogLevelCode(const std::string& level);
			
			virtual int GetActiveLogLevel();
			
			void SetActiveLogLevel(int ll);
			
		};
	};
};

//-------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------
