/*
 *  
 *  $Id: panelconfiguracionextensiones.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iconfiguracion.h>
#include "panelesconfiguracionginkgobase.h"
#include <string>
#include <vector>

namespace GNC {
	namespace GUI {

		class PanelConfiguracionExtensiones: public PanelConfiguracionExtensionesBase, public IPasoConfiguracion
		{
			public:
				PanelConfiguracionExtensiones(wxWindow* pParent,IDialogoConfiguracion* pDialogo);
				~PanelConfiguracionExtensiones();

				void Recargar();

				//region "Metodos de IPasoConfiguracion"
				wxWindow* GetPanel();

				std::string GetTitle();

				std::string GetCabecera();

				bool Validar();

				bool Guardar();

				void Exportar(wxXmlNode* pNodo);

				void Importar(wxXmlNode* pNodo);
				//endregion


			protected:
				virtual void OnListaPACSChoice(wxCommandEvent &event);
				virtual void OnShowActivationDialog(wxCommandEvent& event);
				virtual void OnActivateItem(wxTreeEvent &event);

				void ShowActivation();

				void OnSize(wxSizeEvent &);

				bool m_hasBeenChanged;
		};
	}
}
