/*
 *  
 *  $Id: selectfiles.h 3830 2011-05-06 13:30:18Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwizard.h>
#include <api/ivista.h>
#include <api/controllers/ipacscontroller.h>
#include "uploadpacsbase.h"

#include <string>
#include <vector>

class IModeloDicom;

namespace GNC {

	namespace GUI {

		class SelectFiles: public SelectFilesBase, public IPasoWizard
		{
			public:
				typedef std::list<std::string> TListUIDs;
				SelectFiles(wxWindow* pParent, const TListUIDs& uids , IWizard* pWizard);
				~SelectFiles();

				std::string GetServerSeleccionado();

			protected:
			//region "Metodos heredados de IPasoWizard"
				virtual void Attach(wxSizer *sizer);

				virtual void Detach(wxSizer *sizer);

				virtual std::string GetTitle();

				virtual std::string GetSubTitle();

				virtual bool Siguiente();

				virtual bool Anterior();

				virtual bool Cancelar();

				virtual bool Validar();
			//endregion
		protected:
				wxArrayString m_ListaServidoresPACS;

		};
	}
}
