/*
 *  
 *  $Id: herramientaregla.cpp 3830 2011-05-06 13:30:18Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <api/globals.h>
#include "herramientaregla.h"
#include <widgets/wregla.h>
#include <resources/ginkgoresourcemanager.h>


#include <iostream>
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>
#include <wx/xml/xml.h>

GNC::HerramientaRegla::HerramientaRegla() {
	m_Activa = false;
	m_pReglaBuilder = NULL;

	m_Descripcion = _Std("Rule");
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoLongitud();
}

GNC::HerramientaRegla::~HerramientaRegla() {

}

wxXmlNode* GNC::HerramientaRegla::Serializar(GNC::GCS::IVista* pVista, long vid, const std::string nombreMedicoSerializa)
{
	//se cogen todas los widgets regla de los contratos con ese vid
	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;
	//se cogen todas los widgets regla de los contratos con ese vid
	GNC::GCS::ListaWidgets listaWidgets;
	for (ICConcreto::IteradorMapaContratos it = ICConcreto::m_Contratos.begin(); it != ICConcreto::m_Contratos.end(); it++) {
		if((*it).first == pVista){
			for (ICConcreto::IteradorListaContratos it2 = (*it).second->begin(); it2 != (*it).second->end(); it2++) {
				GNC::GCS::IContratoWidgets* pC = (*it2);
				GNC::GCS::ListaWidgets listaWidgetsTmp;
				if(pC->GetManager() != NULL){
					pC->GetManager()->GetListaWidgetsSubVista(vid,listaWidgetsTmp);
					listaWidgets.splice(listaWidgets.begin(),listaWidgetsTmp);
				}
			}
		}
	}

	wxXmlNode* resultado = NULL;
	if(listaWidgets.size()>0){
		resultado = new wxXmlNode(NULL,wxXML_ELEMENT_NODE,wxT("rule"));
		resultado->AddProperty(wxT("id"),wxString::Format(wxT("%d"),this->ID));
		for (GNC::GCS::IWidgetsManager::IteradorListaWidgets it = listaWidgets.begin();  it!= listaWidgets.end(); it++){
			GNC::GCS::Widgets::WRegla* pRegla = dynamic_cast<GNC::GCS::Widgets::WRegla*>((*it));
			if( pRegla != NULL){
				resultado->AddChild(pRegla->Serializar(nombreMedicoSerializa));
			}
		}
	}
	return resultado;
}

void GNC::HerramientaRegla::Deserializar(GNC::GCS::IVista* pVista, long vid, wxXmlNode* nodo)
{
	if(nodo->GetPropVal(wxT("id"),wxT("")) != wxString::Format(wxT("%d"),this->ID)){
		std::cerr<< "Ha ocurrido un error al desserializar la herramienta regla"<<std::endl;
	}

	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;

	for (ICConcreto::IteradorMapaContratos it = ICConcreto::m_Contratos.begin(); it != ICConcreto::m_Contratos.end(); it++) {
		if((*it).first == pVista){

			for (ICConcreto::IteradorListaContratos it2 = (*it).second->begin(); it2 != (*it).second->end(); it2++) {
				GNC::GCS::IContratoWidgets* pC = (*it2);

				GNC::GCS::ListaWidgets listaWidgets;

				wxXmlNode *child = nodo->GetChildren();
				while (child) {
					GNC::GCS::Widgets::WRegla* pWidget = new GNC::GCS::Widgets::WRegla(pC->GetManager(), vid, child);
					listaWidgets.push_back(pWidget);
					child = child->GetNext();
				}

				for (GNC::GCS::IWidgetsManager::IteradorListaWidgets itWidgets = listaWidgets.begin();  itWidgets!= listaWidgets.end(); itWidgets++){
					pC->GetManager()->InsertarWidget((*itWidgets),false);
				}
			}
		}
	}
}

//region "Realizaci�n de la interfaz IHerramienta"

void GNC::HerramientaRegla::CrearPaneles( wxPanel* /*panel*/ ) {
	m_pAbstractPanelHerramientaOpciones = NULL;
}

void GNC::HerramientaRegla::ConectarContratoFalso(bool activar) {
	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;
	if (ICConcreto::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	for (ICConcreto::IteradorListaContratos it = ICConcreto::m_pListaActiva->begin(); it != ICConcreto::m_pListaActiva->end(); it++) {
		GNC::GCS::IContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			if (activar) {
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GTRACE("HerramientaRegla: Conectando contrato falso de vista " << ICConcreto::m_pVistaActiva);
			} else {
				GTRACE("HerramientaRegla: Desconectando contrato falso de vista " << ICConcreto::m_pVistaActiva);
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
		}
	}
}

void GNC::HerramientaRegla::SetVistaActiva(GNC::GCS::IVista* pVista) {
	GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaRegla::SetVistaActiva(" <<  pVista << ")");
}

void GNC::HerramientaRegla::ConectarContratos(bool activar) {
	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;
	if (ICConcreto::m_pListaActiva == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pReglaBuilder != NULL) {
				delete m_pReglaBuilder;
				m_pReglaBuilder = NULL;
			}
		}
		return;
	}

	for (ICConcreto::IteradorListaContratos it = ICConcreto::m_pListaActiva->begin(); it != ICConcreto::m_pListaActiva->end(); it++) {
		GNC::GCS::IContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE("HerramientaRegla: Conectando contratos de vista " << ICConcreto::m_pVistaActiva);
				// Subscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
				m_pReglaBuilder = new GNC::GCS::Widgets::WReglaBuilder(pC->GetManager());
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(m_pReglaBuilder->GetCursor());
			} else {
				GTRACE( "HerramientaRegla: Desconectando contratos de vista " << ICConcreto::m_pVistaActiva );
				// DesSubscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				if (m_pReglaBuilder != NULL) {
					delete m_pReglaBuilder;
					m_pReglaBuilder = NULL;
				}
			}
		}
	}
}

//endregion

//region "Eventos refinados desde los paneles"

//endregion
