/*
 *  
 *  $Id: wsemillas.cpp 3535 2011-03-18 17:57:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include <cmath>

#include <wx/xml/xml.h>

#include <api/globals.h>
#include "wsemillas.h"
#include <api/ievento.h>
#include <api/iwidgetsrenderer.h>
#include <api/iwidgetsmanager.h>
#include <api/icontexto.h>
#include <api/westilo.h>

#include <eventos/eventosginkgo.h>
#include <main/managers/widgetsmanager.h>
#include <vtkgl.h>



//region "Implementacion de WSemillasBuilder"

GNC::GCS::Widgets::WSemillasBuilder::WSemillasBuilder(GNC::GCS::IWidgetsManager* pManager, int numMaxSemillas, GNC::GCS::Widgets::Semillas::ListaRepresentaciones* pRepresentaciones, long gid, vtkImageData* pImageData) : GNC::GCS::Widgets::IWidgetBuilder(pManager, gid)
{
	m_MouseDown = false;
	m_NumMaxSemillas = numMaxSemillas;
	m_Estado = WBS_Ninguno;
	m_RepresentacionActiva = 0;
	m_pRepresentaciones = pRepresentaciones;
	m_pImageData = pImageData;
}

GNC::GCS::Widgets::WSemillasBuilder::~WSemillasBuilder()
{
	m_pRepresentaciones = NULL;
	m_pImageData = NULL;
}

void GNC::GCS::Widgets::WSemillasBuilder::SetRepresentacionActiva(int idRepresentacion)
{
	m_RepresentacionActiva = idRepresentacion;
}

void GNC::GCS::Widgets::WSemillasBuilder::OnMouseEvents(GNC::GCS::Eventos::EventoRaton& evento)
{
	if (!m_pManager) {
		return;
	}
	GTRACE("GNC::GCS::Widgets::WSemillasBuilder::OnMouseEvents(wxMouseEvent&)");
	if (m_MouseDown && evento.ButtonUp(GNC::GCS::Eventos::EventoRaton::EB_IZQUIERDO)) {

		m_MouseDown = false;
		switch(m_Estado) {
		case WBS_Ninguno:
			// ¿Error?
			break;
		case WBS_Creando:
			{
				m_Nodo= evento.iP;

				int rep = m_RepresentacionActiva;
				if (evento.AltDown()) {
					if (++rep >= (int)m_pRepresentaciones->size()) {
						rep = 0;
					}
				}
				m_pRepActiva = m_pRepresentaciones->at(rep);

				GNC::GCS::Widgets::WSemillas* semilla = new GNC::GCS::Widgets::WSemillas(m_pManager, evento.c->GetRenderer()->GetVID(), m_pRepActiva, m_Nodo, "semillas", m_GID, rep);
				bool stop = false;
				int numSemillas = 0;
				if (m_NumMaxSemillas > 0) {
					for (GNC::GCS::ListaWidgets::iterator it = m_pManager->GetListaWidgets().begin(); !stop && it !=  m_pManager->GetListaWidgets().end(); it++) {
						if ( (*it)->GetGID() == m_GID) {
							numSemillas++;
							if (numSemillas >= m_NumMaxSemillas) {
								m_pManager->EliminarWidget(it);
								stop = true;
							}
						}
					}
				}
				m_pManager->InsertarWidget(semilla);
				m_pManager->LanzarEventoCreacion(semilla);
				m_pManager->Modificado();
				evento.Skip(false);
			}
			break;
		case WBS_Seleccionando:
			break;
		case WBS_Moviendo:
			break;
		}
		m_Estado = WBS_Ninguno;

	} else if (evento.ButtonDown(GNC::GCS::Eventos::EventoRaton::EB_IZQUIERDO)) {
		if (m_Estado != WBS_Ninguno) {
			return;
		}
		int rep = m_RepresentacionActiva;
		if (evento.AltDown()) {
			if (++rep >= (int)m_pRepresentaciones->size()) {
				rep = 0;
			}
		}
		bool stop = false;
		int numSemillas = 0;
		if (m_NumMaxSemillas > 0) {
			for (GNC::GCS::ListaWidgets::iterator it = m_pManager->GetListaWidgets().begin(); !stop && it !=  m_pManager->GetListaWidgets().end(); ) {
				if ( (*it)->GetGID() == m_GID) {
					numSemillas++;
					if (numSemillas >= m_NumMaxSemillas) {
						m_pManager->EliminarWidget(it);
						stop = true;
					} else{
						it++;
					}
				}else{
					it++;
				}
			}
		}
		m_pRepActiva = m_pRepresentaciones->at(rep);
		m_MouseDown = true;
		m_Nodo= evento.iP;
		m_pManager->Modificado();
		m_Estado = WBS_Creando;
		evento.Skip(false);

	} else if (evento.Dragging() && m_MouseDown) {
		if (m_Estado == WBS_Creando) {
			int rep = m_RepresentacionActiva;
			if (evento.AltDown()) {
				if (++rep >= (int)m_pRepresentaciones->size()) {
					rep = 0;
				}
			}
			m_pRepActiva = m_pRepresentaciones->at(rep);
			m_Nodo= evento.iP;
			m_pManager->Modificado();
			evento.Skip(false);
		}
	}

}

void GNC::GCS::Widgets::WSemillasBuilder::OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&)
{
	GTRACE("GNC::GCS::Widgets::WSemillasBuilder::OnKeyEvents(wxKeyEvent&)");
}

void GNC::GCS::Widgets::WSemillasBuilder::Render(GNC::GCS::Contexto3D* c)
{
	if (m_Estado != WBS_Creando) {
		return;
	}

	float escala = c->RelacionImagenPantalla().NormaInfinito();

	float radioCruz = m_pRepActiva->m_RadioCruz * escala;
	float radioCirculo = m_pRepActiva->m_RadioCircunferencia * escala;

	glLineWidth(2.0f);
	glColor4f(m_pRepActiva->colorCircunferenciaIluminada.r, m_pRepActiva->colorCircunferenciaIluminada.g, m_pRepActiva->colorCircunferenciaIluminada.b, m_pRepActiva->colorCircunferenciaIluminada.a);

	glBegin(GL_LINE_LOOP);
	float step = M_2PI / 60;
	for ( float angulo = 0; angulo < M_2PI; angulo += step)
	{
		glVertex3f(m_Nodo.x + (radioCirculo * cos (angulo)) , m_Nodo.y + (radioCirculo * sin (angulo)), 0.0f);
	}
	glEnd();

	glColor4f(m_pRepActiva->colorCruzIluminada.r, m_pRepActiva->colorCruzIluminada.g, m_pRepActiva->colorCruzIluminada.b, m_pRepActiva->colorCruzIluminada.a);

	glBegin(GL_LINES);
	glVertex3f(m_Nodo.x - radioCruz, m_Nodo.y, 0.0f);
	glVertex3f(m_Nodo.x + radioCruz, m_Nodo.y, 0.0f);
	glEnd();

	glBegin(GL_LINES);
	glVertex3f(m_Nodo.x, m_Nodo.y - radioCruz, 0.0f);
	glVertex3f(m_Nodo.x, m_Nodo.y + radioCruz, 0.0f);
	glEnd();

}

GNC::GCS::Widgets::TipoCursor GNC::GCS::Widgets::WSemillasBuilder::GetCursor()
{
	return GNC::GCS::Widgets::CUR_CREAR_PUNTO;
}

//endregion


//region "Constructor y destructor"

GNC::GCS::Widgets::WSemillas::WSemillas(IWidgetsManager* pManager, long vid, GNC::GCS::Widgets::Semillas::RepresentacionSemilla* pRepSemilla, GNC::GCS::Nodo nodo, const char* nombre, long gid, long tid, bool oculto) : GNC::GCS::Widgets::IWidget(pManager, vid, nombre, gid, tid)
{
	m_pRepresentacion = pRepSemilla;
	m_Nodo = nodo;
	m_Nodo.m_Size = pRepSemilla->m_RadioCircunferencia;
	m_MouseDown = false;
	m_UID = (long)this;
	m_Oculto = oculto;
}

GNC::GCS::Widgets::WSemillas::~WSemillas()
{
	LanzarEventoDestruccion();
}

//endregion

//region "Serializado y desserializado"
GNC::GCS::Widgets::WSemillas::WSemillas(IWidgetsManager* pManager, long vid, GNC::GCS::Widgets::Semillas::RepresentacionSemilla* pRepSemilla, long gid, wxXmlNode* nodo) : GNC::GCS::Widgets::IWidget(pManager, vid, "", gid) {
	if(nodo->GetName() != wxT("semilla_widget")){
		std::cerr<< "Ha ocurrido un error al desserializar el widget semillas"<<std::endl;
	}

	wxString strTmp = nodo->GetPropVal(wxT("x"),wxT("0.0"));
	double doubleTmp;
	strTmp.ToDouble(&doubleTmp);
	m_Nodo.x = (float) doubleTmp;

	strTmp = nodo->GetPropVal(wxT("y"),wxT("0.0"));
	strTmp.ToDouble(&doubleTmp);
	m_Nodo.y = (float) doubleTmp;

	m_pRepresentacion = pRepSemilla;
	m_Nodo.m_Size = pRepSemilla->m_RadioCircunferencia;

	m_MouseDown = false;
	m_UID = (long)this;
}

wxXmlNode* GNC::GCS::Widgets::WSemillas::Serializar() {
	wxXmlNode* resultado = new wxXmlNode(NULL,wxXML_ELEMENT_NODE,wxT("semilla_widget"));
	//almacenamos los dos nodos
	resultado->AddProperty(new wxXmlProperty(wxT("x"),wxString::Format(wxT("%f"),m_Nodo.x)));
	resultado->AddProperty(new wxXmlProperty(wxT("y"),wxString::Format(wxT("%f"),m_Nodo.y)));
	return resultado;
}
//endregion

void GNC::GCS::Widgets::WSemillas::OnMouseEvents(GNC::GCS::Eventos::EventoRaton& evento)
{
	if(EstaOculto()){
		return;
	}
	//------------------------------------------------------
	// Leaving
	if (evento.Leaving() ) {
		Iluminar(false);
	}
	//------------------------------------------------------
	// Entering
	else if (evento.Entering() ) {
		if (m_MouseDown) {
			Iluminar(true);
		}
	}
	//------------------------------------------------------
	// Dragging
	else if (evento.Dragging() && m_MouseDown) {
		if (m_Nodo.EstaSeleccionado() ) {
			Vector delta = evento.iP - m_PosCursor;
			m_PosCursor = evento.iP;
			m_Nodo += delta;

			Modificar(true);

			NotificarCambios(true);

			ConsumirEvento();

			LanzarEventoModificacion();
		}
		return;
	}
	//------------------------------------------------------
	// LeftDown
	else if (evento.LeftDown()) {

		if (EventoConsumido()) {
			if (EstaSeleccionado()) {
				NotificarCambios(true);
			}
			Seleccionar(false);
			return;
		}

		bool dentro = false;

		const GNC::GCS::Vector::TComponente& factor = evento.c->RelacionImagenPantalla().NormaInfinito();

		if (m_Nodo.Hits(evento.iP, factor)) { // click sobre el nodo
			dentro = true;
			if (evento.m_controlDown) { // Inversion de seleccion
				InvertirSeleccion();
				NotificarCambios(true);
			}
			else{
				if (!EstaSeleccionado())
				{
					NotificarCambios(true);
				}
				Seleccionar(true);
			}
		}
		else { // Click fuera del nodo
			if (EstaSeleccionado()){
				NotificarCambios(true);
			}
			Seleccionar(false);
		}
		if (dentro) {
			m_MouseDown = true;
			m_PosCursor = evento.iP;
			m_PosAntigua = m_Nodo;
			ConsumirEvento();
		}
		return;
	}
	//------------------------------------------------------
	// LeftUP
	else if (evento.LeftUp()) {
		if (m_MouseDown) {
			m_MouseDown = false;
			ConsumirEvento();
		}
	}
	//------------------------------------------------------
	// Moving
	else if (evento.Moving()) {
		if (EventoConsumido()) {
			return;
		}

		bool dentro = false;

		m_PosCursor= evento.iP;

		const GNC::GCS::Vector::TComponente& factor = evento.c->RelacionImagenPantalla().NormaInfinito();

		if (m_Nodo.Hits(evento.iP, factor)) {
			Iluminar(true);
			dentro = true;
		}
		else {
			Iluminar(false);
		}
		if (dentro) {
			ConsumirEvento();
		}
		return;
	}
}

void GNC::GCS::Widgets::WSemillas::OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&)
{

}

bool GNC::GCS::Widgets::WSemillas::HitTest(float /*x*/, float /*y*/, float /*umbralCuadrado*/)
{
	// Todo: computar bounding box y girarla
	if (0) {
		return true;
	} else {
		return false;
	}
}

bool GNC::GCS::Widgets::WSemillas::HitTest(GNC::GCS::Vector* vertices, int numVertices)
{
	return m_Nodo.DentroDePoligono2(vertices,numVertices);
}

void GNC::GCS::Widgets::WSemillas::Render(GNC::GCS::Contexto3D* c)
{
	if(EstaOculto()){
		return;
	}

	float relacionImagenPantalla = c->RelacionImagenPantalla().NormaInfinito();

	float radioCruz = m_pRepresentacion->m_RadioCruz * relacionImagenPantalla;
	float radioCirculo = m_pRepresentacion->m_RadioCircunferencia * relacionImagenPantalla;

	glLineWidth(2.0f);

	if (m_MouseDown) {
		glEnable(GL_LINE_STIPPLE);
		glColor4f(0.7f, 0.7f, 0.0f, 0.7);
		glLineStipple(3, 0xAAAA);

		glBegin(GL_LINE_STRIP);
		glVertex2d(m_PosAntigua.x, m_PosAntigua.y);
		glVertex2d(m_Nodo.x, m_Nodo.y);
		glEnd();

		glDisable(GL_LINE_STIPPLE);
	}

	if (EstaSeleccionado()) {
		glColor4f(m_pRepresentacion->colorCircunferenciaSeleccionada.r, m_pRepresentacion->colorCircunferenciaSeleccionada.g, m_pRepresentacion->colorCircunferenciaSeleccionada.b, m_pRepresentacion->colorCircunferenciaSeleccionada.a);
	}
	else if (EstaIluminado()) {
		glColor4f(m_pRepresentacion->colorCircunferenciaIluminada.r, m_pRepresentacion->colorCircunferenciaIluminada.g, m_pRepresentacion->colorCircunferenciaIluminada.b, m_pRepresentacion->colorCircunferenciaIluminada.a);
	}
	else {
		glColor4f(m_pRepresentacion->colorCircunferencia.r, m_pRepresentacion->colorCircunferencia.g, m_pRepresentacion->colorCircunferencia.b, m_pRepresentacion->colorCircunferencia.a);
	}

	glBegin(GL_LINE_LOOP);
	float step = M_2PI / 30;
	for ( float angulo = 0; angulo < M_2PI; angulo += step)
	{
		glVertex3f(m_Nodo.x + (radioCirculo * cos (angulo)) , m_Nodo.y + (radioCirculo * sin (angulo)), 0.0f);

	}
	glEnd();

	if (EstaSeleccionado()) {
		glColor4f(m_pRepresentacion->colorCruzSeleccionada.r, m_pRepresentacion->colorCruzSeleccionada.g, m_pRepresentacion->colorCruzSeleccionada.b, m_pRepresentacion->colorCruzSeleccionada.a);
	}
	else if (EstaIluminado()) {
		glColor4f(m_pRepresentacion->colorCruzIluminada.r, m_pRepresentacion->colorCruzIluminada.g, m_pRepresentacion->colorCruzIluminada.b, m_pRepresentacion->colorCruzIluminada.a);
	}
	else {
		glColor4f(m_pRepresentacion->colorCruz.r, m_pRepresentacion->colorCruz.g, m_pRepresentacion->colorCruz.b, m_pRepresentacion->colorCruz.a);
	}

	glBegin(GL_LINES);
	glVertex3f(m_Nodo.x - radioCruz, m_Nodo.y, 0.0f);
	glVertex3f(m_Nodo.x + radioCruz, m_Nodo.y, 0.0f);
	glEnd();

	glBegin(GL_LINES);
	glVertex3f(m_Nodo.x, m_Nodo.y - radioCruz, 0.0f);
	glVertex3f(m_Nodo.x, m_Nodo.y + radioCruz, 0.0f);
	glEnd();
}



