/*
 *  
 *  $Id: wseleccion.h 3535 2011-03-18 17:57:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <export/iherramientaslider.h>
#include <api/iwidgets.h>
#include <export/icontratoscore.h>
#include <api/math/geometria3d.h>
#include <vector>


namespace GNC {
	namespace GCS {
		namespace Widgets {
			//---------------------------------------------------------------------

			class WSliderBuilder : public GNC::GCS::Widgets::IWidgetBuilder {
			public:

				typedef GNC::GCS::Vector TVector;
				typedef GNC::GCS::Eventos::EventoRaton   TEventoRaton;
				typedef GNC::GCS::Eventos::EventoTeclado TEventoTeclado;
				typedef GNC::GCS::IWidgetsManager        TWidgetsManager;
				typedef GNC::GCS::Widgets::IWidget       TWidget;

				WSliderBuilder(TWidgetsManager* pManager, IContratoSlider* pContract, long gid);

				~WSliderBuilder();

				virtual void OnMouseEvents(TEventoRaton& event);
				virtual void OnKeyEvents(TEventoTeclado& event);

				virtual void Render(GNC::GCS::Contexto3D* c);

				virtual GNC::GCS::Widgets::TipoCursor GetCursor();

				//region "Helpers"

				bool         m_Dentro;
				//endregion


			protected:
				TVector  m_NodoMoviendose;  // Cursor
				
				int     m_InitialSlice;
				double  m_Start;           // Displacement origin in screen pixels
				double  m_Stop;            // Displacement destination in screen pixels
				
				bool     m_MouseDown;
				Estado   m_Estado;
				
				
				IContratoSlider* m_pContract;
			};
		}
	}
}
