#pragma once
/*
 *  
 *  $Id: ilock.h $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#ifndef ILOCK_H
#define ILOCK_H
#include <api/api.h>
#include <list>
#include <string>

#if defined(_WINDOWS)
	#define SUSPEND_WAKEUP()
	#define RESUME_WAKEUP()

#else
	#include <signal.h>

	#define SUSPEND_WAKEUP()\
		siginterrupt(SIGUSR2, 0)

	#define RESUME_WAKEUP()\
		siginterrupt(SIGUSR2, 1)
#endif

//----------------------------------------------------------------------------------------------------
//region Forward Declarations
class wxCriticalSection;
class wxSemaphore;

namespace GNC {
	namespace GCS {
		class ILocker;		
	}
}
//endregion


namespace GNC {
	namespace GCS {

		//----------------------------------------------------------------------------------------------------
		//region Interfaz de soporte de cerrojos
		//----------------------------------------------------------------------------------------------------
		class EXTAPI ILockable
		{
			//----------------------------------------------------------------------------------------------------
			//region Constructor y destructor
			public:

				ILockable();
				~ILockable();
			//endregion

			//----------------------------------------------------------------------------------------------------
			//region Interfaz de exclusion mutua
			public:

				void Lock();

				void UnLock();

				bool IsLocked() const;
			//enregion

			//----------------------------------------------------------------------------------------------------
			//region Interfaz de subscripcion
			private:

				ILocker* m_pLocker; // ILocker que ha bloqueado el cerrojo.
			//endregion

			//----------------------------------------------------------------------------------------------------
			//region Atributos
			private:

				bool               m_IsLocked;
				wxCriticalSection* m_pCS;             // El cerrojo real.
			//endregion

			friend class ILocker;
		};
		//endregion

		//----------------------------------------------------------------------------------------------------
		//region Helper de bloqueo automatico
		//----------------------------------------------------------------------------------------------------
		class EXTAPI ILocker
		{
			//----------------------------------------------------------------------------------------------------
			//region Construccion y destruccion
			public:

				ILocker( GNC::GCS::ILockable& pLockable );
				ILocker( GNC::GCS::ILockable* pLockable );
				~ILocker();
			//endregion

			//----------------------------------------------------------------------------------------------------
			//region Atributos
			private:

				ILockable* m_pLockable;
			//endregion

			friend class ILockable;
		};
		//endregion
	}
}

#endif