/*
 *  
 *  $Id: wxwizardcalibradoginkgo.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/ientorno.h>

#include <wx/filename.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>
#include <wx/ginkgostyle/ginkgostyle.h>

#include "wxwizardcalibradoginkgo.h"
#include "procesarcalibrado.h"
#include "refinarcalibrado.h"
#include "datospersistentescalibrado.h"

#include <vector>
#include <sstream>

#include <main/entorno.h>
#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorcomandos.h>
#include <main/controllers/pacscontroller.h>
#include <resources/ginkgoresourcesmanager.h>



namespace GNC {
	namespace GUI {
			wxWidzardCalibradoGinkgo::wxWidzardCalibradoGinkgo(wxWindow* pParent, GNC::GCS::IVista* pVista,vtkImageData* pImagen, int slice) : wxWizardGinkgoBase(pParent)
			{
				SetTitle(wxT("Asistente de calibrado automatico"));
				m_datosPersistentes.m_pVista = pVista;
				m_datosPersistentes.m_slice = slice;

				m_datosPersistentes.m_pImageData = pImagen;

				m_OK = false;
				if(pVista == NULL){
					return;
				}
				m_pVista = pVista;

				//se pillan los pasos
				IPasoWizard* pPaso=NULL;

				pPaso = new ProcesarCalibrado(m_pPanelPrincipal,this,&m_datosPersistentes);
				m_ListaPasos.push_back(pPaso);

				pPaso = new RefinarCalibrado(m_pPanelPrincipal,this,&m_datosPersistentes);

				m_ListaPasos.push_back(pPaso);

				//
				m_currentPaso=m_ListaPasos.begin();
				m_currentPasoIndex=1;
				CargarCurrent();
			}

			wxWidzardCalibradoGinkgo::~wxWidzardCalibradoGinkgo()
			{
				m_ListaPasos.clear();
			}

			bool wxWidzardCalibradoGinkgo::IsOK()
			{
				return m_OK;
			}

			float wxWidzardCalibradoGinkgo::GetHorizontalSpacing()
			{
				return m_datosPersistentes.m_spacingHorizontal;
			}

			float wxWidzardCalibradoGinkgo::GetVerticalSpacing()
			{
				return m_datosPersistentes.m_spacingVertical;
			}
			

			void wxWidzardCalibradoGinkgo::OnCancelarClick(wxCommandEvent& )
			{
				Close();
			}

			void wxWidzardCalibradoGinkgo::OnSiguienteClick(wxCommandEvent& )
			{
				if((*m_currentPaso)->Validar()){
					wxWindow* pCurrent = dynamic_cast<wxWindow*> (*m_currentPaso);
					if ((*m_currentPaso)->Detach() && pCurrent != NULL) {
						pCurrent->Hide();
						m_pSizerPrincipal->Detach(pCurrent);

						++m_currentPasoIndex;
						++m_currentPaso;
						if(m_currentPaso==m_ListaPasos.end()){
							Hide();
							m_OK = true;
							Close();
						}else{
							CargarCurrent();
						}
					}
				}
			}

			void wxWidzardCalibradoGinkgo::OnAnteriorClick(wxCommandEvent &)
			{
				if(m_currentPaso!=m_ListaPasos.begin()){
					wxWindow* pCurrent = dynamic_cast<wxWindow*> (*m_currentPaso);
					if ((*m_currentPaso)->Detach() && pCurrent != NULL) {
						pCurrent->Hide();
						m_pSizerPrincipal->Detach(pCurrent);

						--m_currentPaso;
						--m_currentPasoIndex;
						CargarCurrent();
					}
				}
			}

			 void wxWidzardCalibradoGinkgo::CargarCurrent(){
				wxWindow* pCurrent = dynamic_cast<wxWindow*> (*m_currentPaso);
				if (pCurrent != NULL && (*m_currentPaso)->Attach()) {
					pCurrent->Show(true);
					m_pSizerPrincipal->Add(pCurrent, 5, wxEXPAND);
					wxString label=wxT("Paso ") + wxString::Format(wxT("%d"),m_currentPasoIndex) + wxT(" de ") + wxString::Format(wxT("%d"),m_ListaPasos.size()) + wxT(": ");
					m_pHeader->SetTitle(label+wxString::FromUTF8((*m_currentPaso)->GetTitle().c_str()));
					m_pBSiguiente->Enable((*m_currentPaso)->Siguiente());
					m_pBAnterior->Enable((*m_currentPaso)->Anterior());
					m_pBCerrar->Enable((*m_currentPaso)->Cancelar());
					if(*(m_currentPaso)==m_ListaPasos.back()){
						m_pBSiguiente->SetLabel(wxT("&Terminar"));
					}else{
						m_pBSiguiente->SetLabel(wxT("&Siguiente >"));
					}
					m_pPanelPrincipal->Layout();
					Layout();
				 }
			}
	};

};
