[All current migrations](https://gitlab.com/gitlab-org/gitaly/issues?label_name%5B%5D=Migration&scope=all&state=all)

# Gitaly Migration Process

This document describes the Gitaly migration process.

Migration is done on a feature-by-feature basis. Although not strictly correct, for simplicity, think of each migrated feature as being a single Gitaly endpoint.

![](https://docs.google.com/drawings/d/1wPwweMnEUPgffsdmoVmHwho5wzKtj61ll_Q90N9eZc8/pub?w=756&h=720)

[Edit this document](https://docs.google.com/drawings/d/1wPwweMnEUPgffsdmoVmHwho5wzKtj61ll_Q90N9eZc8/edit)

---------------------------------------------------------------------

## Selection

First step is to consider a route for migration. A route is an endpoint in one of the following GitLab projects:

* GitLab-CE
* GitLab Workhorse
* GitLab Shell

The order of migration is roughly determined using the formula described in the [Order of Migration](../README.md#order-of-migration) section in the Gitaly readme, although tactical and strategic reasons may affect the actual order.

---------------------------------------------------------------------

## RPC Design: ~"RPC Design"

A new GRPC endpoint is added to the [`gitaly-proto`](https://gitlab.com/gitlab-org/gitaly-proto) project.

---------------------------------------------------------------------

## Server Implementation: ~"Server Implementation"

The server implementation of the `gitaly-proto` endpoint is completed, including:
* Unit tests
* Integration tests

Note: the client and server implementations may occur in parallel, or sequentially
depending on the particular case.

---------------------------------------------------------------------

## Client Implementation: ~"Client Implementation"

The client implementation in `gitlab-ce`, `GitLab-Workhorse` or `GitLab-Shell` is completed.



#### Feature Flags

The client code will either call the old route or the new route, depending on a **feature flag**. This flag name should be derived from the name of the grpc endpoint.

---------------------------------------------------------------------

## Feature Status: *Ready-for-Testing*

At this stage, the feature will be considered to complete, but should remain
disabled by default until acceptance testing has been completed.

This happens in three stages:
* Feature Status: Ready-for-Testing
* Feature Status: Opt-In
* Feature Status: Opt-Out
* Feature Status: Mandatory

---------------------------------------------------------------------

## Acceptance Testing: ~"Acceptance Testing"

A feature is tested in dev, staging and gitlab.com. If the results are satisfactory, the testing continues on to the next environment until the test is complete.

The following procedure should be used for testing:

1. Create a new ~"Acceptance Testing" issue
  - Fill it with the content generated by [`_support/generate-acceptance-testing-issue`](https://gitlab.com/gitlab-org/gitaly/blob/master/_support/generate-acceptance-testing-issue)
1. Follow the procedure in the generated issue.
  - Note that the procedure might change, so keep an eye on [`.gitlab/issue_templates/Migration_Acceptance_Testing.md`](https://gitlab.com/gitlab-org/gitaly/blob/master/.gitlab/issue_templates/Migration_Acceptance_Testing.md)

Once acceptance testing has been successfully completed in all three environments, we need to prepare for opt-in status.

* The [Gitaly runbook](https://gitlab.com/gitlab-com/runbooks/blob/master/troubleshooting/gitaly-error-rate.md) should be updated to include any diagnosis information and a description of how to disable the feature flag.
* Using the error-rate data from the gitlab.com acceptance testing, new alerts need to be added to the [Gitaly prometheus rules](https://gitlab.com/gitlab-com/runbooks/blob/master/alerts/gitaly.rules). The alert should also include a link to the new runbook amendments.

---------------------------------------------------------------------

## Feature Status: *Opt-In*

As the maintainer of Gitaly, Jacob to review:

* The testing evidence completed in the acceptance testing stage is sufficient, using the dashboards created in the previous stage.
* The alerts are in-place
* The runbooks are good

The feature flag will be enabled on dev.gitlab.org, staging and GitLab.com, but the feature flag will be disabled by default. On-premise installations can enable the feature if they wish, but it will be disabled by default.

For a feature toggle `GITALY_EXAMPLE_FEATURE`, the toggle would be enabled by setting the environment variable:  

```shell
GITALY_EXAMPLE_FEATURE=1 # "One" to enable
```

Or by running this command in a Rails Console:

```ruby
Feature.enable("gitaly_example_feature")
```

If the flag is missing, the feature will be **disabled by default**.

---------------------------------------------------------------------

## Feature Status: *Opt-Out*

In the next GitLab release, the client application logic will be switched around to make the feature toggle enabled by default.

This gives on-premise installations a month to test a feature and disable it if there are any problems.

Disabling a feature is done by:

For a feature toggle `GITALY_EXAMPLE_FEATURE`, the toggle would be enabled by setting the environment variable:  

```shell
GITALY_EXAMPLE_FEATURE=0 # "Zero" to disable
```

Or by running this command in a Rails Console:

```ruby
Feature.disable("gitaly_example_feature")
```

If the flag is missing, the feature will be **enabled by default**.

---------------------------------------------------------------------

## Feature Status: *Mandatory*

In the next GitLab release following the change to Opt-Out feature status, the feature will be made mandatory. At this point, the option to opt-out will be gone and all GitLab installations will need to use the feature.

The change will be made by:

* Removing the references to the feature flag in Omnibus, Chef repo, etc
* Remove the feature flag switching code from the client application (GitLab-CE, Workhorse, GitLab-Shell) code
