    /**
  *********************************************************************
*************************************************************************
*** 
*** \file  UtilMath.hpp
*** \brief UtilMath class header file
***
*****************************************
  *****************************************
    **/
  
/*
  
  Copyright (c) 2007, Tim Burrell
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and 
  limitations under the License. 
  
*/

#ifndef __UtilMath_h
#define __UtilMath_h

#if HAVE_CONFIG_H
#include "config.h"
#endif

//////////////////////////////////////////////////////////////////////////////
// Namespace
///////////////////////////////////////

namespace H {

//////////////////////////////////////////////////////////////////////////////
// Class Definition
///////////////////////////////////////

/**
 * \class UtilMath
 * \brief Main UtilMath class
 *
 * This class provides static time routines for sleeping and finding the current time
 *
 * It also can be instantiated to provide a time duration watcher
**/
class UtilMath {
public:
	static int 		intDivRoundUp(int Div1, int Div2);		///< integer divide and round up
	static float 		random();					///< get a random float
	static float 		randomFloat(float MinVal, float MaxVal);	///< get a random float 
	static int		randomInt(int MinVal, int MaxVal);		///< get a random int
	static void		randomize();					///< randomize via the clock
	
	UtilMath();
	virtual ~UtilMath();
};

} // H namespace

#endif // __UtilMath_h
