#!/bin/sh

# classpath-docs.sh
# Copyright (C) 2003 Free Software Foundation, Inc.
# 
# This file is part of GNU Classpath.
# 
# GNU Classpath is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#  
# GNU Classpath is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Classpath; see the file COPYING.  If not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# 02111-1307 USA. */


# ----------------------------------------------------------------------
#
# Example script for gjdoc which generates the full documentation tree
# for GNU Classpath. This can take some time.
# 
# The resulting HTML files will be placed in tmp/classpath-api-html
#
# This example demonstrates multiple source paths and use of an external
# argument file.
#
# USAGE:
#    cd gjdoc
#    examples/classpath-docs.sh /path/to/classpath
#
# ----------------------------------------------------------------------


# ============== Check environment and arguments

# --- This script is supposed to be called from the gjdoc home
# --- directory. Make sure this is the case

if [ ! -f src/gnu/classpath/tools/gjdoc/Main.java ]; then
    echo ""
    echo "Please start this script from the gjdoc home directory."
    echo ""
    exit 5
fi

# --- Require first argument to be valid path to a Classpath
# --- distribution

if [ "$1" == "" ]; then
    echo "USAGE: examples/classpath-docs.sh <path/to/classpath>"
    exit 5
fi

if [ ! -f $1/vm/reference/java/lang/VMObject.java ]; then
    echo "$1 doesn't point to the Classpath home directory."
    exit 5
fi


# ============== Generate documentation

# --- Create target directory

mkdir -p tmp/classpath-api-html

# --- Generate HTML documentation

java -jar dist/gjdoc.jar \
    -sourcepath $1:$1/vm/reference \
    -d tmp/classpath-api-html/ \
    @examples/classpath.packages
