#include <gtk/gtk.h>

#include "gkdial.h"
#include "details.h"
#include "defines.h"

void
gkdial_details_show (GtkWidget * w, gpointer data)
{
  GkDial *gkdial = (GkDial *) data;

  gtk_widget_show (gkdial->details_window);
}

void
gkdial_details_delete (GtkWidget * w, GdkEventAny * event, gpointer data)
{
  gkdial_details_close (w, data);
}

void
gkdial_details_close (GtkWidget * w, gpointer data)
{
  GkDial *gkdial = (GkDial *) data;

  if (gkdial->state != DISCONNECTED)
    {
      GtkWidget *dialog;
      gint response;

      dialog = gtk_message_dialog_new (GTK_WINDOW (gkdial->details_window),
				       GTK_DIALOG_MODAL,
				       GTK_MESSAGE_QUESTION,
				       GTK_BUTTONS_YES_NO,
				       _("Do you want to close "
					 "the ongoing connection?"));

      response = gtk_dialog_run (GTK_DIALOG (dialog));

      gtk_widget_destroy (dialog);

      if (response == GTK_RESPONSE_YES)
	gk_disconnect (NULL, gkdial);
    }

  gtk_main_quit ();
}

void
gkdial_details_set_title (GkDial * gkdial, gchar * format, ...)
{
  va_list ap;
  gchar *title_str;

  va_start (ap, format);
  title_str = g_strdup_vprintf (format, ap);
  va_end (ap);

  gtk_window_set_title (GTK_WINDOW (gkdial->details_window), title_str);

  g_free (title_str);
}
