#include <gtk/gtk.h>

#include "gkdial.h"

GdkPixbuf *
pixbuf_from_file (const gchar * file_name)
{
  GdkPixbuf *pixbuf;
  gchar *absolute_fname;

  absolute_fname = g_strdup_printf (PACKAGE_DATA_DIR "/gkdial/images/%s",
				    file_name);
  pixbuf = gdk_pixbuf_new_from_file (absolute_fname, NULL);

  g_free (absolute_fname);

  return pixbuf;
}
