#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#include <gtk/gtk.h>

#include "gkdial.h"
#include "defines.h"
#include "ppp_info.h"
#include "main_loop.h"
#include "util.h"

/*
 * This is the main loop 
 */
int
check_connection (gpointer data)
{
  GkDial *gkdial = (GkDial *) data;

  /*
   * number of bytes entering iface 
   */
  int tin = 0, tout = 0;

  /*
   * number of bytes that entered iface last time 
   */
  static int lastin = 0, lastout = 0;

  /*
   * number of bytes that were counted for the iface while off 
   */
  static int tin_while_off = 0, tout_while_off = 0;
  int ppp_on = FALSE;

  if (gkdial->first_time)
    get_stats (gkdial, &tin_while_off, &tout_while_off);

  /*
   * gets some information 
   */
  ppp_on = get_stats (gkdial, &tin, &tout);

  if (is_connected (gkdial))
    {
      /*
       * values of tin and tout == 0 means the ppp interface is still
       * not up but it seems that, for some systems, this is never true
       * so, if the values for tin and tout are not changed from when
       * the conection was not up is the same now, we'll consider it to 
       * be down too 
       */
      if (!ppp_on || (tin == 0 && tout == 0)
	  || (tin_while_off == tin && tout_while_off == tout))
	{
	  tin = tout = 0;
	  lastin = lastout = 0;
	  if (gkdial->state != CONNECTING && gkdial->state != CONNECTED)
	    gk_status_set_connecting (gkdial);
	}
      else
	{
	  if (gkdial->state != CONNECTED)
	    gk_status_set_connected (gkdial);
	}

      /*
       * updates some connection info 
       */
      update_ctime (gkdial);	// connection time
      if (!gkdial->first_time)
	update_bps (gkdial, tin - lastin, tout - lastout);
    }
  else if (gkdial->state != DISCONNECTED)
    {
      /*
       * gets tin and tout values while off 
       */
      get_stats (gkdial, &tin_while_off, &tout_while_off);
      gk_status_set_disconnected (gkdial);
    }

  lastin = tin;
  lastout = tout;

  gkdial->first_time = FALSE;

  return 1;
}

void
gk_status_set_connecting (GkDial * gkdial)
{
#ifdef DEBUG
  printf ("setting CONNECTING!\n");
#endif

  gkdial->state = CONNECTING;

  gtk_statusbar_pop (GTK_STATUSBAR (gkdial->details_statusbar),
		     gkdial->status_state_id);

  if (gkdial->num_retries)
    {
      gchar *statusbar_text;

      statusbar_text = g_strdup_printf (_("Trying again... (try #%d)"),
					gkdial->num_retries);

      gtk_statusbar_push (GTK_STATUSBAR (gkdial->details_statusbar),
			  gkdial->status_state_id, statusbar_text);

      g_free (statusbar_text);
    }
  else
    gtk_statusbar_push (GTK_STATUSBAR (gkdial->details_statusbar),
			gkdial->status_state_id, _("Dialing..."));

  if (gkdial->connected_to)
    gkdial_details_set_title (gkdial, _("Connecting to: %s - GkDial"),
			      gkdial->connected_to);
  else
    gkdial_details_set_title (gkdial, _("Connecting to: unknown - GkDial"));

  gtk_image_set_from_pixbuf (GTK_IMAGE (gkdial->tray_icon),
			     gkdial->pixbuf_ppp_trying);
  /*
   * sets the big image at the details window 
   */
  gtk_image_set_from_pixbuf (GTK_IMAGE (gkdial->image_details_ppp),
			     gkdial->pixbuf_ppp_trying_64);

  if (gkdial->tray)
    {
      gtk_widget_hide (gkdial->menu_item_connect);
      gtk_widget_show (gkdial->menu_item_disconnect);
    }
  if (GTK_WIDGET_VISIBLE (gkdial->main_window))
    {
      gtk_widget_hide (gkdial->main_window);
      gtk_widget_show (gkdial->details_window);
    }

  /*
   * start clock 
   */
  get_connect_time (gkdial, TRUE);
}

void
gk_status_set_disconnected (GkDial * gkdial)
{
  if (gkdial->state_locked)
    return;

#ifdef DEBUG
  printf ("setting DISCONNECTED!\n");
  printf ("(set_disconnected)was_gkdial: %d"
	  " - gkdial->state: %d\n", gkdial->was_gkdial, gkdial->state);
#endif

  if (gkdial->was_gkdial && gkdial->state != DISCONNECTING)
    {
      if (gkdial_handle_return_code (gkdial))
	return;

      gkdial->state = DISCONNECTING;
    }

  if (gkdial->state != DISCONNECTED)
    {
		/* quits gkdial! */
		if (gkdial->quit_on_off)
			gtk_main_quit ();

      gkdial->num_retries = 0;
      gtk_statusbar_pop (GTK_STATUSBAR (gkdial->details_statusbar),
			 gkdial->status_state_id);

      if (!gkdial->always_tray)
	{
	  gtk_widget_hide (gkdial->tray);
	  gtk_widget_show (gkdial->main_window);
	}

      gtk_label_set_text (GTK_LABEL (gkdial->label_set_out), _("0 B/s"));
      gtk_label_set_text (GTK_LABEL (gkdial->label_set_in), _("0 B/s"));
      gtk_label_set_text (GTK_LABEL (gkdial->label_set_time), _("00:00:00"));
      gtk_image_set_from_pixbuf (GTK_IMAGE (gkdial->tray_icon),
				 gkdial->pixbuf_ppp_off);
      /*
       * sets the big image at the details window 
       */
      gtk_image_set_from_pixbuf (GTK_IMAGE (gkdial->image_details_ppp),
				 gkdial->pixbuf_ppp_off_64);

      if (gkdial->tray)
	{
	  gtk_widget_show (gkdial->menu_item_connect);
	  gtk_widget_hide (gkdial->menu_item_disconnect);
	}
      if (GTK_WIDGET_VISIBLE (gkdial->details_window))
	{
	  gtk_widget_hide (gkdial->details_window);
	  gtk_widget_show (gkdial->main_window);
	}

      gkdial_details_set_title (gkdial, _("Disconnected - GkDial"));
      if (gkdial->connected_to != NULL)
	{
	  g_free (gkdial->connected_to);
	  gkdial->connected_to = NULL;
	}

      gkdial->state = DISCONNECTED;
    }
}

void
gk_status_set_connected (GkDial * gkdial)
{
#ifdef DEBUG
  printf ("setting CONNECTED!\n");
#endif

  if (!GTK_WIDGET_VISIBLE (gkdial->tray))
    gtk_widget_show_all (gkdial->tray);

  gkdial->state = CONNECTED;
  gtk_statusbar_pop (GTK_STATUSBAR (gkdial->details_statusbar),
		     gkdial->status_state_id);
  gtk_statusbar_push (GTK_STATUSBAR (gkdial->details_statusbar),
		      gkdial->status_state_id, _("Connected."));

  if (gkdial->connected_to)
    gkdial_details_set_title (gkdial, _("Connected to: %s - GkDial"),
			      gkdial->connected_to);
  else
    gkdial_details_set_title (gkdial, _("Connected to: unknown - GkDial"));

  gtk_image_set_from_pixbuf (GTK_IMAGE (gkdial->tray_icon),
			     gkdial->pixbuf_ppp_none);
  /*
   * sets the big image at the details window 
   */
  gtk_image_set_from_pixbuf (GTK_IMAGE (gkdial->image_details_ppp),
			     gkdial->pixbuf_ppp_none_64);

  if (gkdial->tray)
    {
      gtk_widget_hide (gkdial->menu_item_connect);
      gtk_widget_show (gkdial->menu_item_disconnect);
    }
  if (GTK_WIDGET_VISIBLE (gkdial->main_window))
    {
      gtk_widget_hide (gkdial->main_window);
      gtk_widget_show (gkdial->details_window);
    }
#ifdef DEBUG
	fprintf (stderr, "hide_dw_on_conn: %d\n",
		gkdial->hide_dw_on_conn);
	fflush (stderr);
#endif

	if (gkdial->hide_dw_on_conn)
	{
		if (gkdial->tray)
			gtk_widget_hide (gkdial->details_window);
		else
			gtk_window_iconify (GTK_WINDOW(gkdial->details_window));
	}

  /*
   * start clock 
   */
  get_connect_time (gkdial, TRUE);
}

gpointer
gk_thread_connect (gpointer data)
{
  GkDial *gkdial = (GkDial *) data;
  gchar *connect_cmd = UPCMD;
  gchar *command;

#ifdef DEBUG
  printf ("Creating new connecting_thread: %p!\n", gkdial->connecting_thread);
#endif

  command = g_strdup_printf ("%s %s nodetach", connect_cmd,
			     gkdial->connected_to);
  gkdial_exec (gkdial, command, CONNECTING);
  g_free (command);
  pthread_exit (NULL);
}

void
gk_connect (GtkWidget * w, gpointer data)
{
  GkDial *gkdial = (GkDial *) data;

  gk_status_set_connecting (gkdial);
  /*
   * lock state to avoid set_disconnected reseting was_gkdial 
   */
  gkdial->state_locked = TRUE;

	g_free (gkdial->connected_to);
  gkdial->connected_to =
    gtk_editable_get_chars (GTK_EDITABLE (GTK_COMBO (gkdial->main_combo)->entry), 
		0, -1);

  gkdial->was_gkdial = TRUE;

  gkdial_details_set_title (gkdial, _("Connecting to: %s - GkDial"),
			    gkdial->connected_to);

	g_free (gkdial->connecting_thread);
  gkdial->connecting_thread = g_new (pthread_t, 1);
  pthread_create (gkdial->connecting_thread, NULL,
		  gk_thread_connect, (gpointer) gkdial);
}

/*
 * runs the command the user defined to disconnect 
 */
void
gk_disconnect (GtkWidget * button, gpointer data)
{
  GkDial *gkdial = (GkDial *) data;
  gchar *disconnect_cmd = DOWNCMD;

  /*
   * this shows that gkdial was the responsible for the connection being 
   * closed 
   */
  gkdial->was_gkdial = FALSE;
  gkdial_exec (gkdial, disconnect_cmd, DISCONNECTING);
}
