// $Id: GladeTag.cc,v 1.4 2002/06/15 13:22:13 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2002  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "GladeTag.hh"
#include "Configuration.hh"

std::string GladeTag::getGladeAttr(const std::string &name, const std::string &def) const
{  if (Configuration.glade2) return getAttr(name,def);
   else return getString(name,def);
}

bool GladeTag::hasGladeAttr(const std::string &name) const
{  if (Configuration.glade2) return hasAttr(name);
   else return hasTag(name);
}

bool GladeTag::getGladeBoolAttr(const std::string &name, bool def) const
{  if (Configuration.glade2) return getBoolAttr(name,def);
   else return getBool(name,def);
}

// this is needed to switch to another widget type during ApplyPreferences
void GladeTag::setWidgetType(const std::string &type)
{  if (Configuration.glade2) 
   {  assert(begin()!=end());
      assert(begin()->Type()=="widget");
      begin()->setAttr("class",type);
   }
   else mark("class",type);
}
