// $Id: container.hh,v 1.21 2002/05/31 07:12:10 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CONTAINER_HH
#define CONTAINER_HH
#include "widget.hh"

class Gtk_Container : public Gtk_Widget
{ 
protected:
	// this lives within menu.cc
        virtual void PushMenuElem(const Widget &w,CxxFile &f,const std::string &instance) const;
public:
	typedef Gtk_Widget Parent;
	virtual bool DefaultSeparateClass(const Widget &w) const
	{  return true; }
	virtual void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual void AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const;
//	void ConfigureChildren(CxxFile &f,const Widget &w,const std::string &instance) const;
	virtual void Configure(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual void AdditionalMemberVars(const Widget &w, CxxFile &f,bool container=false) const;
	virtual void GHInclude(const Widget &w,CxxFile &f) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
};
#endif
