// $Id: gnome_druidpagestd.cc,v 1.6 2002/11/04 11:31:03 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnome_druidpage.hh"

class Gnome_DruidPageStandard : public Gnome_DruidPage
{public:
	typedef Gnome_DruidPage Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_DruidPageStandard();
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual void AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const;
	virtual Subwidget IsSubwidget(const Widget &parent,const Widget &w2) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Gnome_DruidPageStandard Gnome_DruidPageStandard;

const std::string Gnome_DruidPageStandard::TypeName(const Widget &w) const
{  return GnomeUIPrefix()+"DruidPageStandard";
}

const std::string Gnome_DruidPageStandard::IncludeName(const Widget &w) const
{  return Configuration.GnomeUImmIncludePath()+"druid-page-standard.h";
}

Gnome_DruidPageStandard::Gnome_DruidPageStandard()
{  Writer["GnomeDruidPageStandard"]=this;
}

void Gnome_DruidPageStandard::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
}

bool Gnome_DruidPageStandard::NeedExplicitCtor(const Widget &w) const
{  return false; }

void Gnome_DruidPageStandard::AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const
{  const WriterBase &vwr(LookupWriter("GtkVBox"));
   if (w.begin()==w.end()) return;
   const Widget w2(*(w.begin()));
   assert(w2.ChildName()=="GnomeDruidPageStandard:vbox");

   for (Widget::const_iterator i=w2.begin();i!=w2.end();++i)
   {  ((Gtk_Container&)vwr).AddChild(*i,f,Configuration.InstanceName(w2.Name())+"->");
   }
}

Subwidget Gnome_DruidPageStandard::IsSubwidget(const Widget &w,const Widget &ch) const
{  if (ch.ChildName()=="GnomeDruidPageStandard:vbox") return is_Subwidget_only;
   if (!ch.ChildName().empty()) {  std::cerr << "Child name '" << ch.ChildName() << "'\n"; }
   return not_Subwidget;
}

void Gnome_DruidPageStandard::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   assert (w.begin()!=w.end());
   const Widget w2(*(w.begin()));
   assert (w2.ChildName()=="GnomeDruidPageStandard:vbox");

   const std::string name(Configuration.InstanceName(w2.Name()));
   f.Declaration() << GtkPrefix() << "VBox *" << name;
   f.Assignment() << gtk_wrapper() << "((GtkVBox*)GNOME_DRUID_PAGE_STANDARD("
	<< instance << gtk_object_pointer() << ")->vbox)";
   LookupWriter("GtkVBox").Configure(w2,f,name+"->");
}

