dnl
dnl ACG_GNOME_INIT_HOOK (script-if-gnome-enabled, [failflag], [additional-inits])
dnl
dnl if failflag is "fail" then GNOME_INIT_HOOK will abort if gnomeConf.sh
dnl is not found. 
dnl

AC_DEFUN([ACG_GNOME_INIT_HOOK],[
	AC_SUBST(GNOME_LIBS)
	AC_SUBST(GNOMEUI_LIBS)
	AC_SUBST(ZVT_LIBS)
	AC_SUBST(GNOME_LIBDIR)
	AC_SUBST(GNOME_INCLUDEDIR)

	AC_ARG_WITH(gnome-includes,
	[  --with-gnome-includes   Specify location of GNOME headers],[
	CPPFLAGS="$CPPFLAGS -I$withval"
	])
	
	AC_ARG_WITH(gnome-libs,
	[  --with-gnome-libs       Specify location of GNOME libs],[
	LDFLAGS="$LDFLAGS -L$withval"
	gnome_prefix=$withval
	])

	AC_ARG_WITH(gnome,
	[  --with-gnome            Specify prefix for GNOME files],
		if test x$withval = xyes; then
	    		want_gnome=yes
	    		dnl Note that an empty true branch is not
			dnl valid sh syntax.
	    		ifelse([$1], [], :, [$1])
        	else
	    		if test "x$withval" = xno; then
	        		want_gnome=no
	    		else
	        		want_gnome=yes
	    			LDFLAGS="$LDFLAGS -L$withval/lib"
	    			CPPFLAGS="$CPPFLAGS -I$withval/include"
	    			gnome_prefix=$withval/lib
				gnome_config_prefix=$withval
	    		fi
  		fi,
		want_gnome=yes)

	if test "x$want_gnome" = xyes; then

	    gnome_ac_is_buggy_PATH="$gnome_config_prefix/bin:$PATH:/opt/gnome/bin"
	    AC_PATH_PROG(GNOME_CONFIG,gnome-config,no,[$gnome_ac_is_buggy_PATH])
	    if test "$GNOME_CONFIG" = "no"; then
	      no_gnome_config="yes"
	    else
	      AC_MSG_CHECKING(if $GNOME_CONFIG works)
	      if $GNOME_CONFIG --libs-only-l gnome >/dev/null 2>&1; then
	        AC_MSG_RESULT(yes)
		ACG_PATH_ESD(0.2.0, , [
		   AC_MSG_ERROR([GNOME needs esd library and development]) ])
	        GNOME_LIBS="`$GNOME_CONFIG --libs-only-l gnome`"
	        GNOMEUI_LIBS="`$GNOME_CONFIG --libs-only-l gnomeui`"
		ZVT_LIBS="`$GNOME_CONFIG --libs zvt`"
	        GNOME_LIBDIR="`$GNOME_CONFIG --libs-only-L gnomeui gnome`"
	        GNOME_INCLUDEDIR="`$GNOME_CONFIG --cflags gnomeui glib gtk`"
                $1
	      else
	        AC_MSG_RESULT(no)
	        no_gnome_config="yes"
              fi
            fi

dnl Gnomeui uses gdk_imlib, but it's not folded into gnome-config.

	    AC_PATH_PROG(IMLIB_CONFIG,imlib-config,no,[$gnome_ac_is_buggy_PATH])
	    if test "$IMLIB_CONFIG" = "no"; then
	      no_imlib_config="yes"
	    else
	      AC_MSG_CHECKING([if $IMLIB_CONFIG works])
	      if "$IMLIB_CONFIG" --libs-gdk >/dev/null 2>&1; then
	        AC_MSG_RESULT(yes)
		GNOMEUI_LIBS="$GNOMEUI_LIBS `$IMLIB_CONFIG --libs-gdk`"
		GNOME_INCLUDEDIR="$GNOME_INCLUDEDIR `$IMLIB_CONFIG --cflags-gdk`"
	      else
	        no_imlib_config="yes"
		AC_MSG_RESULT(no)
	      fi
	    fi
	    if test "no_imlib_config" = "yes"; then
	      AC_CHECK_HEADER(gdk_imlib.h)
	      AC_CHECK_LIB(gdk_imlib, gdk_imlib_init)
dnl TODO. Some form of error checking here.
	    fi
	    if test x$exec_prefix = xNONE; then
	        if test x$prefix = xNONE; then
		    gnome_prefix=$ac_default_prefix/lib
	        else
 		    gnome_prefix=$prefix/lib
	        fi
	    else
	        gnome_prefix=`eval echo \`echo $libdir\``
	    fi
	
	    if test "$no_gnome_config" = "yes"; then
              AC_MSG_CHECKING(for gnomeConf.sh file in $gnome_prefix)
	      if test -f $gnome_prefix/gnomeConf.sh; then
	        AC_MSG_RESULT(found)
	        echo "loading gnome configuration from" \
		     "$gnome_prefix/gnomeConf.sh"
	        . $gnome_prefix/gnomeConf.sh
	        $1
	      else
	        AC_MSG_RESULT(not found)
 	        if test x$2 = xfail; then
	          AC_MSG_ERROR(Could not find the gnomeConf.sh file that is generated by gnome-libs install)
 	        fi
	      fi
            fi
	fi

	if test -n "$3"; then
	  n="$3"
	  for i in $n; do
	    AC_MSG_CHECKING(extra library \"$i\")
	    case $i in 
	      applets)
		AC_SUBST(GNOME_APPLETS_LIBS)
		GNOME_APPLETS_LIBS=`$GNOME_CONFIG --libs-only-l applets`
		AC_MSG_RESULT($GNOME_APPLETS_LIBS);;
	      capplet)
		AC_SUBST(GNOME_CAPPLET_LIBS)
		GNOME_CAPPLET_LIBS=`$GNOME_CONFIG --libs-only-l capplet`
		AC_MSG_RESULT($GNOME_CAPPLET_LIBS);;
	      *)
		AC_MSG_RESULT(unknown library)
	    esac
	  done
	fi
])

dnl
dnl GNOME_INIT ([additional-inits])
dnl

AC_DEFUN([GNOME_INIT],[
	GNOME_INIT_HOOK([],fail,$1)
])
