/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/*
 * @(#) UniqueIdGenerator.java
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of iPlanet/Sun Microsystems, Inc. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license
 * agreement you entered into with iPlanet/Sun Microsystems.
 */
package com.sun.enterprise.instance;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;


/**
 * Generates unique id for an application or stand alone ejb module.
 * 
 * It uses the low order 6 bytes of the system current time. The remaining
 * 2 bytes are reserved for the beans inside the application and stand 
 * alone ejb module.
 *
 * The unique id generated by this generator will eventually wrap after 
 * 2^48 milli-seconds (8,925.25 years).
 * 
 * The two bytes reserved for the beans in the application or stand alone ejb 
 * module will allow max 2^16 (65,536) beans.
 *
 * @author  Nazrul Islam
 * @since   JDK1.4
 */
public class UniqueIdGenerator {

    /** last unique id given out by this id generator */
    private long _lastUid                      = 0;

    /** the singleton instance */
    private static UniqueIdGenerator _instance = null;
	
	private static Logger _logger = LogDomains.getLogger(LogDomains.CORE_LOGGER);

    static {
        _instance = new UniqueIdGenerator();
    }

    private UniqueIdGenerator() { }

    /**
     * Returns the singleton instance of this class.
     *
     * @return    the singleton instance
     */
    public static UniqueIdGenerator getInstance() {
        return _instance;
    }

    /**
     * Returns the next unique id for an application or 
     * stand alone ejb module.
     *
     * @return    the next unique id
     */
    public long getNextUniqueId() {

        synchronized (this) {
            while (true) {
                long uid  = System.currentTimeMillis();

                // uses the low order 6 bytes as unique id;
                // remaining 2 bytes are reserved for the beans inside the app
                uid       = (uid << 16);

                // ensures that we have a unique id
                if (this._lastUid != uid) {
                    this._lastUid = uid;
                    break;
                } else {
                    try {
                        Thread.currentThread().sleep(1);
                    } catch (InterruptedException ie) {
                        // log debug msg here
						_logger.log(Level.WARNING,"Thread.sleep interrupted ",ie);
                    }
                }
            }
            return this._lastUid;
        }
    }
}

